/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.api.ndarray;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.nd4j.linalg.api.complex.IComplexNDArray;
import org.nd4j.linalg.api.complex.IComplexNumber;
import org.nd4j.linalg.api.ndarray.DimensionSlice;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.api.ndarray.SliceOp;
import org.nd4j.linalg.factory.Nd4j;
import org.nd4j.linalg.indexing.Indices;
import org.nd4j.linalg.indexing.NDArrayIndex;
import org.nd4j.linalg.ops.reduceops.Ops;
import org.nd4j.linalg.ops.transforms.Transforms;
import org.nd4j.linalg.util.ArrayUtil;
import org.nd4j.linalg.util.IterationResult;
import org.nd4j.linalg.util.LinAlgExceptions;
import org.nd4j.linalg.util.Shape;

public abstract class BaseNDArray
implements INDArray {
    protected int[] shape;
    protected int[] stride;
    protected int offset = 0;
    protected char ordering;
    protected float[] data;
    protected int rows;
    protected int columns;
    protected int length;
    protected INDArray linearView;

    public BaseNDArray() {
    }

    public BaseNDArray(double[][] data) {
        this(data.length, data[0].length);
        int r;
        for (r = 0; r < this.rows; ++r) {
            assert (data[r].length == this.columns);
        }
        this.data = new float[this.length];
        for (r = 0; r < this.rows; ++r) {
            for (int c = 0; c < this.columns; ++c) {
                this.putScalar(new int[]{r, c}, (Number)data[r][c]);
            }
        }
    }

    public BaseNDArray(float[] data, int[] shape, char ordering) {
        this(data, shape, 0, ordering);
    }

    public BaseNDArray(float[] data, int[] shape, int offset, char ordering) {
        this(data, shape, ordering == 'c' ? ArrayUtil.calcStrides(shape) : ArrayUtil.calcStridesFortran(shape), offset);
    }

    public BaseNDArray(int[] shape, int[] stride, int offset, char ordering) {
        this(new float[ArrayUtil.prod(shape)], shape, stride, offset, ordering);
    }

    public BaseNDArray(int[] shape, int[] stride, char ordering) {
        this(shape, stride, 0, ordering);
    }

    public BaseNDArray(int[] shape, int offset, char ordering) {
        this(shape, Nd4j.getStrides(shape, ordering), offset, ordering);
    }

    public BaseNDArray(int[] shape) {
        this(shape, 0, Nd4j.order().charValue());
    }

    public BaseNDArray(int newRows, int newColumns, char ordering) {
        this.ordering = ordering;
        this.initShape(new int[]{newRows, newColumns});
    }

    public BaseNDArray(List<INDArray> slices, int[] shape, char ordering) {
        ArrayList<float[]> list = new ArrayList<float[]>();
        for (int i = 0; i < slices.size(); ++i) {
            list.add(slices.get(i).data());
        }
        this.ordering = ordering;
        this.data = ArrayUtil.combine(list);
        this.initShape(shape);
    }

    public BaseNDArray(List<INDArray> slices, int[] shape, int[] stride, char ordering) {
        ArrayList<float[]> list = new ArrayList<float[]>();
        for (int i = 0; i < slices.size(); ++i) {
            list.add(slices.get(i).data());
        }
        this.ordering = ordering;
        this.data = ArrayUtil.combine(list);
        this.stride = stride;
        this.initShape(shape);
    }

    public BaseNDArray(float[] data, int[] shape, int[] stride, char ordering) {
        this(data, shape, stride, 0, ordering);
    }

    public BaseNDArray(float[] data, int[] shape, int[] stride, int offset, char ordering) {
        this.offset = offset;
        this.stride = stride;
        this.ordering = ordering;
        this.initShape(shape);
        if (data != null && data.length > 0) {
            this.data = data;
            if (offset >= data.length) {
                throw new IllegalArgumentException("Invalid offset: must be < data.length");
            }
        }
        this.linearView = this.isVector() ? this : Nd4j.create(data, new int[]{1, this.length}, this.offset());
    }

    @Override
    public INDArray linearView() {
        if (this.isVector()) {
            return this;
        }
        if (this.linearView == null) {
            this.linearView = Nd4j.create(this.data, new int[]{1, this.length}, this.offset());
        }
        return this.linearView;
    }

    public BaseNDArray(float[] data, int[] shape) {
        this(data, shape, 0);
    }

    public BaseNDArray(float[] data, int[] shape, int offset) {
        this(data, shape, offset, Nd4j.order().charValue());
    }

    public BaseNDArray(int[] shape, int[] stride, int offset) {
        this(new float[ArrayUtil.prod(shape)], shape, stride, offset, Nd4j.order().charValue());
    }

    public BaseNDArray(int[] shape, int[] stride) {
        this(shape, stride, 0);
    }

    public BaseNDArray(int[] shape, int offset) {
        this(shape, ArrayUtil.calcStrides(shape), offset);
    }

    public BaseNDArray(int[] shape, char ordering) {
        this(shape, 0, ordering);
    }

    public BaseNDArray(int newRows, int newColumns) {
        this(newRows, newColumns, Nd4j.order().charValue());
    }

    public BaseNDArray(List<INDArray> slices, int[] shape) {
        this(slices, shape, Nd4j.order().charValue());
    }

    public BaseNDArray(List<INDArray> slices, int[] shape, int[] stride) {
        this(slices, shape, stride, Nd4j.order().charValue());
    }

    public BaseNDArray(float[] data, int[] shape, int[] stride) {
        this(data, shape, stride, Nd4j.order().charValue());
    }

    public BaseNDArray(float[] data, int[] shape, int[] stride, int offset) {
        this(data, shape, stride, offset, Nd4j.order().charValue());
    }

    public BaseNDArray(float[] data) {
        this.data = data;
    }

    public BaseNDArray(float[][] data) {
        this(data.length, data[0].length);
        int r;
        for (r = 0; r < this.rows; ++r) {
            assert (data[r].length == this.columns);
        }
        this.data = new float[this.length];
        for (r = 0; r < this.rows; ++r) {
            for (int c = 0; c < this.columns; ++c) {
                this.putScalar(new int[]{r, c}, (Number)Float.valueOf(data[r][c]));
            }
        }
    }

    @Override
    public float[] floatData() {
        return this.data;
    }

    public int majorStride() {
        return this.stride[0];
    }

    @Override
    public int vectorsAlongDimension(int dimension) {
        if (dimension >= this.shape.length) {
            return this.length / this.size(this.shape.length - 1);
        }
        return this.length / this.size(dimension);
    }

    @Override
    public INDArray vectorAlongDimension(int index, int dimension) {
        assert (dimension <= this.shape.length) : "Invalid dimension " + dimension;
        if (dimension > this.shape().length - 1) {
            dimension = this.shape.length - 1;
        }
        if (this.ordering == 'c') {
            if (dimension == this.shape.length - 1 && dimension != 0) {
                return Nd4j.create(this.data, new int[]{1, this.shape[dimension]}, ArrayUtil.removeIndex(this.stride, 0), this.offset + index * this.stride[dimension - 1]);
            }
            if (dimension == 0) {
                return Nd4j.create(this.data, new int[]{this.shape[dimension], 1}, new int[]{this.stride[dimension], 1}, this.offset + index);
            }
            if (this.size(dimension) == 1) {
                return Nd4j.create(this.data, new int[]{this.shape[dimension], 1}, new int[]{this.stride[dimension], 1}, this.offset + index);
            }
            return Nd4j.create(this.data, new int[]{this.shape[dimension], 1}, new int[]{this.stride[dimension], 1}, this.offset + index * this.stride[0]);
        }
        if (this.ordering == 'f') {
            if (dimension == this.shape.length - 1 && dimension != 0) {
                if (this.size(dimension) == 1) {
                    return Nd4j.create(this.data, new int[]{1, this.shape[dimension]}, ArrayUtil.removeIndex(this.stride, 0), this.offset + index);
                }
                return Nd4j.create(this.data, new int[]{1, this.shape[dimension]}, ArrayUtil.removeIndex(this.stride, 0), this.offset + index * this.stride[dimension - 1]);
            }
            if (this.size(dimension) == 1) {
                return Nd4j.create(this.data, new int[]{this.shape[dimension], 1}, new int[]{this.stride[dimension], 1}, this.offset + index);
            }
            return Nd4j.create(this.data, new int[]{this.shape[dimension], 1}, new int[]{this.stride[dimension], 1}, this.offset + index * this.stride[this.stride.length - 1]);
        }
        throw new IllegalStateException("Illegal ordering..none declared");
    }

    @Override
    public INDArray cumsumi(int dimension) {
        if (this.isVector()) {
            double s = 0.0;
            for (int i = 0; i < this.length; ++i) {
                this.putScalar(i, (Number)(s += (double)((Float)this.getScalar(i).element()).floatValue()));
            }
        } else {
            if (dimension == Integer.MAX_VALUE || dimension == this.shape.length - 1) {
                INDArray flattened = this.ravel().dup();
                float prevVal = ((Float)flattened.getScalar(0).element()).floatValue();
                for (int i = 1; i < flattened.length(); ++i) {
                    float d = prevVal + ((Float)flattened.getScalar(i).element()).floatValue();
                    flattened.putScalar(i, (Number)Float.valueOf(d));
                    prevVal = d;
                }
                return flattened;
            }
            for (int i = 0; i < this.vectorsAlongDimension(dimension); ++i) {
                INDArray vec = this.vectorAlongDimension(i, dimension);
                vec.cumsumi(0);
            }
        }
        return this;
    }

    @Override
    public INDArray cumsum(int dimension) {
        return this.dup().cumsumi(dimension);
    }

    @Override
    public INDArray assign(INDArray arr) {
        LinAlgExceptions.assertSameShape(this, arr);
        INDArray other = arr.ravel();
        INDArray thisArr = this.ravel();
        for (int i = 0; i < other.length(); ++i) {
            thisArr.put(i, other.getScalar(i));
        }
        return this;
    }

    @Override
    public INDArray putScalar(int i, Number value) {
        int idx = this.linearIndex(i);
        this.data[idx] = value.floatValue();
        return this;
    }

    @Override
    public INDArray putScalar(int[] indexes, Number value) {
        int ix = this.offset;
        for (int i = 0; i < this.shape.length; ++i) {
            ix += indexes[i] * this.stride[i];
        }
        this.data[ix] = value.floatValue();
        return this;
    }

    @Override
    public INDArray lt(Number other) {
        return this.dup().lti(other);
    }

    @Override
    public INDArray lti(Number other) {
        return this.lti(Nd4j.scalar(other));
    }

    @Override
    public INDArray eq(Number other) {
        return this.dup().eqi(other);
    }

    @Override
    public INDArray eqi(Number other) {
        return this.eqi(Nd4j.scalar(other));
    }

    @Override
    public INDArray gt(Number other) {
        return this.dup().gti(other);
    }

    @Override
    public INDArray gti(Number other) {
        return this.gti(Nd4j.scalar(other));
    }

    @Override
    public INDArray lt(INDArray other) {
        return this.dup().lti(other);
    }

    @Override
    public INDArray lti(INDArray other) {
        return Transforms.lt(other);
    }

    @Override
    public INDArray eq(INDArray other) {
        return this.dup().eqi(other);
    }

    @Override
    public INDArray eqi(INDArray other) {
        return Transforms.eq(other);
    }

    @Override
    public INDArray gt(INDArray other) {
        return this.dup().gti(other);
    }

    @Override
    public INDArray gti(INDArray other) {
        return Transforms.gt(other);
    }

    @Override
    public INDArray neg() {
        return this.dup().negi();
    }

    @Override
    public INDArray negi() {
        return Transforms.neg(this);
    }

    @Override
    public INDArray rdiv(Number n, INDArray result) {
        return this.dup().rdivi(n, result);
    }

    @Override
    public INDArray rdivi(Number n, INDArray result) {
        INDArray linear = this.linearView();
        INDArray resultLinear = result.linearView();
        for (int i = 0; i < this.length; ++i) {
            resultLinear.putScalar(i, (Number)Float.valueOf(n.floatValue() / linear.get(i)));
        }
        return result;
    }

    @Override
    public INDArray rsub(Number n, INDArray result) {
        return this.dup().rsubi(n, result);
    }

    @Override
    public INDArray rsubi(Number n, INDArray result) {
        INDArray linear = this.linearView();
        INDArray resultLinear = result.linearView();
        for (int i = 0; i < this.length; ++i) {
            resultLinear.putScalar(i, (Number)Float.valueOf(n.floatValue() - linear.get(i)));
        }
        return result;
    }

    @Override
    public INDArray div(Number n, INDArray result) {
        return this.dup().divi(n, result);
    }

    @Override
    public INDArray divi(Number n, INDArray result) {
        INDArray linear = this.linearView();
        INDArray resultLinear = result.linearView();
        for (int i = 0; i < this.length; ++i) {
            resultLinear.putScalar(i, (Number)Float.valueOf(linear.get(i) / n.floatValue()));
        }
        return result;
    }

    @Override
    public INDArray mul(Number n, INDArray result) {
        return this.dup().muli(n, result);
    }

    @Override
    public INDArray muli(Number n, INDArray result) {
        INDArray linear = this.linearView();
        INDArray resultLinear = result.linearView();
        for (int i = 0; i < this.length; ++i) {
            resultLinear.putScalar(i, (Number)Float.valueOf(linear.get(i) * n.floatValue()));
        }
        return result;
    }

    @Override
    public INDArray sub(Number n, INDArray result) {
        return this.dup().subi(n, result);
    }

    @Override
    public INDArray subi(Number n, INDArray result) {
        INDArray linear = this.linearView();
        INDArray resultLinear = result.linearView();
        for (int i = 0; i < this.length; ++i) {
            resultLinear.putScalar(i, (Number)Float.valueOf(linear.get(i) - n.floatValue()));
        }
        return result;
    }

    @Override
    public INDArray add(Number n, INDArray result) {
        return this.dup().addi(n, result);
    }

    @Override
    public INDArray addi(Number n, INDArray result) {
        INDArray linear = this.linearView();
        INDArray resultLinear = result.linearView();
        for (int i = 0; i < this.length; ++i) {
            resultLinear.putScalar(i, (Number)Float.valueOf(linear.get(i) + n.floatValue()));
        }
        return result;
    }

    @Override
    public INDArray getScalar(int row, int column) {
        return this.getScalar(new int[]{row, column});
    }

    @Override
    public INDArray dup() {
        return Nd4j.create(Arrays.copyOf(this.data, this.data.length), Arrays.copyOf(this.shape, this.shape.length), Arrays.copyOf(this.stride, this.stride.length), this.offset, this.ordering);
    }

    @Override
    public float get(int ... indices) {
        int ix = this.offset;
        for (int i = 0; i < indices.length; ++i) {
            ix += indices[i] * this.stride[i];
        }
        return this.data[ix];
    }

    @Override
    public boolean isScalar() {
        if (this.shape.length == 0) {
            return true;
        }
        if (this.shape.length == 1 && this.shape[0] == 1) {
            return true;
        }
        if (this.shape.length >= 2) {
            for (int i = 0; i < this.shape.length; ++i) {
                if (this.shape[i] == 1) continue;
                return false;
            }
        }
        return this.length == 1;
    }

    @Override
    public INDArray put(int[] indices, INDArray element) {
        if (!element.isScalar()) {
            throw new IllegalArgumentException("Unable to insert anything but a scalar");
        }
        int ix = this.offset;
        for (int i = 0; i < indices.length; ++i) {
            ix += indices[i] * this.stride[i];
        }
        this.data[ix] = ((Float)element.element()).floatValue();
        return this;
    }

    @Override
    public INDArray put(int i, int j, INDArray element) {
        return this.put(new int[]{i, j}, element);
    }

    @Override
    public INDArray put(int i, int j, Number element) {
        return this.put(i, j, Nd4j.scalar(element));
    }

    @Override
    public INDArray putSlice(int slice, INDArray put) {
        if (this.isScalar()) {
            assert (put.isScalar()) : "Invalid dimension. Can only insert a scalar in to another scalar";
            this.put(0, put.getScalar(0));
            return this;
        }
        if (this.isVector()) {
            assert (put.isScalar()) : "Invalid dimension on insertion. Can only insert scalars input vectors";
            this.put(slice, put.getScalar(0));
            return this;
        }
        this.assertSlice(put, slice);
        INDArray view = this.slice(slice);
        if (put.isScalar()) {
            this.putScalar(slice, (Number)Float.valueOf(put.get(0)));
        } else if (put.isVector()) {
            for (int i = 0; i < put.length(); ++i) {
                view.putScalar(i, (Number)Float.valueOf(put.get(i)));
            }
        } else if (put.shape().length == 2) {
            for (int i = 0; i < put.rows(); ++i) {
                for (int j = 0; j < put.columns(); ++j) {
                    view.put(i, j, Float.valueOf(put.get(i, j)));
                }
            }
        } else {
            assert (put.slices() == view.slices()) : "Slices must be equivalent.";
            for (int i = 0; i < put.slices(); ++i) {
                view.slice(i).putSlice(i, view.slice(i));
            }
        }
        return this;
    }

    protected void assertSlice(INDArray put, int slice) {
        assert (slice <= this.slices()) : "Invalid slice specified " + slice;
        int[] sliceShape = put.shape();
        int[] requiredShape = ArrayUtil.removeIndex(this.shape(), 0);
        if (put.isScalar()) {
            return;
        }
        assert (Shape.shapeEquals(sliceShape, requiredShape)) : String.format("Invalid shape size of %s . Should have been %s ", Arrays.toString(sliceShape), Arrays.toString(requiredShape));
    }

    @Override
    public boolean isMatrix() {
        return this.shape().length == 2 && this.shape[0] != 1 && this.shape[1] != 1;
    }

    @Override
    public INDArray reduce(Ops.DimensionOp op, int dimension) {
        if (this.isScalar()) {
            return this;
        }
        if (this.isVector()) {
            return Nd4j.scalar(this.reduceVector(op, this));
        }
        int[] shape = ArrayUtil.removeIndex(this.shape, dimension);
        if (dimension == 0) {
            double[] data2 = new double[ArrayUtil.prod(shape)];
            int dataIter = 0;
            int numTimes = ArrayUtil.prod(shape);
            for (int offset = this.offset; offset < numTimes; ++offset) {
                double reduce = this.op(dimension, offset, op);
                data2[dataIter++] = reduce;
            }
            return Nd4j.create(data2, shape);
        }
        double[] data2 = new double[ArrayUtil.prod(shape)];
        int dataIter = 0;
        int[] sliceIndices = this.endsForSlices();
        int currOffset = 0;
        int numTimes = ArrayUtil.prod(shape);
        for (int offset = this.offset; offset < numTimes && dataIter < data2.length && currOffset < sliceIndices.length; ++offset) {
            IterationResult pair = this.op(dimension, offset, op, sliceIndices[currOffset]);
            double reduce = pair.getResult();
            data2[dataIter++] = reduce;
            if (!pair.isNextSlice()) continue;
            offset = sliceIndices[currOffset];
            numTimes += sliceIndices[currOffset];
            ++currOffset;
        }
        return Nd4j.create(data2, shape);
    }

    public DimensionSlice vectorForDimensionAndOffset(int dimension, int offset) {
        if (this.isScalar() && dimension == 0 && offset == 0) {
            return new DimensionSlice(false, this.getScalar(offset), new int[]{offset});
        }
        if (this.isVector()) {
            if (dimension == 0) {
                int[] indices = new int[this.length];
                for (int i = 0; i < indices.length; ++i) {
                    indices[i] = i;
                }
                return new DimensionSlice(false, this.dup(), indices);
            }
            if (dimension == 1) {
                return new DimensionSlice(false, this.getScalar(offset), new int[]{offset});
            }
            throw new IllegalArgumentException("Illegal dimension for vector " + dimension);
        }
        int count = 0;
        ArrayList<Integer> indices = new ArrayList<Integer>();
        INDArray ret = Nd4j.create(new int[]{this.shape[dimension]});
        int j = offset;
        while (count < this.shape[dimension]) {
            double d = this.data[j];
            ret.putScalar(count++, (Number)d);
            indices.add(j);
            j += this.stride[dimension];
        }
        return new DimensionSlice(false, ret, ArrayUtil.toArray(indices));
    }

    private IterationResult op(int dimension, int offset, Ops.DimensionOp op, int currOffsetForSlice) {
        double[] dim = new double[this.shape[dimension]];
        int count = 0;
        boolean newSlice = false;
        int j = offset;
        while (count < dim.length) {
            double d = this.data[j];
            dim[count++] = d;
            if (j >= currOffsetForSlice) {
                newSlice = true;
            }
            j += this.stride[dimension];
        }
        return new IterationResult(this.reduceVector(op, Nd4j.create(dim)), newSlice);
    }

    private double op(int dimension, int offset, Ops.DimensionOp op) {
        double[] dim = new double[this.shape[dimension]];
        int count = 0;
        int j = offset;
        while (count < dim.length) {
            double d = this.data[j];
            dim[count++] = d;
            j += this.stride[dimension];
        }
        return this.reduceVector(op, Nd4j.create(dim));
    }

    @Override
    public int index(int row, int column) {
        if (!this.isMatrix()) {
            if (this.isColumnVector()) {
                int idx = this.linearIndex(row);
                return idx;
            }
            if (this.isRowVector()) {
                int idx = this.linearIndex(column);
                return idx;
            }
            throw new IllegalStateException("Unable to getFromOrigin row/column from a non matrix");
        }
        return this.offset + (row * this.stride[0] + column * this.stride[1]);
    }

    protected INDArray newShape(int[] newShape, char ordering) {
        if (Arrays.equals(newShape, this.shape())) {
            return this;
        }
        if (Shape.isVector(newShape) && this.isVector()) {
            if (this.isRowVector() && Shape.isColumnVectorShape(newShape)) {
                return Nd4j.create(this.data, newShape, new int[]{this.stride[0], 1}, this.offset);
            }
            if (this.isColumnVector() && Shape.isRowVectorShape(newShape)) {
                return Nd4j.create(this.data, newShape, new int[]{this.stride[1]}, this.offset);
            }
        }
        INDArray newCopy = this;
        int[] newStrides = null;
        if (this.shape().length > 1 && (ordering == 'c' && this.ordering != 'c' || ordering == 'f' && this.ordering != 'f') && (newStrides = this.noCopyReshape(newShape, ordering)) == null) {
            newCopy = Nd4j.create(this.shape(), ordering);
            for (int i = 0; i < this.vectorsAlongDimension(0); ++i) {
                INDArray copyFrom = this.vectorAlongDimension(i, 0);
                INDArray copyTo = newCopy.vectorAlongDimension(i, 0);
                for (int j = 0; j < copyFrom.length(); ++j) {
                    copyTo.putScalar(j, (Number)Float.valueOf(copyFrom.get(i)));
                }
            }
        }
        if (newStrides == null) {
            newStrides = Nd4j.getStrides(newShape, ordering);
        }
        if (this instanceof IComplexNDArray) {
            return Nd4j.createComplex(newCopy.data(), newShape, newStrides, this.offset);
        }
        return Nd4j.create(newCopy.data(), newShape, newStrides, this.offset);
    }

    protected int[] noCopyReshape(int[] newShape, char ordering) {
        int oi;
        ArrayList<Integer> oldDims = new ArrayList<Integer>();
        ArrayList<Integer> oldStrides = new ArrayList<Integer>();
        for (int i = 0; i < this.shape.length; ++i) {
            if (this.size(i) == 1) continue;
            oldDims.add(this.size(i));
            oldStrides.add(this.stride[i]);
        }
        int np = 1;
        for (int ni = 0; ni < newShape.length; ++ni) {
            np *= newShape[ni];
        }
        int op = 1;
        for (oi = 0; oi < oldDims.size(); ++oi) {
            op *= ((Integer)oldDims.get(oi)).intValue();
        }
        if (np != op) {
            return null;
        }
        if (np == 0) {
            return null;
        }
        oi = 0;
        int oj = 1;
        int ni = 0;
        int nj = 1;
        ArrayList<Integer> newStrides = new ArrayList<Integer>();
        while (ni < newShape.length && oi < oldDims.size()) {
            int nk;
            np = newShape[ni];
            op = (Integer)oldDims.get(oi);
            while (np != op) {
                if (np < op) {
                    np *= newShape[nj++];
                    continue;
                }
                op *= ((Integer)oldDims.get(oj++)).intValue();
            }
            for (int ok = oi; ok < oj - 1; ++ok) {
                if (!(ordering == 'f' ? (Integer)oldStrides.get(ok + 1) != (Integer)oldDims.get(ok) * (Integer)oldStrides.get(ok) : (Integer)oldStrides.get(ok) != (Integer)oldDims.get(ok + 1) * (Integer)oldStrides.get(ok + 1))) continue;
                return null;
            }
            if (ordering == 'f') {
                newStrides.set(ni, (Integer)oldStrides.get(oi));
                for (nk = ni + 1; nk < nj; ++nk) {
                    newStrides.set(nk, (Integer)newStrides.get(nk - 1) * newShape[nk - 1]);
                }
            } else {
                newStrides.set(nj - 1, (Integer)oldStrides.get(oj - 1));
                for (nk = nj - 1; nk > ni; --nk) {
                    newStrides.set(nk - 1, (Integer)newStrides.get(nk) * newShape[nk]);
                }
            }
            ni = nj++;
            oi = oj++;
        }
        int lastStride = ni >= 1 ? (Integer)newStrides.get(ni - 1) : this.length;
        if (ordering == 'f') {
            lastStride *= newShape[ni - 1];
        }
        for (int nk = ni; nk < newShape.length; ++nk) {
            newStrides.set(nk, lastStride);
        }
        return ArrayUtil.toArray(newStrides);
    }

    protected float reduceVector(Ops.DimensionOp op, INDArray vector) {
        switch (op) {
            case SUM: {
                return ((Float)vector.sum(Integer.MAX_VALUE).element()).floatValue();
            }
            case MEAN: {
                return ((Float)vector.mean(Integer.MAX_VALUE).element()).floatValue();
            }
            case MIN: {
                return ((Float)vector.min(Integer.MAX_VALUE).element()).floatValue();
            }
            case MAX: {
                return ((Float)vector.max(Integer.MAX_VALUE).element()).floatValue();
            }
            case NORM_1: {
                return ((Float)vector.norm1(Integer.MAX_VALUE).element()).floatValue();
            }
            case NORM_2: {
                return ((Float)vector.norm2(Integer.MAX_VALUE).element()).floatValue();
            }
            case NORM_MAX: {
                return ((Float)vector.normmax(Integer.MAX_VALUE).element()).floatValue();
            }
        }
        throw new IllegalArgumentException("Illegal operation");
    }

    @Override
    public float squaredDistance(INDArray other) {
        float sd = 0.0f;
        for (int i = 0; i < this.length; ++i) {
            float d = this.get(i) - other.get(i);
            sd += d * d;
        }
        return sd;
    }

    @Override
    public float distance2(INDArray other) {
        return (float)Math.sqrt(this.squaredDistance(other));
    }

    @Override
    public float distance1(INDArray other) {
        return other.sub(this).sum(Integer.MAX_VALUE).get(0);
    }

    @Override
    public INDArray put(NDArrayIndex[] indices, INDArray element) {
        INDArray get = this.get(indices);
        INDArray linear = get.linearView();
        if (element.isScalar()) {
            for (int i = 0; i < linear.length(); ++i) {
                linear.putScalar(i, (Number)Float.valueOf(element.get(0)));
            }
        }
        if (Shape.shapeEquals(element.shape(), get.shape()) || element.length() == get.length()) {
            INDArray elementLinear = element.linearView();
            for (int i = 0; i < linear.length(); ++i) {
                linear.putScalar(i, (Number)Float.valueOf(elementLinear.get(i)));
            }
        }
        return this;
    }

    @Override
    public INDArray put(NDArrayIndex[] indices, Number element) {
        return this.put(indices, Nd4j.scalar(element));
    }

    @Override
    public void iterateOverAllColumns(SliceOp op) {
        if (this.isVector()) {
            op.operate(this);
        } else if (this.isMatrix()) {
            for (int i = 0; i < this.columns(); ++i) {
                op.operate(this.getColumn(i));
            }
        } else {
            for (int i = 0; i < this.slices(); ++i) {
                this.slice(i).iterateOverAllRows(op);
            }
        }
    }

    @Override
    public void iterateOverAllRows(SliceOp op) {
        if (this.isVector()) {
            op.operate(this);
        } else if (this.isMatrix()) {
            for (int i = 0; i < this.rows(); ++i) {
                op.operate(this.getRow(i));
            }
        } else {
            for (int i = 0; i < this.slices(); ++i) {
                this.slice(i).iterateOverAllRows(op);
            }
        }
    }

    @Override
    public INDArray swapAxes(int dimension, int with) {
        int[] shape = ArrayUtil.range(0, this.shape().length);
        shape[dimension] = with;
        shape[with] = dimension;
        return this.permute(shape);
    }

    @Override
    public int[] endsForSlices() {
        int[] ret = new int[this.slices()];
        int currOffset = this.offset + this.stride[0] - 1;
        for (int i = 0; i < this.slices(); ++i) {
            ret[i] = currOffset;
            currOffset += this.stride[0];
        }
        return ret;
    }

    @Override
    public float[] data() {
        return this.data;
    }

    @Override
    public void setData(float[] data) {
        this.data = data;
    }

    @Override
    public int slices() {
        if (this.shape.length < 1) {
            return 0;
        }
        return this.shape[0];
    }

    @Override
    public INDArray subArray(int[] offsets, int[] shape, int[] stride) {
        int n = shape.length;
        if (offsets.length != n) {
            throw new IllegalArgumentException("Invalid offset " + Arrays.toString(offsets));
        }
        if (shape.length != n) {
            throw new IllegalArgumentException("Invalid shape " + Arrays.toString(shape));
        }
        if (Arrays.equals(shape, this.shape)) {
            if (ArrayUtil.isZero(offsets)) {
                return this;
            }
            throw new IllegalArgumentException("Invalid subArray offsets");
        }
        if (this.isVector()) {
            return Nd4j.create(this.data, shape, stride, offsets[0]);
        }
        int offset = this.offset + ArrayUtil.dotProduct(offsets, stride);
        return Nd4j.create(this.data, Arrays.copyOf(shape, shape.length), stride, offset, this.ordering);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void iterateOverDimension(int dimension, SliceOp op, boolean modify) {
        if (dimension >= this.shape.length) {
            throw new IllegalArgumentException("Unable to remove dimension  " + dimension + " was >= shape length");
        }
        if (this.isScalar()) {
            if (dimension > 0) {
                throw new IllegalArgumentException("Dimension must be 0 for a scalar");
            }
            DimensionSlice slice = this.vectorForDimensionAndOffset(0, 0);
            op.operate(slice);
            if (!modify || slice.getIndices() == null) return;
            INDArray result = (INDArray)slice.getResult();
            for (int i = 0; i < slice.getIndices().length; ++i) {
                this.data[slice.getIndices()[i]] = ((Float)result.getScalar(i).element()).floatValue();
            }
            return;
        } else if (this.isVector()) {
            if (dimension == 0) {
                DimensionSlice slice = this.vectorForDimensionAndOffset(0, 0);
                op.operate(slice);
                if (!modify || slice.getIndices() == null) return;
                INDArray result = (INDArray)slice.getResult();
                for (int i = 0; i < slice.getIndices().length; ++i) {
                    this.data[slice.getIndices()[i]] = ((Float)result.getScalar(i).element()).floatValue();
                }
                return;
            } else {
                if (dimension != 1) throw new IllegalArgumentException("Illegal dimension for vector " + dimension);
                for (int i = 0; i < this.length; ++i) {
                    DimensionSlice slice = this.vectorForDimensionAndOffset(dimension, i);
                    op.operate(slice);
                    if (!modify || slice.getIndices() == null) continue;
                    INDArray result = (INDArray)slice.getResult();
                    for (int j = 0; j < slice.getIndices().length; ++j) {
                        this.data[slice.getIndices()[j]] = ((Float)result.getScalar(j).element()).floatValue();
                    }
                }
            }
            return;
        } else {
            for (int i = 0; i < this.vectorsAlongDimension(dimension); ++i) {
                INDArray vector = this.vectorAlongDimension(i, dimension);
                op.operate(vector);
            }
        }
    }

    @Override
    public void setStride(int[] stride) {
        this.stride = stride;
    }

    protected void initShape(int[] shape) {
        this.shape = shape;
        if (this.shape.length == 1) {
            this.rows = 1;
            this.columns = this.shape[0];
        } else if (this.shape().length == 2) {
            if (shape[0] == 1) {
                this.shape = new int[1];
                this.shape[0] = shape[1];
                this.rows = 1;
                this.columns = shape[1];
                if (this.stride != null && this.ordering == 'f') {
                    this.stride = new int[]{ArrayUtil.nonOneStride(this.stride)};
                }
            } else {
                this.rows = shape[0];
                this.columns = shape[1];
            }
        } else if (this.shape.length == 1) {
            this.columns = this.shape[0];
            this.rows = 1;
        }
        if (this.ordering == '\u0000') {
            this.ordering = Nd4j.order().charValue();
        }
        this.length = ArrayUtil.prod(this.shape);
        if (this.stride == null) {
            this.stride = this.ordering == 'f' ? ArrayUtil.calcStridesFortran(shape) : ArrayUtil.calcStrides(this.shape);
        }
        if (this.stride.length != this.shape.length) {
            this.stride = this.ordering == 'f' ? ArrayUtil.calcStridesFortran(this.shape) : ArrayUtil.calcStrides(this.shape);
        }
    }

    @Override
    public INDArray getScalar(int i) {
        if (!this.isVector() && !this.isScalar()) {
            throw new IllegalArgumentException("Unable to do linear indexing with dimensions greater than 1");
        }
        int idx = this.linearIndex(i);
        return Nd4j.scalar(this.data[idx]);
    }

    protected void asserColumnVector(INDArray column) {
        assert (column.isColumnVector() || column.columns() == this.columns() && column.rows() == 1) : "Must only add a row vector";
        assert (column.length() == this.rows() || column.columns() == this.columns() && column.rows() == 1) : "Illegal row vector must have the same length as the number of rows in this ndarray";
    }

    protected INDArray doColumnWise(INDArray columnVector, char operation) {
        this.asserColumnVector(columnVector);
        if (columnVector.columns() == this.columns() && columnVector.rows() == 1) {
            block12: for (int i = 0; i < this.columns(); ++i) {
                switch (operation) {
                    case 'a': {
                        this.getColumn(i).addi(Float.valueOf(columnVector.get(i)));
                        continue block12;
                    }
                    case 's': {
                        this.getColumn(i).subi(Float.valueOf(columnVector.get(i)));
                        continue block12;
                    }
                    case 'm': {
                        this.getColumn(i).muli(Float.valueOf(columnVector.get(i)));
                        continue block12;
                    }
                    case 'd': {
                        this.getColumn(i).divi(Float.valueOf(columnVector.get(i)));
                    }
                }
            }
        } else {
            block13: for (int j = 0; j < this.columns(); ++j) {
                switch (operation) {
                    case 'a': {
                        this.getColumn(j).addi(columnVector);
                        continue block13;
                    }
                    case 's': {
                        this.getColumn(j).subi(columnVector);
                        continue block13;
                    }
                    case 'm': {
                        this.getColumn(j).muli(columnVector);
                        continue block13;
                    }
                    case 'd': {
                        this.getColumn(j).divi(columnVector);
                    }
                }
            }
        }
        return this;
    }

    protected void assertRowVector(INDArray rowVector) {
        assert (rowVector.isRowVector() || rowVector.rows() == this.rows() && rowVector.columns() == 1) : "Must only add a row vector";
        assert (rowVector.length() == this.columns() || rowVector.rows() == this.rows() && rowVector.columns() == 1) : "Illegal row vector must have the same length as the number of rows in this ndarray";
    }

    protected INDArray doRowWise(INDArray rowVector, char operation) {
        this.assertRowVector(rowVector);
        if (rowVector.rows() == this.rows() && rowVector.columns() == 1) {
            block12: for (int i = 0; i < this.rows(); ++i) {
                switch (operation) {
                    case 'a': {
                        this.getRow(i).addi(Float.valueOf(rowVector.get(i)));
                        continue block12;
                    }
                    case 's': {
                        this.getRow(i).subi(Float.valueOf(rowVector.get(i)));
                        continue block12;
                    }
                    case 'm': {
                        this.getRow(i).muli(Float.valueOf(rowVector.get(i)));
                        continue block12;
                    }
                    case 'd': {
                        this.getRow(i).divi(Float.valueOf(rowVector.get(i)));
                    }
                }
            }
        } else {
            block13: for (int j = 0; j < this.rows(); ++j) {
                switch (operation) {
                    case 'a': {
                        this.getRow(j).addi(rowVector);
                        continue block13;
                    }
                    case 's': {
                        this.getRow(j).subi(rowVector);
                        continue block13;
                    }
                    case 'm': {
                        this.getRow(j).muli(rowVector);
                        continue block13;
                    }
                    case 'd': {
                        this.getRow(j).divi(rowVector);
                    }
                }
            }
        }
        return this;
    }

    @Override
    public INDArray put(int i, INDArray element) {
        if (element == null) {
            throw new IllegalArgumentException("Unable to insert null element");
        }
        assert (element.isScalar()) : "Unable to insert non scalar element";
        int idx = this.linearIndex(i);
        this.data[idx] = ((Float)element.element()).floatValue();
        return this;
    }

    @Override
    public INDArray diviColumnVector(INDArray columnVector) {
        return this.doColumnWise(columnVector, 'd');
    }

    @Override
    public INDArray divColumnVector(INDArray columnVector) {
        return this.dup().diviColumnVector(columnVector);
    }

    @Override
    public INDArray diviRowVector(INDArray rowVector) {
        return this.doRowWise(rowVector, 'd');
    }

    @Override
    public INDArray divRowVector(INDArray rowVector) {
        return this.dup().diviRowVector(rowVector);
    }

    @Override
    public INDArray muliColumnVector(INDArray columnVector) {
        return this.doColumnWise(columnVector, 'm');
    }

    @Override
    public INDArray mulColumnVector(INDArray columnVector) {
        return this.dup().muliColumnVector(columnVector);
    }

    @Override
    public INDArray muliRowVector(INDArray rowVector) {
        return this.doRowWise(rowVector, 'm');
    }

    @Override
    public INDArray mulRowVector(INDArray rowVector) {
        return this.dup().muliRowVector(rowVector);
    }

    @Override
    public INDArray subiColumnVector(INDArray columnVector) {
        return this.doColumnWise(columnVector, 's');
    }

    @Override
    public INDArray subColumnVector(INDArray columnVector) {
        return this.dup().subiColumnVector(columnVector);
    }

    @Override
    public INDArray subiRowVector(INDArray rowVector) {
        return this.doRowWise(rowVector, 's');
    }

    @Override
    public INDArray subRowVector(INDArray rowVector) {
        return this.dup().subiRowVector(rowVector);
    }

    @Override
    public INDArray addiColumnVector(INDArray columnVector) {
        return this.doColumnWise(columnVector, 'a');
    }

    @Override
    public INDArray addColumnVector(INDArray columnVector) {
        return this.dup().addiColumnVector(columnVector);
    }

    @Override
    public INDArray addiRowVector(INDArray rowVector) {
        return this.doRowWise(rowVector, 'a');
    }

    @Override
    public INDArray addRowVector(INDArray rowVector) {
        return this.dup().addiRowVector(rowVector);
    }

    @Override
    public INDArray mmul(INDArray other) {
        int[] shape = new int[]{this.rows(), other.columns()};
        char order = Nd4j.factory().order();
        boolean switchedOrder = false;
        if (order != 'f') {
            Nd4j.factory().setOrder('f');
            switchedOrder = true;
        }
        INDArray result = Nd4j.create(shape);
        if (switchedOrder && order != 'f') {
            Nd4j.factory().setOrder('c');
        }
        return this.mmuli(other, result);
    }

    @Override
    public INDArray mmul(INDArray other, INDArray result) {
        return this.dup().mmuli(other, result);
    }

    @Override
    public INDArray div(INDArray other) {
        return this.dup().divi(other);
    }

    @Override
    public INDArray div(INDArray other, INDArray result) {
        return this.dup().divi(other, result);
    }

    @Override
    public INDArray mul(INDArray other) {
        return this.dup().muli(other);
    }

    @Override
    public INDArray mul(INDArray other, INDArray result) {
        return this.dup().muli(other, result);
    }

    @Override
    public INDArray sub(INDArray other) {
        return this.dup().subi(other);
    }

    @Override
    public INDArray sub(INDArray other, INDArray result) {
        return this.dup().subi(other, result);
    }

    @Override
    public INDArray add(INDArray other) {
        return this.dup().addi(other);
    }

    @Override
    public INDArray add(INDArray other, INDArray result) {
        return this.dup().addi(other, result);
    }

    @Override
    public INDArray mmuli(INDArray other) {
        return this.dup().mmuli(other, this);
    }

    @Override
    public INDArray mmuli(INDArray other, INDArray result) {
        INDArray otherArray = other;
        INDArray resultArray = result;
        LinAlgExceptions.assertMultiplies(this, other);
        if (other.isScalar()) {
            return this.muli(Float.valueOf(otherArray.get(0)), resultArray);
        }
        if (this.isScalar()) {
            return otherArray.muli(Float.valueOf(this.get(0)), resultArray);
        }
        if (result == this || result == other) {
            INDArray temp = Nd4j.create(resultArray.shape(), ArrayUtil.calcStridesFortran(resultArray.shape()));
            if (otherArray.columns() == 1) {
                Nd4j.getBlasWrapper().gemv(1.0f, this, otherArray, 0.0f, temp);
            } else {
                Nd4j.getBlasWrapper().gemm(1.0f, this, otherArray, 0.0f, temp);
            }
            Nd4j.getBlasWrapper().copy(temp, resultArray);
        } else if (otherArray.columns() == 1) {
            Nd4j.getBlasWrapper().gemv(1.0f, this, otherArray, 0.0f, resultArray);
        } else {
            Nd4j.getBlasWrapper().gemm(1.0f, this, otherArray, 0.0f, resultArray);
        }
        return resultArray;
    }

    @Override
    public INDArray divi(INDArray other) {
        return this.divi(other, (INDArray)this);
    }

    @Override
    public INDArray divi(INDArray other, INDArray result) {
        if (other.isScalar()) {
            return this.divi(Float.valueOf(other.get(0)), result);
        }
        if (this.isScalar()) {
            return other.divi(Float.valueOf(this.get(0)), result);
        }
        INDArray otherLinear = other.linearView();
        INDArray resultLinear = result.linearView();
        INDArray linearView = this.linearView();
        for (int i = 0; i < this.length; ++i) {
            resultLinear.putScalar(i, (Number)Float.valueOf(linearView.get(i) / otherLinear.get(i)));
        }
        return result;
    }

    @Override
    public INDArray muli(INDArray other) {
        return this.muli(other, (INDArray)this);
    }

    @Override
    public INDArray muli(INDArray other, INDArray result) {
        if (other.isScalar()) {
            return this.muli(Float.valueOf(other.get(0)), result);
        }
        if (this.isScalar()) {
            return other.muli(Float.valueOf(this.get(0)), result);
        }
        INDArray otherLinear = other.linearView();
        INDArray resultLinear = result.linearView();
        INDArray linearView = this.linearView();
        for (int i = 0; i < this.length; ++i) {
            resultLinear.putScalar(i, (Number)Float.valueOf(linearView.get(i) * otherLinear.get(i)));
        }
        return result;
    }

    @Override
    public INDArray subi(INDArray other) {
        return this.subi(other, (INDArray)this);
    }

    @Override
    public INDArray subi(INDArray other, INDArray result) {
        if (other.isScalar()) {
            return this.subi(Float.valueOf(other.get(0)), result);
        }
        if (this.isScalar()) {
            return other.rsubi(Float.valueOf(this.get(0)), result);
        }
        if (result == this) {
            Nd4j.getBlasWrapper().axpy(-1.0f, other, result);
        } else if (result == other) {
            Nd4j.getBlasWrapper().scal(-1.0f, result);
            Nd4j.getBlasWrapper().axpy(1.0f, this, result);
        } else {
            Nd4j.getBlasWrapper().copy(this, result);
            Nd4j.getBlasWrapper().axpy(-1.0f, other, result);
        }
        return result;
    }

    @Override
    public INDArray addi(INDArray other) {
        return this.addi(other, (INDArray)this);
    }

    @Override
    public INDArray addi(INDArray other, INDArray result) {
        if (other.isScalar()) {
            return result.addi(Float.valueOf(other.get(0)), result);
        }
        if (this.isScalar()) {
            return other.addi(Float.valueOf(this.get(0)), result);
        }
        if (result == this) {
            Nd4j.getBlasWrapper().axpy(1.0f, other, result);
        } else if (result == other) {
            Nd4j.getBlasWrapper().axpy(1.0f, this, result);
        } else {
            INDArray resultLinear = result.linearView();
            INDArray otherLinear = other.linearView();
            INDArray linear = this.linearView();
            for (int i = 0; i < resultLinear.length(); ++i) {
                resultLinear.putScalar(i, (Number)Float.valueOf(otherLinear.get(i) + linear.get(i)));
            }
        }
        return result;
    }

    @Override
    public INDArray normmax(int dimension) {
        if (this.isVector()) {
            return Nd4j.scalar(Ops.normmax(this));
        }
        int[] shape = ArrayUtil.removeIndex(this.shape(), dimension);
        final INDArray arr = Nd4j.create(new int[]{ArrayUtil.prod(shape)});
        final AtomicInteger i = new AtomicInteger(0);
        this.iterateOverDimension(dimension, new SliceOp(){

            @Override
            public void operate(DimensionSlice nd) {
                INDArray arr2 = (INDArray)nd.getResult();
                arr.put(i.get(), arr2.normmax(0));
                i.incrementAndGet();
            }

            @Override
            public void operate(INDArray nd) {
                INDArray arr2 = nd;
                arr.put(i.get(), arr2.normmax(0));
                i.incrementAndGet();
            }
        }, false);
        return arr.reshape(shape);
    }

    @Override
    public INDArray rdiv(INDArray other) {
        return this.dup().rdivi(other);
    }

    @Override
    public INDArray rdivi(INDArray other) {
        return this.rdivi(other, (INDArray)this);
    }

    @Override
    public INDArray rdiv(INDArray other, INDArray result) {
        return this.dup().rdivi(other, result);
    }

    @Override
    public INDArray rdivi(INDArray other, INDArray result) {
        return other.divi(this, result);
    }

    @Override
    public INDArray rsub(INDArray other, INDArray result) {
        return this.dup().rsubi(other, result);
    }

    @Override
    public INDArray rsub(INDArray other) {
        return this.dup().rsubi(other);
    }

    @Override
    public INDArray rsubi(INDArray other) {
        return this.rsubi(other, (INDArray)this);
    }

    @Override
    public INDArray rsubi(INDArray other, INDArray result) {
        return other.subi(this, result);
    }

    @Override
    public INDArray assign(Number value) {
        INDArray one = this.linearView();
        for (int i = 0; i < one.length(); ++i) {
            one.put(i, Nd4j.scalar(value.doubleValue()));
        }
        return this;
    }

    @Override
    public int linearIndex(int i) {
        int realStride = this.stride[0];
        int idx = this.offset + i * realStride;
        if (this.data != null && idx >= this.data.length) {
            throw new IllegalArgumentException("Illegal index " + idx + " derived from " + i + " with offset of " + this.offset + " and stride of " + realStride);
        }
        return idx;
    }

    @Override
    public INDArray slice(int slice) {
        if (this.shape.length == 0) {
            throw new IllegalArgumentException("Can't slice a 0-d NDArray");
        }
        if (this.shape.length == 1) {
            if (this.size(0) == 1) {
                return Nd4j.create(this.data, ArrayUtil.empty(), ArrayUtil.empty(), this.offset + slice);
            }
            return Nd4j.create(this.data, ArrayUtil.empty(), ArrayUtil.empty(), this.offset + slice * this.stride[0]);
        }
        if (this.shape.length == 2) {
            if (this.size(0) == 1) {
                INDArray slice2 = Nd4j.create(this.data, ArrayUtil.of(this.shape[1]), Arrays.copyOfRange(this.stride, 1, this.stride.length), this.offset + slice, this.ordering);
                return slice2;
            }
            INDArray slice2 = Nd4j.create(this.data, ArrayUtil.of(this.shape[1]), Arrays.copyOfRange(this.stride, 1, this.stride.length), this.offset + slice * this.stride[0], this.ordering);
            return slice2;
        }
        int offset = this.offset + slice * this.stride[0];
        if (this.size(0) == 1) {
            INDArray slice2 = Nd4j.create(this.data, Arrays.copyOfRange(this.shape, 1, this.shape.length), Arrays.copyOfRange(this.stride, 1, this.stride.length), offset, this.ordering);
            return slice2;
        }
        INDArray slice2 = Nd4j.create(this.data, Arrays.copyOfRange(this.shape, 1, this.shape.length), Arrays.copyOfRange(this.stride, 1, this.stride.length), offset, this.ordering);
        return slice2;
    }

    @Override
    public INDArray slice(int slice, int dimension) {
        if (this.shape.length == 2) {
            if (dimension == 1) {
                return this.getRow(slice);
            }
            if (dimension == 0) {
                return this.getColumn(slice);
            }
            throw new IllegalAccessError("Illegal dimension for matrix");
        }
        if (slice == this.shape.length - 1) {
            return this.slice(dimension);
        }
        INDArray slice2 = Nd4j.create(this.data, ArrayUtil.removeIndex(this.shape, dimension), ArrayUtil.removeIndex(this.stride, dimension), this.offset + slice * this.stride[dimension], this.ordering);
        return slice2;
    }

    @Override
    public INDArray getScalar(int ... indexes) {
        int ix = this.offset;
        for (int i = 0; i < indexes.length; ++i) {
            ix += indexes[i] * this.stride[i];
        }
        if (ix >= this.data.length) {
            throw new IllegalArgumentException("Illegal index " + Arrays.toString(indexes));
        }
        return Nd4j.scalar(this.data[ix]);
    }

    @Override
    public INDArray rdiv(Number n) {
        return this.dup().rdivi(n);
    }

    @Override
    public INDArray rdivi(Number n) {
        return this.rdivi(Nd4j.valueArrayOf(this.shape(), n.doubleValue()));
    }

    @Override
    public INDArray rsub(Number n) {
        return this.dup().rsubi(n);
    }

    @Override
    public INDArray rsubi(Number n) {
        return this.rsubi(Nd4j.valueArrayOf(this.shape(), n.doubleValue()));
    }

    @Override
    public INDArray div(Number n) {
        return this.dup().divi(n);
    }

    @Override
    public INDArray divi(Number n) {
        return this.divi(n, (INDArray)this);
    }

    @Override
    public INDArray mul(Number n) {
        return this.dup().muli(n);
    }

    @Override
    public INDArray muli(Number n) {
        return this.muli(n, (INDArray)this);
    }

    @Override
    public INDArray sub(Number n) {
        return this.dup().subi(n);
    }

    @Override
    public INDArray subi(Number n) {
        return this.subi(n, (INDArray)this);
    }

    @Override
    public INDArray add(Number n) {
        return this.dup().addi(n);
    }

    @Override
    public INDArray addi(Number n) {
        return this.addi(n, (INDArray)this);
    }

    @Override
    public INDArray repmat(int[] shape) {
        int[] newShape = ArrayUtil.copy(this.shape());
        assert (shape.length <= newShape.length) : "Illegal shape: The passed in shape must be <= the current shape length";
        for (int i = 0; i < shape.length; ++i) {
            int n = i;
            newShape[n] = newShape[n] * shape[i];
        }
        INDArray result = Nd4j.create(newShape);
        if (this.isScalar()) {
            for (int i = 0; i < result.length(); ++i) {
                result.put(i, this.getScalar(0));
            }
        } else if (this.isMatrix()) {
            for (int c = 0; c < this.shape()[1]; ++c) {
                for (int r = 0; r < this.shape()[0]; ++r) {
                    for (int i = 0; i < this.rows(); ++i) {
                        for (int j = 0; j < this.columns(); ++j) {
                            result.put(r * this.rows() + i, c * this.columns() + j, this.getScalar(i, j));
                        }
                    }
                }
            }
        } else {
            int[] sliceRepmat = ArrayUtil.removeIndex(shape, 0);
            for (int i = 0; i < result.slices(); ++i) {
                result.putSlice(i, this.repmat(sliceRepmat));
            }
        }
        INDArray ret = result;
        return ret;
    }

    @Override
    public INDArray putRow(int row, INDArray toPut) {
        assert (toPut.isVector() && toPut.length() == this.columns) : "Illegal length for row " + toPut.length() + " should have been " + this.columns;
        INDArray r = this.getRow(row);
        for (int i = 0; i < r.length(); ++i) {
            r.putScalar(i, (Number)Float.valueOf(toPut.get(i)));
        }
        return this;
    }

    @Override
    public INDArray putColumn(int column, INDArray toPut) {
        assert (toPut.isVector() && toPut.length() == this.rows) : "Illegal length for row " + toPut.length() + " should have been " + this.columns;
        INDArray r = this.getColumn(column);
        for (int i = 0; i < r.length(); ++i) {
            r.putScalar(i, (Number)Float.valueOf(toPut.get(i)));
        }
        return this;
    }

    @Override
    public float get(int i) {
        int idx = this.linearIndex(i);
        if (idx < 0) {
            throw new IllegalStateException("Illegal index " + i);
        }
        return this.data[idx];
    }

    @Override
    public float get(int i, int j) {
        int idx = this.index(i, j);
        return this.data[idx];
    }

    public static int getIndex(int offset, int[] stride, int ... indexes) {
        if (stride.length > indexes.length) {
            throw new IllegalArgumentException("Invalid number of items in stride array: should be <= number of indexes");
        }
        int ix = offset;
        for (int i = 0; i < indexes.length; ++i) {
            ix += indexes[i] * stride[i];
        }
        return ix;
    }

    @Override
    public INDArray transpose() {
        if (this.isRowVector()) {
            return Nd4j.create(this.data, new int[]{this.shape[0], 1}, this.offset);
        }
        if (this.isColumnVector()) {
            return Nd4j.create(this.data, new int[]{this.shape[0]}, this.offset);
        }
        if (this.isMatrix()) {
            INDArray reverse = Nd4j.create(new int[]{this.shape[1], this.shape[0]});
            for (int i = 0; i < this.rows; ++i) {
                for (int j = 0; j < this.columns; ++j) {
                    reverse.put(j, i, Float.valueOf(this.get(i, j)));
                }
            }
            return reverse;
        }
        INDArray ret = this.permute(ArrayUtil.range(this.shape.length - 1, -1));
        return ret;
    }

    @Override
    public INDArray reshape(int[] shape) {
        assert (ArrayUtil.prod(shape) == ArrayUtil.prod(this.shape())) : "Illegal reshape must be of same length as data";
        return this.newShape(shape, this.ordering);
    }

    @Override
    public void checkDimensions(INDArray other) {
        assert (Arrays.equals(this.shape, other.shape())) : " Other array should have been shape: " + Arrays.toString(this.shape) + " but was " + Arrays.toString(other.shape());
        assert (Arrays.equals(this.stride, other.stride())) : " Other array should have been stride: " + Arrays.toString(this.stride) + " but was " + Arrays.toString(other.stride());
        assert (this.offset == other.offset()) : "Offset of this array is " + this.offset + " but other was " + other.offset();
    }

    @Override
    public INDArray prod(int dimension) {
        if (dimension == Integer.MAX_VALUE) {
            return Nd4j.scalar(Ops.prod(this));
        }
        if (this.isVector()) {
            return this.prod(Integer.MAX_VALUE);
        }
        int[] shape = ArrayUtil.removeIndex(this.shape(), dimension);
        final INDArray arr = Nd4j.create(new int[]{ArrayUtil.prod(shape)});
        final AtomicInteger i = new AtomicInteger(0);
        this.iterateOverDimension(dimension, new SliceOp(){

            @Override
            public void operate(DimensionSlice nd) {
                INDArray arr2 = (INDArray)nd.getResult();
                arr.put(i.get(), arr2.prod(0));
                i.incrementAndGet();
            }

            @Override
            public void operate(INDArray nd) {
                arr.put(i.get(), nd.prod(0));
                i.incrementAndGet();
            }
        }, false);
        return arr.reshape(shape);
    }

    @Override
    public INDArray mean(int dimension) {
        if (dimension == Integer.MAX_VALUE || this.isVector()) {
            return Nd4j.scalar(Ops.mean(this));
        }
        if (this.isVector()) {
            return Nd4j.scalar((Double)this.sum(Integer.MAX_VALUE).element() / (double)this.length());
        }
        int[] shape = ArrayUtil.removeIndex(this.shape(), dimension);
        final INDArray arr = Nd4j.create(new int[]{ArrayUtil.prod(shape)});
        final AtomicInteger i = new AtomicInteger(0);
        this.iterateOverDimension(dimension, new SliceOp(){

            @Override
            public void operate(DimensionSlice nd) {
                INDArray arr2 = (INDArray)nd.getResult();
                arr.put(i.get(), arr2.mean(0));
                i.incrementAndGet();
            }

            @Override
            public void operate(INDArray nd) {
                arr.put(i.get(), nd.mean(0));
                i.incrementAndGet();
            }
        }, false);
        return arr.reshape(shape);
    }

    @Override
    public INDArray var(int dimension) {
        if (dimension == Integer.MAX_VALUE || this.isVector()) {
            return Nd4j.scalar(Ops.var(this));
        }
        int[] shape = ArrayUtil.removeIndex(this.shape(), dimension);
        final INDArray arr = Nd4j.create(new int[]{ArrayUtil.prod(shape)});
        final AtomicInteger i = new AtomicInteger(0);
        this.iterateOverDimension(dimension, new SliceOp(){

            @Override
            public void operate(DimensionSlice nd) {
                INDArray arr2 = (INDArray)nd.getResult();
                arr.put(i.get(), arr2.var(0));
                i.incrementAndGet();
            }

            @Override
            public void operate(INDArray nd) {
                arr.put(i.get(), nd.var(0));
                i.incrementAndGet();
            }
        }, false);
        return arr.reshape(shape);
    }

    @Override
    public INDArray max(int dimension) {
        if (dimension == Integer.MAX_VALUE || this.isVector()) {
            return Nd4j.scalar(Ops.max(this));
        }
        int[] shape = ArrayUtil.removeIndex(this.shape(), dimension);
        final INDArray arr = Nd4j.create(new int[]{ArrayUtil.prod(shape)});
        final AtomicInteger i = new AtomicInteger(0);
        this.iterateOverDimension(dimension, new SliceOp(){

            @Override
            public void operate(DimensionSlice nd) {
                INDArray arr2 = (INDArray)nd.getResult();
                arr.put(i.get(), arr2.max(0));
                i.incrementAndGet();
            }

            @Override
            public void operate(INDArray nd) {
                arr.put(i.get(), nd.max(0));
                i.incrementAndGet();
            }
        }, false);
        return arr.reshape(shape).transpose();
    }

    @Override
    public INDArray min(int dimension) {
        if (dimension == Integer.MAX_VALUE || this.isVector()) {
            return Nd4j.scalar(Ops.min(this));
        }
        int[] shape = ArrayUtil.removeIndex(this.shape(), dimension);
        final INDArray arr = Nd4j.create(new int[]{ArrayUtil.prod(shape)});
        final AtomicInteger i = new AtomicInteger(0);
        this.iterateOverDimension(dimension, new SliceOp(){

            @Override
            public void operate(DimensionSlice nd) {
                INDArray arr2 = (INDArray)nd.getResult();
                arr.put(i.get(), arr2.min(0));
                i.incrementAndGet();
            }

            @Override
            public void operate(INDArray nd) {
                arr.put(i.get(), nd.min(0));
                i.incrementAndGet();
            }
        }, false);
        return arr.reshape(shape).transpose();
    }

    @Override
    public INDArray sum(int dimension) {
        if (dimension == Integer.MAX_VALUE || this.isVector()) {
            return Nd4j.scalar(Ops.sum(this));
        }
        if (this.isVector()) {
            return this.sum(Integer.MAX_VALUE);
        }
        int[] shape = ArrayUtil.removeIndex(this.shape(), dimension);
        final INDArray arr = Nd4j.create(new int[]{ArrayUtil.prod(shape)});
        final AtomicInteger i = new AtomicInteger(0);
        this.iterateOverDimension(dimension, new SliceOp(){

            @Override
            public void operate(DimensionSlice nd) {
                INDArray arr2 = (INDArray)nd.getResult();
                arr.put(i.get(), arr2.sum(0));
                i.incrementAndGet();
            }

            @Override
            public void operate(INDArray nd) {
                arr.put(i.get(), nd.sum(0));
                i.incrementAndGet();
            }
        }, false);
        return arr.reshape(shape);
    }

    @Override
    public INDArray norm1(int dimension) {
        if (this.isVector() || dimension == Integer.MAX_VALUE) {
            return Nd4j.scalar(Ops.norm1(this));
        }
        int[] shape = ArrayUtil.removeIndex(this.shape(), dimension);
        final INDArray arr = Nd4j.create(new int[]{ArrayUtil.prod(shape)});
        final AtomicInteger i = new AtomicInteger(0);
        this.iterateOverDimension(dimension, new SliceOp(){

            @Override
            public void operate(DimensionSlice nd) {
                INDArray arr2 = (INDArray)nd.getResult();
                arr.put(i.get(), arr2.norm1(0));
                i.incrementAndGet();
            }

            @Override
            public void operate(INDArray nd) {
                arr.put(i.get(), nd.norm1(0));
                i.incrementAndGet();
            }
        }, false);
        return arr.reshape(shape);
    }

    @Override
    public INDArray std(int dimension) {
        if (this.isVector() || dimension == Integer.MAX_VALUE) {
            return Nd4j.scalar(Ops.std(this));
        }
        int[] shape = ArrayUtil.removeIndex(this.shape(), dimension);
        final INDArray arr = Nd4j.create(new int[]{ArrayUtil.prod(shape)});
        final AtomicInteger i = new AtomicInteger(0);
        this.iterateOverDimension(dimension, new SliceOp(){

            @Override
            public void operate(DimensionSlice nd) {
                INDArray arr2 = (INDArray)nd.getResult();
                arr.put(i.get(), arr2.std(0));
                i.incrementAndGet();
            }

            @Override
            public void operate(INDArray nd) {
                arr.put(i.get(), nd.std(0));
                i.incrementAndGet();
            }
        }, false);
        return arr.reshape(shape);
    }

    @Override
    public INDArray norm2(int dimension) {
        if (this.isVector() || dimension == Integer.MAX_VALUE) {
            return Nd4j.scalar(Ops.norm2(this));
        }
        int[] shape = ArrayUtil.removeIndex(this.shape(), dimension);
        final INDArray arr = Nd4j.create(new int[]{ArrayUtil.prod(shape)});
        final AtomicInteger i = new AtomicInteger(0);
        this.iterateOverDimension(dimension, new SliceOp(){

            @Override
            public void operate(DimensionSlice nd) {
                INDArray arr2 = (INDArray)nd.getResult();
                arr.put(i.get(), arr2.norm2(0));
                i.incrementAndGet();
            }

            @Override
            public void operate(INDArray nd) {
                arr.put(i.get(), nd.norm2(0));
                i.incrementAndGet();
            }
        }, false);
        return arr.reshape(shape);
    }

    @Override
    public int columns() {
        if (this.isMatrix()) {
            if (this.shape().length > 2) {
                return Shape.squeeze(this.shape)[1];
            }
            if (this.shape().length == 2) {
                return this.shape[1];
            }
        }
        if (this.isVector()) {
            if (this.isColumnVector()) {
                return 1;
            }
            return this.shape[0];
        }
        throw new IllegalStateException("Unable to getFromOrigin number of of rows for a non 2d matrix");
    }

    @Override
    public int rows() {
        if (this.isMatrix()) {
            if (this.shape().length > 2) {
                return Shape.squeeze(this.shape)[0];
            }
            if (this.shape().length == 2) {
                return this.shape[0];
            }
        } else if (this.isVector()) {
            if (this.isRowVector()) {
                return 1;
            }
            return this.shape[0];
        }
        throw new IllegalStateException("Unable to getFromOrigin number of of rows for a non 2d matrix");
    }

    @Override
    public INDArray ravel() {
        INDArray ret = Nd4j.create(this.length, this.ordering);
        int dimension = this.shape.length == 2 ? 1 : this.shape.length;
        int count = 0;
        for (int i = 0; i < this.vectorsAlongDimension(dimension); ++i) {
            INDArray vec = this.vectorAlongDimension(i, dimension);
            for (int j = 0; j < vec.length(); ++j) {
                ret.putScalar(count++, (Number)Float.valueOf(vec.get(j)));
            }
        }
        return ret;
    }

    @Override
    public void sliceVectors(List<INDArray> list) {
        if (this.isVector()) {
            list.add(this);
        } else {
            for (int i = 0; i < this.slices(); ++i) {
                this.slice(i).sliceVectors(list);
            }
        }
    }

    @Override
    public INDArray reshape(int newRows, int newColumns) {
        assert (newRows * newColumns == this.length) : "Illegal new shape " + newRows + " x " + newColumns;
        return this.reshape(new int[]{newRows, newColumns});
    }

    @Override
    public INDArray getColumn(int c) {
        if (this.shape.length == 2) {
            if (this.ordering == 'c') {
                INDArray ret = Nd4j.create(this.data, new int[]{this.shape[0], 1}, new int[]{this.stride[0], 1}, this.offset + c, this.ordering);
                return ret;
            }
            INDArray ret = Nd4j.create(this.data, new int[]{this.shape[0], 1}, new int[]{this.stride[0], 1}, this.offset + c * this.rows(), this.ordering);
            return ret;
        }
        if (this.isColumnVector() && c == 0) {
            return this;
        }
        throw new IllegalArgumentException("Unable to get scalar column of non 2d matrix");
    }

    @Override
    public INDArray getRows(int[] rindices) {
        INDArray rows = Nd4j.create(rindices.length, this.columns());
        for (int i = 0; i < rindices.length; ++i) {
            rows.putRow(i, this.getRow(rindices[i]));
        }
        return rows;
    }

    @Override
    public INDArray get(NDArrayIndex ... indexes) {
        indexes = Indices.adjustIndices(this.shape(), indexes);
        int[] offsets = Indices.offsets(indexes);
        int[] shape = Indices.shape(this.shape(), indexes);
        int[] strides = ArrayUtil.copy(this.stride());
        return this.subArray(offsets, shape, strides);
    }

    @Override
    public INDArray getColumns(int[] cindices) {
        INDArray rows = Nd4j.create(this.rows(), cindices.length);
        for (int i = 0; i < cindices.length; ++i) {
            rows.putColumn(i, this.getColumn(cindices[i]));
        }
        return rows;
    }

    @Override
    public INDArray getRow(int r) {
        if (this.shape.length == 2) {
            if (this.ordering == 'c') {
                INDArray ret = Nd4j.create(this.data, new int[]{this.shape[1]}, new int[]{this.stride[1]}, this.offset + r * this.columns(), this.ordering);
                return ret;
            }
            INDArray ret = Nd4j.create(this.data, new int[]{this.shape[1]}, new int[]{this.stride[1]}, this.offset + r, this.ordering);
            return ret;
        }
        if (this.isRowVector() && r == 0) {
            return this;
        }
        throw new IllegalArgumentException("Unable to getFromOrigin row of non 2d matrix");
    }

    public boolean equals(Object o) {
        INDArray n = null;
        if (!(o instanceof INDArray)) {
            return false;
        }
        if (n == null) {
            n = (INDArray)o;
        }
        if (this.isScalar() && n.isScalar()) {
            float val2;
            float val = ((Float)this.element()).floatValue();
            return (double)Math.abs(val - (val2 = ((Float)n.element()).floatValue())) < 1.0E-6;
        }
        if (this.isVector() && n.isVector()) {
            for (int i = 0; i < this.length; ++i) {
                float comp;
                float curr = this.get(i);
                if (!((double)Math.abs(curr - (comp = n.get(i))) > 0.001)) continue;
                return false;
            }
            return true;
        }
        if (!Shape.shapeEquals(this.shape(), n.shape())) {
            return false;
        }
        if (this.slices() != n.slices()) {
            return false;
        }
        for (int i = 0; i < this.slices(); ++i) {
            INDArray nSlice;
            INDArray slice = this.slice(i);
            if (slice.equals(nSlice = n.slice(i))) continue;
            return false;
        }
        return true;
    }

    @Override
    public int[] shape() {
        return this.shape;
    }

    @Override
    public int[] stride() {
        return this.stride;
    }

    @Override
    public int offset() {
        return this.offset;
    }

    @Override
    public char ordering() {
        return this.ordering;
    }

    @Override
    public int size(int dimension) {
        if (this.isScalar()) {
            if (dimension == 0) {
                return this.length;
            }
            throw new IllegalArgumentException("Illegal dimension for scalar " + dimension);
        }
        if (this.isVector()) {
            if (dimension == 0) {
                return this.length;
            }
            if (dimension == 1) {
                return 1;
            }
        }
        return this.shape[dimension];
    }

    @Override
    public int length() {
        return this.length;
    }

    @Override
    public INDArray broadcast(int[] shape) {
        int targetDimensions = shape.length;
        int dims = this.shape.length;
        if (targetDimensions < dims) {
            throw new IllegalArgumentException("Invalid shape to broad cast " + Arrays.toString(shape));
        }
        if (dims == targetDimensions) {
            if (dims == 1 && shape.length == 1 && shape[0] == 1 || this.shape[0] == 1) {
                return this;
            }
            if (Shape.shapeEquals(shape, this.shape())) {
                return this;
            }
            throw new IllegalArgumentException("Invalid shape to broad cast " + Arrays.toString(shape));
        }
        int n = shape[0];
        INDArray s = this.broadcast(Arrays.copyOfRange(shape, 1, targetDimensions));
        return Nd4j.repeat(s, n);
    }

    @Override
    public INDArray dimShuffle(Object[] rearrange, int[] newOrder, boolean[] broadCastable) {
        int i;
        assert (broadCastable.length == this.shape.length) : "The broadcastable dimensions must be the same length as the current shape";
        boolean broadcast = false;
        HashSet<Object> set = new HashSet<Object>();
        for (int i2 = 0; i2 < rearrange.length; ++i2) {
            set.add(rearrange[i2]);
            if (rearrange[i2] instanceof Integer) {
                Integer j = (Integer)rearrange[i2];
                if (j < broadCastable.length) continue;
                throw new IllegalArgumentException("Illegal dimension, dimension must be < broadcastable.length (aka the real dimensions");
            }
            if (rearrange[i2] instanceof Character) {
                Character c = (Character)rearrange[i2];
                if (c.charValue() != 'x') {
                    throw new IllegalArgumentException("Illegal input: Must be x");
                }
                broadcast = true;
                continue;
            }
            throw new IllegalArgumentException("Only characters and integers allowed");
        }
        if (!broadcast) {
            int[] ret = new int[rearrange.length];
            for (int i3 = 0; i3 < ret.length; ++i3) {
                ret[i3] = (Integer)rearrange[i3];
            }
            return this.permute(ret);
        }
        ArrayList<Integer> drop = new ArrayList<Integer>();
        for (int i4 = 0; i4 < broadCastable.length; ++i4) {
            if (set.contains(i4)) continue;
            if (broadCastable[i4]) {
                drop.add(i4);
                continue;
            }
            throw new IllegalArgumentException("We can't drop the given dimension because its not broadcastable");
        }
        int[] shuffle = new int[broadCastable.length];
        int count = 0;
        for (int i5 = 0; i5 < rearrange.length; ++i5) {
            if (!(rearrange[i5] instanceof Integer)) continue;
            shuffle[count++] = (Integer)rearrange[i5];
        }
        ArrayList<Integer> augment = new ArrayList<Integer>();
        for (int i6 = 0; i6 < rearrange.length; ++i6) {
            if (!(rearrange[i6] instanceof Character)) continue;
            augment.add(i6);
        }
        Integer[] augmentDims = augment.toArray(new Integer[1]);
        count = 0;
        int[] newShape = new int[shuffle.length + drop.size()];
        for (int i7 = 0; i7 < newShape.length; ++i7) {
            newShape[count++] = i7 < shuffle.length ? shuffle[i7] : (Integer)drop.get(i7);
        }
        INDArray ret = this.permute(newShape);
        ArrayList<Integer> newDims = new ArrayList<Integer>();
        int[] shape = Arrays.copyOfRange(ret.shape(), 0, shuffle.length);
        for (i = 0; i < shape.length; ++i) {
            newDims.add(shape[i]);
        }
        for (i = 0; i < augmentDims.length; ++i) {
            newDims.add(augmentDims[i], 1);
        }
        int[] toReshape = ArrayUtil.toArray(newDims);
        ret = ret.reshape(toReshape);
        return ret;
    }

    @Override
    public INDArray permute(int[] rearrange) {
        if (rearrange.length != this.shape.length) {
            return this.dup();
        }
        this.checkArrangeArray(rearrange);
        int[] newShape = this.doPermuteSwap(this.shape, rearrange);
        int[] newStride = this.doPermuteSwap(this.stride, rearrange);
        return Nd4j.create(this.data, newShape, newStride, this.offset, this.ordering);
    }

    protected void copyRealTo(INDArray arr) {
        INDArray flattened = this.linearView();
        INDArray arrLinear = arr.linearView();
        for (int i = 0; i < flattened.length(); ++i) {
            arrLinear.putScalar(i, (Number)Float.valueOf(flattened.get(i)));
        }
    }

    protected int[] doPermuteSwap(int[] shape, int[] rearrange) {
        int[] ret = new int[shape.length];
        for (int i = 0; i < shape.length; ++i) {
            ret[i] = shape[rearrange[i]];
        }
        return ret;
    }

    protected void checkArrangeArray(int[] arr) {
        int i;
        assert (arr.length == this.shape.length) : "Invalid rearrangement: number of arrangement != shape";
        for (i = 0; i < arr.length; ++i) {
            if (arr[i] >= arr.length) {
                throw new IllegalArgumentException("The specified dimensions can't be swapped. Given element " + i + " was >= number of dimensions");
            }
            if (arr[i] >= 0) continue;
            throw new IllegalArgumentException("Invalid dimension: " + i + " : negative value");
        }
        for (i = 0; i < arr.length; ++i) {
            for (int j = 0; j < arr.length; ++j) {
                if (i == j || arr[i] != arr[j]) continue;
                throw new IllegalArgumentException("Permute array must have unique elements");
            }
        }
    }

    @Override
    public boolean isVector() {
        return this.shape.length == 1 || this.shape.length == 1 && this.shape[0] == 1 || this.shape.length == 2 && (this.shape[0] == 1 || this.shape[1] == 1) && !this.isScalar();
    }

    @Override
    public boolean isRowVector() {
        if (this.shape().length == 1) {
            return true;
        }
        if (this.isVector()) {
            return this.shape()[0] == 1;
        }
        return false;
    }

    @Override
    public boolean isColumnVector() {
        if (this.shape().length == 1) {
            return false;
        }
        if (this.isVector()) {
            return this.shape()[1] == 1;
        }
        return false;
    }

    public String toString() {
        if (this.isScalar()) {
            return this.element().toString();
        }
        if (this.isVector()) {
            StringBuilder sb = new StringBuilder();
            sb.append("[");
            for (int i = 0; i < this.length; ++i) {
                sb.append(this.get(i));
                if (i >= this.length - 1) continue;
                sb.append(" ,");
            }
            sb.append("]\n");
            return sb.toString();
        }
        StringBuilder sb = new StringBuilder();
        int length = this.shape[0];
        sb.append("[");
        if (length > 0) {
            sb.append(this.slice(0).toString());
            for (int i = 1; i < this.slices(); ++i) {
                sb.append(this.slice(i).toString());
                if (i >= length - 1) continue;
                sb.append(" ,");
            }
        }
        sb.append("]\n");
        return sb.toString();
    }

    @Override
    public Object element() {
        if (!this.isScalar()) {
            throw new IllegalStateException("Unable to retrieve element from non scalar matrix");
        }
        return Float.valueOf(this.data[this.offset]);
    }

    @Override
    public IComplexNDArray rdiv(IComplexNumber n) {
        return this.dup().rdivi(n);
    }

    @Override
    public IComplexNDArray rdivi(IComplexNumber n) {
        return this.rdivi(n, Nd4j.createComplex(this.shape()));
    }

    @Override
    public IComplexNDArray rsub(IComplexNumber n) {
        return this.dup().rsubi(n);
    }

    @Override
    public IComplexNDArray rsubi(IComplexNumber n) {
        return this.rsubi(n, Nd4j.createComplex(this.shape()));
    }

    @Override
    public IComplexNDArray div(IComplexNumber n) {
        return this.dup().divi(n);
    }

    @Override
    public IComplexNDArray divi(IComplexNumber n) {
        return this.divi(n, Nd4j.createComplex(this.shape()));
    }

    @Override
    public IComplexNDArray mul(IComplexNumber n) {
        return this.dup().muli(n);
    }

    @Override
    public IComplexNDArray muli(IComplexNumber n) {
        return this.muli(n, Nd4j.createComplex(this.shape()));
    }

    @Override
    public IComplexNDArray sub(IComplexNumber n) {
        return this.dup().subi(n);
    }

    @Override
    public IComplexNDArray subi(IComplexNumber n) {
        return this.subi(n, Nd4j.createComplex(this.shape()));
    }

    @Override
    public IComplexNDArray add(IComplexNumber n) {
        return this.dup().addi(n);
    }

    @Override
    public IComplexNDArray addi(IComplexNumber n) {
        return this.addi(n, Nd4j.createComplex(this.shape()));
    }

    @Override
    public IComplexNDArray rdiv(IComplexNumber n, IComplexNDArray result) {
        return this.dup().rdivi(n, result);
    }

    @Override
    public IComplexNDArray rdivi(IComplexNumber n, IComplexNDArray result) {
        return Nd4j.createComplex(this).rdivi(n, result);
    }

    @Override
    public IComplexNDArray rsub(IComplexNumber n, IComplexNDArray result) {
        return this.dup().rsubi(n, result);
    }

    @Override
    public IComplexNDArray rsubi(IComplexNumber n, IComplexNDArray result) {
        return Nd4j.createComplex(this).rsubi(n, result);
    }

    @Override
    public IComplexNDArray div(IComplexNumber n, IComplexNDArray result) {
        return this.dup().divi(n, result);
    }

    @Override
    public IComplexNDArray divi(IComplexNumber n, IComplexNDArray result) {
        return Nd4j.createComplex(this).divi(n, result);
    }

    @Override
    public IComplexNDArray mul(IComplexNumber n, IComplexNDArray result) {
        return this.dup().muli(n, result);
    }

    @Override
    public IComplexNDArray muli(IComplexNumber n, IComplexNDArray result) {
        return Nd4j.createComplex(this).muli(n, result);
    }

    @Override
    public IComplexNDArray sub(IComplexNumber n, IComplexNDArray result) {
        return this.dup().subi(n, result);
    }

    @Override
    public IComplexNDArray subi(IComplexNumber n, IComplexNDArray result) {
        return Nd4j.createComplex(this).subi(n, result);
    }

    @Override
    public IComplexNDArray add(IComplexNumber n, IComplexNDArray result) {
        return this.dup().addi(n, result);
    }

    @Override
    public IComplexNDArray addi(IComplexNumber n, IComplexNDArray result) {
        return Nd4j.createComplex(this).addi(n, result);
    }
}

