/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.api.test;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.concurrent.atomic.AtomicInteger;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.nd4j.linalg.api.ndarray.DimensionSlice;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.api.ndarray.SliceOp;
import org.nd4j.linalg.factory.Nd4j;
import org.nd4j.linalg.indexing.NDArrayIndex;
import org.nd4j.linalg.ops.reduceops.Ops;
import org.nd4j.linalg.ops.transforms.Transforms;
import org.nd4j.linalg.util.ArrayUtil;
import org.nd4j.linalg.util.Shape;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class NDArrayTests {
    private static Logger log = LoggerFactory.getLogger(NDArrayTests.class);
    private INDArray n = Nd4j.create(Nd4j.linspace(1, 8, 8).data(), new int[]{2, 2, 2});

    @Before
    public void before() {
        Nd4j.factory().setOrder('c');
    }

    @After
    public void after() {
        Nd4j.factory().setOrder('c');
    }

    @Test
    public void testScalarOps() {
        INDArray n = Nd4j.create(Nd4j.ones(27).data(), new int[]{3, 3, 3});
        Assert.assertEquals((double)27.0, (double)n.length(), (double)0.1);
        n.checkDimensions(n.addi(Nd4j.scalar(1.0)));
        n.checkDimensions(n.subi(Nd4j.scalar(1.0)));
        n.checkDimensions(n.muli(Nd4j.scalar(1.0)));
        n.checkDimensions(n.divi(Nd4j.scalar(1.0)));
        n = Nd4j.create(Nd4j.ones(27).data(), new int[]{3, 3, 3});
        Assert.assertEquals((double)27.0, (double)((Float)n.sum(Integer.MAX_VALUE).element()).floatValue(), (double)0.1);
        INDArray a = n.slice(2);
        Assert.assertEquals((Object)true, (Object)Arrays.equals(new int[]{3, 3}, a.shape()));
    }

    @Test
    public void testLinearViewGetAndPut() {
        INDArray test = Nd4j.linspace(1, 4, 4).reshape(2, 2);
        INDArray linear = test.linearView();
        linear.putScalar(2, (Number)6);
        linear.putScalar(3, (Number)7);
        Assert.assertEquals((double)6.0, (double)linear.get(2), (double)0.1);
        Assert.assertEquals((double)7.0, (double)linear.get(3), (double)0.1);
    }

    @Test
    public void testGetIndices() {
        Nd4j.factory().setOrder('f');
        INDArray test = Nd4j.linspace(1, 24, 24).reshape(4, 3, 2);
        NDArrayIndex oneTwo = NDArrayIndex.interval(1, 2);
        NDArrayIndex twoToThree = NDArrayIndex.interval(1, 3);
        INDArray get = test.get(oneTwo, twoToThree);
        Assert.assertTrue((boolean)Arrays.equals(new int[]{1, 2, 2}, get.shape()));
        Assert.assertEquals((Object)Nd4j.create(new float[]{6.0f, 10.0f, 18.0f, 22.0f}, new int[]{1, 2, 2}), (Object)get);
        INDArray anotherGet = Nd4j.create(new float[]{6.0f, 7.0f, 10.0f, 11.0f, 18.0f, 19.0f, 22.0f, 23.0f}, new int[]{2, 1, 2});
        INDArray test2 = test.get(NDArrayIndex.interval(1, 3), NDArrayIndex.interval(1, 4));
        Assert.assertEquals((long)5L, (long)test2.offset());
        Assert.assertTrue((boolean)Arrays.equals(new int[]{2, 1, 2}, test2.shape()));
        Assert.assertEquals((Object)test2, (Object)anotherGet);
    }

    @Test
    public void testSwapAxesFortranOrder() {
        Nd4j.factory().setOrder('f');
        INDArray n = Nd4j.create(Nd4j.linspace(1, 30, 30).data(), new int[]{3, 5, 2});
    }

    @Test
    public void testGetIndicesVector() {
        INDArray line = Nd4j.linspace(1, 4, 4);
        INDArray test = Nd4j.create(new float[]{2.0f, 3.0f});
        INDArray result = line.get(NDArrayIndex.interval(1, 3));
        Assert.assertEquals((Object)test, (Object)result);
    }

    @Test
    public void testGetIndices2d() {
        Nd4j.factory().setOrder('f');
        INDArray twoByTwo = Nd4j.linspace(1, 6, 6).reshape(3, 2);
        INDArray firstRow = twoByTwo.getRow(0);
        INDArray secondRow = twoByTwo.getRow(1);
        INDArray firstAndSecondRow = twoByTwo.getRows(new int[]{1, 2});
        INDArray firstRowViaIndexing = twoByTwo.get(NDArrayIndex.interval(0, 1));
        Assert.assertEquals((Object)firstRow, (Object)firstRowViaIndexing);
        INDArray secondRowViaIndexing = twoByTwo.get(NDArrayIndex.interval(1, 2));
        Assert.assertEquals((Object)secondRow, (Object)secondRowViaIndexing);
        INDArray individualElement = twoByTwo.get(NDArrayIndex.interval(1, 2), NDArrayIndex.interval(1, 2));
        Assert.assertEquals((Object)Nd4j.create(new float[]{5.0f}), (Object)individualElement);
        INDArray firstAndSecondRowTest = twoByTwo.get(NDArrayIndex.interval(1, 3));
        Assert.assertEquals((Object)firstAndSecondRow, (Object)firstAndSecondRowTest);
    }

    @Test
    public void testDimShuffle() {
        INDArray n = Nd4j.linspace(1, 4, 4).reshape(2, 2);
        INDArray twoOneTwo = n.dimShuffle(new Object[]{0, Character.valueOf('x'), 1}, new int[]{0, 1}, new boolean[]{false, false});
        Assert.assertTrue((boolean)Arrays.equals(new int[]{2, 1, 2}, twoOneTwo.shape()));
        INDArray reverse = n.dimShuffle(new Object[]{1, Character.valueOf('x'), 0}, new int[]{1, 0}, new boolean[]{false, false});
        Assert.assertTrue((boolean)Arrays.equals(new int[]{2, 1, 2}, reverse.shape()));
    }

    @Test
    public void testGetVsGetScalar() {
        INDArray a = Nd4j.linspace(1, 4, 4).reshape(2, 2);
        float element = a.get(0, 1);
        float element2 = ((Float)a.getScalar(0, 1).element()).floatValue();
        Assert.assertEquals((double)element, (double)element2, (double)0.1);
        Nd4j.factory().setOrder('f');
        INDArray a2 = Nd4j.linspace(1, 4, 4).reshape(2, 2);
        float element23 = a2.get(0, 1);
        float element22 = ((Float)a2.getScalar(0, 1).element()).floatValue();
        Assert.assertEquals((double)element23, (double)element22, (double)0.1);
    }

    @Test
    public void testDivide() {
        INDArray two = Nd4j.create(new float[]{2.0f, 2.0f, 2.0f, 2.0f});
        INDArray div = two.div(two);
        Assert.assertEquals((Object)Nd4j.ones(4), (Object)div);
        INDArray half = Nd4j.create(new float[]{0.5f, 0.5f, 0.5f, 0.5f}, new int[]{2, 2});
        INDArray divi = Nd4j.create(new float[]{0.3f, 0.6f, 0.9f, 0.1f}, new int[]{2, 2});
        INDArray assertion = Nd4j.create(new float[]{1.6666666f, 0.8333333f, 0.5555556f, 5.0f}, new int[]{2, 2});
        INDArray result = half.div(divi);
        Assert.assertEquals((Object)assertion, (Object)result);
    }

    @Test
    public void testSigmoid() {
        INDArray n = Nd4j.create(new float[]{1.0f, 2.0f, 3.0f, 4.0f});
        INDArray assertion = Nd4j.create(new float[]{0.7310586f, 0.8807971f, 0.95257413f, 0.98201376f});
        INDArray sigmoid = Transforms.sigmoid(n);
        Assert.assertEquals((Object)assertion, (Object)sigmoid);
    }

    @Test
    public void testNeg() {
        INDArray n = Nd4j.create(new float[]{1.0f, 2.0f, 3.0f, 4.0f});
        INDArray assertion = Nd4j.create(new float[]{-1.0f, -2.0f, -3.0f, -4.0f});
        INDArray neg = Transforms.neg(n);
        Assert.assertEquals((Object)assertion, (Object)neg);
    }

    @Test
    public void testNorm2() {
        INDArray n = Nd4j.create(new float[]{1.0f, 2.0f, 3.0f, 4.0f});
        float assertion = 5.477226f;
        Assert.assertEquals((double)assertion, (double)n.norm2(Integer.MAX_VALUE).get(0), (double)0.1);
    }

    @Test
    public void testExp() {
        INDArray n = Nd4j.create(new float[]{1.0f, 2.0f, 3.0f, 4.0f});
        INDArray assertion = Nd4j.create(new float[]{(float)Math.E, 7.389056f, 20.085537f, 54.59815f});
        INDArray exped = Transforms.exp(n);
        Assert.assertEquals((Object)assertion, (Object)exped);
    }

    @Test
    public void testSlices() {
        INDArray arr = Nd4j.create(Nd4j.linspace(1, 24, 24).data(), new int[]{4, 3, 2});
        for (int i = 0; i < arr.slices(); ++i) {
            Assert.assertEquals((long)2L, (long)arr.slice(i).slice(1).slices());
        }
    }

    @Test
    public void testScalar() {
        INDArray a = Nd4j.scalar(1.0);
        Assert.assertEquals((Object)true, (Object)a.isScalar());
        INDArray n = Nd4j.create(new float[]{1.0f}, new int[]{1, 1});
        Assert.assertEquals((Object)n, (Object)a);
        Assert.assertTrue((boolean)n.isScalar());
    }

    @Test
    public void testWrap() {
        INDArray vector;
        INDArray d;
        int[] shape = new int[]{2, 4};
        INDArray n = d = Nd4j.linspace(1, 8, 8).reshape(shape[0], shape[1]);
        Assert.assertEquals((long)d.rows(), (long)n.rows());
        Assert.assertEquals((long)d.columns(), (long)n.columns());
        INDArray testVector = vector = Nd4j.linspace(1, 3, 3);
        for (int i = 0; i < vector.length(); ++i) {
            Assert.assertEquals((double)((Float)vector.getScalar(i).element()).floatValue(), (double)((Float)testVector.getScalar(i).element()).floatValue(), (double)0.1);
        }
        Assert.assertEquals((long)3L, (long)testVector.length());
        Assert.assertEquals((Object)true, (Object)testVector.isVector());
        Assert.assertEquals((Object)true, (Object)Shape.shapeEquals(new int[]{3}, testVector.shape()));
        INDArray row12 = Nd4j.linspace(1, 2, 2).reshape(2, 1);
        INDArray row22 = Nd4j.linspace(3, 4, 2).reshape(1, 2);
        Assert.assertEquals((long)row12.rows(), (long)2L);
        Assert.assertEquals((long)row12.columns(), (long)1L);
        Assert.assertEquals((long)row22.rows(), (long)1L);
        Assert.assertEquals((long)row22.columns(), (long)2L);
    }

    @Test
    public void testGetRowFortran() {
        Nd4j.factory().setOrder('f');
        INDArray n = Nd4j.create(Nd4j.linspace(1, 4, 4).data(), new int[]{2, 2});
        INDArray column = Nd4j.create(new float[]{1.0f, 3.0f});
        INDArray column2 = Nd4j.create(new float[]{2.0f, 4.0f});
        INDArray testColumn = n.getRow(0);
        INDArray testColumn1 = n.getRow(1);
        Assert.assertEquals((Object)column, (Object)testColumn);
        Assert.assertEquals((Object)column2, (Object)testColumn1);
        Nd4j.factory().setOrder('c');
    }

    @Test
    public void testGetColumnFortran() {
        Nd4j.factory().setOrder('f');
        INDArray n = Nd4j.create(Nd4j.linspace(1, 4, 4).data(), new int[]{2, 2});
        INDArray column = Nd4j.create(new float[]{1.0f, 2.0f});
        INDArray column2 = Nd4j.create(new float[]{3.0f, 4.0f});
        INDArray testColumn = n.getColumn(0);
        INDArray testColumn1 = n.getColumn(1);
        Assert.assertEquals((Object)column, (Object)testColumn);
        Assert.assertEquals((Object)column2, (Object)testColumn1);
        Nd4j.factory().setOrder('c');
    }

    @Test
    public void testVectorInit() {
        float[] data = Nd4j.linspace(1, 4, 4).data();
        INDArray arr = Nd4j.create(data, new int[]{4});
        Assert.assertEquals((Object)true, (Object)arr.isRowVector());
        INDArray arr2 = Nd4j.create(data, new int[]{1, 4});
        Assert.assertEquals((Object)true, (Object)arr2.isRowVector());
        INDArray columnVector = Nd4j.create(data, new int[]{4, 1});
        Assert.assertEquals((Object)true, (Object)columnVector.isColumnVector());
    }

    @Test
    public void testColumns() {
        INDArray arr = Nd4j.create(new int[]{3, 2});
        INDArray column2 = arr.getColumn(0);
        Assert.assertEquals((Object)true, (Object)Shape.shapeEquals(new int[]{3, 1}, column2.shape()));
        INDArray column = Nd4j.create(new float[]{1.0f, 2.0f, 3.0f}, new int[]{3});
        arr.putColumn(0, column);
        INDArray firstColumn = arr.getColumn(0);
        Assert.assertEquals((Object)column, (Object)firstColumn);
        INDArray column1 = Nd4j.create(new float[]{4.0f, 5.0f, 6.0f}, new int[]{3});
        arr.putColumn(1, column1);
        Assert.assertEquals((Object)true, (Object)Shape.shapeEquals(new int[]{3, 1}, arr.getColumn(1).shape()));
        INDArray testRow1 = arr.getColumn(1);
        Assert.assertEquals((Object)column1, (Object)testRow1);
        INDArray evenArr = Nd4j.create(new float[]{1.0f, 2.0f, 3.0f, 4.0f}, new int[]{2, 2});
        INDArray put = Nd4j.create(new float[]{5.0f, 6.0f}, new int[]{2});
        evenArr.putColumn(1, put);
        INDArray testColumn = evenArr.getColumn(1);
        Assert.assertEquals((Object)put, (Object)testColumn);
        INDArray n = Nd4j.create(Nd4j.linspace(1, 4, 4).data(), new int[]{2, 2});
        INDArray column23 = n.getColumn(0);
        INDArray column12 = Nd4j.create(new float[]{1.0f, 3.0f}, new int[]{2});
        Assert.assertEquals((Object)column23, (Object)column12);
        INDArray column0 = n.getColumn(1);
        INDArray column01 = Nd4j.create(new float[]{2.0f, 4.0f}, new int[]{2});
        Assert.assertEquals((Object)column0, (Object)column01);
    }

    @Test
    public void testPutRow() {
        INDArray d = Nd4j.linspace(1, 4, 4).reshape(2, 2);
        INDArray n = d.dup();
        float nFirst = 2.0f;
        float dFirst = d.get(0, 1);
        Assert.assertEquals((double)nFirst, (double)dFirst, (double)0.1);
        Assert.assertEquals((Object)true, (Object)Arrays.equals(d.data(), n.data()));
        Assert.assertEquals((Object)true, (Object)Arrays.equals(new int[]{2, 2}, n.shape()));
        INDArray newRow = Nd4j.linspace(5, 6, 2);
        n.putRow(0, newRow);
        d.putRow(0, newRow);
        INDArray testRow = n.getRow(0);
        Assert.assertEquals((long)newRow.length(), (long)testRow.length());
        Assert.assertEquals((Object)true, (Object)Shape.shapeEquals(new int[]{2}, testRow.shape()));
        INDArray nLast = Nd4j.create(Nd4j.linspace(1, 4, 4).data(), new int[]{2, 2});
        INDArray row = nLast.getRow(1);
        INDArray row1 = Nd4j.create(new float[]{3.0f, 4.0f}, new int[]{2});
        Assert.assertEquals((Object)row, (Object)row1);
        INDArray arr = Nd4j.create(new int[]{3, 2});
        INDArray evenRow = Nd4j.create(new float[]{1.0f, 2.0f}, new int[]{2});
        arr.putRow(0, evenRow);
        INDArray firstRow = arr.getRow(0);
        Assert.assertEquals((Object)true, (Object)Shape.shapeEquals(new int[]{2}, firstRow.shape()));
        INDArray testRowEven = arr.getRow(0);
        Assert.assertEquals((Object)evenRow, (Object)testRowEven);
        INDArray row12 = Nd4j.create(new float[]{5.0f, 6.0f}, new int[]{2});
        arr.putRow(1, row12);
        Assert.assertEquals((Object)true, (Object)Shape.shapeEquals(new int[]{2}, arr.getRow(0).shape()));
        INDArray testRow1 = arr.getRow(1);
        Assert.assertEquals((Object)row12, (Object)testRow1);
        INDArray multiSliceTest = Nd4j.create(Nd4j.linspace(1, 16, 16).data(), new int[]{4, 2, 2});
        INDArray test = Nd4j.create(new float[]{7.0f, 8.0f}, new int[]{2});
        INDArray test2 = Nd4j.create(new float[]{9.0f, 10.0f}, new int[]{2});
        Assert.assertEquals((Object)test, (Object)multiSliceTest.slice(1).getRow(1));
        Assert.assertEquals((Object)test2, (Object)multiSliceTest.slice(1).getRow(2));
    }

    @Test
    public void testOrdering() {
        Nd4j.factory().setOrder('c');
        Nd4j.factory().setDType("float");
        INDArray data = Nd4j.create(new float[]{1.0f, 2.0f, 3.0f, 4.0f}, new int[]{2, 2});
        Assert.assertEquals((double)2.0, (double)((Float)data.getScalar(0, 1).element()).floatValue(), (double)0.1);
        Nd4j.factory().setOrder('f');
        INDArray data2 = Nd4j.create(new float[]{1.0f, 2.0f, 3.0f, 4.0f}, new int[]{2, 2});
        Assert.assertNotEquals((Object)data2.getScalar(0, 1), (Object)data.getScalar(0, 1));
        Nd4j.factory().setOrder('c');
    }

    @Test
    public void testSum() {
        INDArray n = Nd4j.create(Nd4j.linspace(1, 8, 8).data(), new int[]{2, 2, 2});
        INDArray test = Nd4j.create(new float[]{3.0f, 7.0f, 11.0f, 15.0f}, new int[]{2, 2});
        INDArray sum = n.sum(n.shape().length - 1);
        Assert.assertEquals((Object)test, (Object)sum);
    }

    @Test
    public void testMmulF() {
        Nd4j.factory().setOrder('f');
        float[] data = Nd4j.linspace(1, 10, 10).data();
        INDArray n = Nd4j.create(data, new int[]{10});
        INDArray transposed = n.transpose();
        Assert.assertEquals((Object)true, (Object)n.isRowVector());
        Assert.assertEquals((Object)true, (Object)transposed.isColumnVector());
        INDArray d = Nd4j.create(Arrays.copyOf(n.data(), n.data().length), new int[]{n.rows(), n.columns()});
        INDArray innerProduct = n.mmul(transposed);
        INDArray scalar = Nd4j.scalar(385.0f);
        Assert.assertEquals((Object)scalar, (Object)innerProduct);
    }

    @Test
    public void testMmul() {
        Nd4j.factory().setOrder('c');
        float[] data = Nd4j.linspace(1, 10, 10).data();
        INDArray n = Nd4j.create(data, new int[]{10});
        INDArray transposed = n.transpose();
        Assert.assertEquals((Object)true, (Object)n.isRowVector());
        Assert.assertEquals((Object)true, (Object)transposed.isColumnVector());
        INDArray d = Nd4j.create(n.rows(), n.columns());
        d.setData(n.data());
        INDArray innerProduct = n.mmul(transposed);
        INDArray scalar = Nd4j.scalar(385.0f);
        Assert.assertEquals((Object)scalar, (Object)innerProduct);
        INDArray outerProduct = transposed.mmul(n);
        Assert.assertEquals((Object)true, (Object)Shape.shapeEquals(new int[]{10, 10}, outerProduct.shape()));
        INDArray testMatrix = Nd4j.create(data, new int[]{5, 2});
        INDArray row1 = testMatrix.getRow(0).transpose();
        INDArray row2 = testMatrix.getRow(1);
        INDArray row12 = Nd4j.linspace(1, 2, 2).reshape(2, 1);
        INDArray row22 = Nd4j.linspace(3, 4, 2).reshape(1, 2);
        INDArray row122 = row12;
        INDArray row222 = row22;
        INDArray rowResult2 = row122.mmul(row222);
        INDArray d3 = Nd4j.create(new float[]{1.0f, 2.0f}).reshape(2, 1);
        INDArray d4 = Nd4j.create(new float[]{3.0f, 4.0f});
        INDArray resultNDArray = d3.mmul(d4);
        INDArray result = Nd4j.create(new float[][]{{3.0f, 4.0f}, {6.0f, 8.0f}});
        Assert.assertEquals((Object)result, (Object)resultNDArray);
        INDArray three = Nd4j.create(new float[]{3.0f, 4.0f}, new int[]{2});
        INDArray test = Nd4j.create(Nd4j.linspace(1, 30, 30).data(), new int[]{3, 5, 2});
        INDArray sliceRow = test.slice(0).getRow(1);
        Assert.assertEquals((Object)three, (Object)sliceRow);
        INDArray twoSix = Nd4j.create(new float[]{2.0f, 6.0f}, new int[]{2, 1});
        INDArray threeTwoSix = three.mmul(twoSix);
        INDArray sliceRowTwoSix = sliceRow.mmul(twoSix);
        Assert.assertEquals((Object)threeTwoSix, (Object)sliceRowTwoSix);
        INDArray vectorVector = Nd4j.create(new float[]{0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 2.0f, 3.0f, 4.0f, 5.0f, 6.0f, 7.0f, 8.0f, 9.0f, 10.0f, 11.0f, 12.0f, 13.0f, 14.0f, 15.0f, 0.0f, 2.0f, 4.0f, 6.0f, 8.0f, 10.0f, 12.0f, 14.0f, 16.0f, 18.0f, 20.0f, 22.0f, 24.0f, 26.0f, 28.0f, 30.0f, 0.0f, 3.0f, 6.0f, 9.0f, 12.0f, 15.0f, 18.0f, 21.0f, 24.0f, 27.0f, 30.0f, 33.0f, 36.0f, 39.0f, 42.0f, 45.0f, 0.0f, 4.0f, 8.0f, 12.0f, 16.0f, 20.0f, 24.0f, 28.0f, 32.0f, 36.0f, 40.0f, 44.0f, 48.0f, 52.0f, 56.0f, 60.0f, 0.0f, 5.0f, 10.0f, 15.0f, 20.0f, 25.0f, 30.0f, 35.0f, 40.0f, 45.0f, 50.0f, 55.0f, 60.0f, 65.0f, 70.0f, 75.0f, 0.0f, 6.0f, 12.0f, 18.0f, 24.0f, 30.0f, 36.0f, 42.0f, 48.0f, 54.0f, 60.0f, 66.0f, 72.0f, 78.0f, 84.0f, 90.0f, 0.0f, 7.0f, 14.0f, 21.0f, 28.0f, 35.0f, 42.0f, 49.0f, 56.0f, 63.0f, 70.0f, 77.0f, 84.0f, 91.0f, 98.0f, 105.0f, 0.0f, 8.0f, 16.0f, 24.0f, 32.0f, 40.0f, 48.0f, 56.0f, 64.0f, 72.0f, 80.0f, 88.0f, 96.0f, 104.0f, 112.0f, 120.0f, 0.0f, 9.0f, 18.0f, 27.0f, 36.0f, 45.0f, 54.0f, 63.0f, 72.0f, 81.0f, 90.0f, 99.0f, 108.0f, 117.0f, 126.0f, 135.0f, 0.0f, 10.0f, 20.0f, 30.0f, 40.0f, 50.0f, 60.0f, 70.0f, 80.0f, 90.0f, 100.0f, 110.0f, 120.0f, 130.0f, 140.0f, 150.0f, 0.0f, 11.0f, 22.0f, 33.0f, 44.0f, 55.0f, 66.0f, 77.0f, 88.0f, 99.0f, 110.0f, 121.0f, 132.0f, 143.0f, 154.0f, 165.0f, 0.0f, 12.0f, 24.0f, 36.0f, 48.0f, 60.0f, 72.0f, 84.0f, 96.0f, 108.0f, 120.0f, 132.0f, 144.0f, 156.0f, 168.0f, 180.0f, 0.0f, 13.0f, 26.0f, 39.0f, 52.0f, 65.0f, 78.0f, 91.0f, 104.0f, 117.0f, 130.0f, 143.0f, 156.0f, 169.0f, 182.0f, 195.0f, 0.0f, 14.0f, 28.0f, 42.0f, 56.0f, 70.0f, 84.0f, 98.0f, 112.0f, 126.0f, 140.0f, 154.0f, 168.0f, 182.0f, 196.0f, 210.0f, 0.0f, 15.0f, 30.0f, 45.0f, 60.0f, 75.0f, 90.0f, 105.0f, 120.0f, 135.0f, 150.0f, 165.0f, 180.0f, 195.0f, 210.0f, 225.0f}, new int[]{16, 16});
        INDArray n1 = Nd4j.create(Nd4j.linspace(0, 15, 16).data(), new int[]{16});
        INDArray k1 = n1.transpose();
        INDArray testVectorVector = k1.mmul(n1);
        Assert.assertEquals((Object)vectorVector, (Object)testVectorVector);
    }

    @Test
    public void testRowsColumns() {
        float[] data = Nd4j.linspace(1, 6, 6).data();
        INDArray rows = Nd4j.create(data, new int[]{2, 3});
        Assert.assertEquals((long)2L, (long)rows.rows());
        Assert.assertEquals((long)3L, (long)rows.columns());
        INDArray columnVector = Nd4j.create(data, new int[]{6, 1});
        Assert.assertEquals((long)6L, (long)columnVector.rows());
        Assert.assertEquals((long)1L, (long)columnVector.columns());
        INDArray rowVector = Nd4j.create(data, new int[]{6});
        Assert.assertEquals((long)1L, (long)rowVector.rows());
        Assert.assertEquals((long)6L, (long)rowVector.columns());
    }

    @Test
    public void testTranspose() {
        INDArray n = Nd4j.create(Nd4j.ones(100).data(), new int[]{5, 5, 4});
        INDArray transpose = n.transpose();
        Assert.assertEquals((long)n.length(), (long)transpose.length());
        Assert.assertEquals((Object)true, (Object)Arrays.equals(new int[]{4, 5, 5}, transpose.shape()));
        INDArray rowVector = Nd4j.linspace(1, 10, 10);
        Assert.assertTrue((boolean)rowVector.isRowVector());
        INDArray columnVector = rowVector.transpose();
        Assert.assertTrue((boolean)columnVector.isColumnVector());
        INDArray linspaced = Nd4j.linspace(1, 4, 4).reshape(2, 2);
        INDArray transposed = Nd4j.create(new float[]{1.0f, 3.0f, 2.0f, 4.0f}, new int[]{2, 2});
        Assert.assertEquals((Object)transposed, (Object)linspaced.transpose());
        Nd4j.factory().setOrder('f');
        linspaced = Nd4j.linspace(1, 4, 4).reshape(2, 2);
        INDArray transposed2 = Nd4j.create(new float[]{1.0f, 3.0f, 2.0f, 4.0f}, new int[]{2, 2});
        transposed = linspaced.transpose();
        Assert.assertEquals((Object)transposed, (Object)transposed2);
        Nd4j.factory().setOrder('c');
    }

    @Test
    public void testPutSlice() {
        INDArray n = Nd4j.create(Nd4j.ones(27).data(), new int[]{3, 3, 3});
        INDArray newSlice = Nd4j.zeros(3, 3);
        n.putSlice(0, newSlice);
        Assert.assertEquals((Object)newSlice, (Object)n.slice(0));
    }

    @Test
    public void testPermute() {
        INDArray n = Nd4j.create(Nd4j.linspace(1, 20, 20).data(), new int[]{5, 4});
        INDArray transpose = n.transpose();
        INDArray permute = n.permute(1, 0);
        Assert.assertEquals((Object)permute, (Object)transpose);
        Assert.assertEquals((double)transpose.length(), (double)permute.length(), (double)0.1);
        INDArray toPermute = Nd4j.create(Nd4j.linspace(0, 7, 8).data(), new int[]{2, 2, 2});
        INDArray permuted = toPermute.permute(2, 1, 0);
        INDArray assertion = Nd4j.create(new float[]{0.0f, 4.0f, 2.0f, 6.0f, 1.0f, 5.0f, 3.0f, 7.0f}, new int[]{2, 2, 2});
        Assert.assertEquals((Object)permuted, (Object)assertion);
    }

    @Test
    public void testSlice() {
        Assert.assertEquals((long)8L, (long)this.n.length());
        Assert.assertEquals((Object)true, (Object)Arrays.equals(new int[]{2, 2, 2}, this.n.shape()));
        INDArray slice = this.n.slice(0);
        Assert.assertEquals((Object)true, (Object)Arrays.equals(new int[]{2, 2}, slice.shape()));
        INDArray slice1 = this.n.slice(1);
        Assert.assertNotEquals((Object)slice, (Object)slice1);
        INDArray arr = Nd4j.create(Nd4j.linspace(1, 24, 24).data(), new int[]{4, 3, 2});
        INDArray slice0 = Nd4j.create(new float[]{1.0f, 2.0f, 3.0f, 4.0f, 5.0f, 6.0f}, new int[]{3, 2});
        INDArray slice2 = Nd4j.create(new float[]{7.0f, 8.0f, 9.0f, 10.0f, 11.0f, 12.0f}, new int[]{3, 2});
        INDArray testSlice0 = arr.slice(0);
        INDArray testSlice1 = arr.slice(1);
        Assert.assertEquals((Object)slice0, (Object)testSlice0);
        Assert.assertEquals((Object)slice2, (Object)testSlice1);
    }

    @Test
    public void testSwapAxes() {
        INDArray n = Nd4j.create(Nd4j.linspace(0, 7, 8).data(), new int[]{2, 2, 2});
        INDArray assertion = n.permute(2, 1, 0);
        float[] data = assertion.data();
        INDArray validate = Nd4j.create(new float[]{0.0f, 4.0f, 2.0f, 6.0f, 1.0f, 5.0f, 3.0f, 7.0f}, new int[]{2, 2, 2});
        Assert.assertEquals((Object)validate, (Object)assertion);
    }

    @Test
    public void testLinearIndex() {
        INDArray n = Nd4j.create(Nd4j.linspace(1, 8, 8).data(), new int[]{8});
        for (int i = 0; i < n.length(); ++i) {
            int linearIndex = n.linearIndex(i);
            Assert.assertEquals((long)i, (long)linearIndex);
            float d = ((Float)n.getScalar(i).element()).floatValue();
            Assert.assertEquals((double)(i + 1), (double)d, (double)0.1);
        }
    }

    @Test
    public void testSliceConstructor() {
        ArrayList<INDArray> testList = new ArrayList<INDArray>();
        for (int i = 0; i < 5; ++i) {
            testList.add(Nd4j.scalar(i + 1));
        }
        INDArray test = Nd4j.create(testList, new int[]{testList.size()});
        INDArray expected = Nd4j.create(new float[]{1.0f, 2.0f, 3.0f, 4.0f, 5.0f}, new int[]{5});
        Assert.assertEquals((Object)expected, (Object)test);
    }

    @Test
    public void testVectorDimension() {
        INDArray test = Nd4j.create(Nd4j.linspace(1, 4, 4).data(), new int[]{2, 2});
        final AtomicInteger count = new AtomicInteger(0);
        test.iterateOverDimension(1, new SliceOp(){

            @Override
            public void operate(DimensionSlice nd) {
                INDArray test = (INDArray)nd.getResult();
                if (count.get() == 0) {
                    INDArray firstDimension = Nd4j.create(new float[]{1.0f, 2.0f}, new int[]{2});
                    Assert.assertEquals((Object)firstDimension, (Object)test);
                } else {
                    INDArray firstDimension = Nd4j.create(new float[]{3.0f, 4.0f}, new int[]{2});
                    Assert.assertEquals((Object)firstDimension, (Object)test);
                }
                count.incrementAndGet();
            }

            @Override
            public void operate(INDArray nd) {
                INDArray test = nd;
                if (count.get() == 0) {
                    INDArray firstDimension = Nd4j.create(new float[]{1.0f, 2.0f}, new int[]{2});
                    Assert.assertEquals((Object)firstDimension, (Object)test);
                } else {
                    INDArray firstDimension = Nd4j.create(new float[]{3.0f, 4.0f}, new int[]{2});
                    Assert.assertEquals((Object)firstDimension, (Object)test);
                }
                count.incrementAndGet();
            }
        }, false);
        count.set(0);
        test.iterateOverDimension(0, new SliceOp(){

            @Override
            public void operate(DimensionSlice nd) {
                log.info("Operator " + nd);
                INDArray test = (INDArray)nd.getResult();
                if (count.get() == 0) {
                    INDArray firstDimension = Nd4j.create(new float[]{1.0f, 3.0f}, new int[]{2});
                    Assert.assertEquals((Object)firstDimension, (Object)test);
                } else {
                    INDArray firstDimension = Nd4j.create(new float[]{2.0f, 4.0f}, new int[]{2});
                    Assert.assertEquals((Object)firstDimension, (Object)test);
                }
                count.incrementAndGet();
            }

            @Override
            public void operate(INDArray nd) {
                log.info("Operator " + nd);
                INDArray test = nd;
                if (count.get() == 0) {
                    INDArray firstDimension = Nd4j.create(new float[]{1.0f, 3.0f}, new int[]{2});
                    Assert.assertEquals((Object)firstDimension, (Object)test);
                } else {
                    INDArray firstDimension = Nd4j.create(new float[]{2.0f, 4.0f}, new int[]{2});
                    Assert.assertEquals((Object)firstDimension, (Object)test);
                }
                count.incrementAndGet();
            }
        }, false);
    }

    @Test
    public void testDimension() {
        INDArray test = Nd4j.create(Nd4j.linspace(1, 4, 4).data(), new int[]{2, 2});
        INDArray slice0 = test.slice(0, 1);
        INDArray slice02 = test.slice(1, 1);
        INDArray assertSlice0 = Nd4j.create(new float[]{1.0f, 2.0f});
        INDArray assertSlice02 = Nd4j.create(new float[]{3.0f, 4.0f});
        Assert.assertEquals((Object)assertSlice0, (Object)slice0);
        Assert.assertEquals((Object)assertSlice02, (Object)slice02);
        INDArray assertSlice1 = Nd4j.create(new float[]{1.0f, 3.0f});
        INDArray assertSlice12 = Nd4j.create(new float[]{2.0f, 4.0f});
        INDArray slice1 = test.slice(0, 0);
        INDArray slice12 = test.slice(1, 0);
        Assert.assertEquals((Object)assertSlice1, (Object)slice1);
        Assert.assertEquals((Object)assertSlice12, (Object)slice12);
        INDArray arr = Nd4j.create(Nd4j.linspace(1, 24, 24).data(), new int[]{4, 3, 2});
        INDArray firstSliceFirstDimension = arr.slice(0, 1);
        INDArray secondSliceFirstDimension = arr.slice(1, 1);
        INDArray firstSliceFirstDimensionAssert = Nd4j.create(new float[]{1.0f, 2.0f, 7.0f, 8.0f, 13.0f, 14.0f, 19.0f, 20.0f});
        INDArray secondSliceFirstDimension2Test = firstSliceFirstDimensionAssert.add(1);
        Assert.assertEquals((Object)secondSliceFirstDimension, (Object)secondSliceFirstDimension);
    }

    @Test
    public void testAppendBias() {
        INDArray rand = Nd4j.linspace(1, 25, 25).transpose();
        INDArray test = Nd4j.appendBias(rand);
        INDArray assertion = Nd4j.toFlattened(rand, Nd4j.scalar(1.0f));
        Assert.assertEquals((Object)assertion, (Object)test);
    }

    @Test
    public void testReshape() {
        INDArray arr = Nd4j.create(Nd4j.linspace(1, 24, 24).data(), new int[]{4, 3, 2});
        INDArray reshaped = arr.reshape(2, 3, 4);
        Assert.assertEquals((long)arr.length(), (long)reshaped.length());
        Assert.assertEquals((Object)true, (Object)Arrays.equals(new int[]{4, 3, 2}, arr.shape()));
        Assert.assertEquals((Object)true, (Object)Arrays.equals(new int[]{2, 3, 4}, reshaped.shape()));
        INDArray n2 = Nd4j.create(Nd4j.linspace(1, 30, 30).data(), new int[]{3, 5, 2});
        INDArray swapped = n2.swapAxes(n2.shape().length - 1, 1);
        INDArray firstSlice2 = swapped.slice(0).slice(0);
        INDArray oneThreeFiveSevenNine = Nd4j.create(new float[]{1.0f, 3.0f, 5.0f, 7.0f, 9.0f});
        Assert.assertEquals((Object)firstSlice2, (Object)oneThreeFiveSevenNine);
        INDArray raveled = oneThreeFiveSevenNine.reshape(5, 1);
        INDArray raveledOneThreeFiveSevenNine = oneThreeFiveSevenNine.reshape(5, 1);
        Assert.assertEquals((Object)raveled, (Object)raveledOneThreeFiveSevenNine);
        INDArray firstSlice3 = swapped.slice(0).slice(1);
        INDArray twoFourSixEightTen = Nd4j.create(new float[]{2.0f, 4.0f, 6.0f, 8.0f, 10.0f});
        Assert.assertEquals((Object)firstSlice2, (Object)oneThreeFiveSevenNine);
        INDArray raveled2 = twoFourSixEightTen.reshape(5, 1);
        INDArray raveled3 = firstSlice3.reshape(5, 1);
        Assert.assertEquals((Object)raveled2, (Object)raveled3);
    }

    @Test
    public void reduceTest() {
        INDArray arr = Nd4j.create(Nd4j.linspace(1, 24, 24).data(), new int[]{4, 3, 2});
        INDArray reduced = arr.reduce(Ops.DimensionOp.MAX, 1);
        log.info("Reduced " + reduced);
        reduced = arr.reduce(Ops.DimensionOp.MAX, 1);
        log.info("Reduced " + reduced);
        reduced = arr.reduce(Ops.DimensionOp.MAX, 2);
        log.info("Reduced " + reduced);
    }

    @Test
    public void testIdentity() {
        INDArray eye = Nd4j.eye(5);
        Assert.assertTrue((boolean)Arrays.equals(new int[]{5, 5}, eye.shape()));
        Nd4j.factory().setOrder('f');
        eye = Nd4j.eye(5);
        Assert.assertTrue((boolean)Arrays.equals(new int[]{5, 5}, eye.shape()));
    }

    @Test
    public void testColumnVectorOpsFortran() {
        Nd4j.factory().setOrder('f');
        INDArray twoByTwo = Nd4j.create(new float[]{1.0f, 2.0f, 3.0f, 4.0f}, new int[]{2, 2});
        INDArray toAdd = Nd4j.create(new float[]{1.0f, 2.0f}, new int[]{2, 1});
        twoByTwo.addiColumnVector(toAdd);
        INDArray assertion = Nd4j.create(new float[]{2.0f, 4.0f, 4.0f, 6.0f}, new int[]{2, 2});
        Assert.assertEquals((Object)assertion, (Object)twoByTwo);
    }

    @Test
    public void testMeans() {
        INDArray a = Nd4j.linspace(1, 4, 4).reshape(2, 2);
        Assert.assertEquals((Object)Nd4j.create(new float[]{2.0f, 3.0f}), (Object)a.mean(0));
        Assert.assertEquals((Object)Nd4j.create(new float[]{1.5f, 3.5f}), (Object)a.mean(1));
        Assert.assertEquals((double)2.5, (double)((Float)a.mean(Integer.MAX_VALUE).element()).floatValue(), (double)0.1);
    }

    @Test
    public void testSums() {
        INDArray a = Nd4j.linspace(1, 4, 4).reshape(2, 2);
        Assert.assertEquals((Object)Nd4j.create(new float[]{4.0f, 6.0f}), (Object)a.sum(0));
        Assert.assertEquals((Object)Nd4j.create(new float[]{3.0f, 7.0f}), (Object)a.sum(1));
        Assert.assertEquals((double)10.0, (double)((Float)a.sum(Integer.MAX_VALUE).element()).floatValue(), (double)0.1);
    }

    @Test
    public void testCumSum() {
        INDArray n = Nd4j.create(new float[]{1.0f, 2.0f, 3.0f, 4.0f}, new int[]{4});
        INDArray cumSumAnswer = Nd4j.create(new float[]{1.0f, 3.0f, 6.0f, 10.0f}, new int[]{4});
        INDArray cumSumTest = n.cumsum(0);
        Assert.assertEquals((Object)cumSumAnswer, (Object)cumSumTest);
        INDArray n2 = Nd4j.linspace(1, 24, 24).reshape(4, 3, 2);
        INDArray cumSumCorrect2 = Nd4j.create(new double[]{1.0, 3.0, 6.0, 10.0, 15.0, 21.0, 28.0, 36.0, 45.0, 55.0, 66.0, 78.0, 91.0, 105.0, 120.0, 136.0, 153.0, 171.0, 190.0, 210.0, 231.0, 253.0, 276.0, 300.0}, new int[]{24});
        INDArray cumSumTest2 = n2.cumsum(n2.shape().length - 1);
        Assert.assertEquals((Object)cumSumCorrect2, (Object)cumSumTest2);
        INDArray axis0assertion = Nd4j.create(new float[]{1.0f, 2.0f, 3.0f, 4.0f, 5.0f, 6.0f, 8.0f, 10.0f, 12.0f, 14.0f, 16.0f, 18.0f, 21.0f, 24.0f, 27.0f, 30.0f, 33.0f, 36.0f, 40.0f, 44.0f, 48.0f, 52.0f, 56.0f, 60.0f}, n2.shape());
        INDArray axis0Test = n2.cumsum(0);
        Assert.assertEquals((Object)axis0assertion, (Object)axis0Test);
    }

    @Test
    public void testRSubi() {
        INDArray n2 = Nd4j.ones(2);
        INDArray n2Assertion = Nd4j.zeros(2);
        INDArray nRsubi = n2.rsubi(1);
        Assert.assertEquals((Object)n2Assertion, (Object)nRsubi);
    }

    @Test
    public void testConcat() {
        INDArray A = Nd4j.linspace(1, 8, 8).reshape(2, 2, 2);
        INDArray B = Nd4j.linspace(1, 12, 12).reshape(3, 2, 2);
        INDArray concat = Nd4j.concat(0, A, B);
        Assert.assertTrue((boolean)Arrays.equals(new int[]{5, 2, 2}, concat.shape()));
    }

    @Test
    public void testConcatHorizontally() {
        INDArray rowVector = Nd4j.ones(5);
        INDArray other = Nd4j.ones(5);
        INDArray concat = Nd4j.hstack(other, rowVector);
        Assert.assertEquals((long)rowVector.rows(), (long)concat.rows());
        Assert.assertEquals((long)(rowVector.columns() * 2), (long)concat.columns());
    }

    @Test
    public void testConcatVertically() {
        INDArray rowVector = Nd4j.ones(5);
        INDArray other = Nd4j.ones(5);
        INDArray concat = Nd4j.vstack(other, rowVector);
        Assert.assertEquals((long)(rowVector.rows() * 2), (long)concat.rows());
        Assert.assertEquals((long)rowVector.columns(), (long)concat.columns());
    }

    @Test
    public void testRDivi() {
        INDArray n2 = Nd4j.valueArrayOf(new int[]{2}, 4.0);
        INDArray n2Assertion = Nd4j.valueArrayOf(new int[]{2}, 0.5);
        INDArray nRsubi = n2.rdivi(2);
        Assert.assertEquals((Object)n2Assertion, (Object)nRsubi);
    }

    @Test
    public void testVectorAlongDimension() {
        INDArray arr = Nd4j.linspace(1, 24, 24).reshape(4, 3, 2);
        INDArray assertion = Nd4j.create(new float[]{1.0f, 2.0f}, new int[]{2});
        Assert.assertEquals((Object)Nd4j.create(new float[]{3.0f, 4.0f}, new int[]{2}), (Object)arr.vectorAlongDimension(1, 2));
        Assert.assertEquals((Object)assertion, (Object)arr.vectorAlongDimension(0, 2));
        Assert.assertEquals((Object)arr.vectorAlongDimension(0, 1), (Object)Nd4j.create(new float[]{1.0f, 3.0f, 5.0f}));
        INDArray testColumn2Assertion = Nd4j.create(new float[]{7.0f, 9.0f, 11.0f});
        INDArray testColumn2 = arr.vectorAlongDimension(1, 1);
        Assert.assertEquals((Object)testColumn2Assertion, (Object)testColumn2);
        INDArray testColumn3Assertion = Nd4j.create(new float[]{13.0f, 15.0f, 17.0f});
        INDArray testColumn3 = arr.vectorAlongDimension(2, 1);
        Assert.assertEquals((Object)testColumn3Assertion, (Object)testColumn3);
        INDArray v1 = Nd4j.linspace(1, 4, 4).reshape(new int[]{2, 2});
        INDArray testColumnV1 = v1.vectorAlongDimension(0, 0);
        INDArray testColumnV1Assertion = Nd4j.create(new float[]{1.0f, 3.0f});
        Assert.assertEquals((Object)testColumnV1Assertion, (Object)testColumnV1);
        INDArray testRowV1 = v1.vectorAlongDimension(1, 0);
        INDArray testRowV1Assertion = Nd4j.create(new float[]{2.0f, 4.0f});
        Assert.assertEquals((Object)testRowV1Assertion, (Object)testRowV1);
        INDArray lastAxis = arr.vectorAlongDimension(0, 2);
        Assert.assertEquals((Object)assertion, (Object)lastAxis);
    }

    @Test
    public void testSquareMatrix() {
        INDArray n = Nd4j.create(Nd4j.linspace(1, 8, 8).data(), new int[]{2, 2, 2});
        INDArray eightFirstTest = n.vectorAlongDimension(0, 2);
        INDArray eightFirstAssertion = Nd4j.create(new float[]{1.0f, 2.0f}, new int[]{2});
        Assert.assertEquals((Object)eightFirstAssertion, (Object)eightFirstTest);
        INDArray eightFirstTestSecond = n.vectorAlongDimension(1, 2);
        INDArray eightFirstTestSecondAssertion = Nd4j.create(new float[]{3.0f, 4.0f});
        Assert.assertEquals((Object)eightFirstTestSecondAssertion, (Object)eightFirstTestSecond);
    }

    @Test
    public void testNumVectorsAlongDimension() {
        INDArray arr = Nd4j.linspace(1, 24, 24).reshape(4, 3, 2);
        Assert.assertEquals((long)12L, (long)arr.vectorsAlongDimension(2));
    }

    @Test
    public void testGetScalar() {
        INDArray scalar;
        int i;
        INDArray n = Nd4j.create(new float[]{1.0f, 2.0f, 3.0f, 4.0f}, new int[]{4});
        Assert.assertTrue((boolean)n.isVector());
        for (i = 0; i < n.length(); ++i) {
            scalar = Nd4j.scalar((float)i + 1.0f);
            Assert.assertEquals((Object)scalar, (Object)n.getScalar(i));
        }
        Nd4j.factory().setOrder('f');
        n = Nd4j.create(new float[]{1.0f, 2.0f, 3.0f, 4.0f}, new int[]{4});
        for (i = 0; i < n.length(); ++i) {
            scalar = Nd4j.scalar((float)i + 1.0f);
            Assert.assertEquals((Object)scalar, (Object)n.getScalar(i));
        }
        INDArray twoByTwo = Nd4j.create(new float[][]{{1.0f, 2.0f}, {3.0f, 4.0f}});
        INDArray column = twoByTwo.getColumn(0);
        Assert.assertEquals((Object)Nd4j.create(new float[]{1.0f, 3.0f}), (Object)column);
        Assert.assertEquals((double)1.0, (double)column.get(0), (double)0.1);
        Assert.assertEquals((double)3.0, (double)column.get(1), (double)0.1);
        Assert.assertEquals((Object)Nd4j.scalar(1.0f), (Object)column.getScalar(0));
        Assert.assertEquals((Object)Nd4j.scalar(3.0f), (Object)column.getScalar(1));
    }

    @Test
    public void testGetMulti() {
        Assert.assertEquals((long)8L, (long)this.n.length());
        Assert.assertEquals((Object)true, (Object)Arrays.equals(ArrayUtil.of(2, 2, 2), this.n.shape()));
        float val = ((Float)this.n.getScalar(new int[]{1, 1, 1}).element()).floatValue();
        Assert.assertEquals((double)8.0, (double)val, (double)1.0E-6);
    }

    @Test
    public void testGetRowOrdering() {
        INDArray row1 = Nd4j.linspace(1, 4, 4).reshape(2, 2);
        Nd4j.factory().setOrder('f');
        INDArray row1Fortran = Nd4j.linspace(1, 4, 4).reshape(2, 2);
        Assert.assertNotEquals((double)row1.get(0, 1), (double)row1Fortran.get(0, 1), (double)0.1);
        Nd4j.factory().setOrder('c');
    }

    @Test
    public void testBroadCast() {
        INDArray n = Nd4j.linspace(1, 4, 4);
        INDArray broadCasted = n.broadcast(new int[]{5, 4});
    }

    @Test
    public void testPutRowGetRowOrdering() {
        INDArray row1 = Nd4j.linspace(1, 4, 4).reshape(2, 2);
        INDArray put = Nd4j.create(new float[]{5.0f, 6.0f});
        row1.putRow(1, put);
        Nd4j.factory().setOrder('f');
        INDArray row1Fortran = Nd4j.linspace(1, 4, 4).reshape(2, 2);
        INDArray putFortran = Nd4j.create(new float[]{5.0f, 6.0f});
        row1Fortran.putRow(1, putFortran);
        Assert.assertNotEquals((Object)row1, (Object)row1Fortran);
        INDArray row1CTest = row1.getRow(1);
        INDArray row1FortranTest = row1Fortran.getRow(1);
        Assert.assertEquals((Object)row1CTest, (Object)row1FortranTest);
        Nd4j.factory().setOrder('c');
    }

    @Test
    public void testPutRowFortran() {
        INDArray row1 = Nd4j.linspace(1, 4, 4).reshape(2, 2);
        INDArray put = Nd4j.create(new float[]{5.0f, 6.0f});
        row1.putRow(1, put);
        Nd4j.factory().setOrder('f');
        INDArray row1Fortran = Nd4j.create(new float[][]{{1.0f, 2.0f}, {3.0f, 4.0f}});
        INDArray putFortran = Nd4j.create(new float[]{5.0f, 6.0f});
        row1Fortran.putRow(1, putFortran);
        Assert.assertEquals((Object)row1, (Object)row1Fortran);
        Nd4j.factory().setOrder('c');
    }

    @Test
    public void testElementWiseOps() {
        INDArray n1 = Nd4j.scalar(1.0f);
        INDArray n2 = Nd4j.scalar(2.0f);
        Assert.assertEquals((Object)Nd4j.scalar(3.0f), (Object)n1.add(n2));
        Assert.assertFalse((boolean)n1.add(n2).equals(n1));
        INDArray n3 = Nd4j.scalar(3.0f);
        INDArray n4 = Nd4j.scalar(4.0f);
        INDArray subbed = n4.sub(n3);
        INDArray mulled = n4.mul(n3);
        INDArray div = n4.div(n3);
        Assert.assertFalse((boolean)subbed.equals(n4));
        Assert.assertFalse((boolean)mulled.equals(n4));
        Assert.assertEquals((Object)Nd4j.scalar(1.0f), (Object)subbed);
        Assert.assertEquals((Object)Nd4j.scalar(12.0f), (Object)mulled);
        Assert.assertEquals((Object)Nd4j.scalar(1.3333333333333333), (Object)div);
    }

    @Test
    public void testSlicing() {
        INDArray arr = this.n.slice(1, 1);
        INDArray n2 = Nd4j.create(Nd4j.linspace(1, 16, 16).data(), new int[]{2, 2, 2, 2});
        log.info("N2 shape " + n2.slice(1, 1).slice(1));
    }

    @Test
    public void testEndsForSlices() {
        INDArray arr = Nd4j.create(Nd4j.linspace(1, 24, 24).data(), new int[]{4, 3, 2});
        int[] endsForSlices = arr.endsForSlices();
        Assert.assertEquals((Object)true, (Object)Arrays.equals(new int[]{5, 11, 17, 23}, endsForSlices));
    }

    @Test
    public void testFlatten() {
        INDArray arr = Nd4j.create(Nd4j.linspace(1, 4, 4).data(), new int[]{2, 2});
        INDArray flattened = arr.ravel();
        Assert.assertEquals((long)arr.length(), (long)flattened.length());
        Assert.assertEquals((Object)true, (Object)Shape.shapeEquals(new int[]{1, arr.length()}, flattened.shape()));
        for (int i = 0; i < arr.length(); ++i) {
            Assert.assertEquals((double)(i + 1), (double)flattened.get(i), (double)0.1);
        }
        Assert.assertTrue((boolean)flattened.isVector());
        INDArray n = Nd4j.create(Nd4j.ones(27).data(), new int[]{3, 3, 3});
        INDArray nFlattened = n.ravel();
        Assert.assertTrue((boolean)nFlattened.isVector());
        INDArray n1 = Nd4j.linspace(1, 24, 24);
        Assert.assertEquals((Object)n1, (Object)Nd4j.linspace(1, 24, 24).reshape(4, 3, 2).ravel());
    }

    @Test
    public void testVectorDimensionMulti() {
        INDArray arr = Nd4j.create(Nd4j.linspace(1, 24, 24).data(), new int[]{4, 3, 2});
        final AtomicInteger count = new AtomicInteger(0);
        arr.iterateOverDimension(arr.shape().length - 1, new SliceOp(){

            @Override
            public void operate(DimensionSlice nd) {
                INDArray test = (INDArray)nd.getResult();
                if (count.get() == 0) {
                    INDArray answer = Nd4j.create(new float[]{1.0f, 7.0f, 13.0f, 19.0f}, new int[]{4});
                    Assert.assertEquals((Object)answer, (Object)test);
                } else if (count.get() == 1) {
                    INDArray answer = Nd4j.create(new float[]{2.0f, 8.0f, 14.0f, 20.0f}, new int[]{4});
                    Assert.assertEquals((Object)answer, (Object)test);
                } else if (count.get() == 2) {
                    INDArray answer = Nd4j.create(new float[]{3.0f, 9.0f, 15.0f, 21.0f}, new int[]{4});
                    Assert.assertEquals((Object)answer, (Object)test);
                } else if (count.get() == 3) {
                    INDArray answer = Nd4j.create(new float[]{4.0f, 10.0f, 16.0f, 22.0f}, new int[]{4});
                    Assert.assertEquals((Object)answer, (Object)test);
                } else if (count.get() == 4) {
                    INDArray answer = Nd4j.create(new float[]{5.0f, 11.0f, 17.0f, 23.0f}, new int[]{4});
                    Assert.assertEquals((Object)answer, (Object)test);
                } else if (count.get() == 5) {
                    INDArray answer = Nd4j.create(new float[]{6.0f, 12.0f, 18.0f, 24.0f}, new int[]{4});
                    Assert.assertEquals((Object)answer, (Object)test);
                }
                count.incrementAndGet();
            }

            @Override
            public void operate(INDArray nd) {
                INDArray test = nd;
                if (count.get() == 0) {
                    INDArray answer = Nd4j.create(new float[]{1.0f, 2.0f}, new int[]{2});
                    Assert.assertEquals((Object)answer, (Object)test);
                } else if (count.get() == 1) {
                    INDArray answer = Nd4j.create(new float[]{3.0f, 4.0f}, new int[]{2});
                    Assert.assertEquals((Object)answer, (Object)test);
                } else if (count.get() == 2) {
                    INDArray answer = Nd4j.create(new float[]{5.0f, 6.0f}, new int[]{2});
                    Assert.assertEquals((Object)answer, (Object)test);
                } else if (count.get() == 3) {
                    INDArray answer = Nd4j.create(new float[]{7.0f, 8.0f}, new int[]{2});
                    Assert.assertEquals((Object)answer, (Object)test);
                } else if (count.get() == 4) {
                    INDArray answer = Nd4j.create(new float[]{9.0f, 10.0f}, new int[]{2});
                    Assert.assertEquals((Object)answer, (Object)test);
                } else if (count.get() == 5) {
                    INDArray answer = Nd4j.create(new float[]{11.0f, 12.0f}, new int[]{2});
                    Assert.assertEquals((Object)answer, (Object)test);
                }
                count.incrementAndGet();
            }
        }, false);
    }
}

