/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.api.activation;

import org.nd4j.linalg.api.activation.BaseActivationFunction;
import org.nd4j.linalg.api.complex.IComplexNDArray;
import org.nd4j.linalg.api.complex.IComplexNumber;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.factory.Nd4j;
import org.nd4j.linalg.ops.ElementWiseOp;
import org.nd4j.linalg.util.ComplexUtil;

public class HardTanh
extends BaseActivationFunction {
    private static final long serialVersionUID = -8484119406683594852L;

    @Override
    public Class<? extends ElementWiseOp> transformClazz() {
        return org.nd4j.linalg.ops.transforms.HardTanh.class;
    }

    @Override
    public String type() {
        return "hardtanh";
    }

    @Override
    public INDArray applyDerivative(INDArray input) {
        if (input instanceof IComplexNDArray) {
            for (int i = 0; i < input.length(); ++i) {
                IComplexNumber val = (IComplexNumber)input.getScalar(i).element();
                if (val.realComponent().doubleValue() < -1.0) {
                    val.set(-1, val.imaginaryComponent().doubleValue());
                } else if (val.realComponent().doubleValue() > 1.0) {
                    val.set(1, val.imaginaryComponent().doubleValue());
                } else {
                    val = Nd4j.createDouble(1.0, 0.0).subi(ComplexUtil.pow(ComplexUtil.tanh(val), 2.0));
                }
                input.put(i, (INDArray)Nd4j.scalar(val));
            }
        } else {
            for (int i = 0; i < input.length(); ++i) {
                double val = (Double)input.getScalar(i).element();
                val = val < -1.0 ? -1.0 : (val > 1.0 ? 1.0 : 1.0 - Math.pow(Math.tanh(val), 2.0));
                input.put(i, Nd4j.scalar(val));
            }
        }
        return input;
    }
}

