/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.shade.jackson.datatype.joda.ser;

import java.io.IOException;
import org.joda.time.Interval;
import org.joda.time.ReadableInstant;
import org.joda.time.format.DateTimeFormatter;
import org.nd4j.shade.jackson.core.JsonGenerator;
import org.nd4j.shade.jackson.databind.SerializationFeature;
import org.nd4j.shade.jackson.databind.SerializerProvider;
import org.nd4j.shade.jackson.datatype.joda.cfg.FormatConfig;
import org.nd4j.shade.jackson.datatype.joda.cfg.JacksonJodaDateFormat;
import org.nd4j.shade.jackson.datatype.joda.ser.JodaDateSerializerBase;

public class IntervalSerializer
extends JodaDateSerializerBase<Interval> {
    private static final long serialVersionUID = 1L;

    public IntervalSerializer() {
        this(FormatConfig.DEFAULT_DATETIME_FORMAT);
    }

    public IntervalSerializer(JacksonJodaDateFormat format) {
        super(Interval.class, format, false, SerializationFeature.WRITE_DURATIONS_AS_TIMESTAMPS);
    }

    public IntervalSerializer withFormat(JacksonJodaDateFormat formatter) {
        return this._format == formatter ? this : new IntervalSerializer(formatter);
    }

    @Override
    public boolean isEmpty(SerializerProvider prov, Interval value) {
        return value.getStartMillis() == value.getEndMillis();
    }

    @Override
    public void serialize(Interval interval, JsonGenerator gen, SerializerProvider provider) throws IOException {
        String repr;
        if (this._useTimestamp(provider)) {
            repr = interval.getStartMillis() + "-" + interval.getEndMillis();
        } else {
            DateTimeFormatter f = this._format.createFormatter(provider);
            repr = f.print((ReadableInstant)interval.getStart()) + "/" + f.print((ReadableInstant)interval.getEnd());
        }
        gen.writeString(repr);
    }
}

