/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.shade.jackson.databind.ser.impl;

import java.io.IOException;
import org.nd4j.shade.jackson.annotation.ObjectIdGenerator;
import org.nd4j.shade.jackson.core.JsonGenerationException;
import org.nd4j.shade.jackson.core.JsonGenerator;
import org.nd4j.shade.jackson.core.SerializableString;
import org.nd4j.shade.jackson.databind.SerializerProvider;
import org.nd4j.shade.jackson.databind.ser.impl.ObjectIdWriter;

public final class WritableObjectId {
    public final ObjectIdGenerator<?> generator;
    public Object id;
    protected boolean idWritten = false;

    public WritableObjectId(ObjectIdGenerator<?> generator) {
        this.generator = generator;
    }

    public boolean writeAsId(JsonGenerator jgen, SerializerProvider provider, ObjectIdWriter w) throws IOException, JsonGenerationException {
        if (this.id != null && (this.idWritten || w.alwaysAsId)) {
            if (jgen.canWriteObjectId()) {
                jgen.writeObjectRef(String.valueOf(this.id));
            } else {
                w.serializer.serialize(this.id, jgen, provider);
            }
            return true;
        }
        return false;
    }

    public Object generateId(Object forPojo) {
        this.id = this.generator.generateId(forPojo);
        return this.id;
    }

    public void writeAsField(JsonGenerator jgen, SerializerProvider provider, ObjectIdWriter w) throws IOException, JsonGenerationException {
        this.idWritten = true;
        if (jgen.canWriteObjectId()) {
            jgen.writeObjectId(String.valueOf(this.id));
            return;
        }
        SerializableString name = w.propertyName;
        if (name != null) {
            jgen.writeFieldName(name);
            w.serializer.serialize(this.id, jgen, provider);
        }
    }
}

