/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.shade.jackson.datatype.joda.deser;

import java.io.IOException;
import org.joda.time.Instant;
import org.joda.time.format.DateTimeFormatter;
import org.nd4j.shade.jackson.core.JsonParser;
import org.nd4j.shade.jackson.core.StreamReadCapability;
import org.nd4j.shade.jackson.core.io.NumberInput;
import org.nd4j.shade.jackson.databind.DeserializationContext;
import org.nd4j.shade.jackson.datatype.joda.cfg.FormatConfig;
import org.nd4j.shade.jackson.datatype.joda.cfg.JacksonJodaDateFormat;
import org.nd4j.shade.jackson.datatype.joda.deser.JodaDateDeserializerBase;

public class InstantDeserializer
extends JodaDateDeserializerBase<Instant> {
    private static final long serialVersionUID = 1L;

    public InstantDeserializer() {
        this(FormatConfig.DEFAULT_DATETIME_PARSER);
    }

    public InstantDeserializer(JacksonJodaDateFormat format) {
        super(Instant.class, format);
    }

    @Override
    public JodaDateDeserializerBase<?> withFormat(JacksonJodaDateFormat format) {
        return new InstantDeserializer(format);
    }

    @Override
    public Instant deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
        switch (p.currentTokenId()) {
            case 7: {
                return this._fromTimestamp(ctxt, p.getLongValue());
            }
            case 6: {
                return this._fromString(p, ctxt, p.getText());
            }
            case 1: {
                return this._fromString(p, ctxt, ctxt.extractScalarFromObject(p, this, this.handledType()));
            }
        }
        return (Instant)this._handleNotNumberOrString(p, ctxt);
    }

    protected Instant _fromString(JsonParser p, DeserializationContext ctxt, String value) throws IOException {
        if ((value = value.trim()).isEmpty()) {
            return (Instant)this._fromEmptyString(p, ctxt, value);
        }
        if (ctxt.isEnabled(StreamReadCapability.UNTYPED_SCALARS) && this._isValidTimestampString(value)) {
            return this._fromTimestamp(ctxt, NumberInput.parseLong(value));
        }
        return Instant.parse((String)value, (DateTimeFormatter)this._format.createParser(ctxt));
    }

    protected Instant _fromTimestamp(DeserializationContext ctxt, long ts) {
        return new Instant(ts);
    }
}

