/*
 * Decompiled with CFR 0.152.
 */
package fi.iki.elonen;

import fi.iki.elonen.NanoHTTPD;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class NanoWSD
extends NanoHTTPD {
    private static final Logger LOG = Logger.getLogger(NanoWSD.class.getName());
    public static final String HEADER_UPGRADE = "upgrade";
    public static final String HEADER_UPGRADE_VALUE = "websocket";
    public static final String HEADER_CONNECTION = "connection";
    public static final String HEADER_CONNECTION_VALUE = "Upgrade";
    public static final String HEADER_WEBSOCKET_VERSION = "sec-websocket-version";
    public static final String HEADER_WEBSOCKET_VERSION_VALUE = "13";
    public static final String HEADER_WEBSOCKET_KEY = "sec-websocket-key";
    public static final String HEADER_WEBSOCKET_ACCEPT = "sec-websocket-accept";
    public static final String HEADER_WEBSOCKET_PROTOCOL = "sec-websocket-protocol";
    private static final String WEBSOCKET_KEY_MAGIC = "258EAFA5-E914-47DA-95CA-C5AB0DC85B11";
    private static final char[] ALPHABET = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/".toCharArray();

    private static String encodeBase64(byte[] buf) {
        int size = buf.length;
        char[] ar = new char[(size + 2) / 3 * 4];
        int a = 0;
        int i = 0;
        while (i < size) {
            byte b0 = buf[i++];
            byte b1 = i < size ? buf[i++] : (byte)0;
            byte b2 = i < size ? buf[i++] : (byte)0;
            int mask = 63;
            ar[a++] = ALPHABET[b0 >> 2 & mask];
            ar[a++] = ALPHABET[(b0 << 4 | (b1 & 0xFF) >> 4) & mask];
            ar[a++] = ALPHABET[(b1 << 2 | (b2 & 0xFF) >> 6) & mask];
            ar[a++] = ALPHABET[b2 & mask];
        }
        switch (size % 3) {
            case 1: {
                ar[--a] = 61;
            }
            case 2: {
                ar[--a] = 61;
            }
        }
        return new String(ar);
    }

    public static String makeAcceptKey(String key) throws NoSuchAlgorithmException {
        MessageDigest md = MessageDigest.getInstance("SHA-1");
        String text = key + WEBSOCKET_KEY_MAGIC;
        md.update(text.getBytes(), 0, text.length());
        byte[] sha1hash = md.digest();
        return NanoWSD.encodeBase64(sha1hash);
    }

    public NanoWSD(int port) {
        super(port);
    }

    public NanoWSD(String hostname, int port) {
        super(hostname, port);
    }

    private boolean isWebSocketConnectionHeader(Map<String, String> headers) {
        String connection = headers.get(HEADER_CONNECTION);
        return connection != null && connection.toLowerCase().contains(HEADER_CONNECTION_VALUE.toLowerCase());
    }

    protected boolean isWebsocketRequested(NanoHTTPD.IHTTPSession session) {
        Map headers = session.getHeaders();
        String upgrade = (String)headers.get(HEADER_UPGRADE);
        boolean isCorrectConnection = this.isWebSocketConnectionHeader(headers);
        boolean isUpgrade = HEADER_UPGRADE_VALUE.equalsIgnoreCase(upgrade);
        return isUpgrade && isCorrectConnection;
    }

    protected abstract WebSocket openWebSocket(NanoHTTPD.IHTTPSession var1);

    public NanoHTTPD.Response serve(NanoHTTPD.IHTTPSession session) {
        Map headers = session.getHeaders();
        if (this.isWebsocketRequested(session)) {
            if (!HEADER_WEBSOCKET_VERSION_VALUE.equalsIgnoreCase((String)headers.get(HEADER_WEBSOCKET_VERSION))) {
                return NanoWSD.newFixedLengthResponse((NanoHTTPD.Response.IStatus)NanoHTTPD.Response.Status.BAD_REQUEST, (String)"text/plain", (String)("Invalid Websocket-Version " + (String)headers.get(HEADER_WEBSOCKET_VERSION)));
            }
            if (!headers.containsKey(HEADER_WEBSOCKET_KEY)) {
                return NanoWSD.newFixedLengthResponse((NanoHTTPD.Response.IStatus)NanoHTTPD.Response.Status.BAD_REQUEST, (String)"text/plain", (String)"Missing Websocket-Key");
            }
            WebSocket webSocket = this.openWebSocket(session);
            NanoHTTPD.Response handshakeResponse = webSocket.getHandshakeResponse();
            try {
                handshakeResponse.addHeader(HEADER_WEBSOCKET_ACCEPT, NanoWSD.makeAcceptKey((String)headers.get(HEADER_WEBSOCKET_KEY)));
            }
            catch (NoSuchAlgorithmException e) {
                return NanoWSD.newFixedLengthResponse((NanoHTTPD.Response.IStatus)NanoHTTPD.Response.Status.INTERNAL_ERROR, (String)"text/plain", (String)"The SHA-1 Algorithm required for websockets is not available on the server.");
            }
            if (headers.containsKey(HEADER_WEBSOCKET_PROTOCOL)) {
                handshakeResponse.addHeader(HEADER_WEBSOCKET_PROTOCOL, ((String)headers.get(HEADER_WEBSOCKET_PROTOCOL)).split(",")[0]);
            }
            return handshakeResponse;
        }
        return this.serveHttp(session);
    }

    protected NanoHTTPD.Response serveHttp(NanoHTTPD.IHTTPSession session) {
        return super.serve(session);
    }

    protected boolean useGzipWhenAccepted(NanoHTTPD.Response r) {
        return false;
    }

    public static class WebSocketFrame {
        public static final Charset TEXT_CHARSET = Charset.forName("UTF-8");
        private OpCode opCode;
        private boolean fin;
        private byte[] maskingKey;
        private byte[] payload;
        private transient int _payloadLength;
        private transient String _payloadString;

        public static String binary2Text(byte[] payload) throws CharacterCodingException {
            return new String(payload, TEXT_CHARSET);
        }

        public static String binary2Text(byte[] payload, int offset, int length) throws CharacterCodingException {
            return new String(payload, offset, length, TEXT_CHARSET);
        }

        private static int checkedRead(int read) throws IOException {
            if (read < 0) {
                throw new EOFException();
            }
            return read;
        }

        public static WebSocketFrame read(InputStream in) throws IOException {
            byte head = (byte)WebSocketFrame.checkedRead(in.read());
            boolean fin = (head & 0x80) != 0;
            OpCode opCode = OpCode.find((byte)(head & 0xF));
            if ((head & 0x70) != 0) {
                throw new WebSocketException(CloseCode.ProtocolError, "The reserved bits (" + Integer.toBinaryString(head & 0x70) + ") must be 0.");
            }
            if (opCode == null) {
                throw new WebSocketException(CloseCode.ProtocolError, "Received frame with reserved/unknown opcode " + (head & 0xF) + ".");
            }
            if (opCode.isControlFrame() && !fin) {
                throw new WebSocketException(CloseCode.ProtocolError, "Fragmented control frame.");
            }
            WebSocketFrame frame = new WebSocketFrame(opCode, fin);
            frame.readPayloadInfo(in);
            frame.readPayload(in);
            if (frame.getOpCode() == OpCode.Close) {
                return new CloseFrame(frame);
            }
            return frame;
        }

        public static byte[] text2Binary(String payload) throws CharacterCodingException {
            return payload.getBytes(TEXT_CHARSET);
        }

        private WebSocketFrame(OpCode opCode, boolean fin) {
            this.setOpCode(opCode);
            this.setFin(fin);
        }

        public WebSocketFrame(OpCode opCode, boolean fin, byte[] payload) {
            this(opCode, fin, payload, null);
        }

        public WebSocketFrame(OpCode opCode, boolean fin, byte[] payload, byte[] maskingKey) {
            this(opCode, fin);
            this.setMaskingKey(maskingKey);
            this.setBinaryPayload(payload);
        }

        public WebSocketFrame(OpCode opCode, boolean fin, String payload) throws CharacterCodingException {
            this(opCode, fin, payload, null);
        }

        public WebSocketFrame(OpCode opCode, boolean fin, String payload, byte[] maskingKey) throws CharacterCodingException {
            this(opCode, fin);
            this.setMaskingKey(maskingKey);
            this.setTextPayload(payload);
        }

        public WebSocketFrame(OpCode opCode, List<WebSocketFrame> fragments) throws WebSocketException {
            this.setOpCode(opCode);
            this.setFin(true);
            long _payloadLength = 0L;
            for (WebSocketFrame inter : fragments) {
                _payloadLength += (long)inter.getBinaryPayload().length;
            }
            if (_payloadLength < 0L || _payloadLength > Integer.MAX_VALUE) {
                throw new WebSocketException(CloseCode.MessageTooBig, "Max frame length has been exceeded.");
            }
            this._payloadLength = (int)_payloadLength;
            byte[] payload = new byte[this._payloadLength];
            int offset = 0;
            for (WebSocketFrame inter : fragments) {
                System.arraycopy(inter.getBinaryPayload(), 0, payload, offset, inter.getBinaryPayload().length);
                offset += inter.getBinaryPayload().length;
            }
            this.setBinaryPayload(payload);
        }

        public WebSocketFrame(WebSocketFrame clone) {
            this.setOpCode(clone.getOpCode());
            this.setFin(clone.isFin());
            this.setBinaryPayload(clone.getBinaryPayload());
            this.setMaskingKey(clone.getMaskingKey());
        }

        public byte[] getBinaryPayload() {
            return this.payload;
        }

        public byte[] getMaskingKey() {
            return this.maskingKey;
        }

        public OpCode getOpCode() {
            return this.opCode;
        }

        public String getTextPayload() {
            if (this._payloadString == null) {
                try {
                    this._payloadString = WebSocketFrame.binary2Text(this.getBinaryPayload());
                }
                catch (CharacterCodingException e) {
                    throw new RuntimeException("Undetected CharacterCodingException", e);
                }
            }
            return this._payloadString;
        }

        public boolean isFin() {
            return this.fin;
        }

        public boolean isMasked() {
            return this.maskingKey != null && this.maskingKey.length == 4;
        }

        private String payloadToString() {
            if (this.payload == null) {
                return "null";
            }
            StringBuilder sb = new StringBuilder();
            sb.append('[').append(this.payload.length).append("b] ");
            if (this.getOpCode() == OpCode.Text) {
                String text = this.getTextPayload();
                if (text.length() > 100) {
                    sb.append(text.substring(0, 100)).append("...");
                } else {
                    sb.append(text);
                }
            } else {
                sb.append("0x");
                for (int i = 0; i < Math.min(this.payload.length, 50); ++i) {
                    sb.append(Integer.toHexString(this.payload[i] & 0xFF));
                }
                if (this.payload.length > 50) {
                    sb.append("...");
                }
            }
            return sb.toString();
        }

        private void readPayload(InputStream in) throws IOException {
            this.payload = new byte[this._payloadLength];
            for (int read = 0; read < this._payloadLength; read += WebSocketFrame.checkedRead(in.read(this.payload, read, this._payloadLength - read))) {
            }
            if (this.isMasked()) {
                for (int i = 0; i < this.payload.length; ++i) {
                    int n = i;
                    this.payload[n] = (byte)(this.payload[n] ^ this.maskingKey[i % 4]);
                }
            }
            if (this.getOpCode() == OpCode.Text) {
                this._payloadString = WebSocketFrame.binary2Text(this.getBinaryPayload());
            }
        }

        private void readPayloadInfo(InputStream in) throws IOException {
            byte b = (byte)WebSocketFrame.checkedRead(in.read());
            boolean masked = (b & 0x80) != 0;
            this._payloadLength = (byte)(0x7F & b);
            if (this._payloadLength == 126) {
                this._payloadLength = (WebSocketFrame.checkedRead(in.read()) << 8 | WebSocketFrame.checkedRead(in.read())) & 0xFFFF;
                if (this._payloadLength < 126) {
                    throw new WebSocketException(CloseCode.ProtocolError, "Invalid data frame 2byte length. (not using minimal length encoding)");
                }
            } else if (this._payloadLength == 127) {
                long _payloadLength = (long)WebSocketFrame.checkedRead(in.read()) << 56 | (long)WebSocketFrame.checkedRead(in.read()) << 48 | (long)WebSocketFrame.checkedRead(in.read()) << 40 | (long)WebSocketFrame.checkedRead(in.read()) << 32 | (long)(WebSocketFrame.checkedRead(in.read()) << 24) | (long)(WebSocketFrame.checkedRead(in.read()) << 16) | (long)(WebSocketFrame.checkedRead(in.read()) << 8) | (long)WebSocketFrame.checkedRead(in.read());
                if (_payloadLength < 65536L) {
                    throw new WebSocketException(CloseCode.ProtocolError, "Invalid data frame 4byte length. (not using minimal length encoding)");
                }
                if (_payloadLength < 0L || _payloadLength > Integer.MAX_VALUE) {
                    throw new WebSocketException(CloseCode.MessageTooBig, "Max frame length has been exceeded.");
                }
                this._payloadLength = (int)_payloadLength;
            }
            if (this.opCode.isControlFrame()) {
                if (this._payloadLength > 125) {
                    throw new WebSocketException(CloseCode.ProtocolError, "Control frame with payload length > 125 bytes.");
                }
                if (this.opCode == OpCode.Close && this._payloadLength == 1) {
                    throw new WebSocketException(CloseCode.ProtocolError, "Received close frame with payload len 1.");
                }
            }
            if (masked) {
                this.maskingKey = new byte[4];
                for (int read = 0; read < this.maskingKey.length; read += WebSocketFrame.checkedRead(in.read(this.maskingKey, read, this.maskingKey.length - read))) {
                }
            }
        }

        public void setBinaryPayload(byte[] payload) {
            this.payload = payload;
            this._payloadLength = payload.length;
            this._payloadString = null;
        }

        public void setFin(boolean fin) {
            this.fin = fin;
        }

        public void setMaskingKey(byte[] maskingKey) {
            if (maskingKey != null && maskingKey.length != 4) {
                throw new IllegalArgumentException("MaskingKey " + Arrays.toString(maskingKey) + " hasn't length 4");
            }
            this.maskingKey = maskingKey;
        }

        public void setOpCode(OpCode opcode) {
            this.opCode = opcode;
        }

        public void setTextPayload(String payload) throws CharacterCodingException {
            this.payload = WebSocketFrame.text2Binary(payload);
            this._payloadLength = payload.length();
            this._payloadString = payload;
        }

        public void setUnmasked() {
            this.setMaskingKey(null);
        }

        public String toString() {
            StringBuilder sb = new StringBuilder("WS[");
            sb.append((Object)this.getOpCode());
            sb.append(", ").append(this.isFin() ? "fin" : "inter");
            sb.append(", ").append(this.isMasked() ? "masked" : "unmasked");
            sb.append(", ").append(this.payloadToString());
            sb.append(']');
            return sb.toString();
        }

        public void write(OutputStream out) throws IOException {
            int header = 0;
            if (this.fin) {
                header = (byte)(header | 0x80);
            }
            header = (byte)(header | this.opCode.getValue() & 0xF);
            out.write(header);
            this._payloadLength = this.getBinaryPayload().length;
            if (this._payloadLength <= 125) {
                out.write(this.isMasked() ? (byte)(0x80 | (byte)this._payloadLength) : (byte)this._payloadLength);
            } else if (this._payloadLength <= 65535) {
                out.write(this.isMasked() ? 254 : 126);
                out.write(this._payloadLength >>> 8);
                out.write(this._payloadLength);
            } else {
                out.write(this.isMasked() ? 255 : 127);
                out.write(this._payloadLength >>> 56 & 0);
                out.write(this._payloadLength >>> 48 & 0);
                out.write(this._payloadLength >>> 40 & 0);
                out.write(this._payloadLength >>> 32 & 0);
                out.write(this._payloadLength >>> 24);
                out.write(this._payloadLength >>> 16);
                out.write(this._payloadLength >>> 8);
                out.write(this._payloadLength);
            }
            if (this.isMasked()) {
                out.write(this.maskingKey);
                for (int i = 0; i < this._payloadLength; ++i) {
                    out.write(this.getBinaryPayload()[i] ^ this.maskingKey[i % 4]);
                }
            } else {
                out.write(this.getBinaryPayload());
            }
            out.flush();
        }

        public static enum OpCode {
            Continuation(0),
            Text(1),
            Binary(2),
            Close(8),
            Ping(9),
            Pong(10);

            private final byte code;

            public static OpCode find(byte value) {
                for (OpCode opcode : OpCode.values()) {
                    if (opcode.getValue() != value) continue;
                    return opcode;
                }
                return null;
            }

            private OpCode(int code) {
                this.code = (byte)code;
            }

            public byte getValue() {
                return this.code;
            }

            public boolean isControlFrame() {
                return this == Close || this == Ping || this == Pong;
            }
        }

        public static class CloseFrame
        extends WebSocketFrame {
            private CloseCode _closeCode;
            private String _closeReason;

            private static byte[] generatePayload(CloseCode code, String closeReason) throws CharacterCodingException {
                if (code != null) {
                    byte[] reasonBytes = CloseFrame.text2Binary(closeReason);
                    byte[] payload = new byte[reasonBytes.length + 2];
                    payload[0] = (byte)(code.getValue() >> 8 & 0xFF);
                    payload[1] = (byte)(code.getValue() & 0xFF);
                    System.arraycopy(reasonBytes, 0, payload, 2, reasonBytes.length);
                    return payload;
                }
                return new byte[0];
            }

            public CloseFrame(CloseCode code, String closeReason) throws CharacterCodingException {
                super(OpCode.Close, true, CloseFrame.generatePayload(code, closeReason));
            }

            private CloseFrame(WebSocketFrame wrap) throws CharacterCodingException {
                super(wrap);
                assert (wrap.getOpCode() == OpCode.Close);
                if (wrap.getBinaryPayload().length >= 2) {
                    this._closeCode = CloseCode.find((wrap.getBinaryPayload()[0] & 0xFF) << 8 | wrap.getBinaryPayload()[1] & 0xFF);
                    this._closeReason = CloseFrame.binary2Text(this.getBinaryPayload(), 2, this.getBinaryPayload().length - 2);
                }
            }

            public CloseCode getCloseCode() {
                return this._closeCode;
            }

            public String getCloseReason() {
                return this._closeReason;
            }
        }

        public static enum CloseCode {
            NormalClosure(1000),
            GoingAway(1001),
            ProtocolError(1002),
            UnsupportedData(1003),
            NoStatusRcvd(1005),
            AbnormalClosure(1006),
            InvalidFramePayloadData(1007),
            PolicyViolation(1008),
            MessageTooBig(1009),
            MandatoryExt(1010),
            InternalServerError(1011),
            TLSHandshake(1015);

            private final int code;

            public static CloseCode find(int value) {
                for (CloseCode code : CloseCode.values()) {
                    if (code.getValue() != value) continue;
                    return code;
                }
                return null;
            }

            private CloseCode(int code) {
                this.code = code;
            }

            public int getValue() {
                return this.code;
            }
        }
    }

    public static class WebSocketException
    extends IOException {
        private static final long serialVersionUID = 1L;
        private final WebSocketFrame.CloseCode code;
        private final String reason;

        public WebSocketException(WebSocketFrame.CloseCode code, String reason) {
            this(code, reason, null);
        }

        public WebSocketException(WebSocketFrame.CloseCode code, String reason, Exception cause) {
            super((Object)((Object)code) + ": " + reason, cause);
            this.code = code;
            this.reason = reason;
        }

        public WebSocketException(Exception cause) {
            this(WebSocketFrame.CloseCode.InternalServerError, cause.toString(), cause);
        }

        public WebSocketFrame.CloseCode getCode() {
            return this.code;
        }

        public String getReason() {
            return this.reason;
        }
    }

    public static abstract class WebSocket {
        private final InputStream in;
        private OutputStream out;
        private WebSocketFrame.OpCode continuousOpCode = null;
        private final List<WebSocketFrame> continuousFrames = new LinkedList<WebSocketFrame>();
        private State state = State.UNCONNECTED;
        private final NanoHTTPD.IHTTPSession handshakeRequest;
        private final NanoHTTPD.Response handshakeResponse = new NanoHTTPD.Response((NanoHTTPD.Response.IStatus)NanoHTTPD.Response.Status.SWITCH_PROTOCOL, null, null, 0L){

            protected void send(OutputStream out) {
                WebSocket.this.out = out;
                WebSocket.this.state = State.CONNECTING;
                super.send(out);
                WebSocket.this.state = State.OPEN;
                WebSocket.this.onOpen();
                WebSocket.this.readWebsocket();
            }
        };

        public WebSocket(NanoHTTPD.IHTTPSession handshakeRequest) {
            this.handshakeRequest = handshakeRequest;
            this.in = handshakeRequest.getInputStream();
            this.handshakeResponse.addHeader(NanoWSD.HEADER_UPGRADE, NanoWSD.HEADER_UPGRADE_VALUE);
            this.handshakeResponse.addHeader(NanoWSD.HEADER_CONNECTION, NanoWSD.HEADER_CONNECTION_VALUE);
        }

        public boolean isOpen() {
            return this.state == State.OPEN;
        }

        protected abstract void onOpen();

        protected abstract void onClose(WebSocketFrame.CloseCode var1, String var2, boolean var3);

        protected abstract void onMessage(WebSocketFrame var1);

        protected abstract void onPong(WebSocketFrame var1);

        protected abstract void onException(IOException var1);

        protected void debugFrameReceived(WebSocketFrame frame) {
        }

        protected void debugFrameSent(WebSocketFrame frame) {
        }

        public void close(WebSocketFrame.CloseCode code, String reason, boolean initiatedByRemote) throws IOException {
            State oldState = this.state;
            this.state = State.CLOSING;
            if (oldState == State.OPEN) {
                this.sendFrame(new WebSocketFrame.CloseFrame(code, reason));
            } else {
                this.doClose(code, reason, initiatedByRemote);
            }
        }

        private void doClose(WebSocketFrame.CloseCode code, String reason, boolean initiatedByRemote) {
            if (this.state == State.CLOSED) {
                return;
            }
            if (this.in != null) {
                try {
                    this.in.close();
                }
                catch (IOException e) {
                    LOG.log(Level.FINE, "close failed", e);
                }
            }
            if (this.out != null) {
                try {
                    this.out.close();
                }
                catch (IOException e) {
                    LOG.log(Level.FINE, "close failed", e);
                }
            }
            this.state = State.CLOSED;
            this.onClose(code, reason, initiatedByRemote);
        }

        public NanoHTTPD.IHTTPSession getHandshakeRequest() {
            return this.handshakeRequest;
        }

        public NanoHTTPD.Response getHandshakeResponse() {
            return this.handshakeResponse;
        }

        private void handleCloseFrame(WebSocketFrame frame) throws IOException {
            WebSocketFrame.CloseCode code = WebSocketFrame.CloseCode.NormalClosure;
            String reason = "";
            if (frame instanceof WebSocketFrame.CloseFrame) {
                code = ((WebSocketFrame.CloseFrame)frame).getCloseCode();
                reason = ((WebSocketFrame.CloseFrame)frame).getCloseReason();
            }
            if (this.state == State.CLOSING) {
                this.doClose(code, reason, false);
            } else {
                this.close(code, reason, true);
            }
        }

        private void handleFrameFragment(WebSocketFrame frame) throws IOException {
            if (frame.getOpCode() != WebSocketFrame.OpCode.Continuation) {
                if (this.continuousOpCode != null) {
                    throw new WebSocketException(WebSocketFrame.CloseCode.ProtocolError, "Previous continuous frame sequence not completed.");
                }
                this.continuousOpCode = frame.getOpCode();
                this.continuousFrames.clear();
                this.continuousFrames.add(frame);
            } else if (frame.isFin()) {
                if (this.continuousOpCode == null) {
                    throw new WebSocketException(WebSocketFrame.CloseCode.ProtocolError, "Continuous frame sequence was not started.");
                }
                this.onMessage(new WebSocketFrame(this.continuousOpCode, this.continuousFrames));
                this.continuousOpCode = null;
                this.continuousFrames.clear();
            } else {
                if (this.continuousOpCode == null) {
                    throw new WebSocketException(WebSocketFrame.CloseCode.ProtocolError, "Continuous frame sequence was not started.");
                }
                this.continuousFrames.add(frame);
            }
        }

        private void handleWebsocketFrame(WebSocketFrame frame) throws IOException {
            this.debugFrameReceived(frame);
            if (frame.getOpCode() == WebSocketFrame.OpCode.Close) {
                this.handleCloseFrame(frame);
            } else if (frame.getOpCode() == WebSocketFrame.OpCode.Ping) {
                this.sendFrame(new WebSocketFrame(WebSocketFrame.OpCode.Pong, true, frame.getBinaryPayload()));
            } else if (frame.getOpCode() == WebSocketFrame.OpCode.Pong) {
                this.onPong(frame);
            } else if (!frame.isFin() || frame.getOpCode() == WebSocketFrame.OpCode.Continuation) {
                this.handleFrameFragment(frame);
            } else {
                if (this.continuousOpCode != null) {
                    throw new WebSocketException(WebSocketFrame.CloseCode.ProtocolError, "Continuous frame sequence not completed.");
                }
                if (frame.getOpCode() == WebSocketFrame.OpCode.Text || frame.getOpCode() == WebSocketFrame.OpCode.Binary) {
                    this.onMessage(frame);
                } else {
                    throw new WebSocketException(WebSocketFrame.CloseCode.ProtocolError, "Non control or continuous frame expected.");
                }
            }
        }

        public void ping(byte[] payload) throws IOException {
            this.sendFrame(new WebSocketFrame(WebSocketFrame.OpCode.Ping, true, payload));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void readWebsocket() {
            try {
                while (this.state == State.OPEN) {
                    this.handleWebsocketFrame(WebSocketFrame.read(this.in));
                }
            }
            catch (CharacterCodingException e) {
                this.onException(e);
                this.doClose(WebSocketFrame.CloseCode.InvalidFramePayloadData, e.toString(), false);
            }
            catch (IOException e) {
                this.onException(e);
                if (e instanceof WebSocketException) {
                    this.doClose(((WebSocketException)e).getCode(), ((WebSocketException)e).getReason(), false);
                }
            }
            finally {
                this.doClose(WebSocketFrame.CloseCode.InternalServerError, "Handler terminated without closing the connection.", false);
            }
        }

        public void send(byte[] payload) throws IOException {
            this.sendFrame(new WebSocketFrame(WebSocketFrame.OpCode.Binary, true, payload));
        }

        public void send(String payload) throws IOException {
            this.sendFrame(new WebSocketFrame(WebSocketFrame.OpCode.Text, true, payload));
        }

        public synchronized void sendFrame(WebSocketFrame frame) throws IOException {
            this.debugFrameSent(frame);
            frame.write(this.out);
        }
    }

    public static enum State {
        UNCONNECTED,
        CONNECTING,
        OPEN,
        CLOSING,
        CLOSED;

    }
}

