/*
 * Decompiled with CFR 0.152.
 */
package com.ibatis.sqlmap.engine.mapping.statement;

import com.ibatis.common.util.PaginatedList;
import com.ibatis.sqlmap.client.SqlMapExecutor;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;

@Deprecated
public class PaginatedDataList
implements PaginatedList {
    private SqlMapExecutor sqlMapExecutor;
    private String statementName;
    private Object parameterObject;
    private int pageSize;
    private int index;
    private List prevPageList;
    private List currentPageList;
    private List nextPageList;

    public PaginatedDataList(SqlMapExecutor sqlMapExecutor, String statementName, Object parameterObject, int pageSize) throws SQLException {
        this.sqlMapExecutor = sqlMapExecutor;
        this.statementName = statementName;
        this.parameterObject = parameterObject;
        this.pageSize = pageSize;
        this.index = 0;
        this.pageTo(0);
    }

    private void pageForward() {
        try {
            this.prevPageList = this.currentPageList;
            this.currentPageList = this.nextPageList;
            this.nextPageList = this.getList(this.index + 1, this.pageSize);
        }
        catch (SQLException e) {
            throw new RuntimeException("Unexpected error while repaginating paged list.  Cause: " + String.valueOf(e), e);
        }
    }

    private void pageBack() {
        try {
            this.nextPageList = this.currentPageList;
            this.currentPageList = this.prevPageList;
            this.prevPageList = this.index > 0 ? this.getList(this.index - 1, this.pageSize) : new ArrayList();
        }
        catch (SQLException e) {
            throw new RuntimeException("Unexpected error while repaginating paged list.  Cause: " + String.valueOf(e), e);
        }
    }

    private void safePageTo(int idx) {
        try {
            this.pageTo(idx);
        }
        catch (SQLException e) {
            throw new RuntimeException("Unexpected error while repaginating paged list.  Cause: " + String.valueOf(e), e);
        }
    }

    public void pageTo(int idx) throws SQLException {
        this.index = idx;
        List list = idx < 1 ? this.getList(idx, this.pageSize * 2) : this.getList(idx - 1, this.pageSize * 3);
        if (list.size() < 1) {
            this.prevPageList = new ArrayList(0);
            this.currentPageList = new ArrayList(0);
            this.nextPageList = new ArrayList(0);
        } else if (idx < 1) {
            this.prevPageList = new ArrayList(0);
            if (list.size() <= this.pageSize) {
                this.currentPageList = list.subList(0, list.size());
                this.nextPageList = new ArrayList(0);
            } else {
                this.currentPageList = list.subList(0, this.pageSize);
                this.nextPageList = list.subList(this.pageSize, list.size());
            }
        } else if (list.size() <= this.pageSize) {
            this.prevPageList = list.subList(0, list.size());
            this.currentPageList = new ArrayList(0);
            this.nextPageList = new ArrayList(0);
        } else if (list.size() <= this.pageSize * 2) {
            this.prevPageList = list.subList(0, this.pageSize);
            this.currentPageList = list.subList(this.pageSize, list.size());
            this.nextPageList = new ArrayList(0);
        } else {
            this.prevPageList = list.subList(0, this.pageSize);
            this.currentPageList = list.subList(this.pageSize, this.pageSize * 2);
            this.nextPageList = list.subList(this.pageSize * 2, list.size());
        }
    }

    private List getList(int idx, int localPageSize) throws SQLException {
        return this.sqlMapExecutor.queryForList(this.statementName, this.parameterObject, idx * this.pageSize, localPageSize);
    }

    @Override
    public boolean nextPage() {
        if (this.isNextPageAvailable()) {
            ++this.index;
            this.pageForward();
            return true;
        }
        return false;
    }

    @Override
    public boolean previousPage() {
        if (this.isPreviousPageAvailable()) {
            --this.index;
            this.pageBack();
            return true;
        }
        return false;
    }

    @Override
    public void gotoPage(int pageNumber) {
        this.safePageTo(pageNumber);
    }

    @Override
    public int getPageSize() {
        return this.pageSize;
    }

    @Override
    public boolean isFirstPage() {
        return this.index == 0;
    }

    @Override
    public boolean isMiddlePage() {
        return !this.isFirstPage() && !this.isLastPage();
    }

    @Override
    public boolean isLastPage() {
        return this.nextPageList.size() < 1;
    }

    @Override
    public boolean isNextPageAvailable() {
        return this.nextPageList.size() > 0;
    }

    @Override
    public boolean isPreviousPageAvailable() {
        return this.prevPageList.size() > 0;
    }

    @Override
    public int size() {
        return this.currentPageList.size();
    }

    @Override
    public boolean isEmpty() {
        return this.currentPageList.isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        return this.currentPageList.contains(o);
    }

    @Override
    public Iterator iterator() {
        return this.currentPageList.iterator();
    }

    @Override
    public Object[] toArray() {
        return this.currentPageList.toArray();
    }

    @Override
    public Object[] toArray(Object[] a) {
        return this.currentPageList.toArray(a);
    }

    @Override
    public boolean containsAll(Collection c) {
        return this.currentPageList.containsAll(c);
    }

    public Object get(int index) {
        return this.currentPageList.get(index);
    }

    @Override
    public int indexOf(Object o) {
        return this.currentPageList.indexOf(o);
    }

    @Override
    public int lastIndexOf(Object o) {
        return this.currentPageList.lastIndexOf(o);
    }

    public ListIterator listIterator() {
        return this.currentPageList.listIterator();
    }

    public ListIterator listIterator(int index) {
        return this.currentPageList.listIterator(index);
    }

    public List subList(int fromIndex, int toIndex) {
        return this.currentPageList.subList(fromIndex, toIndex);
    }

    @Override
    public boolean add(Object o) {
        return this.currentPageList.add(o);
    }

    @Override
    public boolean remove(Object o) {
        return this.currentPageList.remove(o);
    }

    @Override
    public boolean addAll(Collection c) {
        return this.currentPageList.addAll(c);
    }

    public boolean addAll(int index, Collection c) {
        return this.currentPageList.addAll(index, c);
    }

    @Override
    public boolean removeAll(Collection c) {
        return this.currentPageList.removeAll(c);
    }

    @Override
    public boolean retainAll(Collection c) {
        return this.currentPageList.retainAll(c);
    }

    @Override
    public void clear() {
        this.currentPageList.clear();
    }

    public Object set(int index, Object element) {
        return this.currentPageList.set(index, element);
    }

    public void add(int index, Object element) {
        this.currentPageList.add(index, element);
    }

    public Object remove(int index) {
        return this.currentPageList.remove(index);
    }

    @Override
    public int getPageIndex() {
        return this.index;
    }
}

