/*
 * Decompiled with CFR 0.152.
 */
package com.ibatis.sqlmap.engine.mapping.parameter;

import com.ibatis.common.beans.Probe;
import com.ibatis.common.beans.ProbeFactory;
import com.ibatis.common.resources.Resources;
import com.ibatis.sqlmap.client.SqlMapException;
import com.ibatis.sqlmap.client.extensions.TypeHandlerCallback;
import com.ibatis.sqlmap.engine.mapping.parameter.ParameterMapping;
import com.ibatis.sqlmap.engine.mapping.sql.SqlText;
import com.ibatis.sqlmap.engine.type.CustomTypeHandler;
import com.ibatis.sqlmap.engine.type.DomTypeMarker;
import com.ibatis.sqlmap.engine.type.TypeHandler;
import com.ibatis.sqlmap.engine.type.TypeHandlerFactory;
import java.util.ArrayList;
import java.util.Map;
import java.util.StringTokenizer;

public class InlineParameterMapParser {
    private static final Probe PROBE = ProbeFactory.getProbe();
    private static final String PARAMETER_TOKEN = "#";
    private static final String PARAM_DELIM = ":";

    public SqlText parseInlineParameterMap(TypeHandlerFactory typeHandlerFactory, String sqlStatement) {
        return this.parseInlineParameterMap(typeHandlerFactory, sqlStatement, null);
    }

    public SqlText parseInlineParameterMap(TypeHandlerFactory typeHandlerFactory, String sqlStatement, Class parameterClass) {
        String newSql = sqlStatement;
        ArrayList<ParameterMapping> mappingList = new ArrayList<ParameterMapping>();
        StringTokenizer parser = new StringTokenizer(sqlStatement, PARAMETER_TOKEN, true);
        StringBuilder newSqlBuffer = new StringBuilder();
        String token = null;
        String lastToken = null;
        while (parser.hasMoreTokens()) {
            token = parser.nextToken();
            if (PARAMETER_TOKEN.equals(lastToken)) {
                if (PARAMETER_TOKEN.equals(token)) {
                    newSqlBuffer.append(PARAMETER_TOKEN);
                    token = null;
                } else {
                    ParameterMapping mapping = null;
                    mapping = token.indexOf(PARAM_DELIM) > -1 ? this.oldParseMapping(token, parameterClass, typeHandlerFactory) : this.newParseMapping(token, parameterClass, typeHandlerFactory);
                    mappingList.add(mapping);
                    newSqlBuffer.append("?");
                    boolean hasMoreTokens = parser.hasMoreTokens();
                    if (hasMoreTokens) {
                        token = parser.nextToken();
                    }
                    if (!hasMoreTokens || !PARAMETER_TOKEN.equals(token)) {
                        throw new SqlMapException("Unterminated inline parameter in mapped statement near '" + newSqlBuffer.toString() + "'");
                    }
                    token = null;
                }
            } else if (!PARAMETER_TOKEN.equals(token)) {
                newSqlBuffer.append(token);
            }
            lastToken = token;
        }
        newSql = newSqlBuffer.toString();
        ParameterMapping[] mappingArray = mappingList.toArray(new ParameterMapping[mappingList.size()]);
        SqlText sqlText = new SqlText();
        sqlText.setText(newSql);
        sqlText.setParameterMappings(mappingArray);
        return sqlText;
    }

    /*
     * Unable to fully structure code
     */
    private ParameterMapping newParseMapping(String token, Class parameterClass, TypeHandlerFactory typeHandlerFactory) {
        mapping = new ParameterMapping();
        paramParser = new StringTokenizer(token, "=,", false);
        mapping.setPropertyName(paramParser.nextToken());
        while (paramParser.hasMoreTokens()) {
            field = paramParser.nextToken();
            if (!paramParser.hasMoreTokens()) {
                throw new SqlMapException("Incorrect inline parameter map format (missmatched name=value pairs): " + token);
            }
            value = paramParser.nextToken();
            if (field != null) {
                var8_8 = field;
                var9_9 = -1;
                switch (var8_8.hashCode()) {
                    case -581710724: {
                        if (!var8_8.equals("javaType")) break;
                        var9_9 = 0;
                        break;
                    }
                    case 1510064341: {
                        if (!var8_8.equals("jdbcType")) break;
                        var9_9 = 1;
                        break;
                    }
                    case 0x3339A3: {
                        if (!var8_8.equals("mode")) break;
                        var9_9 = 2;
                        break;
                    }
                    case 1034369066: {
                        if (!var8_8.equals("nullValue")) break;
                        var9_9 = 3;
                        break;
                    }
                    case 692803402: {
                        if (!var8_8.equals("handler")) break;
                        var9_9 = 4;
                        break;
                    }
                    case 2139348541: {
                        if (!var8_8.equals("numericScale")) break;
                        var9_9 = 5;
                    }
                }
                switch (var9_9) {
                    case 0: {
                        value = typeHandlerFactory.resolveAlias(value);
                        mapping.setJavaTypeName(value);
                        break;
                    }
                    case 1: {
                        mapping.setJdbcTypeName(value);
                        break;
                    }
                    case 2: {
                        mapping.setMode(value);
                        break;
                    }
                    case 3: {
                        mapping.setNullValue(value);
                        break;
                    }
                    case 4: {
                        try {
                            value = typeHandlerFactory.resolveAlias(value);
                            impl = Resources.instantiate(value);
                            if (impl instanceof TypeHandlerCallback) {
                                mapping.setTypeHandler(new CustomTypeHandler((TypeHandlerCallback)impl));
                                ** break;
                            }
                            if (impl instanceof TypeHandler) {
                                mapping.setTypeHandler((TypeHandler)impl);
                                ** break;
                            }
                            throw new SqlMapException("The class " + value + " is not a valid implementation of TypeHandler or TypeHandlerCallback");
lbl61:
                            // 2 sources

                            break;
                        }
                        catch (Exception e) {
                            throw new SqlMapException("Error loading class specified by handler field in " + token + ".  Cause: " + String.valueOf(e), e);
                        }
                    }
                    case 5: {
                        try {
                            numericScale = Integer.valueOf(value);
                            if (numericScale < 0) {
                                throw new SqlMapException("Value specified for numericScale must be greater than or equal to zero");
                            }
                            mapping.setNumericScale(numericScale);
                            break;
                        }
                        catch (NumberFormatException e) {
                            throw new SqlMapException("Value specified for numericScale is not a valid Integer");
                        }
                    }
                    default: {
                        throw new SqlMapException("Unrecognized parameter mapping field: '" + field + "' in " + token);
                    }
                }
                continue;
            }
            throw new SqlMapException("Unrecognized parameter mapping field: '" + field + "' in " + token);
        }
        if (mapping.getTypeHandler() == null) {
            handler = parameterClass == null ? typeHandlerFactory.getUnkownTypeHandler() : this.resolveTypeHandler(typeHandlerFactory, parameterClass, mapping.getPropertyName(), mapping.getJavaTypeName(), mapping.getJdbcTypeName());
            mapping.setTypeHandler(handler);
        }
        return mapping;
    }

    private ParameterMapping oldParseMapping(String token, Class parameterClass, TypeHandlerFactory typeHandlerFactory) {
        ParameterMapping mapping = new ParameterMapping();
        if (token.indexOf(PARAM_DELIM) <= -1) {
            mapping.setPropertyName(token);
            TypeHandler handler = parameterClass == null ? typeHandlerFactory.getUnkownTypeHandler() : this.resolveTypeHandler(typeHandlerFactory, parameterClass, token, null, null);
            mapping.setTypeHandler(handler);
            return mapping;
        }
        StringTokenizer paramParser = new StringTokenizer(token, PARAM_DELIM, true);
        int n1 = paramParser.countTokens();
        if (n1 == 3) {
            String name = paramParser.nextToken();
            paramParser.nextToken();
            String type = paramParser.nextToken();
            mapping.setPropertyName(name);
            mapping.setJdbcTypeName(type);
            TypeHandler handler = parameterClass == null ? typeHandlerFactory.getUnkownTypeHandler() : this.resolveTypeHandler(typeHandlerFactory, parameterClass, name, null, type);
            mapping.setTypeHandler(handler);
            return mapping;
        }
        if (n1 >= 5) {
            String name = paramParser.nextToken();
            paramParser.nextToken();
            String type = paramParser.nextToken();
            paramParser.nextToken();
            StringBuilder nullValue = new StringBuilder().append(paramParser.nextToken());
            while (paramParser.hasMoreTokens()) {
                nullValue.append(paramParser.nextToken());
            }
            mapping.setPropertyName(name);
            mapping.setJdbcTypeName(type);
            mapping.setNullValue(nullValue.toString());
            TypeHandler handler = parameterClass == null ? typeHandlerFactory.getUnkownTypeHandler() : this.resolveTypeHandler(typeHandlerFactory, parameterClass, name, null, type);
            mapping.setTypeHandler(handler);
            return mapping;
        }
        throw new SqlMapException("Incorrect inline parameter map format: " + token);
    }

    private TypeHandler resolveTypeHandler(TypeHandlerFactory typeHandlerFactory, Class clazz, String propertyName, String javaType, String jdbcType) {
        TypeHandler handler = null;
        if (clazz == null) {
            handler = typeHandlerFactory.getUnkownTypeHandler();
        } else if (DomTypeMarker.class.isAssignableFrom(clazz)) {
            handler = typeHandlerFactory.getTypeHandler(String.class, jdbcType);
        } else if (Map.class.isAssignableFrom(clazz)) {
            if (javaType == null) {
                handler = typeHandlerFactory.getUnkownTypeHandler();
            } else {
                try {
                    javaType = typeHandlerFactory.resolveAlias(javaType);
                    Class javaClass = Resources.classForName(javaType);
                    handler = typeHandlerFactory.getTypeHandler(javaClass, jdbcType);
                }
                catch (Exception e) {
                    throw new SqlMapException("Error.  Could not set TypeHandler.  Cause: " + String.valueOf(e), e);
                }
            }
        } else if (typeHandlerFactory.getTypeHandler(clazz, jdbcType) != null) {
            handler = typeHandlerFactory.getTypeHandler(clazz, jdbcType);
        } else if (javaType == null) {
            Class type = PROBE.getPropertyTypeForGetter(clazz, propertyName);
            handler = typeHandlerFactory.getTypeHandler(type, jdbcType);
        } else {
            try {
                javaType = typeHandlerFactory.resolveAlias(javaType);
                Class javaClass = Resources.classForName(javaType);
                handler = typeHandlerFactory.getTypeHandler(javaClass, jdbcType);
            }
            catch (Exception e) {
                throw new SqlMapException("Error.  Could not set TypeHandler.  Cause: " + String.valueOf(e), e);
            }
        }
        return handler;
    }
}

