/*
 * Decompiled with CFR 0.152.
 */
package com.ibatis.sqlmap.engine.impl;

import com.ibatis.common.jdbc.exception.NestedSQLException;
import com.ibatis.common.util.PaginatedList;
import com.ibatis.sqlmap.client.SqlMapSession;
import com.ibatis.sqlmap.client.event.RowHandler;
import com.ibatis.sqlmap.engine.execution.BatchException;
import com.ibatis.sqlmap.engine.execution.SqlExecutor;
import com.ibatis.sqlmap.engine.impl.SqlMapClientImpl;
import com.ibatis.sqlmap.engine.impl.SqlMapExecutorDelegate;
import com.ibatis.sqlmap.engine.mapping.statement.MappedStatement;
import com.ibatis.sqlmap.engine.scope.SessionScope;
import com.ibatis.sqlmap.engine.transaction.Transaction;
import com.ibatis.sqlmap.engine.transaction.TransactionException;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;
import javax.sql.DataSource;

public class SqlMapSessionImpl
implements SqlMapSession {
    protected SqlMapExecutorDelegate delegate;
    protected SessionScope sessionScope;
    protected boolean closed;

    public SqlMapSessionImpl(SqlMapClientImpl client) {
        this.delegate = client.getDelegate();
        this.sessionScope = this.delegate.beginSessionScope();
        this.sessionScope.setSqlMapClient(client);
        this.sessionScope.setSqlMapExecutor(client);
        this.sessionScope.setSqlMapTxMgr(client);
        this.closed = false;
    }

    public void open() {
        this.sessionScope.setSqlMapTxMgr(this);
    }

    public boolean isClosed() {
        return this.closed;
    }

    @Override
    public void close() {
        if (this.delegate != null && this.sessionScope != null) {
            this.delegate.endSessionScope(this.sessionScope);
        }
        if (this.sessionScope != null) {
            this.sessionScope = null;
        }
        if (this.delegate != null) {
            this.delegate = null;
        }
        if (!this.closed) {
            this.closed = true;
        }
    }

    @Override
    public Object insert(String id, Object param) throws SQLException {
        return this.delegate.insert(this.sessionScope, id, param);
    }

    @Override
    public Object insert(String id) throws SQLException {
        return this.insert(id, null);
    }

    @Override
    public int update(String id, Object param) throws SQLException {
        return this.delegate.update(this.sessionScope, id, param);
    }

    @Override
    public int update(String id) throws SQLException {
        return this.update(id, null);
    }

    @Override
    public int delete(String id, Object param) throws SQLException {
        return this.delegate.delete(this.sessionScope, id, param);
    }

    @Override
    public int delete(String id) throws SQLException {
        return this.delete(id, null);
    }

    @Override
    public Object queryForObject(String id, Object paramObject) throws SQLException {
        return this.delegate.queryForObject(this.sessionScope, id, paramObject);
    }

    @Override
    public Object queryForObject(String id) throws SQLException {
        return this.queryForObject(id, null);
    }

    @Override
    public Object queryForObject(String id, Object paramObject, Object resultObject) throws SQLException {
        return this.delegate.queryForObject(this.sessionScope, id, paramObject, resultObject);
    }

    @Override
    public List queryForList(String id, Object paramObject) throws SQLException {
        return this.delegate.queryForList(this.sessionScope, id, paramObject);
    }

    @Override
    public List queryForList(String id) throws SQLException {
        return this.queryForList(id, null);
    }

    @Override
    public List queryForList(String id, Object paramObject, int skip, int max) throws SQLException {
        return this.delegate.queryForList(this.sessionScope, id, paramObject, skip, max);
    }

    @Override
    public List queryForList(String id, int skip, int max) throws SQLException {
        return this.queryForList(id, null, skip, max);
    }

    @Override
    @Deprecated
    public PaginatedList queryForPaginatedList(String id, Object paramObject, int pageSize) throws SQLException {
        return this.delegate.queryForPaginatedList(this.sessionScope, id, paramObject, pageSize);
    }

    @Override
    @Deprecated
    public PaginatedList queryForPaginatedList(String id, int pageSize) throws SQLException {
        return this.queryForPaginatedList(id, null, pageSize);
    }

    @Override
    public Map queryForMap(String id, Object paramObject, String keyProp) throws SQLException {
        return this.delegate.queryForMap(this.sessionScope, id, paramObject, keyProp);
    }

    @Override
    public Map queryForMap(String id, Object paramObject, String keyProp, String valueProp) throws SQLException {
        return this.delegate.queryForMap(this.sessionScope, id, paramObject, keyProp, valueProp);
    }

    @Override
    public void queryWithRowHandler(String id, Object paramObject, RowHandler rowHandler) throws SQLException {
        this.delegate.queryWithRowHandler(this.sessionScope, id, paramObject, rowHandler);
    }

    @Override
    public void queryWithRowHandler(String id, RowHandler rowHandler) throws SQLException {
        this.queryWithRowHandler(id, null, rowHandler);
    }

    @Override
    public void startTransaction() throws SQLException {
        this.delegate.startTransaction(this.sessionScope);
    }

    @Override
    public void startTransaction(int transactionIsolation) throws SQLException {
        this.delegate.startTransaction(this.sessionScope, transactionIsolation);
    }

    @Override
    public void commitTransaction() throws SQLException {
        this.delegate.commitTransaction(this.sessionScope);
    }

    @Override
    public void endTransaction() throws SQLException {
        this.delegate.endTransaction(this.sessionScope);
    }

    @Override
    public void startBatch() throws SQLException {
        this.delegate.startBatch(this.sessionScope);
    }

    @Override
    public int executeBatch() throws SQLException {
        return this.delegate.executeBatch(this.sessionScope);
    }

    @Override
    public List executeBatchDetailed() throws SQLException, BatchException {
        return this.delegate.executeBatchDetailed(this.sessionScope);
    }

    @Override
    public void setUserConnection(Connection connection) throws SQLException {
        this.delegate.setUserProvidedTransaction(this.sessionScope, connection);
    }

    @Override
    @Deprecated
    public Connection getUserConnection() throws SQLException {
        return this.getCurrentConnection();
    }

    @Override
    public Connection getCurrentConnection() throws SQLException {
        try {
            Connection conn = null;
            Transaction trans = this.delegate.getTransaction(this.sessionScope);
            if (trans != null) {
                conn = trans.getConnection();
            }
            return conn;
        }
        catch (TransactionException e) {
            throw new NestedSQLException("Error getting Connection from Transaction.  Cause: " + String.valueOf(e), e);
        }
    }

    @Override
    public DataSource getDataSource() {
        return this.delegate.getDataSource();
    }

    public MappedStatement getMappedStatement(String id) {
        return this.delegate.getMappedStatement(id);
    }

    public boolean isLazyLoadingEnabled() {
        return this.delegate.isLazyLoadingEnabled();
    }

    public boolean isEnhancementEnabled() {
        return this.delegate.isEnhancementEnabled();
    }

    public SqlExecutor getSqlExecutor() {
        return this.delegate.getSqlExecutor();
    }

    public SqlMapExecutorDelegate getDelegate() {
        return this.delegate;
    }
}

