/*
 * Decompiled with CFR 0.152.
 */
package com.ibatis.sqlmap.engine.config;

import com.ibatis.sqlmap.client.extensions.TypeHandlerCallback;
import com.ibatis.sqlmap.engine.config.SqlMapConfiguration;
import com.ibatis.sqlmap.engine.impl.SqlMapClientImpl;
import com.ibatis.sqlmap.engine.mapping.parameter.ParameterMap;
import com.ibatis.sqlmap.engine.mapping.parameter.ParameterMapping;
import com.ibatis.sqlmap.engine.scope.ErrorContext;
import com.ibatis.sqlmap.engine.type.CustomTypeHandler;
import com.ibatis.sqlmap.engine.type.TypeHandler;
import java.util.ArrayList;
import java.util.List;

public class ParameterMapConfig {
    public static final String MODE_IN = "IN";
    public static final String MODE_OUT = "OUT";
    public static final String MODE_INOUT = "INUOT";
    private SqlMapConfiguration config;
    private ErrorContext errorContext;
    private SqlMapClientImpl client;
    private ParameterMap parameterMap;
    private List parameterMappingList;

    ParameterMapConfig(SqlMapConfiguration config, String id, Class parameterClass) {
        this.config = config;
        this.errorContext = config.getErrorContext();
        this.client = config.getClient();
        this.errorContext.setActivity("building a parameter map");
        this.parameterMap = new ParameterMap(this.client.getDelegate());
        this.parameterMap.setId(id);
        this.parameterMap.setResource(this.errorContext.getResource());
        this.errorContext.setObjectId(id + " parameter map");
        this.parameterMap.setParameterClass(parameterClass);
        this.errorContext.setMoreInfo("Check the parameter mappings.");
        this.parameterMappingList = new ArrayList();
        this.client.getDelegate().addParameterMap(this.parameterMap);
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void addParameterMapping(String propertyName, Class javaClass, String jdbcType, String nullValue, String mode, String outParamType, Integer numericScale, Object typeHandlerImpl, String resultMap) {
        void var10_13;
        this.errorContext.setObjectId(propertyName + " mapping of the " + this.parameterMap.getId() + " parameter map");
        if (typeHandlerImpl != null) {
            this.errorContext.setMoreInfo("Check the parameter mapping typeHandler attribute '" + String.valueOf(typeHandlerImpl) + "' (must be a TypeHandler or TypeHandlerCallback implementation).");
            if (typeHandlerImpl instanceof TypeHandlerCallback) {
                CustomTypeHandler customTypeHandler = new CustomTypeHandler((TypeHandlerCallback)typeHandlerImpl);
            } else {
                if (!(typeHandlerImpl instanceof TypeHandler)) throw new RuntimeException("The class '" + String.valueOf(typeHandlerImpl) + "' is not a valid implementation of TypeHandler or TypeHandlerCallback");
                TypeHandler typeHandler = (TypeHandler)typeHandlerImpl;
            }
        } else {
            this.errorContext.setMoreInfo("Check the parameter mapping property type or name.");
            TypeHandler typeHandler = this.config.resolveTypeHandler(this.client.getDelegate().getTypeHandlerFactory(), this.parameterMap.getParameterClass(), propertyName, javaClass, jdbcType);
        }
        ParameterMapping mapping = new ParameterMapping();
        mapping.setPropertyName(propertyName);
        mapping.setJdbcTypeName(jdbcType);
        mapping.setTypeName(outParamType);
        mapping.setResultMapName(resultMap);
        mapping.setNullValue(nullValue);
        if (mode != null && !mode.isEmpty()) {
            mapping.setMode(mode);
        }
        mapping.setTypeHandler((TypeHandler)var10_13);
        mapping.setJavaType(javaClass);
        mapping.setNumericScale(numericScale);
        this.parameterMappingList.add(mapping);
        this.parameterMap.setParameterMappingList(this.parameterMappingList);
    }
}

