/*
 * Decompiled with CFR 0.152.
 */
package com.ibatis.sqlmap.engine.type;

import com.ibatis.sqlmap.client.SqlMapException;
import com.ibatis.sqlmap.engine.type.BaseTypeHandler;
import com.ibatis.sqlmap.engine.type.BigDecimalTypeHandler;
import com.ibatis.sqlmap.engine.type.BlobTypeHandlerCallback;
import com.ibatis.sqlmap.engine.type.BooleanTypeHandler;
import com.ibatis.sqlmap.engine.type.ByteArrayTypeHandler;
import com.ibatis.sqlmap.engine.type.ByteTypeHandler;
import com.ibatis.sqlmap.engine.type.ClobTypeHandlerCallback;
import com.ibatis.sqlmap.engine.type.CustomTypeHandler;
import com.ibatis.sqlmap.engine.type.DateOnlyTypeHandler;
import com.ibatis.sqlmap.engine.type.DateTypeHandler;
import com.ibatis.sqlmap.engine.type.DoubleTypeHandler;
import com.ibatis.sqlmap.engine.type.EnumTypeHandler;
import com.ibatis.sqlmap.engine.type.FloatTypeHandler;
import com.ibatis.sqlmap.engine.type.IntegerTypeHandler;
import com.ibatis.sqlmap.engine.type.LongTypeHandler;
import com.ibatis.sqlmap.engine.type.ObjectTypeHandler;
import com.ibatis.sqlmap.engine.type.ShortTypeHandler;
import com.ibatis.sqlmap.engine.type.SqlDateTypeHandler;
import com.ibatis.sqlmap.engine.type.SqlTimeTypeHandler;
import com.ibatis.sqlmap.engine.type.SqlTimestampTypeHandler;
import com.ibatis.sqlmap.engine.type.StringTypeHandler;
import com.ibatis.sqlmap.engine.type.TimeOnlyTypeHandler;
import com.ibatis.sqlmap.engine.type.TypeHandler;
import com.ibatis.sqlmap.engine.type.UnknownTypeHandler;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class TypeHandlerFactory {
    private final Map typeHandlerMap = new HashMap();
    private final TypeHandler unknownTypeHandler = new UnknownTypeHandler(this);
    private final Map<String, String> typeAliases = new HashMap<String, String>();
    private static final Map reversePrimitiveMap = new HashMap<Object, Object>(){
        private static final long serialVersionUID = 1L;
        {
            this.put(Byte.class, Byte.TYPE);
            this.put(Short.class, Short.TYPE);
            this.put(Integer.class, Integer.TYPE);
            this.put(Long.class, Long.TYPE);
            this.put(Float.class, Float.TYPE);
            this.put(Double.class, Double.TYPE);
            this.put(Boolean.class, Boolean.TYPE);
        }
    };

    public TypeHandlerFactory() {
        BaseTypeHandler handler = new BooleanTypeHandler();
        this.register(Boolean.class, handler);
        this.register(Boolean.TYPE, handler);
        handler = new ByteTypeHandler();
        this.register(Byte.class, handler);
        this.register(Byte.TYPE, handler);
        handler = new ShortTypeHandler();
        this.register(Short.class, handler);
        this.register(Short.TYPE, handler);
        handler = new IntegerTypeHandler();
        this.register(Integer.class, handler);
        this.register(Integer.TYPE, handler);
        handler = new LongTypeHandler();
        this.register(Long.class, handler);
        this.register(Long.TYPE, handler);
        handler = new FloatTypeHandler();
        this.register(Float.class, handler);
        this.register(Float.TYPE, handler);
        handler = new DoubleTypeHandler();
        this.register(Double.class, handler);
        this.register(Double.TYPE, handler);
        this.register(String.class, new StringTypeHandler());
        this.register(String.class, "CLOB", new CustomTypeHandler(new ClobTypeHandlerCallback()));
        this.register(String.class, "LONGVARCHAR", new CustomTypeHandler(new ClobTypeHandlerCallback()));
        this.register(BigDecimal.class, new BigDecimalTypeHandler());
        this.register(byte[].class, new ByteArrayTypeHandler());
        this.register(byte[].class, "BLOB", new CustomTypeHandler(new BlobTypeHandlerCallback()));
        this.register(byte[].class, "LONGVARBINARY", new CustomTypeHandler(new BlobTypeHandlerCallback()));
        this.register(Object.class, new ObjectTypeHandler());
        this.register(Object.class, "OBJECT", new ObjectTypeHandler());
        this.register(java.util.Date.class, new DateTypeHandler());
        this.register(java.util.Date.class, "DATE", new DateOnlyTypeHandler());
        this.register(java.util.Date.class, "TIME", new TimeOnlyTypeHandler());
        this.register(Date.class, new SqlDateTypeHandler());
        this.register(Time.class, new SqlTimeTypeHandler());
        this.register(Timestamp.class, new SqlTimestampTypeHandler());
        this.putTypeAlias("string", String.class.getName());
        this.putTypeAlias("byte", Byte.class.getName());
        this.putTypeAlias("long", Long.class.getName());
        this.putTypeAlias("short", Short.class.getName());
        this.putTypeAlias("int", Integer.class.getName());
        this.putTypeAlias("integer", Integer.class.getName());
        this.putTypeAlias("double", Double.class.getName());
        this.putTypeAlias("float", Float.class.getName());
        this.putTypeAlias("boolean", Boolean.class.getName());
        this.putTypeAlias("date", java.util.Date.class.getName());
        this.putTypeAlias("decimal", BigDecimal.class.getName());
        this.putTypeAlias("object", Object.class.getName());
        this.putTypeAlias("map", Map.class.getName());
        this.putTypeAlias("hashmap", HashMap.class.getName());
        this.putTypeAlias("list", List.class.getName());
        this.putTypeAlias("arraylist", ArrayList.class.getName());
        this.putTypeAlias("collection", Collection.class.getName());
        this.putTypeAlias("iterator", Iterator.class.getName());
        this.putTypeAlias("cursor", ResultSet.class.getName());
    }

    public TypeHandler getTypeHandler(Class type) {
        return this.getTypeHandler(type, null);
    }

    public TypeHandler getTypeHandler(Class type, String jdbcType) {
        Map jdbcHandlerMap = (Map)this.typeHandlerMap.get(type);
        TypeHandler handler = null;
        if (jdbcHandlerMap != null && (handler = (TypeHandler)jdbcHandlerMap.get(jdbcType)) == null) {
            handler = (TypeHandler)jdbcHandlerMap.get(null);
        }
        if (handler == null && type != null && Enum.class.isAssignableFrom(type)) {
            handler = new EnumTypeHandler(type);
        }
        return handler;
    }

    public TypeHandler getUnkownTypeHandler() {
        return this.unknownTypeHandler;
    }

    public boolean hasTypeHandler(Class type) {
        return type != null && (this.getTypeHandler(type) != null || Enum.class.isAssignableFrom(type));
    }

    public void register(Class type, TypeHandler handler) {
        this.register(type, null, handler);
    }

    public void register(Class type, String jdbcType, TypeHandler handler) {
        HashMap<String, TypeHandler> map = (HashMap<String, TypeHandler>)this.typeHandlerMap.get(type);
        if (map == null) {
            map = new HashMap<String, TypeHandler>();
            this.typeHandlerMap.put(type, map);
        }
        map.put(jdbcType, handler);
        if (reversePrimitiveMap.containsKey(type)) {
            this.register((Class)reversePrimitiveMap.get(type), jdbcType, handler);
        }
    }

    public String resolveAlias(String string) {
        String key = null;
        if (string != null) {
            key = string.toLowerCase();
        }
        String value = null;
        value = this.typeAliases.containsKey(key) ? this.typeAliases.get(key) : string;
        return value;
    }

    public void putTypeAlias(String alias, String value) {
        String key = null;
        if (alias != null) {
            key = alias.toLowerCase();
        }
        if (this.typeAliases.containsKey(key) && !this.typeAliases.get(key).equals(value)) {
            throw new SqlMapException("Error in XmlSqlMapClientBuilder.  Alias name conflict occurred.  The alias '" + key + "' is already mapped to the value '" + this.typeAliases.get(alias) + "'.");
        }
        this.typeAliases.put(key, value);
    }
}

