/*
 * Decompiled with CFR 0.152.
 */
package com.ibatis.sqlmap.engine.type;

import java.util.HashMap;
import java.util.Map;

public class JdbcTypeRegistry {
    public static final int UNKNOWN_TYPE = -99999999;
    private static final Map<String, Integer> TYPE_MAP = new HashMap<String, Integer>();
    public static final int JDBC_30_DATALINK = 70;
    public static final int JDBC_30_BOOLEAN = 16;

    private JdbcTypeRegistry() {
    }

    public static void setType(String name, int value) {
        TYPE_MAP.put(name, value);
    }

    public static int getType(String name) {
        if (name == null) {
            return -99999999;
        }
        Integer i = TYPE_MAP.get(name);
        if (i != null) {
            return i;
        }
        return -99999999;
    }

    private static void initializeTypes() {
        JdbcTypeRegistry.setType("ARRAY", 2003);
        JdbcTypeRegistry.setType("BIGINT", -5);
        JdbcTypeRegistry.setType("BINARY", -2);
        JdbcTypeRegistry.setType("BIT", -7);
        JdbcTypeRegistry.setType("BLOB", 2004);
        JdbcTypeRegistry.setType("BOOLEAN", 16);
        JdbcTypeRegistry.setType("CHAR", 1);
        JdbcTypeRegistry.setType("CLOB", 2005);
        JdbcTypeRegistry.setType("DATALINK", 70);
        JdbcTypeRegistry.setType("DATE", 91);
        JdbcTypeRegistry.setType("DECIMAL", 3);
        JdbcTypeRegistry.setType("DISTINCT", 2001);
        JdbcTypeRegistry.setType("DOUBLE", 8);
        JdbcTypeRegistry.setType("FLOAT", 6);
        JdbcTypeRegistry.setType("INTEGER", 4);
        JdbcTypeRegistry.setType("JAVA_OBJECT", 2000);
        JdbcTypeRegistry.setType("LONGVARBINARY", -4);
        JdbcTypeRegistry.setType("LONGVARCHAR", -1);
        JdbcTypeRegistry.setType("NULL", 0);
        JdbcTypeRegistry.setType("NUMERIC", 2);
        JdbcTypeRegistry.setType("OTHER", 1111);
        JdbcTypeRegistry.setType("REAL", 7);
        JdbcTypeRegistry.setType("REF", 2006);
        JdbcTypeRegistry.setType("SMALLINT", 5);
        JdbcTypeRegistry.setType("STRUCT", 2002);
        JdbcTypeRegistry.setType("TIME", 92);
        JdbcTypeRegistry.setType("TIMESTAMP", 93);
        JdbcTypeRegistry.setType("TINYINT", -6);
        JdbcTypeRegistry.setType("VARBINARY", -3);
        JdbcTypeRegistry.setType("VARCHAR", 12);
        JdbcTypeRegistry.setType("CH", 1);
        JdbcTypeRegistry.setType("VC", 12);
        JdbcTypeRegistry.setType("DT", 91);
        JdbcTypeRegistry.setType("TM", 92);
        JdbcTypeRegistry.setType("TS", 93);
        JdbcTypeRegistry.setType("NM", 2);
        JdbcTypeRegistry.setType("II", 4);
        JdbcTypeRegistry.setType("BI", -5);
        JdbcTypeRegistry.setType("SI", 5);
        JdbcTypeRegistry.setType("TI", -6);
        JdbcTypeRegistry.setType("DC", 3);
        JdbcTypeRegistry.setType("DB", 8);
        JdbcTypeRegistry.setType("FL", 6);
        JdbcTypeRegistry.setType("ORACLECURSOR", -10);
    }

    static {
        JdbcTypeRegistry.initializeTypes();
    }
}

