/*
 * Decompiled with CFR 0.152.
 */
package com.ibatis.sqlmap.engine.mapping.result;

import com.ibatis.common.beans.ClassInfo;
import com.ibatis.common.beans.Probe;
import com.ibatis.common.beans.ProbeFactory;
import com.ibatis.sqlmap.client.SqlMapException;
import com.ibatis.sqlmap.engine.impl.SqlMapExecutorDelegate;
import com.ibatis.sqlmap.engine.mapping.result.ResultMap;
import com.ibatis.sqlmap.engine.mapping.result.ResultMapping;
import com.ibatis.sqlmap.engine.scope.StatementScope;
import com.ibatis.sqlmap.engine.type.DomTypeMarker;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

public class AutoResultMap
extends ResultMap {
    public AutoResultMap(SqlMapExecutorDelegate delegate, boolean allowRemapping) {
        super(delegate);
        this.allowRemapping = allowRemapping;
    }

    @Override
    public synchronized Object[] getResults(StatementScope statementScope, ResultSet rs) throws SQLException {
        if (this.allowRemapping || this.getResultMappings() == null) {
            this.initialize(rs);
        }
        return super.getResults(statementScope, rs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object setResultObjectValues(StatementScope statementScope, Object resultObject, Object[] values) {
        if (this.allowRemapping) {
            AutoResultMap autoResultMap = this;
            synchronized (autoResultMap) {
                return super.setResultObjectValues(statementScope, resultObject, values);
            }
        }
        return super.setResultObjectValues(statementScope, resultObject, values);
    }

    private void initialize(ResultSet rs) {
        if (this.getResultClass() == null) {
            throw new SqlMapException("The automatic ResultMap named " + this.getId() + " had a null result class (not allowed).");
        }
        if (Map.class.isAssignableFrom(this.getResultClass())) {
            this.initializeMapResults(rs);
        } else if (this.getDelegate().getTypeHandlerFactory().getTypeHandler(this.getResultClass()) != null) {
            this.initializePrimitiveResults(rs);
        } else if (DomTypeMarker.class.isAssignableFrom(this.getResultClass())) {
            this.initializeXmlResults(rs);
        } else {
            this.initializeBeanResults(rs);
        }
    }

    private void initializeBeanResults(ResultSet rs) {
        try {
            ClassInfo classInfo = ClassInfo.getInstance(this.getResultClass());
            String[] propertyNames = classInfo.getWriteablePropertyNames();
            HashMap<String, String> propertyMap = new HashMap<String, String>();
            for (String propertyName : propertyNames) {
                propertyMap.put(propertyName.toUpperCase(Locale.ENGLISH), propertyName);
            }
            ArrayList<ResultMapping> resultMappingList = new ArrayList<ResultMapping>();
            ResultSetMetaData rsmd = rs.getMetaData();
            int n = rsmd.getColumnCount();
            for (int i = 0; i < n; ++i) {
                String columnName = this.getColumnIdentifier(rsmd, i + 1);
                String upperColumnName = columnName.toUpperCase(Locale.ENGLISH);
                String matchedProp = (String)propertyMap.get(upperColumnName);
                Class type = null;
                if (matchedProp == null) {
                    Probe p = ProbeFactory.getProbe(this.getResultClass());
                    try {
                        type = p.getPropertyTypeForSetter(this.getResultClass(), columnName);
                    }
                    catch (Exception exception) {}
                } else {
                    type = classInfo.getSetterType(matchedProp);
                }
                if (type == null && matchedProp == null) continue;
                ResultMapping resultMapping = new ResultMapping();
                resultMapping.setPropertyName(matchedProp != null ? matchedProp : columnName);
                resultMapping.setColumnName(columnName);
                resultMapping.setColumnIndex(i + 1);
                resultMapping.setTypeHandler(this.getDelegate().getTypeHandlerFactory().getTypeHandler(type));
                resultMappingList.add(resultMapping);
            }
            this.setResultMappingList(resultMappingList);
        }
        catch (SQLException e) {
            throw new RuntimeException("Error automapping columns. Cause: " + String.valueOf(e));
        }
    }

    private void initializeXmlResults(ResultSet rs) {
        try {
            ArrayList<ResultMapping> resultMappingList = new ArrayList<ResultMapping>();
            ResultSetMetaData rsmd = rs.getMetaData();
            int n = rsmd.getColumnCount();
            for (int i = 0; i < n; ++i) {
                String columnName = this.getColumnIdentifier(rsmd, i + 1);
                ResultMapping resultMapping = new ResultMapping();
                resultMapping.setPropertyName(columnName);
                resultMapping.setColumnName(columnName);
                resultMapping.setColumnIndex(i + 1);
                resultMapping.setTypeHandler(this.getDelegate().getTypeHandlerFactory().getTypeHandler(String.class));
                resultMappingList.add(resultMapping);
            }
            this.setResultMappingList(resultMappingList);
        }
        catch (SQLException e) {
            throw new RuntimeException("Error automapping columns. Cause: " + String.valueOf(e));
        }
    }

    private void initializeMapResults(ResultSet rs) {
        try {
            ArrayList<ResultMapping> resultMappingList = new ArrayList<ResultMapping>();
            ResultSetMetaData rsmd = rs.getMetaData();
            int n = rsmd.getColumnCount();
            for (int i = 0; i < n; ++i) {
                String columnName = this.getColumnIdentifier(rsmd, i + 1);
                ResultMapping resultMapping = new ResultMapping();
                resultMapping.setPropertyName(columnName);
                resultMapping.setColumnName(columnName);
                resultMapping.setColumnIndex(i + 1);
                resultMapping.setTypeHandler(this.getDelegate().getTypeHandlerFactory().getTypeHandler(Object.class));
                resultMappingList.add(resultMapping);
            }
            this.setResultMappingList(resultMappingList);
        }
        catch (SQLException e) {
            throw new RuntimeException("Error automapping columns. Cause: " + String.valueOf(e));
        }
    }

    private void initializePrimitiveResults(ResultSet rs) {
        try {
            ResultSetMetaData rsmd = rs.getMetaData();
            String columnName = this.getColumnIdentifier(rsmd, 1);
            ResultMapping resultMapping = new ResultMapping();
            resultMapping.setPropertyName(columnName);
            resultMapping.setColumnName(columnName);
            resultMapping.setColumnIndex(1);
            resultMapping.setTypeHandler(this.getDelegate().getTypeHandlerFactory().getTypeHandler(this.getResultClass()));
            ArrayList<ResultMapping> resultMappingList = new ArrayList<ResultMapping>();
            resultMappingList.add(resultMapping);
            this.setResultMappingList(resultMappingList);
        }
        catch (SQLException e) {
            throw new RuntimeException("Error automapping columns. Cause: " + String.valueOf(e));
        }
    }

    private String getColumnIdentifier(ResultSetMetaData rsmd, int i) throws SQLException {
        if (this.delegate.isUseColumnLabel()) {
            return rsmd.getColumnLabel(i);
        }
        return rsmd.getColumnName(i);
    }
}

