/*
 * Decompiled with CFR 0.152.
 */
package com.ibatis.sqlmap.engine.execution;

import com.ibatis.sqlmap.engine.config.SqlMapConfiguration;
import com.ibatis.sqlmap.engine.execution.BatchException;
import com.ibatis.sqlmap.engine.execution.BatchResult;
import com.ibatis.sqlmap.engine.execution.SqlExecutor;
import com.ibatis.sqlmap.engine.impl.SqlMapClientImpl;
import com.ibatis.sqlmap.engine.impl.SqlMapExecutorDelegate;
import com.ibatis.sqlmap.engine.mapping.parameter.ParameterMap;
import com.ibatis.sqlmap.engine.mapping.parameter.ParameterMapping;
import com.ibatis.sqlmap.engine.mapping.result.ResultMap;
import com.ibatis.sqlmap.engine.mapping.result.ResultObjectFactoryUtil;
import com.ibatis.sqlmap.engine.mapping.statement.DefaultRowHandler;
import com.ibatis.sqlmap.engine.mapping.statement.MappedStatement;
import com.ibatis.sqlmap.engine.mapping.statement.RowHandlerCallback;
import com.ibatis.sqlmap.engine.scope.ErrorContext;
import com.ibatis.sqlmap.engine.scope.SessionScope;
import com.ibatis.sqlmap.engine.scope.StatementScope;
import java.sql.BatchUpdateException;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;

public class DefaultSqlExecutor
implements SqlExecutor {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int executeUpdate(StatementScope statementScope, Connection conn, String sql, Object[] parameters) throws SQLException {
        ErrorContext errorContext = statementScope.getErrorContext();
        errorContext.setActivity("executing update");
        errorContext.setObjectId(sql);
        PreparedStatement ps = null;
        this.setupResultObjectFactory(statementScope);
        int rows = 0;
        try {
            errorContext.setMoreInfo("Check the SQL Statement (preparation failed).");
            ps = DefaultSqlExecutor.prepareStatement(statementScope.getSession(), conn, sql);
            DefaultSqlExecutor.setStatementTimeout(statementScope.getStatement(), ps);
            errorContext.setMoreInfo("Check the parameters (set parameters failed).");
            statementScope.getParameterMap().setParameters(statementScope, ps, parameters);
            errorContext.setMoreInfo("Check the statement (update failed).");
            ps.execute();
            rows = ps.getUpdateCount();
        }
        catch (Throwable throwable) {
            DefaultSqlExecutor.closeStatement(statementScope.getSession(), ps);
            this.cleanupResultObjectFactory();
            throw throwable;
        }
        DefaultSqlExecutor.closeStatement(statementScope.getSession(), ps);
        this.cleanupResultObjectFactory();
        return rows;
    }

    @Override
    public void addBatch(StatementScope statementScope, Connection conn, String sql, Object[] parameters) throws SQLException {
        Batch batch = (Batch)statementScope.getSession().getBatch();
        if (batch == null) {
            batch = new Batch();
            statementScope.getSession().setBatch(batch);
        }
        batch.addBatch(statementScope, conn, sql, parameters);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int executeBatch(SessionScope sessionScope) throws SQLException {
        int rows = 0;
        Batch batch = (Batch)sessionScope.getBatch();
        if (batch != null) {
            try {
                rows = batch.executeBatch();
            }
            finally {
                batch.cleanupBatch(sessionScope);
            }
        }
        return rows;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List executeBatchDetailed(SessionScope sessionScope) throws SQLException, BatchException {
        List answer = null;
        Batch batch = (Batch)sessionScope.getBatch();
        if (batch != null) {
            try {
                answer = batch.executeBatchDetailed();
            }
            finally {
                batch.cleanupBatch(sessionScope);
            }
        }
        return answer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void executeQuery(StatementScope statementScope, Connection conn, String sql, Object[] parameters, int skipResults, int maxResults, RowHandlerCallback callback) throws SQLException {
        ErrorContext errorContext = statementScope.getErrorContext();
        errorContext.setActivity("executing query");
        errorContext.setObjectId(sql);
        PreparedStatement ps = null;
        ResultSet rs = null;
        this.setupResultObjectFactory(statementScope);
        try {
            errorContext.setMoreInfo("Check the SQL Statement (preparation failed).");
            Integer rsType = statementScope.getStatement().getResultSetType();
            ps = rsType != null ? this.prepareStatement(statementScope.getSession(), conn, sql, rsType) : DefaultSqlExecutor.prepareStatement(statementScope.getSession(), conn, sql);
            DefaultSqlExecutor.setStatementTimeout(statementScope.getStatement(), ps);
            Integer fetchSize = statementScope.getStatement().getFetchSize();
            if (fetchSize != null) {
                ps.setFetchSize(fetchSize);
            }
            errorContext.setMoreInfo("Check the parameters (set parameters failed).");
            statementScope.getParameterMap().setParameters(statementScope, ps, parameters);
            errorContext.setMoreInfo("Check the statement (query failed).");
            ps.execute();
            errorContext.setMoreInfo("Check the results (failed to retrieve results).");
            rs = this.handleMultipleResults(ps, statementScope, skipResults, maxResults, callback);
        }
        catch (Throwable throwable) {
            try {
                DefaultSqlExecutor.closeResultSet(rs);
            }
            finally {
                DefaultSqlExecutor.closeStatement(statementScope.getSession(), ps);
                this.cleanupResultObjectFactory();
            }
            throw throwable;
        }
        try {
            DefaultSqlExecutor.closeResultSet(rs);
        }
        finally {
            DefaultSqlExecutor.closeStatement(statementScope.getSession(), ps);
            this.cleanupResultObjectFactory();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int executeUpdateProcedure(StatementScope statementScope, Connection conn, String sql, Object[] parameters) throws SQLException {
        ErrorContext errorContext = statementScope.getErrorContext();
        errorContext.setActivity("executing update procedure");
        errorContext.setObjectId(sql);
        CallableStatement cs = null;
        this.setupResultObjectFactory(statementScope);
        int rows = 0;
        try {
            errorContext.setMoreInfo("Check the SQL Statement (preparation failed).");
            cs = this.prepareCall(statementScope.getSession(), conn, sql);
            DefaultSqlExecutor.setStatementTimeout(statementScope.getStatement(), cs);
            ParameterMap parameterMap = statementScope.getParameterMap();
            ParameterMapping[] mappings = parameterMap.getParameterMappings();
            errorContext.setMoreInfo("Check the output parameters (register output parameters failed).");
            this.registerOutputParameters(cs, mappings);
            errorContext.setMoreInfo("Check the parameters (set parameters failed).");
            parameterMap.setParameters(statementScope, cs, parameters);
            errorContext.setMoreInfo("Check the statement (update procedure failed).");
            cs.execute();
            rows = cs.getUpdateCount();
            errorContext.setMoreInfo("Check the output parameters (retrieval of output parameters failed).");
            this.retrieveOutputParameters(statementScope, cs, mappings, parameters, null);
        }
        catch (Throwable throwable) {
            DefaultSqlExecutor.closeStatement(statementScope.getSession(), cs);
            this.cleanupResultObjectFactory();
            throw throwable;
        }
        DefaultSqlExecutor.closeStatement(statementScope.getSession(), cs);
        this.cleanupResultObjectFactory();
        return rows;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void executeQueryProcedure(StatementScope statementScope, Connection conn, String sql, Object[] parameters, int skipResults, int maxResults, RowHandlerCallback callback) throws SQLException {
        ErrorContext errorContext = statementScope.getErrorContext();
        errorContext.setActivity("executing query procedure");
        errorContext.setObjectId(sql);
        CallableStatement cs = null;
        ResultSet rs = null;
        this.setupResultObjectFactory(statementScope);
        try {
            errorContext.setMoreInfo("Check the SQL Statement (preparation failed).");
            Integer rsType = statementScope.getStatement().getResultSetType();
            cs = rsType != null ? this.prepareCall(statementScope.getSession(), conn, sql, rsType) : this.prepareCall(statementScope.getSession(), conn, sql);
            DefaultSqlExecutor.setStatementTimeout(statementScope.getStatement(), cs);
            Integer fetchSize = statementScope.getStatement().getFetchSize();
            if (fetchSize != null) {
                cs.setFetchSize(fetchSize);
            }
            ParameterMap parameterMap = statementScope.getParameterMap();
            ParameterMapping[] mappings = parameterMap.getParameterMappings();
            errorContext.setMoreInfo("Check the output parameters (register output parameters failed).");
            this.registerOutputParameters(cs, mappings);
            errorContext.setMoreInfo("Check the parameters (set parameters failed).");
            parameterMap.setParameters(statementScope, cs, parameters);
            errorContext.setMoreInfo("Check the statement (update procedure failed).");
            cs.execute();
            errorContext.setMoreInfo("Check the results (failed to retrieve results).");
            rs = this.handleMultipleResults(cs, statementScope, skipResults, maxResults, callback);
            errorContext.setMoreInfo("Check the output parameters (retrieval of output parameters failed).");
            this.retrieveOutputParameters(statementScope, cs, mappings, parameters, callback);
        }
        catch (Throwable throwable) {
            try {
                DefaultSqlExecutor.closeResultSet(rs);
            }
            finally {
                DefaultSqlExecutor.closeStatement(statementScope.getSession(), cs);
                this.cleanupResultObjectFactory();
            }
            throw throwable;
        }
        try {
            DefaultSqlExecutor.closeResultSet(rs);
        }
        finally {
            DefaultSqlExecutor.closeStatement(statementScope.getSession(), cs);
            this.cleanupResultObjectFactory();
        }
    }

    @Override
    public void init(SqlMapConfiguration config, Properties globalProps) {
    }

    private ResultSet handleMultipleResults(PreparedStatement ps, StatementScope statementScope, int skipResults, int maxResults, RowHandlerCallback callback) throws SQLException {
        ResultSet rs = this.getFirstResultSet(statementScope, ps);
        if (rs != null) {
            this.handleResults(statementScope, rs, skipResults, maxResults, callback);
        }
        if (callback.getRowHandler() instanceof DefaultRowHandler) {
            MappedStatement statement = statementScope.getStatement();
            DefaultRowHandler defaultRowHandler = (DefaultRowHandler)callback.getRowHandler();
            if (statement.hasMultipleResultMaps()) {
                ArrayList<List> multipleResults = new ArrayList<List>();
                multipleResults.add(defaultRowHandler.getList());
                ResultMap[] resultMaps = statement.getAdditionalResultMaps();
                for (int i = 0; this.moveToNextResultsSafely(statementScope, ps) && i < resultMaps.length; ++i) {
                    ResultMap rm = resultMaps[i];
                    statementScope.setResultMap(rm);
                    rs = ps.getResultSet();
                    DefaultRowHandler rh = new DefaultRowHandler();
                    this.handleResults(statementScope, rs, skipResults, maxResults, new RowHandlerCallback(rm, null, rh));
                    multipleResults.add(rh.getList());
                }
                defaultRowHandler.setList(multipleResults);
                statementScope.setResultMap(statement.getResultMap());
            } else {
                while (this.moveToNextResultsSafely(statementScope, ps)) {
                }
            }
        }
        return rs;
    }

    private ResultSet getFirstResultSet(StatementScope scope, Statement stmt) throws SQLException {
        ResultSet rs = null;
        boolean hasMoreResults = true;
        while (hasMoreResults && (rs = stmt.getResultSet()) == null) {
            hasMoreResults = this.moveToNextResultsIfPresent(scope, stmt);
        }
        return rs;
    }

    private boolean moveToNextResultsIfPresent(StatementScope scope, Statement stmt) throws SQLException {
        boolean moreResults;
        boolean movedToNextResultsSafely = this.moveToNextResultsSafely(scope, stmt);
        int updateCount = stmt.getUpdateCount();
        boolean bl = moreResults = movedToNextResultsSafely || updateCount != -1;
        if (moreResults) {
            moreResults = movedToNextResultsSafely || this.isMultipleResultSetSupportPresent(scope, stmt);
        }
        return moreResults;
    }

    private boolean moveToNextResultsSafely(StatementScope scope, Statement stmt) throws SQLException {
        if (this.isMultipleResultSetSupportPresent(scope, stmt)) {
            return stmt.getMoreResults();
        }
        return false;
    }

    private boolean isMultipleResultSetSupportPresent(StatementScope scope, Statement stmt) throws SQLException {
        return this.forceMultipleResultSetSupport(scope) || stmt.getConnection().getMetaData().supportsMultipleResultSets();
    }

    private boolean forceMultipleResultSetSupport(StatementScope scope) {
        return ((SqlMapClientImpl)scope.getSession().getSqlMapClient()).getDelegate().isForceMultipleResultSetSupport();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleResults(StatementScope statementScope, ResultSet rs, int skipResults, int maxResults, RowHandlerCallback callback) throws SQLException {
        try {
            statementScope.setResultSet(rs);
            ResultMap resultMap = statementScope.getResultMap();
            if (resultMap != null) {
                if (rs.getType() != 1003) {
                    if (skipResults > 0) {
                        rs.absolute(skipResults);
                    }
                } else {
                    for (int i = 0; i < skipResults; ++i) {
                        if (rs.next()) continue;
                        return;
                    }
                }
                for (int resultsFetched = 0; (maxResults == -999999 || resultsFetched < maxResults) && rs.next(); ++resultsFetched) {
                    Object[] columnValues = resultMap.resolveSubMap(statementScope, rs).getResults(statementScope, rs);
                    callback.handleResultObject(statementScope, columnValues, rs);
                }
            }
        }
        finally {
            statementScope.setResultSet(null);
        }
    }

    private void retrieveOutputParameters(StatementScope statementScope, CallableStatement cs, ParameterMapping[] mappings, Object[] parameters, RowHandlerCallback callback) throws SQLException {
        for (int i = 0; i < mappings.length; ++i) {
            ParameterMapping mapping = mappings[i];
            if (!mapping.isOutputAllowed()) continue;
            if ("java.sql.ResultSet".equalsIgnoreCase(mapping.getJavaTypeName())) {
                ResultMap resultMap;
                ResultSet rs = (ResultSet)cs.getObject(i + 1);
                if (mapping.getResultMapName() == null) {
                    resultMap = statementScope.getResultMap();
                    this.handleOutputParameterResults(statementScope, resultMap, rs, callback);
                } else {
                    SqlMapClientImpl client = (SqlMapClientImpl)statementScope.getSession().getSqlMapClient();
                    resultMap = client.getDelegate().getResultMap(mapping.getResultMapName());
                    DefaultRowHandler rowHandler = new DefaultRowHandler();
                    RowHandlerCallback handlerCallback = new RowHandlerCallback(resultMap, null, rowHandler);
                    this.handleOutputParameterResults(statementScope, resultMap, rs, handlerCallback);
                    parameters[i] = rowHandler.getList();
                }
                rs.close();
                continue;
            }
            parameters[i] = mapping.getTypeHandler().getResult(cs, i + 1);
        }
    }

    private void registerOutputParameters(CallableStatement cs, ParameterMapping[] mappings) throws SQLException {
        for (int i = 0; i < mappings.length; ++i) {
            ParameterMapping mapping = mappings[i];
            if (!mapping.isOutputAllowed()) continue;
            if (null != mapping.getTypeName() && !mapping.getTypeName().equals("")) {
                cs.registerOutParameter(i + 1, mapping.getJdbcType(), mapping.getTypeName());
                continue;
            }
            if (mapping.getNumericScale() != null && (mapping.getJdbcType() == 2 || mapping.getJdbcType() == 3)) {
                cs.registerOutParameter(i + 1, mapping.getJdbcType(), (int)mapping.getNumericScale());
                continue;
            }
            cs.registerOutParameter(i + 1, mapping.getJdbcType());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleOutputParameterResults(StatementScope statementScope, ResultMap resultMap, ResultSet rs, RowHandlerCallback callback) throws SQLException {
        ResultMap orig = statementScope.getResultMap();
        try {
            statementScope.setResultSet(rs);
            if (resultMap != null) {
                statementScope.setResultMap(resultMap);
                while (rs.next()) {
                    Object[] columnValues = resultMap.resolveSubMap(statementScope, rs).getResults(statementScope, rs);
                    callback.handleResultObject(statementScope, columnValues, rs);
                }
            }
        }
        finally {
            statementScope.setResultSet(null);
            statementScope.setResultMap(orig);
        }
    }

    @Override
    public void cleanup(SessionScope sessionScope) {
        Batch batch = (Batch)sessionScope.getBatch();
        if (batch != null) {
            batch.cleanupBatch(sessionScope);
            sessionScope.setBatch(null);
        }
    }

    private PreparedStatement prepareStatement(SessionScope sessionScope, Connection conn, String sql, Integer rsType) throws SQLException {
        SqlMapExecutorDelegate delegate = ((SqlMapClientImpl)sessionScope.getSqlMapExecutor()).getDelegate();
        if (sessionScope.hasPreparedStatementFor(sql)) {
            return sessionScope.getPreparedStatement(sql);
        }
        PreparedStatement ps = conn.prepareStatement(sql, rsType, 1007);
        sessionScope.putPreparedStatement(delegate, sql, ps);
        return ps;
    }

    private CallableStatement prepareCall(SessionScope sessionScope, Connection conn, String sql, Integer rsType) throws SQLException {
        SqlMapExecutorDelegate delegate = ((SqlMapClientImpl)sessionScope.getSqlMapExecutor()).getDelegate();
        if (sessionScope.hasPreparedStatementFor(sql)) {
            return (CallableStatement)sessionScope.getPreparedStatement(sql);
        }
        CallableStatement cs = conn.prepareCall(sql, rsType, 1007);
        sessionScope.putPreparedStatement(delegate, sql, cs);
        return cs;
    }

    private static PreparedStatement prepareStatement(SessionScope sessionScope, Connection conn, String sql) throws SQLException {
        SqlMapExecutorDelegate delegate = ((SqlMapClientImpl)sessionScope.getSqlMapExecutor()).getDelegate();
        if (sessionScope.hasPreparedStatementFor(sql)) {
            return sessionScope.getPreparedStatement(sql);
        }
        PreparedStatement ps = conn.prepareStatement(sql);
        sessionScope.putPreparedStatement(delegate, sql, ps);
        return ps;
    }

    private CallableStatement prepareCall(SessionScope sessionScope, Connection conn, String sql) throws SQLException {
        SqlMapExecutorDelegate delegate = ((SqlMapClientImpl)sessionScope.getSqlMapExecutor()).getDelegate();
        if (sessionScope.hasPreparedStatementFor(sql)) {
            return (CallableStatement)sessionScope.getPreparedStatement(sql);
        }
        CallableStatement cs = conn.prepareCall(sql);
        sessionScope.putPreparedStatement(delegate, sql, cs);
        return cs;
    }

    private static void closeStatement(SessionScope sessionScope, PreparedStatement ps) {
        if (ps != null && !sessionScope.hasPreparedStatement(ps)) {
            try {
                ps.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }

    private static void closeResultSet(ResultSet rs) {
        if (rs != null) {
            try {
                rs.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }

    private static void setStatementTimeout(MappedStatement mappedStatement, Statement statement) throws SQLException {
        if (mappedStatement.getTimeout() != null) {
            statement.setQueryTimeout(mappedStatement.getTimeout());
        }
    }

    private void setupResultObjectFactory(StatementScope statementScope) {
        SqlMapClientImpl client = (SqlMapClientImpl)statementScope.getSession().getSqlMapClient();
        ResultObjectFactoryUtil.setupResultObjectFactory(client.getResultObjectFactory(), statementScope.getStatement().getId());
    }

    private void cleanupResultObjectFactory() {
        ResultObjectFactoryUtil.cleanupResultObjectFactory();
    }

    private static class Batch {
        private String currentSql;
        private List statementList = new ArrayList();
        private List batchResultList = new ArrayList();
        private int size = 0;

        public int getSize() {
            return this.size;
        }

        public void addBatch(StatementScope statementScope, Connection conn, String sql, Object[] parameters) throws SQLException {
            PreparedStatement ps = null;
            if (this.currentSql != null && this.currentSql.equals(sql)) {
                int last = this.statementList.size() - 1;
                ps = (PreparedStatement)this.statementList.get(last);
            } else {
                ps = DefaultSqlExecutor.prepareStatement(statementScope.getSession(), conn, sql);
                DefaultSqlExecutor.setStatementTimeout(statementScope.getStatement(), ps);
                this.currentSql = sql;
                this.statementList.add(ps);
                this.batchResultList.add(new BatchResult(statementScope.getStatement().getId(), sql));
            }
            statementScope.getParameterMap().setParameters(statementScope, ps, parameters);
            ps.addBatch();
            ++this.size;
        }

        public int executeBatch() throws SQLException {
            int totalRowCount = 0;
            for (Object element : this.statementList) {
                PreparedStatement ps = (PreparedStatement)element;
                int[] rowCounts = ps.executeBatch();
                for (int j = 0; j < rowCounts.length; ++j) {
                    if (rowCounts[j] == -2) continue;
                    if (rowCounts[j] == -3) {
                        throw new SQLException("The batched statement at index " + j + " failed to execute.");
                    }
                    totalRowCount += rowCounts[j];
                }
            }
            return totalRowCount;
        }

        public List executeBatchDetailed() throws SQLException, BatchException {
            ArrayList<BatchResult> answer = new ArrayList<BatchResult>();
            int n = this.statementList.size();
            for (int i = 0; i < n; ++i) {
                BatchResult br = (BatchResult)this.batchResultList.get(i);
                PreparedStatement ps = (PreparedStatement)this.statementList.get(i);
                try {
                    br.setUpdateCounts(ps.executeBatch());
                }
                catch (BatchUpdateException e) {
                    StringBuilder message = new StringBuilder();
                    message.append("Sub batch number ");
                    message.append(i + 1);
                    message.append(" failed.");
                    if (i > 0) {
                        message.append(" ");
                        message.append(i);
                        message.append(" prior sub batch(s) completed successfully, but will be rolled back.");
                    }
                    throw new BatchException(message.toString(), e, answer, br.getStatementId(), br.getSql());
                }
                answer.add(br);
            }
            return answer;
        }

        public void cleanupBatch(SessionScope sessionScope) {
            for (Object element : this.statementList) {
                PreparedStatement ps = (PreparedStatement)element;
                DefaultSqlExecutor.closeStatement(sessionScope, ps);
            }
            this.currentSql = null;
            this.statementList.clear();
            this.batchResultList.clear();
            this.size = 0;
        }
    }
}

