/*
 * Decompiled with CFR 0.152.
 */
package com.ibatis.sqlmap.engine.exchange;

import com.ibatis.sqlmap.engine.accessplan.AccessPlan;
import com.ibatis.sqlmap.engine.accessplan.AccessPlanFactory;
import com.ibatis.sqlmap.engine.exchange.BaseDataExchange;
import com.ibatis.sqlmap.engine.exchange.DataExchange;
import com.ibatis.sqlmap.engine.exchange.DataExchangeFactory;
import com.ibatis.sqlmap.engine.mapping.parameter.ParameterMap;
import com.ibatis.sqlmap.engine.mapping.parameter.ParameterMapping;
import com.ibatis.sqlmap.engine.mapping.result.ResultMap;
import com.ibatis.sqlmap.engine.mapping.result.ResultMapping;
import com.ibatis.sqlmap.engine.mapping.result.ResultObjectFactoryUtil;
import com.ibatis.sqlmap.engine.scope.ErrorContext;
import com.ibatis.sqlmap.engine.scope.StatementScope;
import java.util.ArrayList;
import java.util.Map;

public class JavaBeanDataExchange
extends BaseDataExchange
implements DataExchange {
    private static final Object[] NO_DATA = new Object[0];
    private AccessPlan resultPlan;
    private AccessPlan parameterPlan;
    private AccessPlan outParamPlan;

    protected JavaBeanDataExchange(DataExchangeFactory dataExchangeFactory) {
        super(dataExchangeFactory);
    }

    @Override
    public void initialize(Map properties) {
        ResultMap resultMap;
        Object map = properties.get("map");
        if (map instanceof ParameterMap) {
            ParameterMap parameterMap = (ParameterMap)map;
            if (parameterMap != null) {
                ParameterMapping[] parameterMappings = parameterMap.getParameterMappings();
                String[] parameterPropNames = new String[parameterMappings.length];
                for (int i = 0; i < parameterPropNames.length; ++i) {
                    parameterPropNames[i] = parameterMappings[i].getPropertyName();
                }
                this.parameterPlan = AccessPlanFactory.getAccessPlan(parameterMap.getParameterClass(), parameterPropNames);
                ArrayList<String> outParamList = new ArrayList<String>();
                for (int i = 0; i < parameterPropNames.length; ++i) {
                    if (!parameterMappings[i].isOutputAllowed()) continue;
                    outParamList.add(parameterMappings[i].getPropertyName());
                }
                String[] outParams = outParamList.toArray(new String[outParamList.size()]);
                this.outParamPlan = AccessPlanFactory.getAccessPlan(parameterMap.getParameterClass(), outParams);
            }
        } else if (map instanceof ResultMap && (resultMap = (ResultMap)map) != null) {
            ResultMapping[] resultMappings = resultMap.getResultMappings();
            String[] resultPropNames = new String[resultMappings.length];
            for (int i = 0; i < resultPropNames.length; ++i) {
                resultPropNames[i] = resultMappings[i].getPropertyName();
            }
            this.resultPlan = AccessPlanFactory.getAccessPlan(resultMap.getResultClass(), resultPropNames);
        }
    }

    @Override
    public Object[] getData(StatementScope statementScope, ParameterMap parameterMap, Object parameterObject) {
        if (this.parameterPlan != null) {
            return this.parameterPlan.getProperties(parameterObject);
        }
        return NO_DATA;
    }

    @Override
    public Object setData(StatementScope statementScope, ResultMap resultMap, Object resultObject, Object[] values) {
        if (this.resultPlan != null) {
            Object object = resultObject;
            ErrorContext errorContext = statementScope.getErrorContext();
            if (object == null) {
                errorContext.setMoreInfo("The error occured while instantiating the result object");
                try {
                    object = ResultObjectFactoryUtil.createObjectThroughFactory(resultMap.getResultClass());
                }
                catch (Exception e) {
                    throw new RuntimeException("JavaBeansDataExchange could not instantiate result class.  Cause: " + String.valueOf(e), e);
                }
            }
            errorContext.setMoreInfo("The error happened while setting a property on the result object.");
            this.resultPlan.setProperties(object, values);
            return object;
        }
        return null;
    }

    @Override
    public Object setData(StatementScope statementScope, ParameterMap parameterMap, Object parameterObject, Object[] values) {
        if (this.outParamPlan != null) {
            Object object = parameterObject;
            if (object == null) {
                try {
                    object = ResultObjectFactoryUtil.createObjectThroughFactory(parameterMap.getParameterClass());
                }
                catch (Exception e) {
                    throw new RuntimeException("JavaBeansDataExchange could not instantiate parameter class. Cause: " + String.valueOf(e), e);
                }
            }
            values = this.getOutputParamValues(parameterMap.getParameterMappings(), values);
            this.outParamPlan.setProperties(object, values);
            return object;
        }
        return null;
    }

    private Object[] getOutputParamValues(ParameterMapping[] mappings, Object[] values) {
        ArrayList<Object> outParamValues = new ArrayList<Object>();
        for (int i = 0; i < mappings.length; ++i) {
            if (!mappings[i].isOutputAllowed()) continue;
            outParamValues.add(values[i]);
        }
        return outParamValues.toArray();
    }
}

