/*
 * Decompiled with CFR 0.152.
 */
package com.ibatis.sqlmap.engine.mapping.statement;

import com.ibatis.common.io.ReaderInputStream;
import com.ibatis.common.jdbc.exception.NestedSQLException;
import com.ibatis.sqlmap.client.SqlMapClient;
import com.ibatis.sqlmap.client.event.RowHandler;
import com.ibatis.sqlmap.engine.cache.CacheKey;
import com.ibatis.sqlmap.engine.execution.SqlExecutor;
import com.ibatis.sqlmap.engine.impl.SqlMapClientImpl;
import com.ibatis.sqlmap.engine.mapping.parameter.ParameterMap;
import com.ibatis.sqlmap.engine.mapping.result.ResultMap;
import com.ibatis.sqlmap.engine.mapping.sql.Sql;
import com.ibatis.sqlmap.engine.mapping.statement.DefaultRowHandler;
import com.ibatis.sqlmap.engine.mapping.statement.ExecuteListener;
import com.ibatis.sqlmap.engine.mapping.statement.RowHandlerCallback;
import com.ibatis.sqlmap.engine.mapping.statement.StatementType;
import com.ibatis.sqlmap.engine.scope.ErrorContext;
import com.ibatis.sqlmap.engine.scope.StatementScope;
import com.ibatis.sqlmap.engine.transaction.Transaction;
import com.ibatis.sqlmap.engine.transaction.TransactionException;
import com.ibatis.sqlmap.engine.type.DomTypeMarker;
import com.ibatis.sqlmap.engine.type.XmlTypeMarker;
import java.io.StringReader;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;

public class MappedStatement {
    private String id;
    private Integer resultSetType;
    private Integer fetchSize;
    private ResultMap resultMap;
    private ParameterMap parameterMap;
    private Class parameterClass;
    private Sql sql;
    private int baseCacheKey;
    private SqlMapClientImpl sqlMapClient;
    private Integer timeout;
    private ResultMap[] additionalResultMaps = new ResultMap[0];
    private List executeListeners = new ArrayList();
    private String resource;

    public StatementType getStatementType() {
        return StatementType.UNKNOWN;
    }

    public int executeUpdate(StatementScope statementScope, Transaction trans, Object parameterObject) throws SQLException {
        ErrorContext errorContext = statementScope.getErrorContext();
        errorContext.setActivity("preparing the mapped statement for execution");
        errorContext.setObjectId(this.getId());
        errorContext.setResource(this.getResource());
        statementScope.getSession().setCommitRequired(true);
        try {
            parameterObject = this.validateParameter(parameterObject);
            Sql sql = this.getSql();
            errorContext.setMoreInfo("Check the parameter map.");
            ParameterMap parameterMap = sql.getParameterMap(statementScope, parameterObject);
            errorContext.setMoreInfo("Check the result map.");
            ResultMap resultMap = sql.getResultMap(statementScope, parameterObject);
            statementScope.setResultMap(resultMap);
            statementScope.setParameterMap(parameterMap);
            int rows = 0;
            errorContext.setMoreInfo("Check the parameter map.");
            Object[] parameters = parameterMap.getParameterObjectValues(statementScope, parameterObject);
            errorContext.setMoreInfo("Check the SQL statement.");
            String sqlString = sql.getSql(statementScope, parameterObject);
            errorContext.setActivity("executing mapped statement");
            errorContext.setMoreInfo("Check the statement or the result map.");
            rows = this.sqlExecuteUpdate(statementScope, trans.getConnection(), sqlString, parameters);
            errorContext.setMoreInfo("Check the output parameters.");
            if (parameterObject != null) {
                this.postProcessParameterObject(statementScope, parameterObject, parameters);
            }
            errorContext.reset();
            sql.cleanup(statementScope);
            this.notifyListeners();
            return rows;
        }
        catch (SQLException e) {
            errorContext.setCause(e);
            throw new NestedSQLException(errorContext.toString(), e.getSQLState(), e.getErrorCode(), e);
        }
        catch (Exception e) {
            errorContext.setCause(e);
            throw new NestedSQLException(errorContext.toString(), e);
        }
    }

    public Object executeQueryForObject(StatementScope statementScope, Transaction trans, Object parameterObject, Object resultObject) throws SQLException {
        try {
            Object object = null;
            DefaultRowHandler rowHandler = new DefaultRowHandler();
            this.executeQueryWithCallback(statementScope, trans.getConnection(), parameterObject, resultObject, rowHandler, 0, -999999);
            List list = rowHandler.getList();
            if (list.size() > 1) {
                throw new SQLException("Error: executeQueryForObject returned too many results.");
            }
            if (list.size() > 0) {
                object = list.get(0);
            }
            return object;
        }
        catch (TransactionException e) {
            throw new NestedSQLException("Error getting Connection from Transaction.  Cause: " + e, e);
        }
    }

    public List executeQueryForList(StatementScope statementScope, Transaction trans, Object parameterObject, int skipResults, int maxResults) throws SQLException {
        try {
            DefaultRowHandler rowHandler = new DefaultRowHandler();
            this.executeQueryWithCallback(statementScope, trans.getConnection(), parameterObject, null, rowHandler, skipResults, maxResults);
            return rowHandler.getList();
        }
        catch (TransactionException e) {
            throw new NestedSQLException("Error getting Connection from Transaction.  Cause: " + e, e);
        }
    }

    public void executeQueryWithRowHandler(StatementScope statementScope, Transaction trans, Object parameterObject, RowHandler rowHandler) throws SQLException {
        try {
            this.executeQueryWithCallback(statementScope, trans.getConnection(), parameterObject, null, rowHandler, 0, -999999);
        }
        catch (TransactionException e) {
            throw new NestedSQLException("Error getting Connection from Transaction.  Cause: " + e, e);
        }
    }

    protected void executeQueryWithCallback(StatementScope statementScope, Connection conn, Object parameterObject, Object resultObject, RowHandler rowHandler, int skipResults, int maxResults) throws SQLException {
        ErrorContext errorContext = statementScope.getErrorContext();
        errorContext.setActivity("preparing the mapped statement for execution");
        errorContext.setObjectId(this.getId());
        errorContext.setResource(this.getResource());
        try {
            parameterObject = this.validateParameter(parameterObject);
            Sql sql = this.getSql();
            errorContext.setMoreInfo("Check the parameter map.");
            ParameterMap parameterMap = sql.getParameterMap(statementScope, parameterObject);
            errorContext.setMoreInfo("Check the result map.");
            ResultMap resultMap = sql.getResultMap(statementScope, parameterObject);
            statementScope.setResultMap(resultMap);
            statementScope.setParameterMap(parameterMap);
            errorContext.setMoreInfo("Check the parameter map.");
            Object[] parameters = parameterMap.getParameterObjectValues(statementScope, parameterObject);
            errorContext.setMoreInfo("Check the SQL statement.");
            String sqlString = sql.getSql(statementScope, parameterObject);
            errorContext.setActivity("executing mapped statement");
            errorContext.setMoreInfo("Check the SQL statement or the result map.");
            RowHandlerCallback callback = new RowHandlerCallback(resultMap, resultObject, rowHandler);
            this.sqlExecuteQuery(statementScope, conn, sqlString, parameters, skipResults, maxResults, callback);
            errorContext.setMoreInfo("Check the output parameters.");
            if (parameterObject != null) {
                this.postProcessParameterObject(statementScope, parameterObject, parameters);
            }
            errorContext.reset();
            sql.cleanup(statementScope);
            this.notifyListeners();
        }
        catch (SQLException e) {
            errorContext.setCause(e);
            throw new NestedSQLException(errorContext.toString(), e.getSQLState(), e.getErrorCode(), e);
        }
        catch (Exception e) {
            errorContext.setCause(e);
            throw new NestedSQLException(errorContext.toString(), e);
        }
    }

    protected void postProcessParameterObject(StatementScope statementScope, Object parameterObject, Object[] parameters) {
    }

    protected int sqlExecuteUpdate(StatementScope statementScope, Connection conn, String sqlString, Object[] parameters) throws SQLException {
        if (statementScope.getSession().isInBatch()) {
            this.getSqlExecutor().addBatch(statementScope, conn, sqlString, parameters);
            return 0;
        }
        return this.getSqlExecutor().executeUpdate(statementScope, conn, sqlString, parameters);
    }

    protected void sqlExecuteQuery(StatementScope statementScope, Connection conn, String sqlString, Object[] parameters, int skipResults, int maxResults, RowHandlerCallback callback) throws SQLException {
        this.getSqlExecutor().executeQuery(statementScope, conn, sqlString, parameters, skipResults, maxResults, callback);
    }

    protected Object validateParameter(Object param) throws SQLException {
        Object newParam = param;
        Class parameterClass = this.getParameterClass();
        if (newParam != null && parameterClass != null) {
            if (DomTypeMarker.class.isAssignableFrom(parameterClass)) {
                if (XmlTypeMarker.class.isAssignableFrom(parameterClass)) {
                    if (!(newParam instanceof String) && !(newParam instanceof Document)) {
                        throw new SQLException("Invalid parameter object type.  Expected '" + String.class.getName() + "' or '" + Document.class.getName() + "' but found '" + newParam.getClass().getName() + "'.");
                    }
                    if (!(newParam instanceof Document)) {
                        newParam = this.stringToDocument((String)newParam);
                    }
                } else if (!Document.class.isAssignableFrom(newParam.getClass())) {
                    throw new SQLException("Invalid parameter object type.  Expected '" + Document.class.getName() + "' but found '" + newParam.getClass().getName() + "'.");
                }
            } else if (!parameterClass.isAssignableFrom(newParam.getClass())) {
                throw new SQLException("Invalid parameter object type.  Expected '" + parameterClass.getName() + "' but found '" + newParam.getClass().getName() + "'.");
            }
        }
        return newParam;
    }

    private Document stringToDocument(String s) {
        try {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            return documentBuilder.parse(new ReaderInputStream(new StringReader(s)));
        }
        catch (Exception e) {
            throw new RuntimeException("Error occurred.  Cause: " + e, e);
        }
    }

    public String getId() {
        return this.id;
    }

    public Integer getResultSetType() {
        return this.resultSetType;
    }

    public void setResultSetType(Integer resultSetType) {
        this.resultSetType = resultSetType;
    }

    public Integer getFetchSize() {
        return this.fetchSize;
    }

    public void setFetchSize(Integer fetchSize) {
        this.fetchSize = fetchSize;
    }

    public void setId(String id) {
        this.id = id;
    }

    public Sql getSql() {
        return this.sql;
    }

    public void setSql(Sql sql) {
        this.sql = sql;
    }

    public ResultMap getResultMap() {
        return this.resultMap;
    }

    public void setResultMap(ResultMap resultMap) {
        this.resultMap = resultMap;
    }

    public ParameterMap getParameterMap() {
        return this.parameterMap;
    }

    public void setParameterMap(ParameterMap parameterMap) {
        this.parameterMap = parameterMap;
    }

    public Class getParameterClass() {
        return this.parameterClass;
    }

    public void setParameterClass(Class parameterClass) {
        this.parameterClass = parameterClass;
    }

    public String getResource() {
        return this.resource;
    }

    public void setResource(String resource) {
        this.resource = resource;
    }

    public CacheKey getCacheKey(StatementScope statementScope, Object parameterObject) {
        Sql sql = statementScope.getSql();
        ParameterMap pmap = sql.getParameterMap(statementScope, parameterObject);
        CacheKey cacheKey = pmap.getCacheKey(statementScope, parameterObject);
        cacheKey.update(this.id);
        cacheKey.update(sql.getSql(statementScope, parameterObject));
        return cacheKey;
    }

    public void setBaseCacheKey(int base) {
        this.baseCacheKey = base;
    }

    public void addExecuteListener(ExecuteListener listener) {
        this.executeListeners.add(listener);
    }

    public void notifyListeners() {
        int n = this.executeListeners.size();
        for (int i = 0; i < n; ++i) {
            ((ExecuteListener)this.executeListeners.get(i)).onExecuteStatement(this);
        }
    }

    public SqlExecutor getSqlExecutor() {
        return this.sqlMapClient.getSqlExecutor();
    }

    public SqlMapClient getSqlMapClient() {
        return this.sqlMapClient;
    }

    public void setSqlMapClient(SqlMapClient sqlMapClient) {
        this.sqlMapClient = (SqlMapClientImpl)sqlMapClient;
    }

    public void initRequest(StatementScope statementScope) {
        statementScope.setStatement(this);
        statementScope.setParameterMap(this.parameterMap);
        statementScope.setResultMap(this.resultMap);
        statementScope.setSql(this.sql);
    }

    public Integer getTimeout() {
        return this.timeout;
    }

    public void setTimeout(Integer timeout) {
        this.timeout = timeout;
    }

    public void addResultMap(ResultMap resultMap) {
        List<ResultMap> resultMapList = Arrays.asList(this.additionalResultMaps);
        resultMapList = new ArrayList<ResultMap>(resultMapList);
        resultMapList.add(resultMap);
        this.additionalResultMaps = resultMapList.toArray(new ResultMap[resultMapList.size()]);
    }

    public boolean hasMultipleResultMaps() {
        return this.additionalResultMaps.length > 0;
    }

    public ResultMap[] getAdditionalResultMaps() {
        return this.additionalResultMaps;
    }
}

