/*
 * Decompiled with CFR 0.152.
 */
package com.ibatis.sqlmap.engine.mapping.sql.dynamic.elements;

import com.ibatis.sqlmap.client.SqlMapException;
import com.ibatis.sqlmap.engine.mapping.sql.dynamic.elements.SqlTag;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class IterateContext
implements Iterator {
    private static final String PROCESS_INDEX = "ProcessIndex";
    private static final String PROCESS_STRING = "ProcessString";
    private Iterator iterator;
    private int index = -1;
    private String property;
    private boolean allowNext = true;
    private boolean isFinal = false;
    private SqlTag tag;
    private IterateContext parent;
    private boolean someSubElementsHaveContent;
    private boolean isPrependEnabled;

    public IterateContext(Object collection, SqlTag tag, IterateContext parent) {
        this.parent = parent;
        this.tag = tag;
        if (collection instanceof Collection) {
            this.iterator = ((Collection)collection).iterator();
        } else if (collection instanceof Iterator) {
            this.iterator = (Iterator)collection;
        } else if (collection.getClass().isArray()) {
            List list = this.arrayToList(collection);
            this.iterator = list.iterator();
        } else {
            throw new SqlMapException("ParameterObject or property was not a Collection, Array or Iterator.");
        }
    }

    @Override
    public boolean hasNext() {
        return this.iterator != null && this.iterator.hasNext();
    }

    public Object next() {
        ++this.index;
        return this.iterator.next();
    }

    @Override
    public void remove() {
        this.iterator.remove();
    }

    public int getIndex() {
        return this.index;
    }

    public boolean isFirst() {
        return this.index == 0;
    }

    public boolean isLast() {
        return this.iterator != null && !this.iterator.hasNext();
    }

    private List arrayToList(Object array) {
        List<Object> list = null;
        if (array instanceof Object[]) {
            list = Arrays.asList((Object[])array);
        } else {
            list = new ArrayList();
            int n = Array.getLength(array);
            for (int i = 0; i < n; ++i) {
                list.add(Array.get(array, i));
            }
        }
        return list;
    }

    public String getProperty() {
        return this.property;
    }

    public void setProperty(String property) {
        this.property = property;
    }

    public boolean isAllowNext() {
        return this.allowNext;
    }

    public void setAllowNext(boolean performIterate) {
        this.allowNext = performIterate;
    }

    public SqlTag getTag() {
        return this.tag;
    }

    public void setTag(SqlTag tag) {
        this.tag = tag;
    }

    public boolean isFinal() {
        return this.isFinal;
    }

    public void setFinal(boolean aFinal) {
        this.isFinal = aFinal;
    }

    public String getEndProperty() {
        if (this.parent != null) {
            int parentPropertyIndex = this.property.indexOf(this.parent.getProperty());
            if (parentPropertyIndex > -1) {
                int endPropertyIndex1 = this.property.indexOf(93, parentPropertyIndex);
                int endPropertyIndex2 = this.property.indexOf(46, parentPropertyIndex);
                return this.property.substring(parentPropertyIndex + Math.max(endPropertyIndex1, endPropertyIndex2) + 1, this.property.length());
            }
            return this.property;
        }
        return this.property;
    }

    protected Map processTagProperty(String tagProperty) {
        if (this.parent != null) {
            Map parentResult = this.parent.processTagProperty(tagProperty);
            return this.addIndex((String)parentResult.get(PROCESS_STRING), (Integer)parentResult.get(PROCESS_INDEX));
        }
        return this.addIndex(tagProperty, 0);
    }

    public String addIndexToTagProperty(String tagProperty) {
        Map map = this.processTagProperty(tagProperty);
        return (String)map.get(PROCESS_STRING);
    }

    protected Map addIndex(String input, int startIndex) {
        String endProperty = this.getEndProperty() + "[";
        int propertyIndex = input.indexOf(endProperty, startIndex);
        int modificationIndex = 0;
        if (propertyIndex > -1 && input.charAt(propertyIndex + endProperty.length()) == ']') {
            input = input.substring(0, propertyIndex + endProperty.length()) + this.getIndex() + input.substring(propertyIndex + endProperty.length());
            modificationIndex = propertyIndex + endProperty.length();
        }
        HashMap<String, Object> ret = new HashMap<String, Object>();
        ret.put(PROCESS_INDEX, modificationIndex);
        ret.put(PROCESS_STRING, input);
        return ret;
    }

    public IterateContext getParent() {
        return this.parent;
    }

    public void setParent(IterateContext parent) {
        this.parent = parent;
    }

    public boolean someSubElementsHaveContent() {
        return this.someSubElementsHaveContent;
    }

    public void setSomeSubElementsHaveContent(boolean someSubElementsHaveContent) {
        this.someSubElementsHaveContent = someSubElementsHaveContent;
    }

    public boolean isPrependEnabled() {
        return this.isPrependEnabled;
    }

    public void setPrependEnabled(boolean isPrependEnabled) {
        this.isPrependEnabled = isPrependEnabled;
    }
}

