/*
 * Decompiled with CFR 0.152.
 */
package com.ibatis.sqlmap.engine.builder.xml;

import com.ibatis.common.resources.Resources;
import com.ibatis.common.xml.Nodelet;
import com.ibatis.common.xml.NodeletParser;
import com.ibatis.common.xml.NodeletUtils;
import com.ibatis.sqlmap.client.SqlMapClient;
import com.ibatis.sqlmap.client.SqlMapException;
import com.ibatis.sqlmap.engine.builder.xml.SqlMapClasspathEntityResolver;
import com.ibatis.sqlmap.engine.builder.xml.SqlMapParser;
import com.ibatis.sqlmap.engine.builder.xml.XmlParserState;
import com.ibatis.sqlmap.engine.config.SqlMapConfiguration;
import com.ibatis.sqlmap.engine.datasource.DataSourceFactory;
import com.ibatis.sqlmap.engine.mapping.result.ResultObjectFactory;
import com.ibatis.sqlmap.engine.transaction.TransactionConfig;
import com.ibatis.sqlmap.engine.transaction.TransactionManager;
import java.io.InputStream;
import java.io.Reader;
import java.util.Properties;
import org.w3c.dom.Node;

public class SqlMapConfigParser {
    protected final NodeletParser parser = new NodeletParser();
    private XmlParserState state = new XmlParserState();
    private boolean usingStreams = false;

    public SqlMapConfigParser() {
        this.parser.setValidation(true);
        this.parser.setEntityResolver(new SqlMapClasspathEntityResolver());
        this.addSqlMapConfigNodelets();
        this.addGlobalPropNodelets();
        this.addSettingsNodelets();
        this.addTypeAliasNodelets();
        this.addTypeHandlerNodelets();
        this.addTransactionManagerNodelets();
        this.addSqlMapNodelets();
        this.addResultObjectFactoryNodelets();
    }

    public SqlMapClient parse(Reader reader, Properties props) {
        if (props != null) {
            this.state.setGlobalProps(props);
        }
        return this.parse(reader);
    }

    public SqlMapClient parse(Reader reader) {
        try {
            this.usingStreams = false;
            this.parser.parse(reader);
            return this.state.getConfig().getClient();
        }
        catch (Exception e) {
            throw new RuntimeException("Error occurred.  Cause: " + e, e);
        }
    }

    public SqlMapClient parse(InputStream inputStream, Properties props) {
        if (props != null) {
            this.state.setGlobalProps(props);
        }
        return this.parse(inputStream);
    }

    public SqlMapClient parse(InputStream inputStream) {
        try {
            this.usingStreams = true;
            this.parser.parse(inputStream);
            return this.state.getConfig().getClient();
        }
        catch (Exception e) {
            throw new RuntimeException("Error occurred.  Cause: " + e, e);
        }
    }

    private void addSqlMapConfigNodelets() {
        this.parser.addNodelet("/sqlMapConfig/end()", new Nodelet(){

            @Override
            public void process(Node node) throws Exception {
                SqlMapConfigParser.this.state.getConfig().finalizeSqlMapConfig();
            }
        });
    }

    private void addGlobalPropNodelets() {
        this.parser.addNodelet("/sqlMapConfig/properties", new Nodelet(){

            @Override
            public void process(Node node) throws Exception {
                Properties attributes = NodeletUtils.parseAttributes(node, SqlMapConfigParser.this.state.getGlobalProps());
                String resource = attributes.getProperty("resource");
                String url = attributes.getProperty("url");
                SqlMapConfigParser.this.state.setGlobalProperties(resource, url);
            }
        });
    }

    private void addSettingsNodelets() {
        this.parser.addNodelet("/sqlMapConfig/settings", new Nodelet(){

            @Override
            public void process(Node node) throws Exception {
                Properties attributes = NodeletUtils.parseAttributes(node, SqlMapConfigParser.this.state.getGlobalProps());
                SqlMapConfiguration config = SqlMapConfigParser.this.state.getConfig();
                String classInfoCacheEnabledAttr = attributes.getProperty("classInfoCacheEnabled");
                boolean classInfoCacheEnabled = classInfoCacheEnabledAttr == null || "true".equals(classInfoCacheEnabledAttr);
                config.setClassInfoCacheEnabled(classInfoCacheEnabled);
                String lazyLoadingEnabledAttr = attributes.getProperty("lazyLoadingEnabled");
                boolean lazyLoadingEnabled = lazyLoadingEnabledAttr == null || "true".equals(lazyLoadingEnabledAttr);
                config.setLazyLoadingEnabled(lazyLoadingEnabled);
                String statementCachingEnabledAttr = attributes.getProperty("statementCachingEnabled");
                boolean statementCachingEnabled = statementCachingEnabledAttr == null || "true".equals(statementCachingEnabledAttr);
                config.setStatementCachingEnabled(statementCachingEnabled);
                String cacheModelsEnabledAttr = attributes.getProperty("cacheModelsEnabled");
                boolean cacheModelsEnabled = cacheModelsEnabledAttr == null || "true".equals(cacheModelsEnabledAttr);
                config.setCacheModelsEnabled(cacheModelsEnabled);
                String enhancementEnabledAttr = attributes.getProperty("enhancementEnabled");
                boolean enhancementEnabled = enhancementEnabledAttr == null || "true".equals(enhancementEnabledAttr);
                config.setEnhancementEnabled(enhancementEnabled);
                String useColumnLabelAttr = attributes.getProperty("useColumnLabel");
                boolean useColumnLabel = useColumnLabelAttr == null || "true".equals(useColumnLabelAttr);
                config.setUseColumnLabel(useColumnLabel);
                String forceMultipleResultSetSupportAttr = attributes.getProperty("forceMultipleResultSetSupport");
                boolean forceMultipleResultSetSupport = "true".equals(forceMultipleResultSetSupportAttr);
                config.setForceMultipleResultSetSupport(forceMultipleResultSetSupport);
                String defaultTimeoutAttr = attributes.getProperty("defaultStatementTimeout");
                Integer defaultTimeout = defaultTimeoutAttr == null ? null : Integer.valueOf(defaultTimeoutAttr);
                config.setDefaultStatementTimeout(defaultTimeout);
                String useStatementNamespacesAttr = attributes.getProperty("useStatementNamespaces");
                boolean useStatementNamespaces = "true".equals(useStatementNamespacesAttr);
                SqlMapConfigParser.this.state.setUseStatementNamespaces(useStatementNamespaces);
            }
        });
    }

    private void addTypeAliasNodelets() {
        this.parser.addNodelet("/sqlMapConfig/typeAlias", new Nodelet(){

            @Override
            public void process(Node node) throws Exception {
                Properties prop = NodeletUtils.parseAttributes(node, SqlMapConfigParser.this.state.getGlobalProps());
                String alias = prop.getProperty("alias");
                String type = prop.getProperty("type");
                SqlMapConfigParser.this.state.getConfig().getTypeHandlerFactory().putTypeAlias(alias, type);
            }
        });
    }

    private void addTypeHandlerNodelets() {
        this.parser.addNodelet("/sqlMapConfig/typeHandler", new Nodelet(){

            @Override
            public void process(Node node) throws Exception {
                Properties prop = NodeletUtils.parseAttributes(node, SqlMapConfigParser.this.state.getGlobalProps());
                String jdbcType = prop.getProperty("jdbcType");
                String javaType = prop.getProperty("javaType");
                String callback = prop.getProperty("callback");
                javaType = SqlMapConfigParser.this.state.getConfig().getTypeHandlerFactory().resolveAlias(javaType);
                callback = SqlMapConfigParser.this.state.getConfig().getTypeHandlerFactory().resolveAlias(callback);
                SqlMapConfigParser.this.state.getConfig().newTypeHandler(Resources.classForName(javaType), jdbcType, Resources.instantiate(callback));
            }
        });
    }

    private void addTransactionManagerNodelets() {
        this.parser.addNodelet("/sqlMapConfig/transactionManager/property", new Nodelet(){

            @Override
            public void process(Node node) throws Exception {
                Properties attributes = NodeletUtils.parseAttributes(node, SqlMapConfigParser.this.state.getGlobalProps());
                String name = attributes.getProperty("name");
                String value = NodeletUtils.parsePropertyTokens(attributes.getProperty("value"), SqlMapConfigParser.this.state.getGlobalProps());
                SqlMapConfigParser.this.state.getTxProps().setProperty(name, value);
            }
        });
        this.parser.addNodelet("/sqlMapConfig/transactionManager/end()", new Nodelet(){

            @Override
            public void process(Node node) throws Exception {
                TransactionManager txManager;
                Properties attributes = NodeletUtils.parseAttributes(node, SqlMapConfigParser.this.state.getGlobalProps());
                String type = attributes.getProperty("type");
                boolean commitRequired = "true".equals(attributes.getProperty("commitRequired"));
                SqlMapConfigParser.this.state.getConfig().getErrorContext().setActivity("configuring the transaction manager");
                type = SqlMapConfigParser.this.state.getConfig().getTypeHandlerFactory().resolveAlias(type);
                try {
                    SqlMapConfigParser.this.state.getConfig().getErrorContext().setMoreInfo("Check the transaction manager type or class.");
                    TransactionConfig config = (TransactionConfig)Resources.instantiate(type);
                    config.setDataSource(SqlMapConfigParser.this.state.getDataSource());
                    SqlMapConfigParser.this.state.getConfig().getErrorContext().setMoreInfo("Check the transaction manager properties or configuration.");
                    config.setProperties(SqlMapConfigParser.this.state.getTxProps());
                    config.setForceCommit(commitRequired);
                    config.setDataSource(SqlMapConfigParser.this.state.getDataSource());
                    SqlMapConfigParser.this.state.getConfig().getErrorContext().setMoreInfo(null);
                    txManager = new TransactionManager(config);
                }
                catch (Exception e) {
                    if (e instanceof SqlMapException) {
                        throw (SqlMapException)e;
                    }
                    throw new SqlMapException("Error initializing TransactionManager.  Could not instantiate TransactionConfig.  Cause: " + e, e);
                }
                SqlMapConfigParser.this.state.getConfig().setTransactionManager(txManager);
            }
        });
        this.parser.addNodelet("/sqlMapConfig/transactionManager/dataSource/property", new Nodelet(){

            @Override
            public void process(Node node) throws Exception {
                Properties attributes = NodeletUtils.parseAttributes(node, SqlMapConfigParser.this.state.getGlobalProps());
                String name = attributes.getProperty("name");
                String value = NodeletUtils.parsePropertyTokens(attributes.getProperty("value"), SqlMapConfigParser.this.state.getGlobalProps());
                SqlMapConfigParser.this.state.getDsProps().setProperty(name, value);
            }
        });
        this.parser.addNodelet("/sqlMapConfig/transactionManager/dataSource/end()", new Nodelet(){

            @Override
            public void process(Node node) throws Exception {
                SqlMapConfigParser.this.state.getConfig().getErrorContext().setActivity("configuring the data source");
                Properties attributes = NodeletUtils.parseAttributes(node, SqlMapConfigParser.this.state.getGlobalProps());
                String type = attributes.getProperty("type");
                Properties props = SqlMapConfigParser.this.state.getDsProps();
                type = SqlMapConfigParser.this.state.getConfig().getTypeHandlerFactory().resolveAlias(type);
                try {
                    SqlMapConfigParser.this.state.getConfig().getErrorContext().setMoreInfo("Check the data source type or class.");
                    DataSourceFactory dsFactory = (DataSourceFactory)Resources.instantiate(type);
                    SqlMapConfigParser.this.state.getConfig().getErrorContext().setMoreInfo("Check the data source properties or configuration.");
                    dsFactory.initialize(props);
                    SqlMapConfigParser.this.state.setDataSource(dsFactory.getDataSource());
                    SqlMapConfigParser.this.state.getConfig().getErrorContext().setMoreInfo(null);
                }
                catch (Exception e) {
                    if (e instanceof SqlMapException) {
                        throw (SqlMapException)e;
                    }
                    throw new SqlMapException("Error initializing DataSource.  Could not instantiate DataSourceFactory.  Cause: " + e, e);
                }
            }
        });
    }

    protected void addSqlMapNodelets() {
        this.parser.addNodelet("/sqlMapConfig/sqlMap", new Nodelet(){

            @Override
            public void process(Node node) throws Exception {
                SqlMapConfigParser.this.state.getConfig().getErrorContext().setActivity("loading the SQL Map resource");
                Properties attributes = NodeletUtils.parseAttributes(node, SqlMapConfigParser.this.state.getGlobalProps());
                String resource = attributes.getProperty("resource");
                String url = attributes.getProperty("url");
                if (SqlMapConfigParser.this.usingStreams) {
                    InputStream inputStream = null;
                    if (resource != null) {
                        SqlMapConfigParser.this.state.getConfig().getErrorContext().setResource(resource);
                        inputStream = Resources.getResourceAsStream(resource);
                    } else if (url != null) {
                        SqlMapConfigParser.this.state.getConfig().getErrorContext().setResource(url);
                        inputStream = Resources.getUrlAsStream(url);
                    } else {
                        throw new SqlMapException("The <sqlMap> element requires either a resource or a url attribute.");
                    }
                    new SqlMapParser(SqlMapConfigParser.this.state).parse(inputStream);
                } else {
                    Reader reader = null;
                    if (resource != null) {
                        SqlMapConfigParser.this.state.getConfig().getErrorContext().setResource(resource);
                        reader = Resources.getResourceAsReader(resource);
                    } else if (url != null) {
                        SqlMapConfigParser.this.state.getConfig().getErrorContext().setResource(url);
                        reader = Resources.getUrlAsReader(url);
                    } else {
                        throw new SqlMapException("The <sqlMap> element requires either a resource or a url attribute.");
                    }
                    new SqlMapParser(SqlMapConfigParser.this.state).parse(reader);
                }
            }
        });
    }

    private void addResultObjectFactoryNodelets() {
        this.parser.addNodelet("/sqlMapConfig/resultObjectFactory", new Nodelet(){

            @Override
            public void process(Node node) throws Exception {
                Properties attributes = NodeletUtils.parseAttributes(node, SqlMapConfigParser.this.state.getGlobalProps());
                String type = attributes.getProperty("type");
                SqlMapConfigParser.this.state.getConfig().getErrorContext().setActivity("configuring the Result Object Factory");
                try {
                    ResultObjectFactory rof = (ResultObjectFactory)Resources.instantiate(type);
                    SqlMapConfigParser.this.state.getConfig().setResultObjectFactory(rof);
                }
                catch (Exception e) {
                    throw new SqlMapException("Error instantiating resultObjectFactory: " + type, e);
                }
            }
        });
        this.parser.addNodelet("/sqlMapConfig/resultObjectFactory/property", new Nodelet(){

            @Override
            public void process(Node node) throws Exception {
                Properties attributes = NodeletUtils.parseAttributes(node, SqlMapConfigParser.this.state.getGlobalProps());
                String name = attributes.getProperty("name");
                String value = NodeletUtils.parsePropertyTokens(attributes.getProperty("value"), SqlMapConfigParser.this.state.getGlobalProps());
                SqlMapConfigParser.this.state.getConfig().getDelegate().getResultObjectFactory().setProperty(name, value);
            }
        });
    }
}

