/*
 * Decompiled with CFR 0.152.
 */
package com.ibatis.sqlmap.engine.transaction.external;

import com.ibatis.sqlmap.engine.transaction.BaseTransactionConfig;
import com.ibatis.sqlmap.engine.transaction.Transaction;
import com.ibatis.sqlmap.engine.transaction.TransactionException;
import com.ibatis.sqlmap.engine.transaction.external.ExternalTransaction;
import java.sql.SQLException;
import java.util.Properties;

public class ExternalTransactionConfig
extends BaseTransactionConfig {
    private boolean defaultAutoCommit = false;
    private boolean setAutoCommitAllowed = true;

    @Override
    public Transaction newTransaction(int transactionIsolation) throws SQLException, TransactionException {
        return new ExternalTransaction(this.dataSource, this.defaultAutoCommit, this.setAutoCommitAllowed, transactionIsolation);
    }

    public boolean isDefaultAutoCommit() {
        return this.defaultAutoCommit;
    }

    public void setDefaultAutoCommit(boolean defaultAutoCommit) {
        this.defaultAutoCommit = defaultAutoCommit;
    }

    public boolean isSetAutoCommitAllowed() {
        return this.setAutoCommitAllowed;
    }

    public void setSetAutoCommitAllowed(boolean setAutoCommitAllowed) {
        this.setAutoCommitAllowed = setAutoCommitAllowed;
    }

    @Override
    public void setProperties(Properties props) throws SQLException, TransactionException {
        String dacProp = props.getProperty("DefaultAutoCommit");
        String sacaProp = props.getProperty("SetAutoCommitAllowed");
        this.defaultAutoCommit = "true".equals(dacProp);
        this.setAutoCommitAllowed = "true".equals(sacaProp) || sacaProp == null;
    }
}

