/*
 * Decompiled with CFR 0.152.
 */
package com.ibatis.sqlmap.engine.mapping.sql.dynamic;

import com.ibatis.sqlmap.engine.impl.SqlMapExecutorDelegate;
import com.ibatis.sqlmap.engine.mapping.parameter.InlineParameterMapParser;
import com.ibatis.sqlmap.engine.mapping.parameter.ParameterMap;
import com.ibatis.sqlmap.engine.mapping.parameter.ParameterMapping;
import com.ibatis.sqlmap.engine.mapping.result.ResultMap;
import com.ibatis.sqlmap.engine.mapping.sql.Sql;
import com.ibatis.sqlmap.engine.mapping.sql.SqlChild;
import com.ibatis.sqlmap.engine.mapping.sql.SqlText;
import com.ibatis.sqlmap.engine.mapping.sql.dynamic.elements.DynamicParent;
import com.ibatis.sqlmap.engine.mapping.sql.dynamic.elements.IterateContext;
import com.ibatis.sqlmap.engine.mapping.sql.dynamic.elements.SqlTag;
import com.ibatis.sqlmap.engine.mapping.sql.dynamic.elements.SqlTagContext;
import com.ibatis.sqlmap.engine.mapping.sql.dynamic.elements.SqlTagHandler;
import com.ibatis.sqlmap.engine.mapping.sql.simple.SimpleDynamicSql;
import com.ibatis.sqlmap.engine.scope.StatementScope;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class DynamicSql
implements Sql,
DynamicParent {
    private static final InlineParameterMapParser PARAM_PARSER = new InlineParameterMapParser();
    private List children = new ArrayList();
    private SqlMapExecutorDelegate delegate;

    public DynamicSql(SqlMapExecutorDelegate delegate) {
        this.delegate = delegate;
    }

    @Override
    public String getSql(StatementScope statementScope, Object parameterObject) {
        String sql = statementScope.getDynamicSql();
        if (sql == null) {
            this.process(statementScope, parameterObject);
            sql = statementScope.getDynamicSql();
        }
        return sql;
    }

    @Override
    public ParameterMap getParameterMap(StatementScope statementScope, Object parameterObject) {
        ParameterMap map = statementScope.getDynamicParameterMap();
        if (map == null) {
            this.process(statementScope, parameterObject);
            map = statementScope.getDynamicParameterMap();
        }
        return map;
    }

    @Override
    public ResultMap getResultMap(StatementScope statementScope, Object parameterObject) {
        return statementScope.getResultMap();
    }

    @Override
    public void cleanup(StatementScope statementScope) {
        statementScope.setDynamicSql(null);
        statementScope.setDynamicParameterMap(null);
    }

    private void process(StatementScope statementScope, Object parameterObject) {
        SqlTagContext ctx = new SqlTagContext();
        List localChildren = this.children;
        this.processBodyChildren(statementScope, ctx, parameterObject, localChildren.iterator());
        ParameterMap map = new ParameterMap(this.delegate);
        map.setId(statementScope.getStatement().getId() + "-InlineParameterMap");
        map.setParameterClass(statementScope.getStatement().getParameterClass());
        map.setParameterMappingList(ctx.getParameterMappings());
        String dynSql = ctx.getBodyText();
        if (SimpleDynamicSql.isSimpleDynamicSql(dynSql)) {
            dynSql = new SimpleDynamicSql(this.delegate, dynSql).getSql(statementScope, parameterObject);
        }
        statementScope.setDynamicSql(dynSql);
        statementScope.setDynamicParameterMap(map);
    }

    private void processBodyChildren(StatementScope statementScope, SqlTagContext ctx, Object parameterObject, Iterator localChildren) {
        PrintWriter out = ctx.getWriter();
        this.processBodyChildren(statementScope, ctx, parameterObject, localChildren, out);
    }

    private void processBodyChildren(StatementScope statementScope, SqlTagContext ctx, Object parameterObject, Iterator localChildren, PrintWriter out) {
        while (localChildren.hasNext()) {
            SqlChild child = (SqlChild)localChildren.next();
            if (child instanceof SqlText) {
                SqlText sqlText = (SqlText)child;
                String sqlStatement = sqlText.getText();
                if (sqlText.isWhiteSpace()) {
                    out.print(sqlStatement);
                    continue;
                }
                if (!sqlText.isPostParseRequired()) {
                    out.print(sqlStatement);
                    ParameterMapping[] mappings = sqlText.getParameterMappings();
                    if (mappings == null) continue;
                    int n = mappings.length;
                    for (int i = 0; i < n; ++i) {
                        ctx.addParameterMapping(mappings[i]);
                    }
                    continue;
                }
                IterateContext itCtx = ctx.peekIterateContext();
                if (null != itCtx && itCtx.isAllowNext()) {
                    itCtx.next();
                    itCtx.setAllowNext(false);
                    if (!itCtx.hasNext()) {
                        itCtx.setFinal(true);
                    }
                }
                if (itCtx != null) {
                    StringBuilder sqlStatementBuffer = new StringBuilder(sqlStatement);
                    this.iteratePropertyReplace(sqlStatementBuffer, itCtx);
                    sqlStatement = sqlStatementBuffer.toString();
                }
                sqlText = PARAM_PARSER.parseInlineParameterMap(this.delegate.getTypeHandlerFactory(), sqlStatement);
                ParameterMapping[] mappings = sqlText.getParameterMappings();
                out.print(sqlText.getText());
                if (mappings == null) continue;
                int n = mappings.length;
                for (int i = 0; i < n; ++i) {
                    ctx.addParameterMapping(mappings[i]);
                }
                continue;
            }
            if (!(child instanceof SqlTag)) continue;
            SqlTag tag = (SqlTag)child;
            SqlTagHandler handler = tag.getHandler();
            int response = 1;
            do {
                StringWriter sw = new StringWriter();
                PrintWriter pw = new PrintWriter(sw);
                response = handler.doStartFragment(ctx, tag, parameterObject);
                if (response == 0) continue;
                this.processBodyChildren(statementScope, ctx, parameterObject, tag.getChildren(), pw);
                pw.flush();
                pw.close();
                StringBuilder body = new StringBuilder(sw.getBuffer());
                response = handler.doEndFragment(ctx, tag, parameterObject, body);
                handler.doPrepend(ctx, tag, parameterObject, body);
                if (response == 0 || body.length() <= 0) continue;
                out.print(body.toString());
            } while (response == 2);
            ctx.popRemoveFirstPrependMarker(tag);
            if (ctx.peekIterateContext() == null || ctx.peekIterateContext().getTag() != tag) continue;
            ctx.setAttribute(ctx.peekIterateContext().getTag(), null);
            ctx.popIterateContext();
        }
    }

    protected void iteratePropertyReplace(StringBuilder bodyContent, IterateContext iterate) {
        if (iterate != null) {
            String[] mappings = new String[]{"#", "$"};
            for (int i = 0; i < mappings.length; ++i) {
                int startIndex = 0;
                int endIndex = -1;
                while (startIndex > -1 && startIndex < bodyContent.length()) {
                    startIndex = bodyContent.indexOf(mappings[i], endIndex + 1);
                    endIndex = bodyContent.indexOf(mappings[i], startIndex + 1);
                    if (startIndex <= -1 || endIndex <= -1) continue;
                    bodyContent.replace(startIndex + 1, endIndex, iterate.addIndexToTagProperty(bodyContent.substring(startIndex + 1, endIndex)));
                }
            }
        }
    }

    protected static void replace(StringBuilder builder, String find, String replace) {
        int pos = builder.toString().indexOf(find);
        int len = find.length();
        while (pos > -1) {
            builder.replace(pos, pos + len, replace);
            pos = builder.toString().indexOf(find);
        }
    }

    @Override
    public void addChild(SqlChild child) {
        this.children.add(child);
    }
}

