/*
 * Decompiled with CFR 0.152.
 */
package com.ibatis.sqlmap.engine.cache.fifo;

import com.ibatis.sqlmap.engine.cache.CacheController;
import com.ibatis.sqlmap.engine.cache.CacheModel;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;

public class FifoCacheController
implements CacheController {
    private int cacheSize = 100;
    private Map cache = Collections.synchronizedMap(new HashMap());
    private List keyList = Collections.synchronizedList(new LinkedList());

    public int getCacheSize() {
        return this.cacheSize;
    }

    public void setCacheSize(int cacheSize) {
        this.cacheSize = cacheSize;
    }

    public void setProperties(Properties props) {
        String size = props.getProperty("cache-size");
        if (size == null) {
            size = props.getProperty("size");
        }
        if (size != null) {
            this.cacheSize = Integer.parseInt(size);
        }
    }

    public void putObject(CacheModel cacheModel, Object key, Object value) {
        this.cache.put(key, value);
        this.keyList.add(key);
        if (this.keyList.size() > this.cacheSize) {
            try {
                Object oldestKey = this.keyList.remove(0);
                this.cache.remove(oldestKey);
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                // empty catch block
            }
        }
    }

    public Object getObject(CacheModel cacheModel, Object key) {
        return this.cache.get(key);
    }

    public Object removeObject(CacheModel cacheModel, Object key) {
        this.keyList.remove(key);
        return this.cache.remove(key);
    }

    public void flush(CacheModel cacheModel) {
        this.cache.clear();
        this.keyList.clear();
    }
}

