/*
 * Decompiled with CFR 0.152.
 */
package org.mybatis.spring.annotation;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.mybatis.spring.annotation.MapperScan;
import org.mybatis.spring.annotation.MapperScans;
import org.mybatis.spring.mapper.MapperFactoryBean;
import org.mybatis.spring.mapper.MapperScannerConfigurer;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.BeanNameGenerator;
import org.springframework.context.ResourceLoaderAware;
import org.springframework.context.annotation.FilterType;
import org.springframework.context.annotation.ImportBeanDefinitionRegistrar;
import org.springframework.core.annotation.AnnotationAttributes;
import org.springframework.core.io.ResourceLoader;
import org.springframework.core.type.AnnotationMetadata;
import org.springframework.core.type.filter.AnnotationTypeFilter;
import org.springframework.core.type.filter.AssignableTypeFilter;
import org.springframework.core.type.filter.TypeFilter;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.StringUtils;

public class MapperScannerRegistrar
implements ImportBeanDefinitionRegistrar,
ResourceLoaderAware {
    private ResourceLoader resourceLoader;

    public void setResourceLoader(ResourceLoader resourceLoader) {
        this.resourceLoader = resourceLoader;
    }

    public void registerBeanDefinitions(AnnotationMetadata importingClassMetadata, BeanDefinitionRegistry registry) {
        AnnotationAttributes mapperScanAttrs = AnnotationAttributes.fromMap((Map)importingClassMetadata.getAnnotationAttributes(MapperScan.class.getName()));
        if (mapperScanAttrs != null) {
            this.registerBeanDefinitions(importingClassMetadata, mapperScanAttrs, registry, MapperScannerRegistrar.generateBaseBeanName(importingClassMetadata, 0));
        }
    }

    void registerBeanDefinitions(AnnotationMetadata annoMeta, AnnotationAttributes annoAttrs, BeanDefinitionRegistry registry, String beanName) {
        String defaultScope;
        String lazyInitialization;
        AnnotationAttributes[] excludeFilterArray;
        String sqlSessionFactoryRef;
        String sqlSessionTemplateRef;
        Class mapperFactoryBeanClass;
        Class generatorClass;
        Class markerInterface;
        BeanDefinitionBuilder builder = BeanDefinitionBuilder.genericBeanDefinition(MapperScannerConfigurer.class);
        builder.addPropertyValue("processPropertyPlaceHolders", (Object)annoAttrs.getBoolean("processPropertyPlaceHolders"));
        Class annotationClass = annoAttrs.getClass("annotationClass");
        if (!Annotation.class.equals((Object)annotationClass)) {
            builder.addPropertyValue("annotationClass", (Object)annotationClass);
        }
        if (!Class.class.equals((Object)(markerInterface = annoAttrs.getClass("markerInterface")))) {
            builder.addPropertyValue("markerInterface", (Object)markerInterface);
        }
        if (!BeanNameGenerator.class.equals((Object)(generatorClass = annoAttrs.getClass("nameGenerator")))) {
            builder.addPropertyValue("nameGenerator", BeanUtils.instantiateClass((Class)generatorClass));
        }
        if (!MapperFactoryBean.class.equals((Object)(mapperFactoryBeanClass = annoAttrs.getClass("factoryBean")))) {
            builder.addPropertyValue("mapperFactoryBeanClass", (Object)mapperFactoryBeanClass);
        }
        if (StringUtils.hasText((String)(sqlSessionTemplateRef = annoAttrs.getString("sqlSessionTemplateRef")))) {
            builder.addPropertyValue("sqlSessionTemplateBeanName", (Object)annoAttrs.getString("sqlSessionTemplateRef"));
        }
        if (StringUtils.hasText((String)(sqlSessionFactoryRef = annoAttrs.getString("sqlSessionFactoryRef")))) {
            builder.addPropertyValue("sqlSessionFactoryBeanName", (Object)annoAttrs.getString("sqlSessionFactoryRef"));
        }
        ArrayList<String> basePackages = new ArrayList<String>(Arrays.stream(annoAttrs.getStringArray("basePackages")).filter(StringUtils::hasText).collect(Collectors.toList()));
        basePackages.addAll(Arrays.stream(annoAttrs.getClassArray("basePackageClasses")).map(ClassUtils::getPackageName).collect(Collectors.toList()));
        if (basePackages.isEmpty()) {
            basePackages.add(MapperScannerRegistrar.getDefaultBasePackage(annoMeta));
        }
        if ((excludeFilterArray = annoAttrs.getAnnotationArray("excludeFilters")).length > 0) {
            ArrayList<TypeFilter> typeFilters = new ArrayList<TypeFilter>();
            ArrayList<Map<String, String>> rawTypeFilters = new ArrayList<Map<String, String>>();
            for (AnnotationAttributes excludeFilters : excludeFilterArray) {
                if (excludeFilters.getStringArray("pattern").length > 0) {
                    rawTypeFilters.addAll(this.parseFiltersHasPatterns(excludeFilters));
                    continue;
                }
                typeFilters.addAll(this.typeFiltersFor(excludeFilters));
            }
            builder.addPropertyValue("excludeFilters", typeFilters);
            builder.addPropertyValue("rawExcludeFilters", rawTypeFilters);
        }
        if (StringUtils.hasText((String)(lazyInitialization = annoAttrs.getString("lazyInitialization")))) {
            builder.addPropertyValue("lazyInitialization", (Object)lazyInitialization);
        }
        if (!"".equals(defaultScope = annoAttrs.getString("defaultScope"))) {
            builder.addPropertyValue("defaultScope", (Object)defaultScope);
        }
        builder.addPropertyValue("basePackage", (Object)StringUtils.collectionToCommaDelimitedString(basePackages));
        builder.setRole(2);
        registry.registerBeanDefinition(beanName, (BeanDefinition)builder.getBeanDefinition());
    }

    private List<Map<String, String>> parseFiltersHasPatterns(AnnotationAttributes filterAttributes) {
        String[] expressionArray;
        ArrayList<Map<String, String>> rawTypeFilters = new ArrayList<Map<String, String>>();
        FilterType filterType = (FilterType)filterAttributes.getEnum("type");
        block3: for (String expression : expressionArray = filterAttributes.getStringArray("pattern")) {
            switch (filterType) {
                case REGEX: 
                case ASPECTJ: {
                    HashMap<String, String> typeFilter = new HashMap<String, String>(16);
                    typeFilter.put("type", filterType.name().toLowerCase());
                    typeFilter.put("expression", expression);
                    rawTypeFilters.add(typeFilter);
                    continue block3;
                }
                default: {
                    throw new IllegalArgumentException("Cannot specify the 'pattern' attribute if use the " + String.valueOf(filterType) + " FilterType in exclude filter of @MapperScan");
                }
            }
        }
        return rawTypeFilters;
    }

    private List<TypeFilter> typeFiltersFor(AnnotationAttributes filterAttributes) {
        ArrayList<TypeFilter> typeFilters = new ArrayList<TypeFilter>();
        FilterType filterType = (FilterType)filterAttributes.getEnum("type");
        block5: for (Class filterClass : filterAttributes.getClassArray("value")) {
            switch (filterType) {
                case ANNOTATION: {
                    Assert.isAssignable(Annotation.class, (Class)filterClass, (String)"Specified an unsupported type in 'ANNOTATION' exclude filter of @MapperScan");
                    Class annoClass = filterClass;
                    typeFilters.add((TypeFilter)new AnnotationTypeFilter(annoClass));
                    continue block5;
                }
                case ASSIGNABLE_TYPE: {
                    typeFilters.add((TypeFilter)new AssignableTypeFilter(filterClass));
                    continue block5;
                }
                case CUSTOM: {
                    Assert.isAssignable(TypeFilter.class, (Class)filterClass, (String)"An error occured when processing a @ComponentScan CUSTOM type filter: ");
                    typeFilters.add((TypeFilter)BeanUtils.instantiateClass((Class)filterClass, TypeFilter.class));
                    continue block5;
                }
                default: {
                    throw new IllegalArgumentException("Cannot specify the 'value' or 'classes' attribute if use the " + String.valueOf(filterType) + " FilterType in exclude filter of @MapperScan");
                }
            }
        }
        return typeFilters;
    }

    private static String generateBaseBeanName(AnnotationMetadata importingClassMetadata, int index) {
        return importingClassMetadata.getClassName() + "#" + MapperScannerRegistrar.class.getSimpleName() + "#" + index;
    }

    private static String getDefaultBasePackage(AnnotationMetadata importingClassMetadata) {
        return ClassUtils.getPackageName((String)importingClassMetadata.getClassName());
    }

    static class RepeatingRegistrar
    extends MapperScannerRegistrar {
        RepeatingRegistrar() {
        }

        @Override
        public void registerBeanDefinitions(AnnotationMetadata importingClassMetadata, BeanDefinitionRegistry registry) {
            AnnotationAttributes mapperScansAttrs = AnnotationAttributes.fromMap((Map)importingClassMetadata.getAnnotationAttributes(MapperScans.class.getName()));
            if (mapperScansAttrs != null) {
                AnnotationAttributes[] annotations = mapperScansAttrs.getAnnotationArray("value");
                for (int i = 0; i < annotations.length; ++i) {
                    this.registerBeanDefinitions(importingClassMetadata, annotations[i], registry, MapperScannerRegistrar.generateBaseBeanName(importingClassMetadata, i));
                }
            }
        }
    }
}

