/*
 * Decompiled with CFR 0.152.
 */
package org.mybatis.dynamic.sql.select.render;

import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import org.mybatis.dynamic.sql.BasicColumn;
import org.mybatis.dynamic.sql.TableExpression;
import org.mybatis.dynamic.sql.render.ExplicitTableAliasCalculator;
import org.mybatis.dynamic.sql.render.GuaranteedTableAliasCalculator;
import org.mybatis.dynamic.sql.render.RenderingStrategy;
import org.mybatis.dynamic.sql.render.TableAliasCalculator;
import org.mybatis.dynamic.sql.render.TableAliasCalculatorWithParent;
import org.mybatis.dynamic.sql.select.GroupByModel;
import org.mybatis.dynamic.sql.select.HavingModel;
import org.mybatis.dynamic.sql.select.QueryExpressionModel;
import org.mybatis.dynamic.sql.select.join.JoinModel;
import org.mybatis.dynamic.sql.select.render.AbstractQueryRendererBuilder;
import org.mybatis.dynamic.sql.select.render.HavingRenderer;
import org.mybatis.dynamic.sql.select.render.JoinRenderer;
import org.mybatis.dynamic.sql.select.render.TableExpressionRenderer;
import org.mybatis.dynamic.sql.util.FragmentAndParameters;
import org.mybatis.dynamic.sql.util.FragmentCollector;
import org.mybatis.dynamic.sql.util.StringUtilities;
import org.mybatis.dynamic.sql.where.WhereModel;
import org.mybatis.dynamic.sql.where.render.WhereRenderer;

public class QueryExpressionRenderer {
    private final QueryExpressionModel queryExpression;
    private final RenderingStrategy renderingStrategy;
    private final AtomicInteger sequence;
    private final TableExpressionRenderer tableExpressionRenderer;
    private final TableAliasCalculator tableAliasCalculator;

    private QueryExpressionRenderer(Builder builder) {
        this.queryExpression = Objects.requireNonNull(builder.queryExpression);
        this.renderingStrategy = Objects.requireNonNull(builder.renderingStrategy);
        this.sequence = Objects.requireNonNull(builder.sequence);
        this.tableAliasCalculator = this.calculateTableAliasCalculator(this.queryExpression, builder.parentTableAliasCalculator);
        this.tableExpressionRenderer = new TableExpressionRenderer.Builder().withTableAliasCalculator(this.tableAliasCalculator).withRenderingStrategy(this.renderingStrategy).withSequence(this.sequence).build();
    }

    private TableAliasCalculator calculateTableAliasCalculator(QueryExpressionModel queryExpression, TableAliasCalculator parentTableAliasCalculator) {
        TableAliasCalculator baseTableAliasCalculator = queryExpression.joinModel().map(JoinModel::containsSubQueries).map(this::calculateTableAliasCalculatorWithJoins).orElseGet(this::explicitTableAliasCalculator);
        if (parentTableAliasCalculator == null) {
            return baseTableAliasCalculator;
        }
        return new TableAliasCalculatorWithParent.Builder().withParent(parentTableAliasCalculator).withChild(baseTableAliasCalculator).build();
    }

    private TableAliasCalculator calculateTableAliasCalculatorWithJoins(boolean hasSubQueries) {
        if (hasSubQueries) {
            return this.explicitTableAliasCalculator();
        }
        return this.guaranteedTableAliasCalculator();
    }

    private TableAliasCalculator explicitTableAliasCalculator() {
        return ExplicitTableAliasCalculator.of(this.queryExpression.tableAliases());
    }

    private TableAliasCalculator guaranteedTableAliasCalculator() {
        return GuaranteedTableAliasCalculator.of(this.queryExpression.tableAliases());
    }

    public FragmentAndParameters render() {
        FragmentCollector fragmentCollector = new FragmentCollector();
        fragmentCollector.add(this.calculateQueryExpressionStart());
        this.calculateJoinClause().ifPresent(fragmentCollector::add);
        this.calculateWhereClause().ifPresent(fragmentCollector::add);
        this.calculateGroupByClause().ifPresent(fragmentCollector::add);
        this.calculateHavingClause().ifPresent(fragmentCollector::add);
        return this.toFragmentAndParameters(fragmentCollector);
    }

    private FragmentAndParameters toFragmentAndParameters(FragmentCollector fragmentCollector) {
        return FragmentAndParameters.withFragment(fragmentCollector.fragments().collect(Collectors.joining(" "))).withParameters(fragmentCollector.parameters()).build();
    }

    private FragmentAndParameters calculateQueryExpressionStart() {
        String start = this.queryExpression.connector().map(StringUtilities::spaceAfter).orElse("") + "select " + (this.queryExpression.isDistinct() ? "distinct " : "") + this.calculateColumnList() + " from ";
        FragmentAndParameters renderedTable = this.renderTableExpression(this.queryExpression.table());
        start = start + renderedTable.fragment();
        return FragmentAndParameters.withFragment(start).withParameters(renderedTable.parameters()).build();
    }

    private String calculateColumnList() {
        return this.queryExpression.mapColumns(this::applyTableAndColumnAlias).collect(Collectors.joining(", "));
    }

    private String applyTableAndColumnAlias(BasicColumn selectListItem) {
        return selectListItem.renderWithTableAndColumnAlias(this.tableAliasCalculator);
    }

    private FragmentAndParameters renderTableExpression(TableExpression table) {
        return table.accept(this.tableExpressionRenderer);
    }

    private Optional<FragmentAndParameters> calculateJoinClause() {
        return this.queryExpression.joinModel().map(this::renderJoin);
    }

    private FragmentAndParameters renderJoin(JoinModel joinModel) {
        return JoinRenderer.withJoinModel(joinModel).withTableExpressionRenderer(this.tableExpressionRenderer).withTableAliasCalculator(this.tableAliasCalculator).build().render();
    }

    private Optional<FragmentAndParameters> calculateWhereClause() {
        return this.queryExpression.whereModel().flatMap(this::renderWhereClause);
    }

    private Optional<FragmentAndParameters> renderWhereClause(WhereModel whereModel) {
        return ((WhereRenderer.Builder)((WhereRenderer.Builder)((WhereRenderer.Builder)WhereRenderer.withWhereModel(whereModel).withRenderingStrategy(this.renderingStrategy)).withTableAliasCalculator(this.tableAliasCalculator)).withSequence(this.sequence)).build().render();
    }

    private Optional<FragmentAndParameters> calculateGroupByClause() {
        return this.queryExpression.groupByModel().map(this::renderGroupBy);
    }

    private FragmentAndParameters renderGroupBy(GroupByModel groupByModel) {
        String groupBy = groupByModel.mapColumns(this::applyTableAlias).collect(Collectors.joining(", ", "group by ", ""));
        return FragmentAndParameters.withFragment(groupBy).build();
    }

    private Optional<FragmentAndParameters> calculateHavingClause() {
        return this.queryExpression.havingModel().flatMap(this::renderHavingClause);
    }

    private Optional<FragmentAndParameters> renderHavingClause(HavingModel havingModel) {
        return ((HavingRenderer.Builder)((HavingRenderer.Builder)((HavingRenderer.Builder)HavingRenderer.withHavingModel(havingModel).withRenderingStrategy(this.renderingStrategy)).withTableAliasCalculator(this.tableAliasCalculator)).withSequence(this.sequence)).build().render();
    }

    private String applyTableAlias(BasicColumn column) {
        return column.renderWithTableAlias(this.tableAliasCalculator);
    }

    public static Builder withQueryExpression(QueryExpressionModel model) {
        return new Builder().withQueryExpression(model);
    }

    public static class Builder
    extends AbstractQueryRendererBuilder<Builder> {
        private QueryExpressionModel queryExpression;

        public Builder withQueryExpression(QueryExpressionModel queryExpression) {
            this.queryExpression = queryExpression;
            return this;
        }

        @Override
        Builder getThis() {
            return this;
        }

        public QueryExpressionRenderer build() {
            return new QueryExpressionRenderer(this);
        }
    }
}

