/*
 * Decompiled with CFR 0.152.
 */
package org.mybatis.dynamic.sql.select;

import java.util.Objects;
import org.mybatis.dynamic.sql.SortSpecification;
import org.mybatis.dynamic.sql.SqlColumn;

public class ColumnSortSpecification
implements SortSpecification {
    private final String tableAlias;
    private final SqlColumn<?> column;
    private final boolean isDescending;

    public ColumnSortSpecification(String tableAlias, SqlColumn<?> column) {
        this(tableAlias, column, false);
    }

    private ColumnSortSpecification(String tableAlias, SqlColumn<?> column, boolean isDescending) {
        this.tableAlias = Objects.requireNonNull(tableAlias);
        this.column = Objects.requireNonNull(column);
        this.isDescending = isDescending;
    }

    @Override
    public SortSpecification descending() {
        return new ColumnSortSpecification(this.tableAlias, this.column, true);
    }

    @Override
    public String orderByName() {
        return this.tableAlias + "." + this.column.name();
    }

    @Override
    public boolean isDescending() {
        return this.isDescending;
    }
}

