/*
 * Decompiled with CFR 0.152.
 */
package org.mybatis.dynamic.sql.delete.render;

import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import org.mybatis.dynamic.sql.SqlTable;
import org.mybatis.dynamic.sql.common.OrderByModel;
import org.mybatis.dynamic.sql.common.OrderByRenderer;
import org.mybatis.dynamic.sql.delete.DeleteModel;
import org.mybatis.dynamic.sql.delete.render.DefaultDeleteStatementProvider;
import org.mybatis.dynamic.sql.delete.render.DeleteStatementProvider;
import org.mybatis.dynamic.sql.render.ExplicitTableAliasCalculator;
import org.mybatis.dynamic.sql.render.RenderingStrategy;
import org.mybatis.dynamic.sql.render.TableAliasCalculator;
import org.mybatis.dynamic.sql.util.FragmentAndParameters;
import org.mybatis.dynamic.sql.util.FragmentCollector;
import org.mybatis.dynamic.sql.where.WhereModel;
import org.mybatis.dynamic.sql.where.render.WhereRenderer;

public class DeleteRenderer {
    private final DeleteModel deleteModel;
    private final RenderingStrategy renderingStrategy;
    private final TableAliasCalculator tableAliasCalculator;
    private final AtomicInteger sequence = new AtomicInteger(1);

    private DeleteRenderer(Builder builder) {
        this.deleteModel = Objects.requireNonNull(builder.deleteModel);
        this.renderingStrategy = Objects.requireNonNull(builder.renderingStrategy);
        this.tableAliasCalculator = builder.deleteModel.tableAlias().map(a -> ExplicitTableAliasCalculator.of(this.deleteModel.table(), a)).orElseGet(TableAliasCalculator::empty);
    }

    public DeleteStatementProvider render() {
        FragmentCollector fragmentCollector = new FragmentCollector();
        fragmentCollector.add(this.calculateDeleteStatementStart());
        this.calculateWhereClause().ifPresent(fragmentCollector::add);
        this.calculateOrderByClause().ifPresent(fragmentCollector::add);
        this.calculateLimitClause().ifPresent(fragmentCollector::add);
        return this.toDeleteStatementProvider(fragmentCollector);
    }

    private DeleteStatementProvider toDeleteStatementProvider(FragmentCollector fragmentCollector) {
        return DefaultDeleteStatementProvider.withDeleteStatement(fragmentCollector.fragments().collect(Collectors.joining(" "))).withParameters(fragmentCollector.parameters()).build();
    }

    private FragmentAndParameters calculateDeleteStatementStart() {
        SqlTable table = this.deleteModel.table();
        String tableName = table.tableNameAtRuntime();
        String aliasedTableName = this.tableAliasCalculator.aliasForTable(table).map(a -> tableName + " " + a).orElse(tableName);
        return FragmentAndParameters.withFragment("delete from " + aliasedTableName).build();
    }

    private Optional<FragmentAndParameters> calculateWhereClause() {
        return this.deleteModel.whereModel().flatMap(this::renderWhereClause);
    }

    private Optional<FragmentAndParameters> renderWhereClause(WhereModel whereModel) {
        return ((WhereRenderer.Builder)((WhereRenderer.Builder)((WhereRenderer.Builder)WhereRenderer.withWhereModel(whereModel).withRenderingStrategy(this.renderingStrategy)).withSequence(this.sequence)).withTableAliasCalculator(this.tableAliasCalculator)).build().render();
    }

    private Optional<FragmentAndParameters> calculateLimitClause() {
        return this.deleteModel.limit().map(this::renderLimitClause);
    }

    private FragmentAndParameters renderLimitClause(Long limit) {
        String mapKey = this.renderingStrategy.formatParameterMapKey(this.sequence);
        String jdbcPlaceholder = this.renderingStrategy.getFormattedJdbcPlaceholder("parameters", mapKey);
        return FragmentAndParameters.withFragment("limit " + jdbcPlaceholder).withParameter(mapKey, limit).build();
    }

    private Optional<FragmentAndParameters> calculateOrderByClause() {
        return this.deleteModel.orderByModel().map(this::renderOrderByClause);
    }

    private FragmentAndParameters renderOrderByClause(OrderByModel orderByModel) {
        return new OrderByRenderer().render(orderByModel);
    }

    public static Builder withDeleteModel(DeleteModel deleteModel) {
        return new Builder().withDeleteModel(deleteModel);
    }

    public static class Builder {
        private DeleteModel deleteModel;
        private RenderingStrategy renderingStrategy;

        public Builder withDeleteModel(DeleteModel deleteModel) {
            this.deleteModel = deleteModel;
            return this;
        }

        public Builder withRenderingStrategy(RenderingStrategy renderingStrategy) {
            this.renderingStrategy = renderingStrategy;
            return this;
        }

        public DeleteRenderer build() {
            return new DeleteRenderer(this);
        }
    }
}

