/*
 * Decompiled with CFR 0.152.
 */
package org.mybatis.dynamic.sql.where;

import java.util.Arrays;
import java.util.List;
import java.util.function.Consumer;
import org.mybatis.dynamic.sql.AndOrCriteriaGroup;
import org.mybatis.dynamic.sql.BindableColumn;
import org.mybatis.dynamic.sql.ExistsPredicate;
import org.mybatis.dynamic.sql.SqlCriterion;
import org.mybatis.dynamic.sql.VisitableCondition;
import org.mybatis.dynamic.sql.util.ConfigurableStatement;
import org.mybatis.dynamic.sql.where.AbstractWhereDSL;
import org.mybatis.dynamic.sql.where.WhereApplier;

public abstract class AbstractWhereSupport<W extends AbstractWhereDSL<?>, D extends AbstractWhereSupport<W, D>>
implements ConfigurableStatement<D> {
    public abstract W where();

    public <T> W where(BindableColumn<T> column, VisitableCondition<T> condition, AndOrCriteriaGroup ... subCriteria) {
        return this.where(column, condition, Arrays.asList(subCriteria));
    }

    public <T> W where(BindableColumn<T> column, VisitableCondition<T> condition, List<AndOrCriteriaGroup> subCriteria) {
        return (W)this.apply(w -> w.where(column, condition, subCriteria));
    }

    public W where(ExistsPredicate existsPredicate, AndOrCriteriaGroup ... subCriteria) {
        return this.where(existsPredicate, Arrays.asList(subCriteria));
    }

    public W where(ExistsPredicate existsPredicate, List<AndOrCriteriaGroup> subCriteria) {
        return (W)this.apply(w -> w.where(existsPredicate, subCriteria));
    }

    public W where(SqlCriterion initialCriterion, AndOrCriteriaGroup ... subCriteria) {
        return this.where(initialCriterion, Arrays.asList(subCriteria));
    }

    public W where(SqlCriterion initialCriterion, List<AndOrCriteriaGroup> subCriteria) {
        return (W)this.apply(w -> w.where(initialCriterion, subCriteria));
    }

    public W where(List<AndOrCriteriaGroup> subCriteria) {
        return (W)this.apply(w -> w.where(subCriteria));
    }

    public W applyWhere(WhereApplier whereApplier) {
        return (W)this.apply(w -> w.applyWhere(whereApplier));
    }

    private W apply(Consumer<W> block) {
        W dsl = this.where();
        block.accept(dsl);
        return dsl;
    }
}

