/*
 * Decompiled with CFR 0.152.
 */
package org.mybatis.dynamic.sql.where;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import org.jetbrains.annotations.NotNull;
import org.mybatis.dynamic.sql.AndOrCriteriaGroup;
import org.mybatis.dynamic.sql.BindableColumn;
import org.mybatis.dynamic.sql.ColumnAndConditionCriterion;
import org.mybatis.dynamic.sql.CriteriaGroup;
import org.mybatis.dynamic.sql.ExistsCriterion;
import org.mybatis.dynamic.sql.ExistsPredicate;
import org.mybatis.dynamic.sql.SqlCriterion;
import org.mybatis.dynamic.sql.VisitableCondition;
import org.mybatis.dynamic.sql.configuration.StatementConfiguration;
import org.mybatis.dynamic.sql.util.ConfigurableStatement;
import org.mybatis.dynamic.sql.where.WhereApplier;
import org.mybatis.dynamic.sql.where.WhereModel;

public abstract class AbstractWhereDSL<T extends AbstractWhereDSL<T>>
implements ConfigurableStatement<T> {
    private SqlCriterion initialCriterion;
    private final List<AndOrCriteriaGroup> subCriteria = new ArrayList<AndOrCriteriaGroup>();
    private final StatementConfiguration statementConfiguration;

    protected AbstractWhereDSL(StatementConfiguration statementConfiguration) {
        this.statementConfiguration = Objects.requireNonNull(statementConfiguration);
    }

    @Override
    public T configureStatement(Consumer<StatementConfiguration> consumer) {
        consumer.accept(this.statementConfiguration);
        return this.getThis();
    }

    @NotNull
    public <S> T where(BindableColumn<S> column, VisitableCondition<S> condition, AndOrCriteriaGroup ... subCriteria) {
        return this.where(column, condition, Arrays.asList(subCriteria));
    }

    @NotNull
    public <S> T where(BindableColumn<S> column, VisitableCondition<S> condition, List<AndOrCriteriaGroup> subCriteria) {
        this.initialCriterion = ((ColumnAndConditionCriterion.Builder)ColumnAndConditionCriterion.withColumn(column).withCondition(condition).withSubCriteria((List)subCriteria)).build();
        return this.getThis();
    }

    @NotNull
    public T where(ExistsPredicate existsPredicate, AndOrCriteriaGroup ... subCriteria) {
        return this.where(existsPredicate, Arrays.asList(subCriteria));
    }

    @NotNull
    public T where(ExistsPredicate existsPredicate, List<AndOrCriteriaGroup> subCriteria) {
        this.initialCriterion = ((ExistsCriterion.Builder)new ExistsCriterion.Builder().withExistsPredicate(existsPredicate).withSubCriteria((List)subCriteria)).build();
        return this.getThis();
    }

    @NotNull
    public T where(SqlCriterion initialCriterion, AndOrCriteriaGroup ... subCriteria) {
        return this.where(initialCriterion, Arrays.asList(subCriteria));
    }

    @NotNull
    public T where(SqlCriterion initialCriterion, List<AndOrCriteriaGroup> subCriteria) {
        this.initialCriterion = ((CriteriaGroup.Builder)((CriteriaGroup.Builder)new CriteriaGroup.Builder().withInitialCriterion(initialCriterion)).withSubCriteria((List)subCriteria)).build();
        return this.getThis();
    }

    @NotNull
    public T where(List<AndOrCriteriaGroup> criteria) {
        this.initialCriterion = ((CriteriaGroup.Builder)new CriteriaGroup.Builder().withSubCriteria((List)criteria)).build();
        return this.getThis();
    }

    @NotNull
    public T applyWhere(WhereApplier whereApplier) {
        whereApplier.accept(this);
        return this.getThis();
    }

    @NotNull
    public <S> T and(BindableColumn<S> column, VisitableCondition<S> condition, AndOrCriteriaGroup ... subCriteria) {
        return this.and(column, condition, Arrays.asList(subCriteria));
    }

    @NotNull
    public <S> T and(BindableColumn<S> column, VisitableCondition<S> condition, List<AndOrCriteriaGroup> subCriteria) {
        this.addSubCriteria("and", this.buildCriterion(column, condition), subCriteria);
        return this.getThis();
    }

    @NotNull
    public T and(ExistsPredicate existsPredicate, AndOrCriteriaGroup ... subCriteria) {
        return this.and(existsPredicate, Arrays.asList(subCriteria));
    }

    @NotNull
    public T and(ExistsPredicate existsPredicate, List<AndOrCriteriaGroup> subCriteria) {
        this.addSubCriteria("and", this.buildCriterion(existsPredicate), subCriteria);
        return this.getThis();
    }

    @NotNull
    public T and(SqlCriterion initialCriterion, AndOrCriteriaGroup ... subCriteria) {
        return this.and(initialCriterion, Arrays.asList(subCriteria));
    }

    @NotNull
    public T and(SqlCriterion initialCriterion, List<AndOrCriteriaGroup> subCriteria) {
        this.addSubCriteria("and", this.buildCriterion(initialCriterion), subCriteria);
        return this.getThis();
    }

    @NotNull
    public T and(List<AndOrCriteriaGroup> criteria) {
        this.addSubCriteria("and", criteria);
        return this.getThis();
    }

    @NotNull
    public <S> T or(BindableColumn<S> column, VisitableCondition<S> condition, AndOrCriteriaGroup ... subCriteria) {
        return this.or(column, condition, Arrays.asList(subCriteria));
    }

    @NotNull
    public <S> T or(BindableColumn<S> column, VisitableCondition<S> condition, List<AndOrCriteriaGroup> subCriteria) {
        this.addSubCriteria("or", this.buildCriterion(column, condition), subCriteria);
        return this.getThis();
    }

    @NotNull
    public T or(ExistsPredicate existsPredicate, AndOrCriteriaGroup ... subCriteria) {
        return this.or(existsPredicate, Arrays.asList(subCriteria));
    }

    @NotNull
    public T or(ExistsPredicate existsPredicate, List<AndOrCriteriaGroup> subCriteria) {
        this.addSubCriteria("or", this.buildCriterion(existsPredicate), subCriteria);
        return this.getThis();
    }

    @NotNull
    public T or(SqlCriterion initialCriterion, AndOrCriteriaGroup ... subCriteria) {
        return this.or(initialCriterion, Arrays.asList(subCriteria));
    }

    @NotNull
    public T or(SqlCriterion initialCriterion, List<AndOrCriteriaGroup> subCriteria) {
        this.addSubCriteria("or", this.buildCriterion(initialCriterion), subCriteria);
        return this.getThis();
    }

    @NotNull
    public T or(List<AndOrCriteriaGroup> criteria) {
        this.addSubCriteria("or", criteria);
        return this.getThis();
    }

    protected WhereModel internalBuild() {
        return new WhereModel(this.initialCriterion, this.subCriteria, this.statementConfiguration);
    }

    private <R> SqlCriterion buildCriterion(BindableColumn<R> column, VisitableCondition<R> condition) {
        return ColumnAndConditionCriterion.withColumn(column).withCondition(condition).build();
    }

    private SqlCriterion buildCriterion(ExistsPredicate existsPredicate) {
        return new ExistsCriterion.Builder().withExistsPredicate(existsPredicate).build();
    }

    private SqlCriterion buildCriterion(SqlCriterion initialCriterion) {
        return ((CriteriaGroup.Builder)new CriteriaGroup.Builder().withInitialCriterion(initialCriterion)).build();
    }

    private void addSubCriteria(String connector, SqlCriterion initialCriterion, List<AndOrCriteriaGroup> subCriteria) {
        this.subCriteria.add(new AndOrCriteriaGroup.Builder().withInitialCriterion(initialCriterion).withConnector(connector).withSubCriteria(subCriteria).build());
    }

    private void addSubCriteria(String connector, List<AndOrCriteriaGroup> criteria) {
        this.subCriteria.add(new AndOrCriteriaGroup.Builder().withConnector(connector).withSubCriteria(criteria).build());
    }

    protected abstract T getThis();
}

