/*
 * Decompiled with CFR 0.152.
 */
package org.mybatis.dynamic.sql.select;

import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;
import org.mybatis.dynamic.sql.BasicColumn;
import org.mybatis.dynamic.sql.SqlBuilder;
import org.mybatis.dynamic.sql.SqlTable;
import org.mybatis.dynamic.sql.configuration.StatementConfiguration;
import org.mybatis.dynamic.sql.select.AbstractQueryExpressionDSL;
import org.mybatis.dynamic.sql.select.QueryExpressionModel;
import org.mybatis.dynamic.sql.select.SelectModel;
import org.mybatis.dynamic.sql.util.Buildable;
import org.mybatis.dynamic.sql.where.AbstractWhereDSL;
import org.mybatis.dynamic.sql.where.WhereModel;

public class CountDSL<R>
extends AbstractQueryExpressionDSL<CountWhereBuilder, CountDSL<R>>
implements Buildable<R> {
    private final Function<SelectModel, R> adapterFunction;
    private CountWhereBuilder whereBuilder;
    private final BasicColumn countColumn;
    private final StatementConfiguration statementConfiguration = new StatementConfiguration();

    private CountDSL(BasicColumn countColumn, SqlTable table, Function<SelectModel, R> adapterFunction) {
        super(table);
        this.countColumn = Objects.requireNonNull(countColumn);
        this.adapterFunction = Objects.requireNonNull(adapterFunction);
    }

    @Override
    public CountWhereBuilder where() {
        if (this.whereBuilder == null) {
            this.whereBuilder = new CountWhereBuilder();
        }
        return this.whereBuilder;
    }

    @Override
    @NotNull
    public R build() {
        return this.adapterFunction.apply(this.buildModel());
    }

    @Override
    public CountDSL<R> configureStatement(Consumer<StatementConfiguration> consumer) {
        consumer.accept(this.statementConfiguration);
        return this;
    }

    private SelectModel buildModel() {
        QueryExpressionModel.Builder b = new QueryExpressionModel.Builder().withSelectColumn(this.countColumn).withTable(this.table()).withTableAliases(this.tableAliases());
        if (this.whereBuilder != null) {
            b.withWhereModel(this.whereBuilder.buildWhereModel());
        }
        this.buildJoinModel().ifPresent(b::withJoinModel);
        return new SelectModel.Builder().withQueryExpression(b.build()).build();
    }

    public static CountDSL<SelectModel> countFrom(SqlTable table) {
        return CountDSL.countFrom(Function.identity(), table);
    }

    public static <R> CountDSL<R> countFrom(Function<SelectModel, R> adapterFunction, SqlTable table) {
        return new CountDSL<R>(SqlBuilder.count(), table, adapterFunction);
    }

    public static FromGatherer<SelectModel> count(BasicColumn column) {
        return CountDSL.count(Function.identity(), column);
    }

    public static <R> FromGatherer<R> count(Function<SelectModel, R> adapterFunction, BasicColumn column) {
        return new FromGatherer<R>(adapterFunction, SqlBuilder.count(column));
    }

    public static FromGatherer<SelectModel> countDistinct(BasicColumn column) {
        return CountDSL.countDistinct(Function.identity(), column);
    }

    public static <R> FromGatherer<R> countDistinct(Function<SelectModel, R> adapterFunction, BasicColumn column) {
        return new FromGatherer<R>(adapterFunction, SqlBuilder.countDistinct(column));
    }

    @Override
    protected CountDSL<R> getThis() {
        return this;
    }

    public class CountWhereBuilder
    extends AbstractWhereDSL<CountWhereBuilder>
    implements Buildable<R> {
        private CountWhereBuilder() {
            super(CountDSL.this.statementConfiguration);
        }

        @Override
        @NotNull
        public R build() {
            return CountDSL.this.build();
        }

        @Override
        protected CountWhereBuilder getThis() {
            return this;
        }

        protected WhereModel buildWhereModel() {
            return this.internalBuild();
        }
    }

    public static class FromGatherer<R> {
        private final BasicColumn column;
        private final Function<SelectModel, R> adapterFunction;

        public FromGatherer(Function<SelectModel, R> adapterFunction, BasicColumn column) {
            this.adapterFunction = adapterFunction;
            this.column = column;
        }

        public CountDSL<R> from(SqlTable table) {
            return new CountDSL(this.column, table, this.adapterFunction);
        }
    }
}

