/*
 * Decompiled with CFR 0.152.
 */
package org.mybatis.dynamic.sql.insert.render;

import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.mybatis.dynamic.sql.insert.BatchInsertModel;
import org.mybatis.dynamic.sql.insert.render.BatchInsert;
import org.mybatis.dynamic.sql.insert.render.BatchValuePhraseVisitor;
import org.mybatis.dynamic.sql.insert.render.FieldAndValue;
import org.mybatis.dynamic.sql.render.RenderingStrategy;
import org.mybatis.dynamic.sql.util.StringUtilities;

public class BatchInsertRenderer<T> {
    private final BatchInsertModel<T> model;
    private final RenderingStrategy renderingStrategy;

    private BatchInsertRenderer(Builder<T> builder) {
        this.model = Objects.requireNonNull(((Builder)builder).model);
        this.renderingStrategy = Objects.requireNonNull(((Builder)builder).renderingStrategy);
    }

    public BatchInsert<T> render() {
        BatchValuePhraseVisitor visitor = new BatchValuePhraseVisitor(this.renderingStrategy, "row");
        List<FieldAndValue> fieldsAndValues = this.model.mapColumnMappings(m -> m.accept(visitor)).collect(Collectors.toList());
        return BatchInsert.withRecords(this.model.records()).withInsertStatement(this.calculateInsertStatement(fieldsAndValues)).build();
    }

    private String calculateInsertStatement(List<FieldAndValue> fieldsAndValues) {
        return "insert into" + StringUtilities.spaceBefore(this.model.table().tableNameAtRuntime()) + StringUtilities.spaceBefore(this.calculateColumnsPhrase(fieldsAndValues)) + StringUtilities.spaceBefore(this.calculateValuesPhrase(fieldsAndValues));
    }

    private String calculateColumnsPhrase(List<FieldAndValue> fieldsAndValues) {
        return fieldsAndValues.stream().map(FieldAndValue::fieldName).collect(Collectors.joining(", ", "(", ")"));
    }

    private String calculateValuesPhrase(List<FieldAndValue> fieldsAndValues) {
        return fieldsAndValues.stream().map(FieldAndValue::valuePhrase).collect(Collectors.joining(", ", "values (", ")"));
    }

    public static <T> Builder<T> withBatchInsertModel(BatchInsertModel<T> model) {
        return new Builder<T>().withBatchInsertModel(model);
    }

    public static class Builder<T> {
        private BatchInsertModel<T> model;
        private RenderingStrategy renderingStrategy;

        public Builder<T> withBatchInsertModel(BatchInsertModel<T> model) {
            this.model = model;
            return this;
        }

        public Builder<T> withRenderingStrategy(RenderingStrategy renderingStrategy) {
            this.renderingStrategy = renderingStrategy;
            return this;
        }

        public BatchInsertRenderer<T> build() {
            return new BatchInsertRenderer(this);
        }
    }
}

