/*
 * Decompiled with CFR 0.152.
 */
package org.mybatis.dynamic.sql.where.condition;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.function.Predicate;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.mybatis.dynamic.sql.AbstractListValueCondition;
import org.mybatis.dynamic.sql.Callback;
import org.mybatis.dynamic.sql.util.StringUtilities;

public class IsInCaseInsensitive
extends AbstractListValueCondition<String> {
    private static final IsInCaseInsensitive EMPTY = new IsInCaseInsensitive((Collection<String>)Collections.emptyList());

    public static IsInCaseInsensitive empty() {
        return EMPTY;
    }

    private IsInCaseInsensitive emptyWithCallback() {
        return new IsInCaseInsensitive((Collection<String>)Collections.emptyList(), this.emptyCallback);
    }

    protected IsInCaseInsensitive(Collection<String> values) {
        super(values);
    }

    protected IsInCaseInsensitive(Collection<String> values, Callback emptyCallback) {
        super(values, emptyCallback);
    }

    @Override
    public String renderCondition(String columnName, Stream<String> placeholders) {
        return "upper(" + columnName + ") " + placeholders.collect(Collectors.joining(",", "in (", ")"));
    }

    public IsInCaseInsensitive withListEmptyCallback(Callback callback) {
        return new IsInCaseInsensitive(this.values, callback);
    }

    public IsInCaseInsensitive filter(Predicate<? super String> predicate) {
        return this.filterSupport(predicate, IsInCaseInsensitive::new, this, this::emptyWithCallback);
    }

    public IsInCaseInsensitive map(UnaryOperator<String> mapper) {
        return this.mapSupport(mapper, IsInCaseInsensitive::new, this::emptyWithCallback);
    }

    public static IsInCaseInsensitive of(String ... values) {
        return IsInCaseInsensitive.of(Arrays.asList(values));
    }

    public static IsInCaseInsensitive of(Collection<String> values) {
        return new IsInCaseInsensitive(values).map(StringUtilities::safelyUpperCase);
    }
}

