/*
 * Decompiled with CFR 0.152.
 */
package org.mybatis.dynamic.sql.where;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.mybatis.dynamic.sql.BindableColumn;
import org.mybatis.dynamic.sql.ColumnAndConditionCriterion;
import org.mybatis.dynamic.sql.ExistsCriterion;
import org.mybatis.dynamic.sql.ExistsPredicate;
import org.mybatis.dynamic.sql.SqlCriterion;
import org.mybatis.dynamic.sql.VisitableCondition;
import org.mybatis.dynamic.sql.where.WhereApplier;
import org.mybatis.dynamic.sql.where.WhereModel;

public abstract class AbstractWhereDSL<T extends AbstractWhereDSL<T>> {
    private final List<SqlCriterion> criteria = new ArrayList<SqlCriterion>();

    @NotNull
    public <S> T where(BindableColumn<S> column, VisitableCondition<S> condition) {
        this.criteria.add(ColumnAndConditionCriterion.withColumn(column).withCondition(condition).build());
        return this.getThis();
    }

    @NotNull
    public <S> T where(BindableColumn<S> column, VisitableCondition<S> condition, SqlCriterion ... subCriteria) {
        return this.where(column, condition, Arrays.asList(subCriteria));
    }

    @NotNull
    public <S> T where(BindableColumn<S> column, VisitableCondition<S> condition, List<SqlCriterion> subCriteria) {
        this.criteria.add(((ColumnAndConditionCriterion.Builder)ColumnAndConditionCriterion.withColumn(column).withCondition(condition).withSubCriteria((List)subCriteria)).build());
        return this.getThis();
    }

    @NotNull
    public T where(ExistsPredicate existsPredicate) {
        this.criteria.add(new ExistsCriterion.Builder().withExistsPredicate(existsPredicate).build());
        return this.getThis();
    }

    @NotNull
    public T where(ExistsPredicate existsPredicate, SqlCriterion ... subCriteria) {
        return this.where(existsPredicate, Arrays.asList(subCriteria));
    }

    @NotNull
    public T where(ExistsPredicate existsPredicate, List<SqlCriterion> subCriteria) {
        this.criteria.add(((ExistsCriterion.Builder)new ExistsCriterion.Builder().withExistsPredicate(existsPredicate).withSubCriteria((List)subCriteria)).build());
        return this.getThis();
    }

    @NotNull
    public T applyWhere(WhereApplier whereApplier) {
        whereApplier.accept(this);
        return this.getThis();
    }

    @NotNull
    public <S> T and(BindableColumn<S> column, VisitableCondition<S> condition) {
        this.criteria.add(((ColumnAndConditionCriterion.Builder)ColumnAndConditionCriterion.withColumn(column).withConnector("and")).withCondition(condition).build());
        return this.getThis();
    }

    @NotNull
    public <S> T and(BindableColumn<S> column, VisitableCondition<S> condition, SqlCriterion ... subCriteria) {
        return this.and(column, condition, Arrays.asList(subCriteria));
    }

    @NotNull
    public <S> T and(BindableColumn<S> column, VisitableCondition<S> condition, List<SqlCriterion> subCriteria) {
        this.criteria.add(((ColumnAndConditionCriterion.Builder)((ColumnAndConditionCriterion.Builder)ColumnAndConditionCriterion.withColumn(column).withConnector("and")).withCondition(condition).withSubCriteria((List)subCriteria)).build());
        return this.getThis();
    }

    @NotNull
    public T and(ExistsPredicate existsPredicate) {
        this.criteria.add(((ExistsCriterion.Builder)new ExistsCriterion.Builder().withConnector("and")).withExistsPredicate(existsPredicate).build());
        return this.getThis();
    }

    @NotNull
    public T and(ExistsPredicate existsPredicate, SqlCriterion ... subCriteria) {
        return this.and(existsPredicate, Arrays.asList(subCriteria));
    }

    @NotNull
    public T and(ExistsPredicate existsPredicate, List<SqlCriterion> subCriteria) {
        this.criteria.add(((ExistsCriterion.Builder)((ExistsCriterion.Builder)new ExistsCriterion.Builder().withConnector("and")).withExistsPredicate(existsPredicate).withSubCriteria((List)subCriteria)).build());
        return this.getThis();
    }

    @NotNull
    public <S> T or(BindableColumn<S> column, VisitableCondition<S> condition) {
        this.criteria.add(((ColumnAndConditionCriterion.Builder)ColumnAndConditionCriterion.withColumn(column).withConnector("or")).withCondition(condition).build());
        return this.getThis();
    }

    @NotNull
    public <S> T or(BindableColumn<S> column, VisitableCondition<S> condition, SqlCriterion ... subCriteria) {
        return this.or(column, condition, Arrays.asList(subCriteria));
    }

    @NotNull
    public <S> T or(BindableColumn<S> column, VisitableCondition<S> condition, List<SqlCriterion> subCriteria) {
        this.criteria.add(((ColumnAndConditionCriterion.Builder)((ColumnAndConditionCriterion.Builder)ColumnAndConditionCriterion.withColumn(column).withConnector("or")).withCondition(condition).withSubCriteria((List)subCriteria)).build());
        return this.getThis();
    }

    @NotNull
    public T or(ExistsPredicate existsPredicate) {
        this.criteria.add(((ExistsCriterion.Builder)new ExistsCriterion.Builder().withConnector("or")).withExistsPredicate(existsPredicate).build());
        return this.getThis();
    }

    @NotNull
    public T or(ExistsPredicate existsPredicate, SqlCriterion ... subCriteria) {
        return this.or(existsPredicate, Arrays.asList(subCriteria));
    }

    @NotNull
    public T or(ExistsPredicate existsPredicate, List<SqlCriterion> subCriteria) {
        this.criteria.add(((ExistsCriterion.Builder)((ExistsCriterion.Builder)new ExistsCriterion.Builder().withConnector("or")).withExistsPredicate(existsPredicate).withSubCriteria((List)subCriteria)).build());
        return this.getThis();
    }

    protected WhereModel internalBuild() {
        return WhereModel.of(this.criteria);
    }

    protected abstract T getThis();
}

