/*
 * Decompiled with CFR 0.152.
 */
package org.mybatis.dynamic.sql.select;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Stream;
import org.mybatis.dynamic.sql.BasicColumn;
import org.mybatis.dynamic.sql.SqlTable;
import org.mybatis.dynamic.sql.TableExpression;
import org.mybatis.dynamic.sql.render.GuaranteedTableAliasCalculator;
import org.mybatis.dynamic.sql.render.TableAliasCalculator;
import org.mybatis.dynamic.sql.select.GroupByModel;
import org.mybatis.dynamic.sql.select.join.JoinModel;
import org.mybatis.dynamic.sql.where.WhereModel;

public class QueryExpressionModel {
    private final String connector;
    private final boolean isDistinct;
    private final List<BasicColumn> selectList;
    private final TableExpression table;
    private final JoinModel joinModel;
    private final TableAliasCalculator tableAliasCalculator;
    private final WhereModel whereModel;
    private final GroupByModel groupByModel;

    private QueryExpressionModel(Builder builder) {
        this.connector = builder.connector;
        this.isDistinct = builder.isDistinct;
        this.selectList = Objects.requireNonNull(builder.selectList);
        this.table = Objects.requireNonNull(builder.table);
        this.joinModel = builder.joinModel;
        this.tableAliasCalculator = this.joinModel().map(jm -> this.determineJoinTableAliasCalculator((JoinModel)jm, builder.tableAliases)).orElseGet(() -> TableAliasCalculator.of(builder.tableAliases));
        this.whereModel = builder.whereModel;
        this.groupByModel = builder.groupByModel;
    }

    private TableAliasCalculator determineJoinTableAliasCalculator(JoinModel joinModel, Map<SqlTable, String> tableAliases) {
        if (joinModel.containsSubQueries()) {
            return TableAliasCalculator.of(tableAliases);
        }
        return GuaranteedTableAliasCalculator.of(tableAliases);
    }

    public Optional<String> connector() {
        return Optional.ofNullable(this.connector);
    }

    public boolean isDistinct() {
        return this.isDistinct;
    }

    public <R> Stream<R> mapColumns(Function<BasicColumn, R> mapper) {
        return this.selectList.stream().map(mapper);
    }

    public TableExpression table() {
        return this.table;
    }

    public TableAliasCalculator tableAliasCalculator() {
        return this.tableAliasCalculator;
    }

    public Optional<WhereModel> whereModel() {
        return Optional.ofNullable(this.whereModel);
    }

    public Optional<JoinModel> joinModel() {
        return Optional.ofNullable(this.joinModel);
    }

    public Optional<GroupByModel> groupByModel() {
        return Optional.ofNullable(this.groupByModel);
    }

    public static Builder withSelectList(List<BasicColumn> columnList) {
        return new Builder().withSelectList(columnList);
    }

    public static class Builder {
        private String connector;
        private boolean isDistinct;
        private final List<BasicColumn> selectList = new ArrayList<BasicColumn>();
        private TableExpression table;
        private final Map<SqlTable, String> tableAliases = new HashMap<SqlTable, String>();
        private WhereModel whereModel;
        private JoinModel joinModel;
        private GroupByModel groupByModel;

        public Builder withConnector(String connector) {
            this.connector = connector;
            return this;
        }

        public Builder withTable(TableExpression table) {
            this.table = table;
            return this;
        }

        public Builder isDistinct(boolean isDistinct) {
            this.isDistinct = isDistinct;
            return this;
        }

        public Builder withSelectColumn(BasicColumn selectColumn) {
            this.selectList.add(selectColumn);
            return this;
        }

        public Builder withSelectList(List<BasicColumn> selectList2) {
            this.selectList.addAll(selectList2);
            return this;
        }

        public Builder withTableAliases(Map<SqlTable, String> tableAliases) {
            this.tableAliases.putAll(tableAliases);
            return this;
        }

        public Builder withWhereModel(WhereModel whereModel) {
            this.whereModel = whereModel;
            return this;
        }

        public Builder withJoinModel(JoinModel joinModel) {
            this.joinModel = joinModel;
            return this;
        }

        public Builder withGroupByModel(GroupByModel groupByModel) {
            this.groupByModel = groupByModel;
            return this;
        }

        public QueryExpressionModel build() {
            return new QueryExpressionModel(this);
        }
    }
}

