/*
 * Decompiled with CFR 0.152.
 */
package org.mybatis.dynamic.sql.insert;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.mybatis.dynamic.sql.SqlColumn;
import org.mybatis.dynamic.sql.SqlTable;
import org.mybatis.dynamic.sql.insert.BatchInsertModel;
import org.mybatis.dynamic.sql.util.AbstractColumnMapping;
import org.mybatis.dynamic.sql.util.Buildable;
import org.mybatis.dynamic.sql.util.ConstantMapping;
import org.mybatis.dynamic.sql.util.NullMapping;
import org.mybatis.dynamic.sql.util.PropertyMapping;
import org.mybatis.dynamic.sql.util.StringConstantMapping;

public class BatchInsertDSL<T>
implements Buildable<BatchInsertModel<T>> {
    private final Collection<T> records;
    private final SqlTable table;
    private final List<AbstractColumnMapping> columnMappings = new ArrayList<AbstractColumnMapping>();

    private BatchInsertDSL(Collection<T> records, SqlTable table) {
        this.records = records;
        this.table = table;
    }

    public <F> ColumnMappingFinisher<F> map(SqlColumn<F> column) {
        return new ColumnMappingFinisher<F>(column);
    }

    @Override
    @NotNull
    public BatchInsertModel<T> build() {
        return ((BatchInsertModel.Builder)((BatchInsertModel.Builder)BatchInsertModel.withRecords(this.records).withTable(this.table)).withColumnMappings(this.columnMappings)).build();
    }

    @SafeVarargs
    public static <T> IntoGatherer<T> insert(T ... records) {
        return BatchInsertDSL.insert(Arrays.asList(records));
    }

    public static <T> IntoGatherer<T> insert(Collection<T> records) {
        return new IntoGatherer(records);
    }

    public class ColumnMappingFinisher<F> {
        private final SqlColumn<F> column;

        public ColumnMappingFinisher(SqlColumn<F> column) {
            this.column = column;
        }

        public BatchInsertDSL<T> toProperty(String property) {
            BatchInsertDSL.this.columnMappings.add(PropertyMapping.of(this.column, property));
            return BatchInsertDSL.this;
        }

        public BatchInsertDSL<T> toNull() {
            BatchInsertDSL.this.columnMappings.add(NullMapping.of(this.column));
            return BatchInsertDSL.this;
        }

        public BatchInsertDSL<T> toConstant(String constant) {
            BatchInsertDSL.this.columnMappings.add(ConstantMapping.of(this.column, constant));
            return BatchInsertDSL.this;
        }

        public BatchInsertDSL<T> toStringConstant(String constant) {
            BatchInsertDSL.this.columnMappings.add(StringConstantMapping.of(this.column, constant));
            return BatchInsertDSL.this;
        }
    }

    public static class IntoGatherer<T> {
        private final Collection<T> records;

        private IntoGatherer(Collection<T> records) {
            this.records = records;
        }

        public BatchInsertDSL<T> into(SqlTable table) {
            return new BatchInsertDSL(this.records, table);
        }
    }
}

