/*
 * Decompiled with CFR 0.152.
 */
package org.mvnsearch.boot.xtermjs.commands.sql;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class QueryResult {
    private String SQL;
    private long elapsed;
    private List<String> columns = new ArrayList<String>();
    private List<String> columnTypes = new ArrayList<String>();
    private List<List<Object>> rows = new ArrayList<List<Object>>();

    public String getSQL() {
        return this.SQL;
    }

    public void setSQL(String SQL) {
        this.SQL = SQL;
    }

    public long getElapsed() {
        return this.elapsed;
    }

    public void setElapsed(long elapsed) {
        this.elapsed = elapsed;
    }

    public List<String> getColumns() {
        return this.columns;
    }

    public void setColumns(List<String> columns) {
        this.columns = columns;
    }

    public void addColumn(String name) {
        this.columns.add(name);
    }

    public List<String> getColumnTypes() {
        return this.columnTypes;
    }

    public void setColumnTypes(List<String> columnTypes) {
        this.columnTypes = columnTypes;
    }

    public void addColumnType(String columnType) {
        this.columnTypes.add(columnType);
    }

    public List<List<Object>> getRows() {
        return this.rows;
    }

    public void setRows(List<List<Object>> rows) {
        this.rows = rows;
    }

    public void addRow(List<Object> row) {
        this.rows.add(row);
    }

    public String toString() {
        return "columns:" + this.columns.size() + ", rows: " + this.rows.size();
    }

    public String getTable() {
        ArrayList<Integer> columnsWidth = new ArrayList<Integer>();
        for (String string : this.columns) {
            columnsWidth.add(string.length());
        }
        for (List list : this.rows) {
            for (int i = 0; i < list.size(); ++i) {
                String cellValue = this.getCellValue(i, list.get(i));
                int cellWidth = cellValue.getBytes().length;
                if (cellWidth <= (Integer)columnsWidth.get(i)) continue;
                columnsWidth.set(i, cellWidth);
            }
        }
        ArrayList<String> lines = new ArrayList<String>();
        StringBuilder stringBuilder = new StringBuilder();
        for (Integer width : columnsWidth) {
            stringBuilder.append(StringUtils.rightPad((String)"+", (int)(width + 3), (String)"-"));
        }
        stringBuilder.append("+");
        lines.add(stringBuilder.toString());
        StringBuilder columnBuilder = new StringBuilder();
        for (int i = 0; i < this.columns.size(); ++i) {
            columnBuilder.append("| " + StringUtils.rightPad((String)this.columns.get(i), (int)((Integer)columnsWidth.get(i) + 1)));
        }
        columnBuilder.append("|");
        lines.add(columnBuilder.toString());
        lines.add(stringBuilder.toString());
        for (List<Object> row : this.getRows()) {
            StringBuilder rowBuilder = new StringBuilder();
            for (int i = 0; i < row.size(); ++i) {
                String cellValue = this.getCellValue(i, row.get(i));
                int bytelen = cellValue.getBytes().length;
                int charlen = cellValue.toCharArray().length;
                rowBuilder.append("| " + StringUtils.rightPad((String)cellValue, (int)((Integer)columnsWidth.get(i) + 1 - (bytelen - charlen))));
            }
            rowBuilder.append("|");
            lines.add(rowBuilder.toString());
        }
        lines.add(stringBuilder.toString());
        return StringUtils.join(lines, (String)"\r\n");
    }

    private String getCellValue(int i, Object value) {
        if (this.columnTypes.get(i).toLowerCase().contains("lob")) {
            return "LOB";
        }
        return value == null ? "" : value.toString().trim();
    }

    public String getStatics() {
        if (this.rows.isEmpty()) {
            return "Empty set (" + (double)this.elapsed / 1000.0 + " sec)";
        }
        if (this.rows.size() == 1) {
            return "1 row in set (" + (double)this.elapsed / 1000.0 + " sec)";
        }
        return this.rows.size() + " rows in set (" + (double)this.elapsed / 1000.0 + " sec)";
    }
}

