/*
 * Decompiled with CFR 0.152.
 */
package org.mvnsearch.boot.xtermjs.commands.sql;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.Statement;
import java.util.ArrayList;
import javax.sql.DataSource;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.mvnsearch.boot.xtermjs.commands.CustomizedCommand;
import org.mvnsearch.boot.xtermjs.commands.sql.QueryResult;
import org.mvnsearch.boot.xtermjs.commands.sql.UpdateResult;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.shell.standard.ShellComponent;

@ShellComponent(value="db: execute database commands")
public class DatabaseCommands
implements CustomizedCommand {
    @Autowired(required=false)
    private DataSource ds;

    @Override
    public String[] getNames() {
        return new String[]{"db-select", "db-show", "db-update", "db-insert", "db-delete", "db-desc"};
    }

    @Override
    @Nullable
    public Object execute(@NotNull String command, @Nullable String arguments) throws Exception {
        switch (command) {
            case "db-select": {
                return this.select(this.trimSemicolon("select " + arguments));
            }
            case "db-show": {
                return this.select(this.trimSemicolon("show " + arguments));
            }
            case "db-desc": {
                return this.select(this.trimSemicolon("desc " + arguments));
            }
        }
        return this.execute(this.trimSemicolon(command.replace("db-", "") + " " + arguments));
    }

    public String select(String sql) throws Exception {
        QueryResult rowResult = new QueryResult();
        rowResult.setSQL(sql);
        try (Connection conn = this.ds.getConnection();){
            long start = System.currentTimeMillis();
            Statement statement = conn.createStatement();
            ResultSet resultset = statement.executeQuery(sql);
            ResultSetMetaData metaData = resultset.getMetaData();
            int columnCount = metaData.getColumnCount();
            for (int i = 1; i <= columnCount; ++i) {
                rowResult.addColumn(metaData.getColumnLabel(i));
                rowResult.addColumnType(metaData.getColumnTypeName(i));
            }
            while (resultset.next()) {
                ArrayList<Object> row = new ArrayList<Object>();
                for (int i = 1; i <= rowResult.getColumns().size(); ++i) {
                    row.add(resultset.getObject(i));
                }
                rowResult.addRow(row);
            }
            resultset.close();
            statement.close();
            long end = System.currentTimeMillis();
            rowResult.setElapsed(end - start);
        }
        if (rowResult.getRows().size() == 0) {
            return rowResult.getStatics();
        }
        return rowResult.getTable() + "\r\n" + rowResult.getStatics();
    }

    public String execute(String sqlUpdate) throws Exception {
        UpdateResult updateResult = new UpdateResult();
        updateResult.setSql(sqlUpdate);
        sqlUpdate = this.trimSemicolon(sqlUpdate);
        try (Connection conn = this.ds.getConnection();){
            long start = System.currentTimeMillis();
            Statement statement = conn.createStatement();
            updateResult.setRows(statement.executeUpdate(sqlUpdate));
            statement.close();
            long end = System.currentTimeMillis();
            updateResult.setElapsed(end - start);
            conn.close();
            String string = updateResult.getStatics();
            return string;
        }
    }

    public String trimSemicolon(String sql) {
        if (sql.endsWith(";")) {
            sql = sql.substring(0, sql.length() - 1);
        }
        return sql;
    }
}

