/*
 * Decompiled with CFR 0.152.
 */
package org.mvnsearch.boot.xtermjs.commands;

import java.io.File;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.commons.io.FilenameUtils;
import org.mvnsearch.boot.xtermjs.commands.CommandsSupport;
import org.springframework.shell.standard.ShellComponent;
import org.springframework.shell.standard.ShellMethod;
import org.springframework.shell.standard.ShellOption;
import reactor.core.publisher.Mono;

@ShellComponent
public class SystemCommands
implements CommandsSupport {
    @ShellMethod(value="Date command")
    public String date() {
        SimpleDateFormat dateFormat = new SimpleDateFormat("EEE, d MMM yyyy HH:mm:ss z");
        return dateFormat.format(new Date());
    }

    @ShellMethod(value="cd command")
    public Mono<String> cd(@ShellOption(help="path name", defaultValue="") String path) throws Exception {
        return Mono.deferWithContext(context -> {
            String currentDir = (String)context.get((Object)"path");
            File dest = path.isEmpty() ? new File(System.getProperty("user.home", ".")) : (path.startsWith("/") ? new File(path) : new File(new File(currentDir), path));
            String absolutePath = FilenameUtils.normalize((String)dest.getAbsolutePath());
            if (!dest.exists()) {
                return Mono.error((Throwable)new Exception("Directory not existed: " + absolutePath));
            }
            if (!dest.isDirectory()) {
                return Mono.error((Throwable)new Exception("Not directory: " + absolutePath));
            }
            context.put((Object)"path", (Object)absolutePath);
            return Mono.just((Object)("$path:" + absolutePath));
        });
    }
}

