/*
 * Decompiled with CFR 0.152.
 */
package org.mvnsearch.boot.xtermjs.commands;

import io.micrometer.core.instrument.Measurement;
import io.micrometer.core.instrument.Meter;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Tag;
import java.io.File;
import java.net.InetAddress;
import java.nio.charset.StandardCharsets;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.io.input.ReversedLinesFileReader;
import org.mvnsearch.boot.xtermjs.commands.CommandsSupport;
import org.mvnsearch.boot.xtermjs.commands.CurlCommand;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.boot.SpringBootVersion;
import org.springframework.boot.actuate.endpoint.web.annotation.WebEndpointDiscoverer;
import org.springframework.boot.actuate.health.Health;
import org.springframework.boot.actuate.health.HealthComponent;
import org.springframework.boot.actuate.health.HealthEndpoint;
import org.springframework.boot.actuate.health.ReactiveHealthIndicator;
import org.springframework.context.ApplicationContext;
import org.springframework.core.env.AbstractEnvironment;
import org.springframework.core.env.EnumerablePropertySource;
import org.springframework.core.env.PropertySource;
import org.springframework.shell.standard.ShellComponent;
import org.springframework.shell.standard.ShellMethod;
import org.springframework.shell.standard.ShellOption;
import org.springframework.util.ClassUtils;
import reactor.core.publisher.Mono;

@ShellComponent
public class SpringCommands
implements CommandsSupport {
    private String startedTime = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss:SSS'Z'").format(new Date());
    @Autowired
    private ApplicationContext applicationContext;
    @Autowired
    private AbstractEnvironment env;
    @Autowired
    private ConfigurableListableBeanFactory beanFactory;
    @Autowired
    private HealthEndpoint healthEndpoint;
    @Autowired
    private MeterRegistry meterRegistry;
    @Autowired
    private WebEndpointDiscoverer endpointDiscoverer;

    @ShellMethod(value="Display application info")
    public String app() {
        ArrayList<String> lines = new ArrayList<String>();
        if (this.env.getProperty("spring.application.name") != null) {
            lines.add("Application name: " + this.env.getProperty("spring.application.name"));
        }
        lines.add("User Home: " + this.env.getProperty("user.home"));
        lines.add("Work Dir: " + this.env.getProperty("user.dir"));
        lines.add("Shell: " + this.env.getProperty("SHELL", ""));
        if (this.env.getProperty("PID") != null) {
            lines.add("PID: " + this.env.getProperty("PID"));
        }
        lines.add("Started Time: " + this.startedTime);
        lines.add("Java Version: " + System.getProperty("java.version"));
        lines.add("OS Name: " + System.getProperty("os.name"));
        lines.add("OS Version: " + System.getProperty("os.version"));
        lines.add("OS Arch: " + System.getProperty("os.arch"));
        lines.add("Spring Boot Version: " + SpringBootVersion.getVersion());
        int mb = 0x100000;
        int gb = mb * 1024;
        Runtime runtime = Runtime.getRuntime();
        lines.add("CPU Cores: " + runtime.availableProcessors());
        lines.add("Total Memory(M): " + runtime.totalMemory() / (long)mb);
        lines.add("Free Memory(M): " + runtime.freeMemory() / (long)mb);
        lines.add("Used Memory(M): " + (runtime.totalMemory() - runtime.freeMemory()) / (long)mb);
        lines.add("Max Memory(M): " + runtime.maxMemory() / (long)mb);
        File path = new File(".");
        lines.add("Total Space(G): " + path.getTotalSpace() / (long)gb);
        lines.add("Free Space(G): " + path.getUsableSpace() / (long)gb);
        try {
            InetAddress inetAddress = InetAddress.getLocalHost();
            lines.add("IP: " + inetAddress.getHostAddress());
            lines.add("Host: " + inetAddress.getHostName());
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this.linesToString(lines);
    }

    @ShellMethod(value="Context list")
    public List<String> contexts() {
        ArrayList<String> contexts = new ArrayList<String>();
        Map beansWithAnnotation = this.applicationContext.getBeansWithAnnotation(ShellComponent.class);
        for (Object bean : beansWithAnnotation.values()) {
            ShellComponent shellComponent = bean.getClass().getAnnotation(ShellComponent.class);
            String value = shellComponent.value();
            if (!value.contains(": ")) continue;
            contexts.add(value);
        }
        if (contexts.isEmpty()) {
            contexts.add("No context found");
        }
        return contexts;
    }

    @ShellMethod(value="Execute SpEL")
    public String spel() {
        return "Not implemented";
    }

    @ShellMethod(value="Display beans info")
    public String beans() {
        ArrayList<String> lines = new ArrayList<String>(Arrays.asList(this.beanFactory.getBeanDefinitionNames()));
        lines.add("");
        lines.add("Beans: " + this.beanFactory.getBeanDefinitionNames().length);
        return this.linesToString(lines);
    }

    @ShellMethod(value="Display bean info")
    public String bean(@ShellOption(help="Bean name or class") String beanNameOrClass) {
        ArrayList<String> lines = new ArrayList<String>();
        String nameForSearch = beanNameOrClass;
        if (beanNameOrClass.contains("*")) {
            nameForSearch = beanNameOrClass.replaceAll("\\*", "").toLowerCase();
        }
        for (String beanName : this.beanFactory.getBeanDefinitionNames()) {
            Class[] allInterfaces;
            boolean matched;
            BeanDefinition beanDefinition = this.beanFactory.getBeanDefinition(beanName);
            String beanClassName = beanDefinition.getBeanClassName();
            Object bean = this.applicationContext.getBean(beanName);
            if (beanClassName == null && (beanClassName = bean.getClass().getCanonicalName()) == null) {
                beanClassName = bean.getClass().getSimpleName();
            }
            if (beanNameOrClass.contains("*")) {
                matched = beanName.toLowerCase().contains(nameForSearch) || beanClassName.toLowerCase().contains(nameForSearch);
            } else {
                boolean bl = matched = beanNameOrClass.equalsIgnoreCase(beanName) || beanNameOrClass.equalsIgnoreCase(beanClassName);
            }
            if (!matched) continue;
            if (!lines.isEmpty()) {
                lines.add("-------------------------------");
            }
            lines.add("Name: " + beanName);
            lines.add("Class: " + beanClassName);
            if (beanDefinition.getFactoryBeanName() != null) {
                lines.add("Factory Bean: " + beanDefinition.getFactoryBeanName());
            }
            if (beanDefinition.getFactoryMethodName() != null) {
                lines.add("Factory Method: " + beanDefinition.getFactoryMethodName());
            }
            if (beanDefinition.getScope() != null && !beanDefinition.getScope().isEmpty()) {
                lines.add("Scope: " + beanDefinition.getScope());
            }
            if (beanDefinition.getDependsOn() != null && beanDefinition.getDependsOn().length > 0) {
                lines.add("DependsOn: " + String.join((CharSequence)"\n", beanDefinition.getDependsOn()));
            }
            if (beanDefinition.getParentName() != null) {
                lines.add("Parent: " + beanDefinition.getParentName());
            }
            for (Class beanInterface : allInterfaces = ClassUtils.getAllInterfaces((Object)bean)) {
                lines.add("=========" + beanInterface.getCanonicalName() + " ========");
                Arrays.stream(beanInterface.getDeclaredMethods()).map(method -> {
                    if (method.getParameterCount() == 0) {
                        return this.formatClassName(method.getGenericReturnType().getTypeName()) + " " + method.getName() + "()";
                    }
                    String parameterTypes = Arrays.stream(method.getParameters()).map(parameter -> {
                        String parameterName = parameter.getName();
                        return this.formatClassName(parameter.getParameterizedType().getTypeName()) + " " + parameterName;
                    }).collect(Collectors.joining(", "));
                    return this.formatClassName(method.getGenericReturnType().getTypeName()) + " " + method.getName() + "(" + parameterTypes + ")";
                }).forEach(lines::add);
            }
        }
        return this.linesToString(lines);
    }

    @ShellMethod(value="Display env info")
    public String env(@ShellOption(help="env name", defaultValue="") String envName) {
        ArrayList<String> lines = new ArrayList<String>();
        if (!envName.isEmpty()) {
            String key = envName;
            String value = this.env.getProperty(key);
            if (value == null) {
                key = envName.toUpperCase();
                value = this.env.getProperty(key);
            }
            if (value == null) {
                lines.add("Env name not found!");
            } else {
                lines.add(key + ": " + value);
            }
        } else {
            for (PropertySource propertySource : this.env.getPropertySources()) {
                if (!(propertySource instanceof EnumerablePropertySource)) continue;
                EnumerablePropertySource enumerablePropertySource = (EnumerablePropertySource)propertySource;
                for (String propertyName : enumerablePropertySource.getPropertyNames()) {
                    lines.add(propertyName + ": " + this.env.getProperty(propertyName));
                }
            }
            lines.add("");
            lines.add("Env names: " + (lines.size() - 1));
        }
        return this.linesToString(lines);
    }

    @ShellMethod(value="Display metrics")
    public String metrics(@ShellOption(help="metrics name", defaultValue="") String metricsName) {
        ArrayList<String> lines = new ArrayList<String>();
        if (!metricsName.isEmpty()) {
            for (Meter meter : this.meterRegistry.getMeters()) {
                String meterName = meter.getId().getName();
                if (!meterName.contains(metricsName)) continue;
                lines.add(SpringCommands.meterName(metricsName, meter.getId().getTags()) + ": " + ((Measurement)meter.measure().iterator().next()).getValue());
            }
        } else {
            for (Meter meter : this.meterRegistry.getMeters()) {
                lines.add(SpringCommands.meterName(meter.getId().getName(), meter.getId().getTags()) + ": " + ((Measurement)meter.measure().iterator().next()).getValue());
            }
            lines.add("");
            lines.add("Metrics Count: " + (lines.size() - 1));
        }
        return this.linesToString(lines);
    }

    @ShellMethod(value="Display health")
    public Object health(@ShellOption(help="health component name", defaultValue="") String componentName) {
        try {
            ReactiveHealthIndicator healthIndicator = (ReactiveHealthIndicator)this.applicationContext.getBean(ReactiveHealthIndicator.class);
            return healthIndicator.health().map(health -> health.getStatus().getCode());
        }
        catch (Exception e) {
            return new Exception("Failed to get health:" + e.getMessage());
        }
    }

    @ShellMethod(value="Display profiles")
    public String profiles() {
        CharSequence[] profiles = this.env.getActiveProfiles();
        if (profiles.length > 0) {
            return "Active Profiles: [" + String.join((CharSequence)",", profiles) + "]";
        }
        return "No active profiles";
    }

    @ShellMethod(value="Display logfile")
    public List<String> log() throws Exception {
        String line;
        String loggingFilePath = this.env.getProperty("logging.file.path");
        String loggingFileName = this.env.getProperty("logging.file.name");
        if (loggingFilePath == null || loggingFileName == null) {
            throw new Exception("Missing 'logging.file.name' or 'logging.file.path' properties");
        }
        File loggingFile = new File(loggingFilePath, loggingFileName);
        if (!loggingFile.exists()) {
            throw new Exception("Logging file not found: " + loggingFile.getAbsolutePath());
        }
        ReversedLinesFileReader object = new ReversedLinesFileReader(loggingFile, StandardCharsets.UTF_8);
        ArrayList<String> lines = new ArrayList<String>();
        for (int i = 0; i < 100 && (line = object.readLine()) != null; ++i) {
            lines.add(line);
        }
        Collections.reverse(lines);
        return lines;
    }

    @ShellMethod(value="Display actuator")
    public Mono<String> actuator(@ShellOption(help="health component name", defaultValue="") String endpoint) {
        if (endpoint.isEmpty()) {
            return Mono.just((Object)this.endpointDiscoverer.getEndpoints().stream().map(exposableWebEndpoint -> exposableWebEndpoint.getEndpointId().toLowerCaseString()).collect(Collectors.joining(",")));
        }
        String serverPort = this.env.getProperty("server.port");
        if (serverPort == null || serverPort.equals("-1")) {
            serverPort = "8080";
        }
        String managementPort = this.env.getProperty("management.server.port", serverPort);
        String managementPath = this.env.getProperty("management.endpoints.web.base-path", "/actuator");
        return CurlCommand.webClient.get().uri("http://127.0.0.1:" + managementPort + managementPath + "/" + endpoint, new Object[0]).retrieve().bodyToMono(String.class);
    }

    private static String meterName(String name, List<Tag> tags) {
        if (tags != null && tags.size() > 0) {
            return tags.stream().map(tag -> tag.getKey() + ":" + tag.getValue()).collect(Collectors.joining(",", name + "(", ")"));
        }
        return name;
    }

    private static String healthName(String name, HealthComponent healthComponent) {
        Map details;
        if (healthComponent instanceof Health && (details = ((Health)healthComponent).getDetails()) != null && !details.isEmpty()) {
            return details.entrySet().stream().map(entry -> (String)entry.getKey() + ":" + entry.getValue().toString()).collect(Collectors.joining(",", name + "(", ")"));
        }
        return name;
    }
}

