/*
 * Decompiled with CFR 0.152.
 */
package org.mvnsearch.boot.xtermjs.commands;

import javax.annotation.PostConstruct;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.mvnsearch.boot.xtermjs.commands.CustomizedCommand;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.config.BeanExpressionContext;
import org.springframework.beans.factory.config.ConfigurableBeanFactory;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.context.expression.BeanExpressionContextAccessor;
import org.springframework.context.expression.BeanFactoryResolver;
import org.springframework.expression.BeanResolver;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.Expression;
import org.springframework.expression.ExpressionParser;
import org.springframework.expression.ParserContext;
import org.springframework.expression.PropertyAccessor;
import org.springframework.expression.common.TemplateParserContext;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.expression.spel.support.StandardEvaluationContext;

public class SpelCommand
implements CustomizedCommand {
    @Autowired
    private ConfigurableListableBeanFactory beanFactory;
    final ExpressionParser spelParser = new SpelExpressionParser();
    private StandardEvaluationContext spelContext;
    private BeanExpressionContext rootObject;

    @PostConstruct
    public void init() {
        this.spelContext = new StandardEvaluationContext();
        this.spelContext.setBeanResolver((BeanResolver)new BeanFactoryResolver((BeanFactory)this.beanFactory));
        this.spelContext.addPropertyAccessor((PropertyAccessor)new BeanExpressionContextAccessor());
        this.rootObject = new BeanExpressionContext((ConfigurableBeanFactory)this.beanFactory, null);
    }

    @Override
    public String[] getNames() {
        return new String[]{"spel"};
    }

    @Override
    @Nullable
    public Object execute(@NotNull String command, @Nullable String expressionText) {
        if (expressionText == null || expressionText.isEmpty()) {
            return new Exception("No expression");
        }
        Expression expression = expressionText.contains("#{") ? this.spelParser.parseExpression(expressionText, (ParserContext)new TemplateParserContext()) : this.spelParser.parseExpression(expressionText);
        return expression.getValue((EvaluationContext)this.spelContext, (Object)this.rootObject);
    }
}

