/*
 * Decompiled with CFR 0.152.
 */
package org.mvnsearch.boot.xtermjs.commands;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.shell.Availability;
import org.springframework.shell.standard.ShellComponent;
import org.springframework.shell.standard.ShellMethod;
import org.springframework.shell.standard.ShellMethodAvailability;
import org.springframework.shell.standard.ShellOption;

@ShellComponent(value="redis: execute redis commands")
public class RedisCommands {
    @Autowired(required=false)
    private RedisTemplate redisTemplate;

    @ShellMethod(value="Redis Get")
    public Object redisGet(@ShellOption(help="Key", defaultValue="") String key) {
        return this.redisTemplate.opsForValue().get((Object)key);
    }

    @ShellMethod(value="Redis Set")
    public String redisSet(@ShellOption(help="Redis Key", defaultValue="") String key, @ShellOption(help="Value", defaultValue="") String value) {
        this.redisTemplate.opsForValue().set((Object)key, (Object)value);
        return "OK";
    }

    @ShellMethodAvailability
    public Availability availabilityOnWeekdays() {
        return this.redisTemplate != null ? Availability.available() : Availability.unavailable((String)"RedisTemplate bean not found!");
    }
}

