/*
 * Decompiled with CFR 0.152.
 */
package org.mvnsearch.boot.xtermjs.commands;

import java.io.File;
import java.lang.management.ManagementFactory;
import java.lang.management.OperatingSystemMXBean;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Set;
import org.fusesource.jansi.Ansi;
import org.mvnsearch.boot.xtermjs.commands.CommandsSupport;
import org.springframework.shell.standard.ShellComponent;
import org.springframework.shell.standard.ShellMethod;
import org.springframework.shell.standard.ShellOption;

@ShellComponent
public class JvmCommands
implements CommandsSupport {
    @ShellMethod(value="Java Options")
    public String options() {
        return this.linesToString(ManagementFactory.getRuntimeMXBean().getInputArguments());
    }

    @ShellMethod(value="Show Threads")
    public String threads() {
        String threadPattern = "%4s %5s %10s %8s %16s  %s";
        Set<Thread> threadSet = Thread.getAllStackTraces().keySet();
        ArrayList<String> lines = new ArrayList<String>();
        lines.add(String.format(threadPattern, "ID", "Alive", "State", "Priority", "Group", "Name", "Daemon"));
        threadSet.stream().map(thread -> String.format(threadPattern, thread.getId(), thread.isAlive() ? 1 : 0, thread.getState().name(), thread.getPriority(), thread.getThreadGroup() == null ? "" : thread.getThreadGroup().getName(), thread.getName(), thread.isDaemon())).forEach(lines::add);
        lines.add("");
        lines.add("Thread Count: " + (lines.size() - 1));
        return this.linesToString(lines);
    }

    @ShellMethod(value="Show Thread")
    public String thread(@ShellOption(help="Thread ID", defaultValue="") Integer threadId) {
        return "";
    }

    @ShellMethod(value="Show Memory")
    public String mem() {
        StringBuilder builder = new StringBuilder();
        builder.append("HeapSize:").append(Runtime.getRuntime().totalMemory()).append(",");
        builder.append("HeapMaxSize:").append(Runtime.getRuntime().maxMemory()).append(",");
        builder.append("HeapFreeSize:").append(Runtime.getRuntime().freeMemory());
        return builder.toString();
    }

    @ShellMethod(value="Show CPU")
    public String cpu() {
        StringBuilder builder = new StringBuilder();
        OperatingSystemMXBean operatingSystemMXBean = ManagementFactory.getOperatingSystemMXBean();
        builder.append("arch:").append(operatingSystemMXBean.getArch()).append(",");
        builder.append("processors:").append(operatingSystemMXBean.getAvailableProcessors()).append(",");
        builder.append("load:").append(operatingSystemMXBean.getSystemLoadAverage());
        return builder.toString();
    }

    @ShellMethod(value="Display Classpath info")
    public String classpath() {
        ArrayList<String> lines = new ArrayList<String>();
        String classPath = System.getProperty("CLASSPATH");
        if (classPath == null || classPath.isEmpty()) {
            classPath = ManagementFactory.getRuntimeMXBean().getClassPath();
        }
        if (classPath != null) {
            lines.addAll(Arrays.asList(classPath.split(File.pathSeparator)));
        } else {
            ClassLoader cl = ClassLoader.getSystemClassLoader();
            URL[] urls = ((URLClassLoader)cl).getURLs();
            Arrays.stream(urls).map(URL::toString).forEach(lines::add);
        }
        return this.linesToString(lines);
    }

    @ShellMethod(value="demo")
    public String demo() {
        return Ansi.ansi().fgRed().a("good").reset().toString();
    }
}

