/*
 * Decompiled with CFR 0.152.
 */
package org.mvnsearch.boot.xtermjs.commands;

import java.net.URI;
import java.time.Duration;
import java.util.ArrayList;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.client.reactive.ClientHttpConnector;
import org.springframework.http.client.reactive.ReactorClientHttpConnector;
import org.springframework.shell.Shell;
import org.springframework.shell.standard.ShellComponent;
import org.springframework.shell.standard.ShellMethod;
import org.springframework.shell.standard.ShellOption;
import org.springframework.util.Base64Utils;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.util.StringUtils;
import org.springframework.web.reactive.function.BodyInserter;
import org.springframework.web.reactive.function.BodyInserters;
import org.springframework.web.reactive.function.client.WebClient;
import reactor.core.publisher.Mono;
import reactor.netty.http.client.HttpClient;

@ShellComponent
public class CurlCommand {
    @Autowired
    private ApplicationContext applicationContext;
    public static WebClient webClient = WebClient.builder().build();
    public static WebClient webClientFollowRedirect = WebClient.builder().clientConnector((ClientHttpConnector)new ReactorClientHttpConnector(HttpClient.create().followRedirect(true))).build();

    @ShellMethod(value="Curl command")
    public Mono<String> curl(@ShellOption(value={""}, defaultValue="__NULL__", help="Request URL") URI uri, @ShellOption(value={"-X", "--request"}, defaultValue="GET", help="Specify request command to use") HttpMethod requestMethod, @ShellOption(value={"-d", "--data"}, defaultValue="__NULL__", help="HTTP POST data") String data, @ShellOption(value={"--data-urlencode"}, defaultValue="__NULL__", help="HTTP POST data url encoded") String urlEncodedData, @ShellOption(value={"-H", "--header"}, defaultValue="__NULL__", help="Custom header to pass to server") String header, @ShellOption(value={"-b", "--cookie"}, defaultValue="__NULL__", help="Send cookies") String cookies, @ShellOption(value={"-u", "--user"}, defaultValue="__NULL__", help="Send cookies") String user, @ShellOption(value={"-A", "--user-agent"}, defaultValue="__NULL__", help="User-Agent to send to server") String userAgent, @ShellOption(value={"-e", "--referer"}, defaultValue="__NULL__", help="Referer URL") String refer, @ShellOption(value={"-m", "--max-time"}, defaultValue="300", help="Maximum time allowed for the transfer") int maxTime, @ShellOption(arity=0, value={"-I", "--head"}, defaultValue="false", help="Show document info only") boolean headOnly, @ShellOption(arity=0, value={"-v", "--verbose"}, defaultValue="false", help="Verbose") boolean verbose, @ShellOption(arity=0, value={"-L", "--location"}, defaultValue="false", help="Follow redirects") boolean followRedirects, @ShellOption(arity=0, value={"-K", "--insecure"}, defaultValue="false") boolean allowInsecure, @ShellOption(arity=0, value={"-v", "--version"}, defaultValue="false", help="Show version number and quit") boolean showVersion, @ShellOption(arity=0, value={"-h", "--help"}, defaultValue="false", help="Show help information") boolean showHelp) {
        String requestHeaderLines;
        if (showVersion) {
            return Mono.just((Object)"7.0.0 - WebClient");
        }
        if (showHelp) {
            Shell shell = (Shell)this.applicationContext.getBean(Shell.class);
            return Mono.just((Object)shell.evaluate(() -> "help curl").toString());
        }
        WebClient.RequestBodySpec requestBodySpec = followRedirects ? (WebClient.RequestBodySpec)webClientFollowRedirect.method(requestMethod).uri(uri) : (WebClient.RequestBodySpec)webClient.method(requestMethod).uri(uri);
        requestBodySpec.header("Host", new String[]{uri.getHost()});
        if (!StringUtils.isEmpty((Object)header)) {
            String[] parts = header.split(":", 2);
            requestBodySpec = parts.length > 1 ? (WebClient.RequestBodySpec)requestBodySpec.header(parts[0], new String[]{parts[1]}) : (WebClient.RequestBodySpec)requestBodySpec.header(parts[0], new String[]{""});
        }
        requestBodySpec = !StringUtils.isEmpty((Object)userAgent) ? (WebClient.RequestBodySpec)requestBodySpec.header("User-Agent", new String[]{userAgent}) : (WebClient.RequestBodySpec)requestBodySpec.header("User-Agent", new String[]{"curl/7.64.1"});
        if (!StringUtils.isEmpty((Object)refer)) {
            requestBodySpec = (WebClient.RequestBodySpec)requestBodySpec.header("Referer", new String[]{userAgent});
        }
        if (!StringUtils.isEmpty((Object)data)) {
            requestBodySpec = (WebClient.RequestBodySpec)requestBodySpec.body((Object)data, String.class);
        }
        if (!StringUtils.isEmpty((Object)urlEncodedData)) {
            String[] pairs;
            LinkedMultiValueMap multiValueMap = new LinkedMultiValueMap();
            for (String pair : pairs = urlEncodedData.split("&")) {
                String[] parts = pair.split("=");
                if (parts.length > 1) {
                    multiValueMap.add((Object)parts[0], (Object)parts[1]);
                    continue;
                }
                multiValueMap.add((Object)parts[0], (Object)"");
            }
            requestBodySpec = (WebClient.RequestBodySpec)requestBodySpec.body((BodyInserter)BodyInserters.fromFormData((MultiValueMap)multiValueMap));
        }
        if (!StringUtils.isEmpty((Object)user)) {
            requestBodySpec.header("Authorization", new String[]{"Basic " + Base64Utils.encodeToString((byte[])user.getBytes())});
        }
        if (verbose) {
            ArrayList<String> requestLines = new ArrayList<String>();
            int port = uri.getPort();
            if (port == -1) {
                if (uri.getScheme().equals("http")) {
                    port = 80;
                } else if (uri.getScheme().equalsIgnoreCase("https")) {
                    port = 443;
                }
            }
            requestLines.add("Connected to " + uri.getHost() + " port " + port);
            requestLines.add(requestMethod.name() + " " + uri.getPath() + " HTTP/1.1");
            requestBodySpec.headers(httpHeaders -> httpHeaders.forEach((name, values) -> values.forEach(value -> requestLines.add(name + ": " + value))));
            requestHeaderLines = String.join((CharSequence)"\r\n", requestLines);
        } else {
            requestHeaderLines = "";
        }
        return requestBodySpec.exchange().flatMap(response -> {
            Mono body = response.bodyToMono(String.class);
            if (verbose || headOnly) {
                body = body.map(textBody -> {
                    ArrayList<String> lines = new ArrayList<String>();
                    HttpStatus httpStatus = response.statusCode();
                    lines.add("HTTP/1.1 " + httpStatus.value() + " " + httpStatus.getReasonPhrase());
                    response.headers().asHttpHeaders().forEach((name, values) -> values.forEach(value -> lines.add(name + ": " + value)));
                    String responseHeaderLines = String.join((CharSequence)"\r\n", lines);
                    if (headOnly) {
                        return responseHeaderLines;
                    }
                    return requestHeaderLines + "\r\n\r\n" + responseHeaderLines + "\r\n\r\n" + textBody;
                });
            }
            return body;
        }).onErrorResume(error -> Mono.just((Object)error.getMessage())).timeout(Duration.ofSeconds(maxTime));
    }
}

