/*
 * Decompiled with CFR 0.152.
 */
package org.mvnsearch.boot.xtermjs;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.datatype.jdk8.Jdk8Module;
import java.io.File;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.PostConstruct;
import org.jetbrains.annotations.NotNull;
import org.jline.reader.impl.DefaultParser;
import org.jline.utils.AttributedString;
import org.jline.utils.AttributedStyle;
import org.mvnsearch.boot.xtermjs.commands.CustomizedCommand;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.shell.Shell;
import org.springframework.shell.command.CommandCatalog;
import org.zeroturnaround.exec.ProcessExecutor;
import reactor.core.publisher.Mono;

public class XtermCommandHandler {
    @Autowired
    private ApplicationContext applicationContext;
    @Autowired
    public List<CustomizedCommand> customizedCommands;
    private ObjectMapper objectMapper;
    private DefaultParser lineParser = new DefaultParser();
    private List<String> stringOutputClasses = Arrays.asList("java.util.Date", "java.lang.Boolean", "java.lang.Void");
    private Map<String, CustomizedCommand> customizedCommandMap = new HashMap<String, CustomizedCommand>();

    @PostConstruct
    public void init() {
        this.objectMapper = new ObjectMapper();
        this.objectMapper.registerModule((Module)new Jdk8Module());
        this.objectMapper.enable(SerializationFeature.INDENT_OUTPUT);
        this.objectMapper.setSerializationInclusion(JsonInclude.Include.NON_ABSENT);
        for (CustomizedCommand customizedCommand : this.customizedCommands) {
            String[] names;
            for (String name : names = customizedCommand.getNames()) {
                this.customizedCommandMap.put(name, customizedCommand);
            }
        }
    }

    public Mono<String> executeCommand(String commandLine) {
        String textOutput;
        Object result;
        String command;
        String arguments = null;
        int spaceIndex = commandLine.indexOf(" ");
        if (spaceIndex > 0) {
            command = commandLine.substring(0, spaceIndex);
            arguments = commandLine.substring(spaceIndex + 1).trim();
        } else {
            command = commandLine;
        }
        try {
            CommandCatalog commandCatalog = (CommandCatalog)this.applicationContext.getBean(CommandCatalog.class);
            if (this.customizedCommandMap.containsKey(command)) {
                result = this.customizedCommandMap.get(command).execute(command, arguments);
            } else if (commandCatalog.getRegistrations().containsKey(command)) {
                Shell shell = (Shell)this.applicationContext.getBean(Shell.class);
                result = shell.evaluate(() -> commandLine);
            } else {
                result = this.executeOsCommand(commandLine);
            }
        }
        catch (Exception e) {
            result = e;
        }
        if (result == null) {
            textOutput = "";
        } else {
            if (result instanceof Mono) {
                return ((Mono)result).map(this::formatObject).map(this::formatLineBreak).onErrorResume(error -> Mono.just((Object)this.formatObject(error))).defaultIfEmpty((Object)"");
            }
            textOutput = this.formatObject(result);
        }
        if (!textOutput.contains("\r\n") && textOutput.contains("\n")) {
            return Mono.just((Object)textOutput.replaceAll("\n", "\r\n"));
        }
        return Mono.just((Object)textOutput);
    }

    public Mono<Object> executeOsCommand(String commandLine) {
        return Mono.deferWithContext(context -> {
            try {
                List command = this.lineParser.parse(commandLine, 0).words();
                String output = new ProcessExecutor().directory(new File((String)context.get((Object)"path"))).command(command).readOutput(true).execute().outputUTF8();
                return Mono.just((Object)output.trim());
            }
            catch (Exception e) {
                return Mono.error((Throwable)e);
            }
        });
    }

    public String formatLineBreak(String textOutput) {
        if (!textOutput.contains("\r\n") && textOutput.contains("\n")) {
            return textOutput.replaceAll("\n", "\r\n");
        }
        return textOutput;
    }

    public String formatObject(@NotNull Object object) {
        if (object instanceof Exception) {
            String message = ((Exception)object).getMessage();
            if (message == null) {
                message = "Null message from exception";
            }
            return new AttributedString((CharSequence)message, AttributedStyle.DEFAULT.foreground(1)).toAnsi();
        }
        if (object instanceof AttributedString) {
            return ((AttributedString)object).toAnsi();
        }
        if (object instanceof CharSequence || object instanceof Number || object instanceof Throwable) {
            return object.toString();
        }
        if (object instanceof Collection) {
            return String.join((CharSequence)"\r\n", (Collection)object);
        }
        String classFullName = object.getClass().getCanonicalName();
        try {
            Method toStringMethod = object.getClass().getDeclaredMethod("toString", new Class[0]);
            if (toStringMethod != null) {
                return object.toString();
            }
        }
        catch (Exception toStringMethod) {
            // empty catch block
        }
        if (classFullName == null) {
            classFullName = object.getClass().getSimpleName();
        }
        if (this.stringOutputClasses.contains(classFullName)) {
            return object.toString();
        }
        if (classFullName.startsWith("java.lang.") && classFullName.matches("java.lang.([A-Z]\\w*)")) {
            return object.toString();
        }
        if (classFullName.startsWith("java.time.")) {
            return object.toString();
        }
        try {
            return "Class: " + classFullName + "\n" + this.objectMapper.writeValueAsString(object);
        }
        catch (Exception ignore) {
            return object.toString();
        }
    }
}

