"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.VictoryChart = void 0;

var _isEmpty2 = _interopRequireDefault(require("lodash/isEmpty"));

var _defaults2 = _interopRequireDefault(require("lodash/defaults"));

var _react = _interopRequireDefault(require("react"));

var _victoryCore = require("victory-core");

var _victorySharedEvents = require("victory-shared-events");

var _victoryAxis = require("victory-axis");

var _victoryPolarAxis = require("victory-polar-axis");

var _helperMethods = require("./helper-methods");

var _reactFastCompare = _interopRequireDefault(require("react-fast-compare"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); enumerableOnly && (symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; })), keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = null != arguments[i] ? arguments[i] : {}; i % 2 ? ownKeys(Object(source), !0).forEach(function (key) { _defineProperty(target, key, source[key]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)) : ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } return target; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

var fallbackProps = {
  width: 450,
  height: 300,
  padding: 50
};
var defaultProps = {
  backgroundComponent: /*#__PURE__*/_react.default.createElement(_victoryCore.Background, null),
  containerComponent: /*#__PURE__*/_react.default.createElement(_victoryCore.VictoryContainer, null),
  defaultAxes: {
    independent: /*#__PURE__*/_react.default.createElement(_victoryAxis.VictoryAxis, null),
    dependent: /*#__PURE__*/_react.default.createElement(_victoryAxis.VictoryAxis, {
      dependentAxis: true
    })
  },
  defaultPolarAxes: {
    independent: /*#__PURE__*/_react.default.createElement(_victoryPolarAxis.VictoryPolarAxis, null),
    dependent: /*#__PURE__*/_react.default.createElement(_victoryPolarAxis.VictoryPolarAxis, {
      dependentAxis: true
    })
  },
  groupComponent: /*#__PURE__*/_react.default.createElement("g", null),
  standalone: true,
  theme: _victoryCore.VictoryTheme.grayscale
};

var VictoryChartImpl = function (initialProps) {
  var propsWithDefaults = _react.default.useMemo(function () {
    return _objectSpread(_objectSpread({}, defaultProps), initialProps);
  }, [initialProps]);

  var role = "chart";

  var _Hooks$useAnimationSt = _victoryCore.Hooks.useAnimationState(),
      getAnimationProps = _Hooks$useAnimationSt.getAnimationProps,
      setAnimationState = _Hooks$useAnimationSt.setAnimationState,
      getProps = _Hooks$useAnimationSt.getProps;

  var props = getProps(propsWithDefaults);

  var modifiedProps = _victoryCore.Helpers.modifyProps(props, fallbackProps, role);

  var desc = modifiedProps.desc,
      eventKey = modifiedProps.eventKey,
      containerComponent = modifiedProps.containerComponent,
      standalone = modifiedProps.standalone,
      groupComponent = modifiedProps.groupComponent,
      externalEventMutations = modifiedProps.externalEventMutations,
      width = modifiedProps.width,
      height = modifiedProps.height,
      theme = modifiedProps.theme,
      polar = modifiedProps.polar,
      name = modifiedProps.name,
      title = modifiedProps.title;
  var axes = props.polar ? modifiedProps.defaultPolarAxes : modifiedProps.defaultAxes;

  var childComponents = _react.default.useMemo(function () {
    return (0, _helperMethods.getChildComponents)(modifiedProps, axes);
  }, [modifiedProps, axes]);

  var calculatedProps = _react.default.useMemo(function () {
    return (0, _helperMethods.getCalculatedProps)(modifiedProps, childComponents);
  }, [modifiedProps, childComponents]);

  var domain = calculatedProps.domain,
      scale = calculatedProps.scale,
      style = calculatedProps.style,
      origin = calculatedProps.origin,
      horizontal = calculatedProps.horizontal;

  var newChildren = _react.default.useMemo(function () {
    var children = (0, _helperMethods.getChildren)(props, childComponents, calculatedProps);
    var mappedChildren = children.map(function (child, index) {
      var childProps = Object.assign({
        animate: getAnimationProps(props, child, index)
      }, child.props);
      return /*#__PURE__*/_react.default.cloneElement(child, childProps);
    });

    if (props.style && props.style.background) {
      var backgroundComponent = (0, _helperMethods.getBackgroundWithProps)(props, calculatedProps);
      mappedChildren.unshift(backgroundComponent);
    }

    return mappedChildren;
  }, [getAnimationProps, childComponents, props, calculatedProps]);

  var containerProps = _react.default.useMemo(function () {
    if (standalone) {
      return {
        desc: desc,
        domain: domain,
        width: width,
        height: height,
        horizontal: horizontal,
        name: name,
        origin: polar ? origin : undefined,
        polar: polar,
        theme: theme,
        title: title,
        scale: scale,
        standalone: standalone,
        style: style.parent
      };
    }

    return {};
  }, [desc, domain, height, horizontal, name, origin, polar, scale, standalone, style, title, theme, width]);

  var container = _react.default.useMemo(function () {
    if (standalone) {
      var defaultContainerProps = (0, _defaults2.default)({}, containerComponent.props, containerProps, _victoryCore.UserProps.getSafeUserProps(propsWithDefaults));
      return /*#__PURE__*/_react.default.cloneElement(containerComponent, defaultContainerProps);
    }

    return groupComponent;
  }, [groupComponent, standalone, containerComponent, containerProps, propsWithDefaults]);

  var events = _react.default.useMemo(function () {
    return _victoryCore.Wrapper.getAllEvents(props);
  }, [props]);

  var previousProps = _victoryCore.Hooks.usePreviousProps(propsWithDefaults);

  _react.default.useEffect(function () {
    // This is called before dismount to keep state in sync
    return function () {
      if (propsWithDefaults.animate) {
        setAnimationState(previousProps, propsWithDefaults);
      }
    };
  }, [setAnimationState, previousProps, propsWithDefaults]);

  if (!(0, _isEmpty2.default)(events)) {
    return /*#__PURE__*/_react.default.createElement(_victorySharedEvents.VictorySharedEvents, {
      container: container,
      eventKey: eventKey,
      events: events,
      externalEventMutations: externalEventMutations
    }, newChildren);
  }

  return /*#__PURE__*/_react.default.cloneElement(container, container.props, newChildren);
};

var VictoryChart = /*#__PURE__*/_react.default.memo(VictoryChartImpl, _reactFastCompare.default);

exports.VictoryChart = VictoryChart;
VictoryChart.displayName = "VictoryChart"; // @ts-expect-error FIXME: Does this "expectedComponents" do anything?

VictoryChart.expectedComponents = ["groupComponent", "containerComponent"];