import _isEmpty from "lodash/isEmpty";
import _defaults from "lodash/defaults";

function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); enumerableOnly && (symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; })), keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = null != arguments[i] ? arguments[i] : {}; i % 2 ? ownKeys(Object(source), !0).forEach(function (key) { _defineProperty(target, key, source[key]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)) : ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } return target; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

import React from "react";
import { Background, Helpers, Hooks, UserProps, VictoryContainer, VictoryTheme, Wrapper } from "victory-core";
import { VictorySharedEvents } from "victory-shared-events";
import { VictoryAxis } from "victory-axis";
import { VictoryPolarAxis } from "victory-polar-axis";
import { getBackgroundWithProps, getChildComponents, getCalculatedProps, getChildren } from "./helper-methods";
import isEqual from "react-fast-compare";
var fallbackProps = {
  width: 450,
  height: 300,
  padding: 50
};
var defaultProps = {
  backgroundComponent: /*#__PURE__*/React.createElement(Background, null),
  containerComponent: /*#__PURE__*/React.createElement(VictoryContainer, null),
  defaultAxes: {
    independent: /*#__PURE__*/React.createElement(VictoryAxis, null),
    dependent: /*#__PURE__*/React.createElement(VictoryAxis, {
      dependentAxis: true
    })
  },
  defaultPolarAxes: {
    independent: /*#__PURE__*/React.createElement(VictoryPolarAxis, null),
    dependent: /*#__PURE__*/React.createElement(VictoryPolarAxis, {
      dependentAxis: true
    })
  },
  groupComponent: /*#__PURE__*/React.createElement("g", null),
  standalone: true,
  theme: VictoryTheme.grayscale
};

var VictoryChartImpl = function (initialProps) {
  var propsWithDefaults = React.useMemo(function () {
    return _objectSpread(_objectSpread({}, defaultProps), initialProps);
  }, [initialProps]);
  var role = "chart";

  var _Hooks$useAnimationSt = Hooks.useAnimationState(),
      getAnimationProps = _Hooks$useAnimationSt.getAnimationProps,
      setAnimationState = _Hooks$useAnimationSt.setAnimationState,
      getProps = _Hooks$useAnimationSt.getProps;

  var props = getProps(propsWithDefaults);
  var modifiedProps = Helpers.modifyProps(props, fallbackProps, role);
  var desc = modifiedProps.desc,
      eventKey = modifiedProps.eventKey,
      containerComponent = modifiedProps.containerComponent,
      standalone = modifiedProps.standalone,
      groupComponent = modifiedProps.groupComponent,
      externalEventMutations = modifiedProps.externalEventMutations,
      width = modifiedProps.width,
      height = modifiedProps.height,
      theme = modifiedProps.theme,
      polar = modifiedProps.polar,
      name = modifiedProps.name,
      title = modifiedProps.title;
  var axes = props.polar ? modifiedProps.defaultPolarAxes : modifiedProps.defaultAxes;
  var childComponents = React.useMemo(function () {
    return getChildComponents(modifiedProps, axes);
  }, [modifiedProps, axes]);
  var calculatedProps = React.useMemo(function () {
    return getCalculatedProps(modifiedProps, childComponents);
  }, [modifiedProps, childComponents]);
  var domain = calculatedProps.domain,
      scale = calculatedProps.scale,
      style = calculatedProps.style,
      origin = calculatedProps.origin,
      horizontal = calculatedProps.horizontal;
  var newChildren = React.useMemo(function () {
    var children = getChildren(props, childComponents, calculatedProps);
    var mappedChildren = children.map(function (child, index) {
      var childProps = Object.assign({
        animate: getAnimationProps(props, child, index)
      }, child.props);
      return /*#__PURE__*/React.cloneElement(child, childProps);
    });

    if (props.style && props.style.background) {
      var backgroundComponent = getBackgroundWithProps(props, calculatedProps);
      mappedChildren.unshift(backgroundComponent);
    }

    return mappedChildren;
  }, [getAnimationProps, childComponents, props, calculatedProps]);
  var containerProps = React.useMemo(function () {
    if (standalone) {
      return {
        desc: desc,
        domain: domain,
        width: width,
        height: height,
        horizontal: horizontal,
        name: name,
        origin: polar ? origin : undefined,
        polar: polar,
        theme: theme,
        title: title,
        scale: scale,
        standalone: standalone,
        style: style.parent
      };
    }

    return {};
  }, [desc, domain, height, horizontal, name, origin, polar, scale, standalone, style, title, theme, width]);
  var container = React.useMemo(function () {
    if (standalone) {
      var defaultContainerProps = _defaults({}, containerComponent.props, containerProps, UserProps.getSafeUserProps(propsWithDefaults));

      return /*#__PURE__*/React.cloneElement(containerComponent, defaultContainerProps);
    }

    return groupComponent;
  }, [groupComponent, standalone, containerComponent, containerProps, propsWithDefaults]);
  var events = React.useMemo(function () {
    return Wrapper.getAllEvents(props);
  }, [props]);
  var previousProps = Hooks.usePreviousProps(propsWithDefaults);
  React.useEffect(function () {
    // This is called before dismount to keep state in sync
    return function () {
      if (propsWithDefaults.animate) {
        setAnimationState(previousProps, propsWithDefaults);
      }
    };
  }, [setAnimationState, previousProps, propsWithDefaults]);

  if (!_isEmpty(events)) {
    return /*#__PURE__*/React.createElement(VictorySharedEvents, {
      container: container,
      eventKey: eventKey,
      events: events,
      externalEventMutations: externalEventMutations
    }, newChildren);
  }

  return /*#__PURE__*/React.cloneElement(container, container.props, newChildren);
};

export var VictoryChart = /*#__PURE__*/React.memo(VictoryChartImpl, isEqual);
VictoryChart.displayName = "VictoryChart"; // @ts-expect-error FIXME: Does this "expectedComponents" do anything?

VictoryChart.expectedComponents = ["groupComponent", "containerComponent"];