/*
 * Decompiled with CFR 0.152.
 */
package org.mvel2.ast;

import org.mvel2.CompileException;
import org.mvel2.DataConversion;
import org.mvel2.Operator;
import org.mvel2.ParserContext;
import org.mvel2.ScriptRuntimeException;
import org.mvel2.ast.ASTNode;
import org.mvel2.ast.BooleanNode;
import org.mvel2.ast.LiteralNode;
import org.mvel2.debug.DebugTools;
import org.mvel2.integration.VariableResolverFactory;
import org.mvel2.math.MathProcessor;
import org.mvel2.util.CompatibilityStrategy;
import org.mvel2.util.CompilerTools;
import org.mvel2.util.NullType;
import org.mvel2.util.ParseTools;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BinaryOperation
extends BooleanNode {
    private final int operation;
    private int lType = -1;
    private int rType = -1;

    public BinaryOperation(int operation, ParserContext ctx) {
        super(ctx);
        this.operation = operation;
    }

    public BinaryOperation(int operation, ASTNode left, ASTNode right, ParserContext ctx) {
        super(ctx);
        this.operation = operation;
        this.left = left;
        if (this.left == null) {
            throw new ScriptRuntimeException("not a statement");
        }
        this.right = right;
        if (this.right == null) {
            throw new ScriptRuntimeException("not a statement");
        }
        switch (operation) {
            case 0: {
                if (left.getEgressType() != String.class && right.getEgressType() != String.class) break;
                this.egressType = String.class;
                this.lType = ParseTools.__resolveType(left.egressType);
                this.rType = ParseTools.__resolveType(right.egressType);
                return;
            }
        }
        if (ctx.isStrongTyping() && !left.getEgressType().isAssignableFrom(right.getEgressType()) && !right.getEgressType().isAssignableFrom(left.getEgressType())) {
            if (right.isLiteral() && DataConversion.canConvert(left.getEgressType(), right.getEgressType())) {
                this.right = new LiteralNode(DataConversion.convert(right.getReducedValueAccelerated(null, null, null), left.getEgressType()), this.pCtx);
            } else if (!this.areCompatible(left.getEgressType(), right.getEgressType()) && (operation != 18 && operation != 19 || !CompatibilityStrategy.areEqualityCompatible(left.getEgressType(), right.getEgressType()))) {
                throw new CompileException("incompatible types in statement: " + right.getEgressType() + " (compared from: " + left.getEgressType() + ")", left.getExpr() != null ? left.getExpr() : right.getExpr(), left.getExpr() != null ? left.getStart() : right.getStart());
            }
        }
        if (this.left.isLiteral() && this.right.isLiteral()) {
            if (this.left.egressType == this.right.egressType) {
                this.lType = this.rType = ParseTools.__resolveType(left.egressType);
            } else {
                this.lType = ParseTools.__resolveType(this.left.egressType);
                this.rType = ParseTools.__resolveType(this.right.egressType);
            }
        }
        this.egressType = CompilerTools.getReturnTypeFromOp(operation, this.left.egressType, this.right.egressType);
    }

    private boolean areCompatible(Class<?> leftClass, Class<?> rightClass) {
        return leftClass.equals(NullType.class) || rightClass.equals(NullType.class) || Number.class.isAssignableFrom(rightClass) && Number.class.isAssignableFrom(leftClass) || (rightClass.isPrimitive() || leftClass.isPrimitive()) && DataConversion.canConvert(ParseTools.boxPrimitive(leftClass), ParseTools.boxPrimitive(rightClass));
    }

    @Override
    public Object getReducedValueAccelerated(Object ctx, Object thisValue, VariableResolverFactory factory) {
        return MathProcessor.doOperations(this.lType, this.left.getReducedValueAccelerated(ctx, thisValue, factory), this.operation, this.rType, this.right.getReducedValueAccelerated(ctx, thisValue, factory));
    }

    @Override
    public Object getReducedValue(Object ctx, Object thisValue, VariableResolverFactory factory) {
        throw new RuntimeException("unsupported AST operation");
    }

    public int getOperation() {
        return this.operation;
    }

    public BinaryOperation getRightBinary() {
        return this.right != null && this.right instanceof BinaryOperation ? (BinaryOperation)this.right : null;
    }

    @Override
    public void setRightMost(ASTNode right) {
        BinaryOperation n = this;
        while (n.right != null && n.right instanceof BinaryOperation) {
            n = (BinaryOperation)n.right;
        }
        n.right = right;
        if (n == this && (this.rType = ParseTools.__resolveType(n.right.getEgressType())) == 0) {
            this.rType = -1;
        }
    }

    @Override
    public ASTNode getRightMost() {
        BinaryOperation n = this;
        while (n.right != null && n.right instanceof BinaryOperation) {
            n = (BinaryOperation)n.right;
        }
        return n.right;
    }

    public int getPrecedence() {
        return Operator.PTABLE[this.operation];
    }

    public boolean isGreaterPrecedence(BinaryOperation o) {
        return o.getPrecedence() > Operator.PTABLE[this.operation];
    }

    @Override
    public boolean isLiteral() {
        return false;
    }

    @Override
    public String toString() {
        return "(" + this.left + " " + DebugTools.getOperatorSymbol(this.operation) + " " + this.right + ")";
    }
}

