/*
 * Decompiled with CFR 0.152.
 */
package org.mvel2.ast;

import org.mvel2.CompileException;
import org.mvel2.ast.ASTNode;
import org.mvel2.integration.VariableResolverFactory;
import org.mvel2.util.ParseTools;

public class ImportNode
extends ASTNode {
    private Class importClass;
    private boolean packageImport;
    private int _offset;
    private static final char[] WC_TEST = new char[]{'.', '*'};

    public ImportNode(char[] expr, int start, int offset) {
        this.expr = expr;
        this.start = start;
        this.offset = offset;
        if (ParseTools.endsWith(expr, start, offset, WC_TEST)) {
            this.packageImport = true;
            this._offset = (short)ParseTools.findLast(expr, start, offset, '.');
            if (this._offset == -1) {
                this._offset = 0;
            }
        } else {
            String clsName = new String(expr, start, offset);
            try {
                this.importClass = Class.forName(clsName, true, Thread.currentThread().getContextClassLoader());
            }
            catch (ClassNotFoundException e) {
                int idx = clsName.lastIndexOf(46);
                clsName = (clsName.substring(0, idx) + "$" + clsName.substring(idx + 1)).trim();
                try {
                    this.importClass = Class.forName(clsName, true, Thread.currentThread().getContextClassLoader());
                }
                catch (ClassNotFoundException e2) {
                    throw new CompileException("class not found: " + new String(expr), expr, start);
                }
            }
        }
    }

    public Object getReducedValueAccelerated(Object ctx, Object thisValue, VariableResolverFactory factory) {
        if (!this.packageImport) {
            return ParseTools.findClassImportResolverFactory(factory).addClass(this.importClass);
        }
        ParseTools.findClassImportResolverFactory(factory).addPackageImport(new String(this.expr, this.start, this._offset - this.start));
        return null;
    }

    public Object getReducedValue(Object ctx, Object thisValue, VariableResolverFactory factory) {
        return this.getReducedValueAccelerated(ctx, thisValue, factory);
    }

    public Class getImportClass() {
        return this.importClass;
    }

    public boolean isPackageImport() {
        return this.packageImport;
    }

    public void setPackageImport(boolean packageImport) {
        this.packageImport = packageImport;
    }

    public String getPackageImport() {
        return new String(this.expr, this.start, this._offset - this.start);
    }
}

