/*
 * Decompiled with CFR 0.152.
 */
package org.mvel2.optimizers.impl.refl;

import java.lang.reflect.Method;
import org.mvel2.CompileException;
import org.mvel2.MVEL;
import org.mvel2.compiler.AccessorNode;
import org.mvel2.integration.VariableResolverFactory;

public class GetterAccessor
implements AccessorNode {
    private AccessorNode nextNode;
    private final Method method;
    public static final Object[] EMPTY = new Object[0];

    public Object getValue(Object ctx, Object elCtx, VariableResolverFactory vars) {
        try {
            if (this.nextNode != null) {
                return this.nextNode.getValue(this.method.invoke(ctx, EMPTY), elCtx, vars);
            }
            return this.method.invoke(ctx, EMPTY);
        }
        catch (IllegalArgumentException e) {
            if (this.nextNode != null) {
                return this.nextNode.getValue(MVEL.getProperty(this.method.getName() + "()", ctx), elCtx, vars);
            }
            return MVEL.getProperty(this.method.getName() + "()", ctx);
        }
        catch (Exception e) {
            throw new CompileException("cannot invoke getter: " + this.method.getName() + " [declr.class: " + this.method.getDeclaringClass().getName() + "; act.class: " + (ctx != null ? ctx.getClass().getName() : "null") + "]", e);
        }
    }

    public GetterAccessor(Method method) {
        this.method = method;
    }

    public Method getMethod() {
        return this.method;
    }

    public AccessorNode setNextNode(AccessorNode nextNode) {
        this.nextNode = nextNode;
        return this.nextNode;
    }

    public AccessorNode getNextNode() {
        return this.nextNode;
    }

    public String toString() {
        return this.method.getDeclaringClass().getName() + "." + this.method.getName();
    }

    public Object setValue(Object ctx, Object elCtx, VariableResolverFactory vars, Object value) {
        try {
            if (this.nextNode != null) {
                return this.nextNode.setValue(this.method.invoke(ctx, EMPTY), elCtx, vars, value);
            }
            throw new CompileException("bad payload");
        }
        catch (IllegalArgumentException e) {
            if (this.nextNode != null) {
                return this.nextNode.setValue(MVEL.getProperty(this.method.getName() + "()", ctx), elCtx, vars, value);
            }
            return MVEL.getProperty(this.method.getName() + "()", ctx);
        }
        catch (CompileException e) {
            throw e;
        }
        catch (Exception e) {
            throw new CompileException("error " + this.method.getName() + ": " + e.getClass().getName() + ":" + e.getMessage(), e);
        }
    }

    public Class getKnownEgressType() {
        return this.method.getReturnType();
    }
}

