/*
 * Decompiled with CFR 0.152.
 */
package org.mvel2.ast;

import org.mvel2.CompileException;
import org.mvel2.MVEL;
import org.mvel2.ast.ASTNode;
import org.mvel2.compiler.ExecutableStatement;
import org.mvel2.integration.VariableResolverFactory;
import org.mvel2.util.ParseTools;

public class AssertNode
extends ASTNode {
    public ExecutableStatement assertion;

    public AssertNode(char[] expr, int fields) {
        this.name = expr;
        if ((fields & 0x10) != 0) {
            this.assertion = (ExecutableStatement)ParseTools.subCompileExpression(expr);
        }
    }

    public Object getReducedValueAccelerated(Object ctx, Object thisValue, VariableResolverFactory factory) {
        try {
            Boolean bool = (Boolean)this.assertion.getValue(ctx, thisValue, factory);
            if (!bool.booleanValue()) {
                throw new AssertionError((Object)("assertion failed in expression: " + new String(this.name)));
            }
            return bool;
        }
        catch (ClassCastException e) {
            throw new CompileException("assertion does not contain a boolean statement");
        }
    }

    public Object getReducedValue(Object ctx, Object thisValue, VariableResolverFactory factory) {
        try {
            Boolean bool = (Boolean)MVEL.eval(this.name, ctx, factory);
            if (!bool.booleanValue()) {
                throw new AssertionError((Object)("assertion failed in expression: " + new String(this.name)));
            }
            return bool;
        }
        catch (ClassCastException e) {
            throw new CompileException("assertion does not contain a boolean statement");
        }
    }
}

