/*
 * Decompiled with CFR 0.152.
 */
package org.mvel2.optimizers.impl.refl;

import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import org.mvel2.CompileException;
import org.mvel2.ConversionException;
import org.mvel2.DataConversion;
import org.mvel2.MVEL;
import org.mvel2.OptimizationFailure;
import org.mvel2.ParserContext;
import org.mvel2.PropertyAccessException;
import org.mvel2.ast.Function;
import org.mvel2.ast.TypeDescriptor;
import org.mvel2.compiler.Accessor;
import org.mvel2.compiler.AccessorNode;
import org.mvel2.compiler.ExecutableStatement;
import org.mvel2.compiler.PropertyVerifier;
import org.mvel2.integration.PropertyHandlerFactory;
import org.mvel2.integration.VariableResolver;
import org.mvel2.integration.VariableResolverFactory;
import org.mvel2.optimizers.AbstractOptimizer;
import org.mvel2.optimizers.AccessorOptimizer;
import org.mvel2.optimizers.impl.refl.ArrayAccessor;
import org.mvel2.optimizers.impl.refl.ArrayAccessorNest;
import org.mvel2.optimizers.impl.refl.ArrayLength;
import org.mvel2.optimizers.impl.refl.ConstructorAccessor;
import org.mvel2.optimizers.impl.refl.DynamicFieldAccessor;
import org.mvel2.optimizers.impl.refl.FieldAccessor;
import org.mvel2.optimizers.impl.refl.FunctionAccessor;
import org.mvel2.optimizers.impl.refl.GetterAccessor;
import org.mvel2.optimizers.impl.refl.IndexedCharSeqAccessor;
import org.mvel2.optimizers.impl.refl.IndexedCharSeqAccessorNest;
import org.mvel2.optimizers.impl.refl.IndexedVariableAccessor;
import org.mvel2.optimizers.impl.refl.ListAccessor;
import org.mvel2.optimizers.impl.refl.ListAccessorNest;
import org.mvel2.optimizers.impl.refl.MapAccessor;
import org.mvel2.optimizers.impl.refl.MapAccessorNest;
import org.mvel2.optimizers.impl.refl.MethodAccessor;
import org.mvel2.optimizers.impl.refl.PropertyHandlerAccessor;
import org.mvel2.optimizers.impl.refl.SetterAccessor;
import org.mvel2.optimizers.impl.refl.StaticReferenceAccessor;
import org.mvel2.optimizers.impl.refl.StaticVarAccessor;
import org.mvel2.optimizers.impl.refl.ThisValueAccessor;
import org.mvel2.optimizers.impl.refl.Union;
import org.mvel2.optimizers.impl.refl.VariableAccessor;
import org.mvel2.optimizers.impl.refl.WithAccessor;
import org.mvel2.optimizers.impl.refl.collection.ArrayCreator;
import org.mvel2.optimizers.impl.refl.collection.ExprValueAccessor;
import org.mvel2.optimizers.impl.refl.collection.ListCreator;
import org.mvel2.optimizers.impl.refl.collection.MapCreator;
import org.mvel2.util.ArrayTools;
import org.mvel2.util.CompilerTools;
import org.mvel2.util.MethodStub;
import org.mvel2.util.ParseTools;
import org.mvel2.util.PropertyTools;
import org.mvel2.util.StringAppender;

public class ReflectiveAccessorOptimizer
extends AbstractOptimizer
implements AccessorOptimizer {
    private AccessorNode rootNode;
    private AccessorNode currNode;
    private Object ctx;
    private Object thisRef;
    private Object val;
    private VariableResolverFactory variableFactory;
    private static final int DONE = -1;
    private static final Object[] EMPTYARG = new Object[0];
    private static final Class[] EMPTYCLS = new Class[0];
    private boolean first = true;
    private boolean literal = false;
    private static final Map<Integer, Accessor> REFLECTIVE_ACCESSOR_CACHE = new WeakHashMap<Integer, Accessor>();
    private Class returnType;

    public ReflectiveAccessorOptimizer() {
    }

    public void init() {
    }

    private ReflectiveAccessorOptimizer(ParserContext pCtx, char[] property, Object ctx, Object thisRef, VariableResolverFactory variableFactory) {
        this.pCtx = pCtx;
        this.expr = property;
        this.length = property != null ? property.length : 0;
        this.ctx = ctx;
        this.variableFactory = variableFactory;
        this.thisRef = thisRef;
    }

    private static int createSignatureHash(String expr, Object ctx) {
        if (ctx == null) {
            return expr.hashCode();
        }
        return expr.hashCode() + ctx.getClass().hashCode();
    }

    public static Object get(String expression, Object ctx) {
        int hash = ReflectiveAccessorOptimizer.createSignatureHash(expression, ctx);
        Accessor accessor = REFLECTIVE_ACCESSOR_CACHE.get(hash);
        if (accessor != null) {
            return accessor.getValue(ctx, null, null);
        }
        accessor = new ReflectiveAccessorOptimizer().optimizeAccessor(ReflectiveAccessorOptimizer.getCurrentThreadParserContext(), expression.toCharArray(), ctx, null, null, false);
        REFLECTIVE_ACCESSOR_CACHE.put(hash, accessor);
        return accessor.getValue(ctx, null, null);
    }

    public Accessor optimizeAccessor(ParserContext pCtx, char[] property, Object ctx, Object thisRef, VariableResolverFactory factory, boolean root) {
        this.currNode = null;
        this.rootNode = null;
        this.cursor = 0;
        this.start = 0;
        this.first = true;
        this.expr = property;
        this.length = property.length;
        this.ctx = ctx;
        this.thisRef = thisRef;
        this.variableFactory = factory;
        this.pCtx = pCtx;
        return this.compileGetChain();
    }

    public Accessor optimizeSetAccessor(ParserContext pCtx, char[] property, Object ctx, Object thisRef, VariableResolverFactory factory, boolean rootThisRef, Object value) {
        block20: {
            this.currNode = null;
            this.rootNode = null;
            this.cursor = 0;
            this.start = 0;
            this.first = true;
            this.expr = property;
            this.length = property.length;
            this.ctx = ctx;
            this.thisRef = thisRef;
            this.variableFactory = factory;
            char[] root = null;
            int split = this.findLastUnion();
            this.pCtx = pCtx;
            PropertyVerifier verifier = new PropertyVerifier(property, this.pCtx);
            if (split != -1) {
                root = ParseTools.subset(property, 0, split++);
                property = ParseTools.subset(property, split, property.length - split);
            }
            if (root != null) {
                this.expr = root;
                this.length = root.length;
                this.compileGetChain();
                ctx = this.val;
            }
            try {
                this.expr = property;
                this.length = property.length;
                this.start = 0;
                this.cursor = 0;
                this.whiteSpaceSkip();
                if (this.collection) {
                    int start = this.cursor;
                    this.whiteSpaceSkip();
                    if (this.cursor == this.length) {
                        throw new PropertyAccessException("unterminated '['");
                    }
                    if (this.scanTo(']')) {
                        throw new PropertyAccessException("unterminated '['");
                    }
                    String ex = new String(property, start, this.cursor - start);
                    if (ctx instanceof Map) {
                        this.returnType = verifier.analyze();
                        ((Map)ctx).put(MVEL.eval(ex, ctx, this.variableFactory), DataConversion.convert(value, this.returnType));
                        this.addAccessorNode(new MapAccessorNest(ex, this.returnType));
                        return this.rootNode;
                    }
                    if (ctx instanceof List) {
                        this.returnType = verifier.analyze();
                        ((List)ctx).set(MVEL.eval(ex, ctx, this.variableFactory, Integer.class), DataConversion.convert(value, this.returnType));
                        this.addAccessorNode(new ListAccessorNest(ex, this.returnType));
                        return this.rootNode;
                    }
                    if (ctx.getClass().isArray()) {
                        Array.set(ctx, MVEL.eval(ex, ctx, this.variableFactory, Integer.class), DataConversion.convert(value, ParseTools.getBaseComponentType(ctx.getClass())));
                        this.addAccessorNode(new ArrayAccessorNest(ex));
                        return this.rootNode;
                    }
                    throw new PropertyAccessException("cannot bind to collection property: " + new String(property) + ": not a recognized collection type: " + ctx.getClass());
                }
                String tk = new String(property);
                Member member = PropertyTools.getFieldOrWriteAccessor(ctx.getClass(), tk);
                if (member instanceof Field) {
                    Field fld = (Field)member;
                    if (value != null && !fld.getType().isAssignableFrom(value.getClass())) {
                        if (!DataConversion.canConvert(fld.getType(), value.getClass())) {
                            throw new ConversionException("cannot convert type: " + value.getClass() + ": to " + fld.getType());
                        }
                        fld.set(ctx, DataConversion.convert(value, fld.getType()));
                        this.addAccessorNode(new DynamicFieldAccessor(fld));
                    } else {
                        fld.set(ctx, value);
                        this.addAccessorNode(new FieldAccessor(fld));
                    }
                    break block20;
                }
                if (member != null) {
                    Method meth = (Method)member;
                    if (value != null && !meth.getParameterTypes()[0].isAssignableFrom(value.getClass())) {
                        if (!DataConversion.canConvert(meth.getParameterTypes()[0], value.getClass())) {
                            throw new ConversionException("cannot convert type: " + value.getClass() + ": to " + meth.getParameterTypes()[0]);
                        }
                        meth.invoke(ctx, DataConversion.convert(value, meth.getParameterTypes()[0]));
                    } else {
                        meth.invoke(ctx, value);
                    }
                    this.addAccessorNode(new SetterAccessor(meth));
                    break block20;
                }
                if (ctx instanceof Map) {
                    ((Map)ctx).put(tk, value);
                    this.addAccessorNode(new MapAccessor(tk));
                    break block20;
                }
                throw new PropertyAccessException("could not access property (" + tk + ") in: " + ctx.getClass().getName());
            }
            catch (InvocationTargetException e) {
                throw new PropertyAccessException("could not access property", e);
            }
            catch (IllegalAccessException e) {
                throw new PropertyAccessException("could not access property", e);
            }
        }
        return this.rootNode;
    }

    private Accessor compileGetChain() {
        Object curr = this.ctx;
        try {
            while (this.cursor < this.length) {
                switch (this.nextSubToken()) {
                    case 0: {
                        curr = this.getBeanProperty(curr, this.capture());
                        break;
                    }
                    case 1: {
                        curr = this.getMethod(curr, this.capture());
                        break;
                    }
                    case 2: {
                        curr = this.getCollectionProperty(curr, this.capture());
                        break;
                    }
                    case 3: {
                        curr = this.getWithProperty(curr);
                        break;
                    }
                }
                this.first = false;
                if (curr == null) continue;
                this.returnType = curr.getClass();
            }
            this.val = curr;
            if (this.pCtx.isStrongTyping()) {
                this.returnType = new PropertyVerifier(this.expr, this.pCtx).analyze();
            }
            return this.rootNode;
        }
        catch (InvocationTargetException e) {
            throw new PropertyAccessException(new String(this.expr), e);
        }
        catch (IllegalAccessException e) {
            throw new PropertyAccessException(new String(this.expr), e);
        }
        catch (IndexOutOfBoundsException e) {
            throw new PropertyAccessException(new String(this.expr) + ": array index out of bounds.", e);
        }
        catch (PropertyAccessException e) {
            throw new CompileException(e.getMessage(), e);
        }
        catch (CompileException e) {
            throw e;
        }
        catch (NullPointerException e) {
            throw new PropertyAccessException(new String(this.expr), e);
        }
        catch (Exception e) {
            throw new CompileException(e.getMessage(), e);
        }
    }

    private void addAccessorNode(AccessorNode an) {
        if (this.rootNode == null) {
            this.rootNode = this.currNode = an;
        } else {
            this.currNode = this.currNode.setNextNode(an);
        }
    }

    private Object getWithProperty(Object ctx) {
        String root = new String(this.expr, 0, this.cursor - 1).trim();
        int start = this.cursor + 1;
        int[] res = ParseTools.balancedCaptureWithLineAccounting(this.expr, this.cursor, '{');
        this.cursor = res[0];
        this.getParserContext().incrementLineCount(res[1]);
        WithAccessor wa = new WithAccessor(root, ParseTools.subset(this.expr, start, this.cursor++ - start));
        this.addAccessorNode(wa);
        return wa.getValue(ctx, this.thisRef, this.variableFactory);
    }

    private Object getBeanProperty(Object ctx, String property) throws Exception {
        Member member;
        Class<?> cls;
        if (this.first) {
            if ("this".equals(property)) {
                this.addAccessorNode(new ThisValueAccessor());
                return this.thisRef;
            }
            if (this.variableFactory != null && this.variableFactory.isResolveable(property)) {
                if (this.variableFactory.isIndexedFactory() && this.variableFactory.isTarget(property)) {
                    int idx = this.variableFactory.variableIndexOf(property);
                    this.addAccessorNode(new IndexedVariableAccessor(idx));
                    VariableResolver vr = this.variableFactory.getIndexedVariableResolver(idx);
                    if (vr == null) {
                        this.variableFactory.setIndexedVariableResolver(idx, this.variableFactory.getVariableResolver(property));
                    }
                    return this.variableFactory.getIndexedVariableResolver(idx).getValue();
                }
                this.addAccessorNode(new VariableAccessor(property));
                return this.variableFactory.getVariableResolver(property).getValue();
            }
        }
        Class<Object> clazz = ctx instanceof Class ? (Class<?>)ctx : (cls = ctx != null ? ctx.getClass() : null);
        if (PropertyHandlerFactory.hasPropertyHandler(cls)) {
            PropertyHandlerAccessor acc = new PropertyHandlerAccessor(property, PropertyHandlerFactory.getPropertyHandler(cls));
            this.addAccessorNode(acc);
            return acc.getValue(ctx, this.thisRef, this.variableFactory);
        }
        Member member2 = member = cls != null ? PropertyTools.getFieldOrAccessor(cls, property) : null;
        if (member instanceof Method) {
            Object o;
            try {
                o = ((Method)member).invoke(ctx, EMPTYARG);
                this.addAccessorNode(new GetterAccessor((Method)member));
            }
            catch (IllegalAccessException e) {
                Method iFaceMeth = ParseTools.determineActualTargetMethod((Method)member);
                if (iFaceMeth == null) {
                    throw new PropertyAccessException("could not access field: " + cls.getName() + "." + property);
                }
                this.addAccessorNode(new GetterAccessor(iFaceMeth));
                o = iFaceMeth.invoke(ctx, EMPTYARG);
            }
            return o;
        }
        if (member != null) {
            this.addAccessorNode(new FieldAccessor((Field)member));
            return ((Field)member).get(ctx);
        }
        if (ctx instanceof Map && ((Map)ctx).containsKey(property)) {
            this.addAccessorNode(new MapAccessor(property));
            return ((Map)ctx).get(property);
        }
        if ("length".equals(property) && ctx.getClass().isArray()) {
            this.addAccessorNode(new ArrayLength());
            return Array.getLength(ctx);
        }
        if (LITERALS.containsKey(property)) {
            ctx = LITERALS.get(property);
            this.addAccessorNode(new StaticReferenceAccessor(ctx));
            return ctx;
        }
        Object tryStaticMethodRef = this.tryStaticAccess();
        if (tryStaticMethodRef != null) {
            if (tryStaticMethodRef instanceof Class) {
                this.addAccessorNode(new StaticReferenceAccessor(tryStaticMethodRef));
                return tryStaticMethodRef;
            }
            if (tryStaticMethodRef instanceof Field) {
                this.addAccessorNode(new StaticVarAccessor((Field)tryStaticMethodRef));
                return ((Field)tryStaticMethodRef).get(null);
            }
            this.addAccessorNode(new StaticReferenceAccessor(tryStaticMethodRef));
            return tryStaticMethodRef;
        }
        if (ctx instanceof Class) {
            Class c = (Class)ctx;
            for (Method m : c.getMethods()) {
                if (!property.equals(m.getName())) continue;
                if (MVEL.COMPILER_OPT_ALLOW_NAKED_METH_CALL) {
                    this.addAccessorNode(new MethodAccessor(m, new ExecutableStatement[0]));
                    return m.invoke(null, ParseTools.EMPTY_OBJ_ARR);
                }
                this.addAccessorNode(new StaticReferenceAccessor(m));
                return m;
            }
        } else if (MVEL.COMPILER_OPT_ALLOW_NAKED_METH_CALL) {
            return this.getMethod(ctx, property);
        }
        throw new PropertyAccessException(property);
    }

    private Object getCollectionProperty(Object ctx, String prop) throws Exception {
        if (prop.length() > 0) {
            ctx = this.getBeanProperty(ctx, prop);
        }
        int start = ++this.cursor;
        this.whiteSpaceSkip();
        if (this.cursor == this.length) {
            throw new CompileException("unterminated '['");
        }
        if (this.scanTo(']')) {
            throw new CompileException("unterminated '['");
        }
        String item = new String(this.expr, start, this.cursor - start);
        boolean itemSubExpr = true;
        Object idx = null;
        try {
            idx = Integer.parseInt(item);
            itemSubExpr = false;
        }
        catch (Exception e) {
            // empty catch block
        }
        ExecutableStatement itemStmt = null;
        if (itemSubExpr) {
            itemStmt = (ExecutableStatement)ParseTools.subCompileExpression(item.toCharArray());
            idx = itemStmt.getValue(ctx, this.thisRef, this.variableFactory);
        }
        ++this.cursor;
        if (ctx instanceof Map) {
            if (itemSubExpr) {
                this.addAccessorNode(new MapAccessorNest(itemStmt, null));
            } else {
                this.addAccessorNode(new MapAccessor(Integer.parseInt(item)));
            }
            return ((Map)ctx).get(idx);
        }
        if (ctx instanceof List) {
            if (itemSubExpr) {
                this.addAccessorNode(new ListAccessorNest(itemStmt, null));
            } else {
                this.addAccessorNode(new ListAccessor(Integer.parseInt(item)));
            }
            return ((List)ctx).get((Integer)idx);
        }
        if (ctx.getClass().isArray()) {
            if (itemSubExpr) {
                this.addAccessorNode(new ArrayAccessorNest(itemStmt));
            } else {
                this.addAccessorNode(new ArrayAccessor(Integer.parseInt(item)));
            }
            return Array.get(ctx, (Integer)idx);
        }
        if (ctx instanceof CharSequence) {
            if (itemSubExpr) {
                this.addAccessorNode(new IndexedCharSeqAccessorNest(itemStmt));
            } else {
                this.addAccessorNode(new IndexedCharSeqAccessor(Integer.parseInt(item)));
            }
            return Character.valueOf(((CharSequence)ctx).charAt((Integer)idx));
        }
        TypeDescriptor tDescr = new TypeDescriptor(this.expr, 0);
        if (tDescr.isArray()) {
            Class cls = TypeDescriptor.getClassReference((Class)ctx, tDescr, this.variableFactory);
            this.rootNode = new StaticReferenceAccessor(cls);
            return cls;
        }
        throw new CompileException("illegal use of []: unknown type: " + (ctx == null ? null : ctx.getClass().getName()));
    }

    private Object getMethod(Object ctx, String name) throws Exception {
        Accessor[] es;
        Object[] args;
        int st = this.cursor;
        String tk = this.cursor != this.length && (this.cursor = ParseTools.balancedCapture(this.expr, this.cursor, '(')) - st > 1 ? new String(this.expr, st + 1, this.cursor - st - 1) : "";
        ++this.cursor;
        if (tk.length() == 0) {
            args = ParseTools.EMPTY_OBJ_ARR;
            es = null;
        } else {
            String[] subtokens = ParseTools.parseParameterList(tk.toCharArray(), 0, -1);
            es = new ExecutableStatement[subtokens.length];
            args = new Object[subtokens.length];
            for (int i = 0; i < subtokens.length; ++i) {
                es[i] = (ExecutableStatement)ParseTools.subCompileExpression(subtokens[i].toCharArray());
                args[i] = es[i].getValue(this.ctx, this.thisRef, this.variableFactory);
            }
        }
        if (this.first && this.variableFactory != null && this.variableFactory.isResolveable(name)) {
            Object ptr = this.variableFactory.getVariableResolver(name).getValue();
            if (ptr instanceof Method) {
                ctx = ((Method)ptr).getDeclaringClass();
                name = ((Method)ptr).getName();
            } else if (ptr instanceof MethodStub) {
                ctx = ((MethodStub)ptr).getClassReference();
                name = ((MethodStub)ptr).getMethodName();
            } else {
                if (ptr instanceof Function) {
                    this.addAccessorNode(new FunctionAccessor((Function)ptr, es));
                    Object[] parm = null;
                    if (es != null) {
                        parm = new Object[es.length];
                        for (int i = 0; i < es.length; ++i) {
                            parm[i] = es[i].getValue(ctx, this.thisRef, this.variableFactory);
                        }
                    }
                    return ((Function)ptr).call(ctx, this.thisRef, this.variableFactory, parm);
                }
                throw new OptimizationFailure("attempt to optimize a method call for a reference that does not point to a method: " + name + " (reference is type: " + (ctx != null ? ctx.getClass().getName() : null) + ")");
            }
            this.first = false;
        }
        Class<?> cls = ctx instanceof Class ? (Class<?>)ctx : ctx.getClass();
        Class<?>[] parameterTypes = null;
        Method m = ParseTools.getBestCandidate(args, name, cls, cls.getMethods(), false);
        if (m != null) {
            parameterTypes = m.getParameterTypes();
        }
        if (m == null && (m = ParseTools.getBestCandidate(args, name, cls, cls.getClass().getDeclaredMethods(), false)) != null) {
            parameterTypes = m.getParameterTypes();
        }
        if (m == null) {
            StringAppender errorBuild = new StringAppender();
            for (int i = 0; i < args.length; ++i) {
                errorBuild.append(args[i] != null ? args[i].getClass().getName() : null);
                if (i >= args.length - 1) continue;
                errorBuild.append(", ");
            }
            if ("size".equals(name) && args.length == 0 && cls.isArray()) {
                this.addAccessorNode(new ArrayLength());
                return Array.getLength(ctx);
            }
            throw new PropertyAccessException("unable to resolve method: " + cls.getName() + "." + name + "(" + errorBuild.toString() + ") [arglength=" + args.length + "]");
        }
        if (es != null) {
            for (int i = 0; i < es.length; ++i) {
                ExecutableStatement cExpr = (ExecutableStatement)es[i];
                if (cExpr.getKnownIngressType() == null) {
                    cExpr.setKnownIngressType(parameterTypes[i]);
                    cExpr.computeTypeConversionRule();
                }
                if (cExpr.isConvertableIngressEgress()) continue;
                args[i] = DataConversion.convert(args[i], parameterTypes[i]);
            }
        } else {
            for (int i = 0; i < args.length; ++i) {
                args[i] = DataConversion.convert(args[i], parameterTypes[i]);
            }
        }
        this.addAccessorNode(new MethodAccessor(ParseTools.getWidenedTarget(m), (ExecutableStatement[])es));
        return m.invoke((Object)ctx, args);
    }

    public Object getValue(Object ctx, Object elCtx, VariableResolverFactory variableFactory) throws Exception {
        return this.rootNode.getValue(ctx, elCtx, variableFactory);
    }

    private Accessor _getAccessor(Object o, Class type) {
        if (o instanceof List) {
            Accessor[] a = new Accessor[((List)o).size()];
            int i = 0;
            for (Object item : (List)o) {
                a[i++] = this._getAccessor(item, type);
            }
            this.returnType = List.class;
            return new ListCreator(a);
        }
        if (o instanceof Map) {
            Accessor[] k = new Accessor[((Map)o).size()];
            Accessor[] v = new Accessor[k.length];
            int i = 0;
            for (Object item : ((Map)o).keySet()) {
                k[i] = this._getAccessor(item, type);
                v[i++] = this._getAccessor(((Map)o).get(item), type);
            }
            this.returnType = Map.class;
            return new MapCreator(k, v);
        }
        if (o instanceof Object[]) {
            Accessor[] a = new Accessor[((Object[])o).length];
            int i = 0;
            int dim = 0;
            if (type != null) {
                String nm = type.getName();
                while (nm.charAt(dim) == '[') {
                    ++dim;
                }
            } else {
                type = Object[].class;
                dim = 1;
            }
            try {
                Class base = ParseTools.getBaseComponentType(type);
                Class cls = dim > 1 ? ParseTools.findClass(null, ParseTools.repeatChar('[', dim - 1) + "L" + base.getName() + ";") : type;
                for (Object item : (Object[])o) {
                    int n = i++;
                    Accessor accessor = this._getAccessor(item, cls);
                    a[n] = accessor;
                    CompilerTools.expectType(accessor, base, true);
                }
                return new ArrayCreator(a, ParseTools.getSubComponentType(type));
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException("this error should never throw:" + ParseTools.getBaseComponentType(type).getName(), e);
            }
        }
        if (this.returnType == null) {
            this.returnType = Object.class;
        }
        if (type.isArray()) {
            return new ExprValueAccessor((String)o, type);
        }
        return new ExprValueAccessor((String)o);
    }

    public Accessor optimizeCollection(Object o, Class type, char[] property, Object ctx, Object thisRef, VariableResolverFactory factory) {
        this.returnType = type;
        Accessor root = this._getAccessor(o, this.returnType);
        if (property != null && property.length > 0) {
            return new Union(root, property);
        }
        return root;
    }

    public Accessor optimizeObjectCreation(ParserContext pCtx, char[] property, Object ctx, Object thisRef, VariableResolverFactory factory) {
        this.expr = property;
        this.length = property.length;
        this.cursor = 0;
        this.pCtx = pCtx;
        try {
            return this.compileConstructor(property, ctx, factory);
        }
        catch (CompileException e) {
            throw e;
        }
        catch (Exception e) {
            throw new CompileException("could not create constructor: " + e.getMessage(), e);
        }
    }

    private void setRootNode(AccessorNode rootNode) {
        this.rootNode = this.currNode = rootNode;
    }

    private AccessorNode getRootNode() {
        return this.rootNode;
    }

    public Object getResultOptPass() {
        return this.val;
    }

    public AccessorNode compileConstructor(char[] expression, Object ctx, VariableResolverFactory vars) throws InstantiationException, IllegalAccessException, InvocationTargetException, ClassNotFoundException, NoSuchMethodException {
        String[] cnsRes = ParseTools.captureContructorAndResidual(expression);
        String[] constructorParms = ParseTools.parseMethodOrConstructor(cnsRes[0].toCharArray());
        if (constructorParms != null) {
            String s = new String(ParseTools.subset(expression, 0, ArrayTools.findFirst('(', expression)));
            Class cls = ParseTools.findClass(vars, s);
            ExecutableStatement[] cStmts = new ExecutableStatement[constructorParms.length];
            for (int i = 0; i < constructorParms.length; ++i) {
                cStmts[i] = (ExecutableStatement)ParseTools.subCompileExpression(constructorParms[i].toCharArray());
            }
            Object[] parms = new Object[constructorParms.length];
            for (int i = 0; i < constructorParms.length; ++i) {
                parms[i] = cStmts[i].getValue(ctx, vars);
            }
            Constructor cns = ParseTools.getBestConstructorCanadidate(parms, cls);
            if (cns == null) {
                throw new CompileException("unable to find constructor for: " + cls.getName());
            }
            for (int i = 0; i < parms.length; ++i) {
                parms[i] = DataConversion.convert(parms[i], cns.getParameterTypes()[i]);
            }
            AccessorNode ca = new ConstructorAccessor(cns, cStmts);
            if (cnsRes.length > 1) {
                ReflectiveAccessorOptimizer compiledOptimizer = new ReflectiveAccessorOptimizer(this.pCtx, cnsRes[1].toCharArray(), cns.newInstance(parms), ctx, vars);
                compiledOptimizer.setRootNode(ca);
                compiledOptimizer.compileGetChain();
                ca = compiledOptimizer.getRootNode();
                this.val = compiledOptimizer.getResultOptPass();
            }
            return ca;
        }
        Constructor<?> cns = Thread.currentThread().getContextClassLoader().loadClass(new String(expression)).getConstructor(EMPTYCLS);
        AccessorNode ca = new ConstructorAccessor(cns, null);
        if (cnsRes.length > 1) {
            ReflectiveAccessorOptimizer compiledOptimizer = new ReflectiveAccessorOptimizer(ReflectiveAccessorOptimizer.getCurrentThreadParserContext(), cnsRes[1].toCharArray(), cns.newInstance(null), ctx, vars);
            compiledOptimizer.setRootNode(ca);
            compiledOptimizer.compileGetChain();
            ca = compiledOptimizer.getRootNode();
            this.val = compiledOptimizer.getResultOptPass();
        }
        return ca;
    }

    public Class getEgressType() {
        return this.returnType;
    }

    public boolean isLiteralOnly() {
        return this.literal;
    }
}

